/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Notification;
import android.app.Person;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewStub;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.widget.NotificationRunnables;
import com.android.internal.widget.PeopleHelper;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.layoutlib.androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

@RemoteViews.RemoteView
public class CompactMessagingLayout
extends FrameLayout {
    private final PeopleHelper mPeopleHelper = new PeopleHelper();
    private ViewStub mConversationFacePileViewStub;
    private int mNotificationBackgroundColor;
    private int mFacePileSize;
    private int mFacePileAvatarSize;
    private int mFacePileProtectionWidth;
    private int mLayoutColor;

    public CompactMessagingLayout(@NonNull Context context) {
        super(context);
    }

    public CompactMessagingLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CompactMessagingLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CompactMessagingLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mPeopleHelper.init(this.getContext());
        this.mConversationFacePileViewStub = (ViewStub)this.requireViewById(16908971);
        this.mFacePileSize = this.getResources().getDimensionPixelSize(17105202);
        this.mFacePileAvatarSize = this.getResources().getDimensionPixelSize(17105200);
        this.mFacePileProtectionWidth = this.getResources().getDimensionPixelSize(17105201);
    }

    @RemotableViewMethod(asyncImpl="setGroupFacePileAsync")
    public void setGroupFacePile(Bundle extras) {
    }

    @RemotableViewMethod
    public Runnable setLayoutColorAsync(int color2) {
        this.mLayoutColor = color2;
        return NotificationRunnables.NOOP;
    }

    @RemotableViewMethod(asyncImpl="setLayoutColorAsync")
    public void setLayoutColor(int color2) {
        this.mLayoutColor = color2;
    }

    @RemotableViewMethod
    public void setNotificationBackgroundColor(int color2) {
        this.mNotificationBackgroundColor = color2;
    }

    public Runnable setGroupFacePileAsync(Bundle extras) {
        Parcelable[] messages = extras.getParcelableArray("android.messages");
        List<Notification.MessagingStyle.Message> newMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(messages);
        Parcelable[] histMessages = extras.getParcelableArray("android.messages.historic");
        List<Notification.MessagingStyle.Message> newHistoricMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(histMessages);
        Person user = extras.getParcelable("android.messagingUser", Person.class);
        List<List<Notification.MessagingStyle.Message>> groups = CompactMessagingLayout.groupMessages(newMessages, newHistoricMessages);
        PeopleHelper.NameToPrefixMap nameToPrefixMap = this.mPeopleHelper.mapUniqueNamesToPrefixWithGroupList(groups);
        int layoutColor = this.mLayoutColor;
        Icon secondLastIcon = null;
        Icon lastIcon = null;
        CharSequence lastKey = null;
        CharSequence userKey = CompactMessagingLayout.getPersonKey(user);
        for (int i = groups.size() - 1; i >= 0; --i) {
            boolean notIncluded;
            Notification.MessagingStyle.Message message = groups.get(i).get(0);
            Person sender = message.getSenderPerson() != null ? message.getSenderPerson() : user;
            CharSequence senderKey = CompactMessagingLayout.getPersonKey(sender);
            boolean notUser = senderKey != userKey;
            boolean bl = notIncluded = senderKey != lastKey;
            if ((!notUser || !notIncluded) && (i != 0 || lastKey != null)) continue;
            Icon icon = this.getSenderIcon(sender, nameToPrefixMap, layoutColor);
            if (lastIcon == null) {
                lastIcon = icon;
                lastKey = senderKey;
                continue;
            }
            secondLastIcon = icon;
            break;
        }
        if (lastIcon == null) {
            lastIcon = this.getSenderIcon(null, null, layoutColor);
        }
        if (secondLastIcon == null) {
            secondLastIcon = this.getSenderIcon(null, null, layoutColor);
        }
        Drawable secondLastIconDrawable = secondLastIcon.loadDrawable(this.getContext());
        Drawable lastIconDrawable = lastIcon.loadDrawable(this.getContext());
        return () -> {
            View conversationFacePile = this.mConversationFacePileViewStub.inflate();
            conversationFacePile.setVisibility(0);
            ImageView facePileBottomBg = (ImageView)conversationFacePile.requireViewById(16908973);
            ImageView facePileTop = (ImageView)conversationFacePile.requireViewById(16908974);
            ImageView facePileBottom = (ImageView)conversationFacePile.requireViewById(16908972);
            facePileTop.setImageDrawable(secondLastIconDrawable);
            facePileBottom.setImageDrawable(lastIconDrawable);
            facePileBottomBg.setImageTintList(ColorStateList.valueOf(this.mNotificationBackgroundColor));
            CompactMessagingLayout.setSize(conversationFacePile, this.mFacePileSize);
            CompactMessagingLayout.setSize(facePileBottom, this.mFacePileAvatarSize);
            CompactMessagingLayout.setSize(facePileTop, this.mFacePileAvatarSize);
            CompactMessagingLayout.setSize(facePileBottomBg, this.mFacePileAvatarSize + 2 * this.mFacePileProtectionWidth);
        };
    }

    @NonNull
    private Icon getSenderIcon(@Nullable Person sender, @Nullable PeopleHelper.NameToPrefixMap uniqueNames, int layoutColor) {
        if (sender == null) {
            return this.mPeopleHelper.createAvatarSymbol("", "", layoutColor);
        }
        if (sender.getIcon() != null) {
            return sender.getIcon();
        }
        CharSequence senderName = sender.getName();
        if (!TextUtils.isEmpty(senderName)) {
            String symbol = uniqueNames != null ? uniqueNames.getPrefix(senderName) : "";
            return this.mPeopleHelper.createAvatarSymbol(senderName, symbol, layoutColor);
        }
        return this.mPeopleHelper.createAvatarSymbol("", "", layoutColor);
    }

    private static List<List<Notification.MessagingStyle.Message>> groupMessages(List<Notification.MessagingStyle.Message> messages, List<Notification.MessagingStyle.Message> historicMessages) {
        if (messages.isEmpty() && historicMessages.isEmpty()) {
            return List.of();
        }
        ArrayList<Notification.MessagingStyle.Message> currentGroup = null;
        CharSequence currentSenderKey = null;
        ArrayList<List<Notification.MessagingStyle.Message>> groups = new ArrayList<List<Notification.MessagingStyle.Message>>();
        int histSize = historicMessages.size();
        for (int i = 0; i < histSize + messages.size(); ++i) {
            boolean isNewGroup;
            Notification.MessagingStyle.Message message;
            Notification.MessagingStyle.Message message2 = message = i < histSize ? historicMessages.get(i) : messages.get(i - histSize);
            if (message == null) continue;
            CharSequence senderKey = CompactMessagingLayout.getPersonKey(message.getSenderPerson());
            boolean bl = isNewGroup = currentGroup == null || senderKey != currentSenderKey;
            if (isNewGroup) {
                currentGroup = new ArrayList<Notification.MessagingStyle.Message>();
                groups.add(currentGroup);
                currentSenderKey = senderKey;
            }
            currentGroup.add(message);
        }
        return groups;
    }

    private static CharSequence getPersonKey(@Nullable Person person) {
        return person == null ? null : (person.getKey() == null ? person.getName() : person.getKey());
    }

    private static void setSize(View view, int size) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)view.getLayoutParams();
        lp.width = size;
        lp.height = size;
        view.setLayoutParams(lp);
    }
}

