/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Person;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.flags.Flags;
import com.android.internal.widget.CachingIconView;
import com.android.internal.widget.PeopleHelper;

@RemoteViews.RemoteView
public class CallLayout
extends FrameLayout {
    private final PeopleHelper mPeopleHelper = new PeopleHelper();
    private int mLayoutColor;
    private Icon mLargeIcon;
    private Person mUser;
    private CachingIconView mConversationIconView;
    private CachingIconView mIcon;
    private CachingIconView mConversationIconBadgeBg;

    public CallLayout(@NonNull Context context) {
        super(context);
    }

    public CallLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CallLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CallLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mPeopleHelper.init(this.getContext());
        this.mConversationIconView = (CachingIconView)this.findViewById(16908976);
        this.mIcon = (CachingIconView)this.findViewById(16908294);
        this.mConversationIconBadgeBg = (CachingIconView)this.findViewById(16908978);
        this.mIcon.setOnForceHiddenChangedListener(forceHidden -> this.mPeopleHelper.animateViewForceHidden(this.mConversationIconBadgeBg, (boolean)forceHidden));
    }

    @NonNull
    private Icon getConversationIcon() {
        CharSequence callerName = "";
        String symbol = "";
        Icon icon = null;
        if (this.mUser != null) {
            icon = this.mUser.getIcon();
            callerName = this.mUser.getName();
            symbol = this.mPeopleHelper.findNamePrefix(callerName, "");
        }
        if (icon == null) {
            icon = this.mLargeIcon;
        }
        if (icon == null) {
            icon = this.mPeopleHelper.createAvatarSymbol(callerName, symbol, this.mLayoutColor);
        }
        return icon;
    }

    public Runnable setLayoutColorAsync(int color2) {
        if (!Flags.callStyleSetDataAsync()) {
            return () -> this.setLayoutColor(color2);
        }
        this.mLayoutColor = color2;
        return () -> {};
    }

    @RemotableViewMethod(asyncImpl="setLayoutColorAsync")
    public void setLayoutColor(int color2) {
        this.mLayoutColor = color2;
    }

    @RemotableViewMethod
    public void setNotificationBackgroundColor(int color2) {
        this.mConversationIconBadgeBg.setImageTintList(ColorStateList.valueOf(color2));
    }

    public Runnable setLargeIconAsync(Icon largeIcon) {
        if (!Flags.callStyleSetDataAsync()) {
            return () -> this.setLargeIcon(largeIcon);
        }
        this.mLargeIcon = largeIcon;
        return () -> {};
    }

    @RemotableViewMethod(asyncImpl="setLargeIconAsync")
    public void setLargeIcon(Icon largeIcon) {
        this.mLargeIcon = largeIcon;
    }

    @RemotableViewMethod(asyncImpl="setDataAsync")
    public void setData(Bundle extras) {
        Person person = this.getPerson(extras);
        this.setUser(person);
        Icon icon = this.getConversationIcon();
        this.mConversationIconView.setImageIcon(icon);
    }

    public Runnable setDataAsync(Bundle extras) {
        if (!Flags.callStyleSetDataAsync()) {
            return () -> this.setData(extras);
        }
        Person person = this.getPerson(extras);
        this.setUser(person);
        Icon conversationIcon = this.getConversationIcon();
        return this.mConversationIconView.setImageIconAsync(conversationIcon);
    }

    @Nullable
    private Person getPerson(Bundle extras) {
        return extras.getParcelable("android.callPerson", Person.class);
    }

    private void setUser(Person user) {
        this.mUser = user;
    }
}

