/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.vibrator.persistence;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.VibrationEffect;
import android.os.vibrator.Flags;
import com.android.internal.vibrator.persistence.SerializedComposedEffect;
import com.android.internal.vibrator.persistence.XmlConstants;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlReader;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;

class SerializedCompositionPrimitive
implements SerializedComposedEffect.SerializedSegment {
    @NonNull
    private final XmlConstants.PrimitiveEffectName mPrimitiveName;
    private final float mPrimitiveScale;
    private final int mPrimitiveDelayMs;
    @Nullable
    private final XmlConstants.PrimitiveDelayType mDelayType;

    SerializedCompositionPrimitive(XmlConstants.PrimitiveEffectName primitiveName, float scale, int delayMs, @Nullable XmlConstants.PrimitiveDelayType delayType) {
        this.mPrimitiveName = primitiveName;
        this.mPrimitiveScale = scale;
        this.mPrimitiveDelayMs = delayMs;
        this.mDelayType = delayType;
    }

    @Override
    public void deserializeIntoComposition(@NonNull VibrationEffect.Composition composition) {
        if (Flags.primitiveCompositionAbsoluteDelay() && this.mDelayType != null) {
            composition.addPrimitive(this.mPrimitiveName.getPrimitiveId(), this.mPrimitiveScale, this.mPrimitiveDelayMs, this.mDelayType.getDelayType());
        } else {
            composition.addPrimitive(this.mPrimitiveName.getPrimitiveId(), this.mPrimitiveScale, this.mPrimitiveDelayMs);
        }
    }

    @Override
    public void write(@NonNull TypedXmlSerializer serializer) throws IOException {
        serializer.startTag(XmlConstants.NAMESPACE, "primitive-effect");
        serializer.attribute(XmlConstants.NAMESPACE, "name", this.mPrimitiveName.toString());
        if (Float.compare(this.mPrimitiveScale, 1.0f) != 0) {
            serializer.attributeFloat(XmlConstants.NAMESPACE, "scale", this.mPrimitiveScale);
        }
        if (this.mPrimitiveDelayMs != 0) {
            serializer.attributeInt(XmlConstants.NAMESPACE, "delayMs", this.mPrimitiveDelayMs);
        }
        if (Flags.primitiveCompositionAbsoluteDelay() && this.mDelayType != null && this.mDelayType.getDelayType() != 0) {
            serializer.attribute(XmlConstants.NAMESPACE, "delayType", this.mDelayType.toString());
        }
        serializer.endTag(XmlConstants.NAMESPACE, "primitive-effect");
    }

    public String toString() {
        return "SerializedCompositionPrimitive{name=" + (Object)((Object)this.mPrimitiveName) + ", scale=" + this.mPrimitiveScale + ", delayMs=" + this.mPrimitiveDelayMs + ", delayType=" + (Object)((Object)this.mDelayType) + '}';
    }

    static class Parser {
        Parser() {
        }

        @NonNull
        static SerializedCompositionPrimitive parseNext(@NonNull TypedXmlPullParser parser) throws XmlParserException, IOException {
            XmlValidator.checkStartTag(parser, "primitive-effect");
            if (Flags.primitiveCompositionAbsoluteDelay()) {
                XmlValidator.checkTagHasNoUnexpectedAttributes(parser, "name", "delayMs", "scale", "delayType");
            } else {
                XmlValidator.checkTagHasNoUnexpectedAttributes(parser, "name", "delayMs", "scale");
            }
            XmlConstants.PrimitiveEffectName primitiveName = Parser.parsePrimitiveName(parser.getAttributeValue(XmlConstants.NAMESPACE, "name"));
            float scale = XmlReader.readAttributeFloatInRange(parser, "scale", 0.0f, 1.0f, 1.0f);
            int delayMs = XmlReader.readAttributeIntNonNegative(parser, "delayMs", 0);
            XmlConstants.PrimitiveDelayType delayType = Parser.parseDelayType(parser.getAttributeValue(XmlConstants.NAMESPACE, "delayType"));
            XmlReader.readEndTag(parser);
            return new SerializedCompositionPrimitive(primitiveName, scale, delayMs, delayType);
        }

        @NonNull
        private static XmlConstants.PrimitiveEffectName parsePrimitiveName(@Nullable String name) throws XmlParserException {
            if (name == null) {
                throw new XmlParserException("Missing primitive effect name");
            }
            XmlConstants.PrimitiveEffectName effectName = XmlConstants.PrimitiveEffectName.findByName(name);
            if (effectName == null) {
                throw new XmlParserException("Unexpected primitive effect name " + name);
            }
            return effectName;
        }

        @Nullable
        private static XmlConstants.PrimitiveDelayType parseDelayType(@Nullable String name) throws XmlParserException {
            if (name == null) {
                return null;
            }
            if (!Flags.primitiveCompositionAbsoluteDelay()) {
                throw new XmlParserException("Unexpected primitive delay type " + name);
            }
            XmlConstants.PrimitiveDelayType delayType = XmlConstants.PrimitiveDelayType.findByName(name);
            if (delayType == null) {
                throw new XmlParserException("Unexpected primitive delay type " + name);
            }
            return delayType;
        }
    }
}

