/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Bundle;
import android.os.Parcelable;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SyncResultReceiver
extends IResultReceiver.Stub {
    private static final String EXTRA = "EXTRA";
    private final CountDownLatch mLatch = new CountDownLatch(1);
    private final int mTimeoutMs;
    private int mResult;
    private Bundle mBundle;

    public SyncResultReceiver(int timeoutMs) {
        this.mTimeoutMs = timeoutMs;
    }

    private void waitResult() throws TimeoutException {
        try {
            if (!this.mLatch.await(this.mTimeoutMs, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Not called in " + this.mTimeoutMs + "ms");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TimeoutException("Interrupted");
        }
    }

    public int getIntResult() throws TimeoutException {
        this.waitResult();
        return this.mResult;
    }

    @Nullable
    public String getStringResult() throws TimeoutException {
        this.waitResult();
        return this.mBundle == null ? null : this.mBundle.getString(EXTRA);
    }

    @Nullable
    public String[] getStringArrayResult() throws TimeoutException {
        this.waitResult();
        return this.mBundle == null ? null : this.mBundle.getStringArray(EXTRA);
    }

    @Nullable
    public <P extends Parcelable> P getParcelableResult() throws TimeoutException {
        this.waitResult();
        return this.mBundle == null ? null : (P)this.mBundle.getParcelable(EXTRA);
    }

    @Nullable
    public <P extends Parcelable> ArrayList<P> getParcelableListResult() throws TimeoutException {
        this.waitResult();
        return this.mBundle == null ? null : this.mBundle.getParcelableArrayList(EXTRA);
    }

    public int getOptionalExtraIntResult(int defaultValue) throws TimeoutException {
        this.waitResult();
        if (this.mBundle == null || !this.mBundle.containsKey(EXTRA)) {
            return defaultValue;
        }
        return this.mBundle.getInt(EXTRA);
    }

    @Override
    public void send(int resultCode, Bundle resultData) {
        this.mResult = resultCode;
        this.mBundle = resultData;
        this.mLatch.countDown();
    }

    @NonNull
    public static Bundle bundleFor(@Nullable String value) {
        Bundle bundle = new Bundle();
        bundle.putString(EXTRA, value);
        return bundle;
    }

    @NonNull
    public static Bundle bundleFor(@Nullable String[] value) {
        Bundle bundle = new Bundle();
        bundle.putStringArray(EXTRA, value);
        return bundle;
    }

    @NonNull
    public static Bundle bundleFor(@Nullable Parcelable value) {
        Bundle bundle = new Bundle();
        bundle.putParcelable(EXTRA, value);
        return bundle;
    }

    @NonNull
    public static Bundle bundleFor(@Nullable ArrayList<? extends Parcelable> value) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(EXTRA, value);
        return bundle;
    }

    @NonNull
    public static Bundle bundleFor(int value) {
        Bundle bundle = new Bundle();
        bundle.putInt(EXTRA, value);
        return bundle;
    }

    public static class TimeoutException
    extends Exception {
        private TimeoutException(String msg) {
            super(msg);
        }
    }
}

