/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.statusbar;

import android.app.ITransientNotificationCallback;
import android.content.ComponentName;
import android.graphics.drawable.Icon;
import android.hardware.biometrics.IBiometricContextListener;
import android.hardware.biometrics.IBiometricSysuiReceiver;
import android.hardware.biometrics.PromptInfo;
import android.hardware.fingerprint.IUdfpsRefreshRateRequestCallback;
import android.media.INearbyMediaDevicesProvider;
import android.media.MediaRoute2Info;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;
import android.text.TextUtils;
import android.view.KeyEvent;
import com.android.internal.statusbar.DisableStates;
import com.android.internal.statusbar.IAddTileResultCallback;
import com.android.internal.statusbar.IUndoMediaTransferCallback;
import com.android.internal.statusbar.LetterboxDetails;
import com.android.internal.statusbar.StatusBarIcon;
import com.android.internal.view.AppearanceRegion;

public interface IStatusBar
extends IInterface {
    public void setIcon(String var1, StatusBarIcon var2) throws RemoteException;

    public void removeIcon(String var1) throws RemoteException;

    public void disable(int var1, int var2, int var3) throws RemoteException;

    public void disableForAllDisplays(DisableStates var1) throws RemoteException;

    public void animateExpandNotificationsPanel() throws RemoteException;

    public void animateExpandSettingsPanel(String var1) throws RemoteException;

    public void animateCollapsePanels() throws RemoteException;

    public void toggleNotificationsPanel() throws RemoteException;

    public void showWirelessChargingAnimation(int var1) throws RemoteException;

    public void setImeWindowStatus(int var1, int var2, int var3, boolean var4) throws RemoteException;

    public void setWindowState(int var1, int var2, int var3) throws RemoteException;

    public void showRecentApps(boolean var1) throws RemoteException;

    public void hideRecentApps(boolean var1, boolean var2) throws RemoteException;

    public void toggleRecentApps() throws RemoteException;

    public void toggleTaskbar() throws RemoteException;

    public void toggleSplitScreen() throws RemoteException;

    public void preloadRecentApps() throws RemoteException;

    public void cancelPreloadRecentApps() throws RemoteException;

    public void showScreenPinningRequest(int var1) throws RemoteException;

    public void confirmImmersivePrompt() throws RemoteException;

    public void immersiveModeChanged(int var1, boolean var2, int var3) throws RemoteException;

    public void dismissKeyboardShortcutsMenu() throws RemoteException;

    public void toggleKeyboardShortcutsMenu(int var1) throws RemoteException;

    public void appTransitionPending(int var1) throws RemoteException;

    public void appTransitionCancelled(int var1) throws RemoteException;

    public void appTransitionStarting(int var1, long var2, long var4) throws RemoteException;

    public void appTransitionFinished(int var1) throws RemoteException;

    public void showAssistDisclosure() throws RemoteException;

    public void startAssist(Bundle var1) throws RemoteException;

    public void onCameraLaunchGestureDetected(int var1) throws RemoteException;

    public void onWalletLaunchGestureDetected() throws RemoteException;

    public void onEmergencyActionLaunchGestureDetected() throws RemoteException;

    public void showPictureInPictureMenu() throws RemoteException;

    public void showGlobalActionsMenu() throws RemoteException;

    public void onProposedRotationChanged(int var1, boolean var2) throws RemoteException;

    public void setTopAppHidesStatusBar(boolean var1) throws RemoteException;

    public void addQsTile(ComponentName var1) throws RemoteException;

    public void addQsTileToFrontOrEnd(ComponentName var1, boolean var2) throws RemoteException;

    public void remQsTile(ComponentName var1) throws RemoteException;

    public void setQsTiles(String[] var1) throws RemoteException;

    public void clickQsTile(ComponentName var1) throws RemoteException;

    public void handleSystemKey(KeyEvent var1) throws RemoteException;

    public void showPinningEnterExitToast(boolean var1) throws RemoteException;

    public void showPinningEscapeToast() throws RemoteException;

    public void showShutdownUi(boolean var1, String var2) throws RemoteException;

    public void showAuthenticationDialog(PromptInfo var1, IBiometricSysuiReceiver var2, int[] var3, boolean var4, boolean var5, int var6, long var7, String var9, long var10) throws RemoteException;

    public void onBiometricAuthenticated(int var1) throws RemoteException;

    public void onBiometricHelp(int var1, String var2) throws RemoteException;

    public void onBiometricError(int var1, int var2, int var3) throws RemoteException;

    public void hideAuthenticationDialog(long var1) throws RemoteException;

    public void setBiometicContextListener(IBiometricContextListener var1) throws RemoteException;

    public void setUdfpsRefreshRateCallback(IUdfpsRefreshRateRequestCallback var1) throws RemoteException;

    public void onDisplayAddSystemDecorations(int var1) throws RemoteException;

    public void onDisplayRemoveSystemDecorations(int var1) throws RemoteException;

    public void onSystemBarAttributesChanged(int var1, int var2, AppearanceRegion[] var3, boolean var4, int var5, int var6, String var7, LetterboxDetails[] var8) throws RemoteException;

    public void showTransient(int var1, int var2, boolean var3) throws RemoteException;

    public void abortTransient(int var1, int var2) throws RemoteException;

    public void showInattentiveSleepWarning() throws RemoteException;

    public void dismissInattentiveSleepWarning(boolean var1) throws RemoteException;

    public void showToast(int var1, String var2, IBinder var3, CharSequence var4, IBinder var5, int var6, ITransientNotificationCallback var7, int var8) throws RemoteException;

    public void hideToast(String var1, IBinder var2) throws RemoteException;

    public void startTracing() throws RemoteException;

    public void stopTracing() throws RemoteException;

    public void suppressAmbientDisplay(boolean var1) throws RemoteException;

    public void requestMagnificationConnection(boolean var1) throws RemoteException;

    public void passThroughShellCommand(String[] var1, ParcelFileDescriptor var2) throws RemoteException;

    public void setNavigationBarLumaSamplingEnabled(int var1, boolean var2) throws RemoteException;

    public void runGcForTest() throws RemoteException;

    public void requestTileServiceListeningState(ComponentName var1) throws RemoteException;

    public void requestAddTile(int var1, ComponentName var2, CharSequence var3, CharSequence var4, Icon var5, IAddTileResultCallback var6) throws RemoteException;

    public void cancelRequestAddTile(String var1) throws RemoteException;

    public void updateMediaTapToTransferSenderDisplay(int var1, MediaRoute2Info var2, IUndoMediaTransferCallback var3) throws RemoteException;

    public void updateMediaTapToTransferReceiverDisplay(int var1, MediaRoute2Info var2, Icon var3, CharSequence var4) throws RemoteException;

    public void registerNearbyMediaDevicesProvider(INearbyMediaDevicesProvider var1) throws RemoteException;

    public void unregisterNearbyMediaDevicesProvider(INearbyMediaDevicesProvider var1) throws RemoteException;

    public void dumpProto(String[] var1, ParcelFileDescriptor var2) throws RemoteException;

    public void showRearDisplayDialog(int var1) throws RemoteException;

    public void moveFocusedTaskToFullscreen(int var1) throws RemoteException;

    public void moveFocusedTaskToStageSplit(int var1, boolean var2) throws RemoteException;

    public void setSplitscreenFocus(boolean var1) throws RemoteException;

    public void showMediaOutputSwitcher(String var1, UserHandle var2) throws RemoteException;

    public void moveFocusedTaskToDesktop(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IStatusBar {
        public static final String DESCRIPTOR = "com.android.internal.statusbar.IStatusBar";
        static final int TRANSACTION_setIcon = 1;
        static final int TRANSACTION_removeIcon = 2;
        static final int TRANSACTION_disable = 3;
        static final int TRANSACTION_disableForAllDisplays = 4;
        static final int TRANSACTION_animateExpandNotificationsPanel = 5;
        static final int TRANSACTION_animateExpandSettingsPanel = 6;
        static final int TRANSACTION_animateCollapsePanels = 7;
        static final int TRANSACTION_toggleNotificationsPanel = 8;
        static final int TRANSACTION_showWirelessChargingAnimation = 9;
        static final int TRANSACTION_setImeWindowStatus = 10;
        static final int TRANSACTION_setWindowState = 11;
        static final int TRANSACTION_showRecentApps = 12;
        static final int TRANSACTION_hideRecentApps = 13;
        static final int TRANSACTION_toggleRecentApps = 14;
        static final int TRANSACTION_toggleTaskbar = 15;
        static final int TRANSACTION_toggleSplitScreen = 16;
        static final int TRANSACTION_preloadRecentApps = 17;
        static final int TRANSACTION_cancelPreloadRecentApps = 18;
        static final int TRANSACTION_showScreenPinningRequest = 19;
        static final int TRANSACTION_confirmImmersivePrompt = 20;
        static final int TRANSACTION_immersiveModeChanged = 21;
        static final int TRANSACTION_dismissKeyboardShortcutsMenu = 22;
        static final int TRANSACTION_toggleKeyboardShortcutsMenu = 23;
        static final int TRANSACTION_appTransitionPending = 24;
        static final int TRANSACTION_appTransitionCancelled = 25;
        static final int TRANSACTION_appTransitionStarting = 26;
        static final int TRANSACTION_appTransitionFinished = 27;
        static final int TRANSACTION_showAssistDisclosure = 28;
        static final int TRANSACTION_startAssist = 29;
        static final int TRANSACTION_onCameraLaunchGestureDetected = 30;
        static final int TRANSACTION_onWalletLaunchGestureDetected = 31;
        static final int TRANSACTION_onEmergencyActionLaunchGestureDetected = 32;
        static final int TRANSACTION_showPictureInPictureMenu = 33;
        static final int TRANSACTION_showGlobalActionsMenu = 34;
        static final int TRANSACTION_onProposedRotationChanged = 35;
        static final int TRANSACTION_setTopAppHidesStatusBar = 36;
        static final int TRANSACTION_addQsTile = 37;
        static final int TRANSACTION_addQsTileToFrontOrEnd = 38;
        static final int TRANSACTION_remQsTile = 39;
        static final int TRANSACTION_setQsTiles = 40;
        static final int TRANSACTION_clickQsTile = 41;
        static final int TRANSACTION_handleSystemKey = 42;
        static final int TRANSACTION_showPinningEnterExitToast = 43;
        static final int TRANSACTION_showPinningEscapeToast = 44;
        static final int TRANSACTION_showShutdownUi = 45;
        static final int TRANSACTION_showAuthenticationDialog = 46;
        static final int TRANSACTION_onBiometricAuthenticated = 47;
        static final int TRANSACTION_onBiometricHelp = 48;
        static final int TRANSACTION_onBiometricError = 49;
        static final int TRANSACTION_hideAuthenticationDialog = 50;
        static final int TRANSACTION_setBiometicContextListener = 51;
        static final int TRANSACTION_setUdfpsRefreshRateCallback = 52;
        static final int TRANSACTION_onDisplayAddSystemDecorations = 53;
        static final int TRANSACTION_onDisplayRemoveSystemDecorations = 54;
        static final int TRANSACTION_onSystemBarAttributesChanged = 55;
        static final int TRANSACTION_showTransient = 56;
        static final int TRANSACTION_abortTransient = 57;
        static final int TRANSACTION_showInattentiveSleepWarning = 58;
        static final int TRANSACTION_dismissInattentiveSleepWarning = 59;
        static final int TRANSACTION_showToast = 60;
        static final int TRANSACTION_hideToast = 61;
        static final int TRANSACTION_startTracing = 62;
        static final int TRANSACTION_stopTracing = 63;
        static final int TRANSACTION_suppressAmbientDisplay = 64;
        static final int TRANSACTION_requestMagnificationConnection = 65;
        static final int TRANSACTION_passThroughShellCommand = 66;
        static final int TRANSACTION_setNavigationBarLumaSamplingEnabled = 67;
        static final int TRANSACTION_runGcForTest = 68;
        static final int TRANSACTION_requestTileServiceListeningState = 69;
        static final int TRANSACTION_requestAddTile = 70;
        static final int TRANSACTION_cancelRequestAddTile = 71;
        static final int TRANSACTION_updateMediaTapToTransferSenderDisplay = 72;
        static final int TRANSACTION_updateMediaTapToTransferReceiverDisplay = 73;
        static final int TRANSACTION_registerNearbyMediaDevicesProvider = 74;
        static final int TRANSACTION_unregisterNearbyMediaDevicesProvider = 75;
        static final int TRANSACTION_dumpProto = 76;
        static final int TRANSACTION_showRearDisplayDialog = 77;
        static final int TRANSACTION_moveFocusedTaskToFullscreen = 78;
        static final int TRANSACTION_moveFocusedTaskToStageSplit = 79;
        static final int TRANSACTION_setSplitscreenFocus = 80;
        static final int TRANSACTION_showMediaOutputSwitcher = 81;
        static final int TRANSACTION_moveFocusedTaskToDesktop = 82;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IStatusBar asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IStatusBar) {
                return (IStatusBar)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "setIcon";
                }
                case 2: {
                    return "removeIcon";
                }
                case 3: {
                    return "disable";
                }
                case 4: {
                    return "disableForAllDisplays";
                }
                case 5: {
                    return "animateExpandNotificationsPanel";
                }
                case 6: {
                    return "animateExpandSettingsPanel";
                }
                case 7: {
                    return "animateCollapsePanels";
                }
                case 8: {
                    return "toggleNotificationsPanel";
                }
                case 9: {
                    return "showWirelessChargingAnimation";
                }
                case 10: {
                    return "setImeWindowStatus";
                }
                case 11: {
                    return "setWindowState";
                }
                case 12: {
                    return "showRecentApps";
                }
                case 13: {
                    return "hideRecentApps";
                }
                case 14: {
                    return "toggleRecentApps";
                }
                case 15: {
                    return "toggleTaskbar";
                }
                case 16: {
                    return "toggleSplitScreen";
                }
                case 17: {
                    return "preloadRecentApps";
                }
                case 18: {
                    return "cancelPreloadRecentApps";
                }
                case 19: {
                    return "showScreenPinningRequest";
                }
                case 20: {
                    return "confirmImmersivePrompt";
                }
                case 21: {
                    return "immersiveModeChanged";
                }
                case 22: {
                    return "dismissKeyboardShortcutsMenu";
                }
                case 23: {
                    return "toggleKeyboardShortcutsMenu";
                }
                case 24: {
                    return "appTransitionPending";
                }
                case 25: {
                    return "appTransitionCancelled";
                }
                case 26: {
                    return "appTransitionStarting";
                }
                case 27: {
                    return "appTransitionFinished";
                }
                case 28: {
                    return "showAssistDisclosure";
                }
                case 29: {
                    return "startAssist";
                }
                case 30: {
                    return "onCameraLaunchGestureDetected";
                }
                case 31: {
                    return "onWalletLaunchGestureDetected";
                }
                case 32: {
                    return "onEmergencyActionLaunchGestureDetected";
                }
                case 33: {
                    return "showPictureInPictureMenu";
                }
                case 34: {
                    return "showGlobalActionsMenu";
                }
                case 35: {
                    return "onProposedRotationChanged";
                }
                case 36: {
                    return "setTopAppHidesStatusBar";
                }
                case 37: {
                    return "addQsTile";
                }
                case 38: {
                    return "addQsTileToFrontOrEnd";
                }
                case 39: {
                    return "remQsTile";
                }
                case 40: {
                    return "setQsTiles";
                }
                case 41: {
                    return "clickQsTile";
                }
                case 42: {
                    return "handleSystemKey";
                }
                case 43: {
                    return "showPinningEnterExitToast";
                }
                case 44: {
                    return "showPinningEscapeToast";
                }
                case 45: {
                    return "showShutdownUi";
                }
                case 46: {
                    return "showAuthenticationDialog";
                }
                case 47: {
                    return "onBiometricAuthenticated";
                }
                case 48: {
                    return "onBiometricHelp";
                }
                case 49: {
                    return "onBiometricError";
                }
                case 50: {
                    return "hideAuthenticationDialog";
                }
                case 51: {
                    return "setBiometicContextListener";
                }
                case 52: {
                    return "setUdfpsRefreshRateCallback";
                }
                case 53: {
                    return "onDisplayAddSystemDecorations";
                }
                case 54: {
                    return "onDisplayRemoveSystemDecorations";
                }
                case 55: {
                    return "onSystemBarAttributesChanged";
                }
                case 56: {
                    return "showTransient";
                }
                case 57: {
                    return "abortTransient";
                }
                case 58: {
                    return "showInattentiveSleepWarning";
                }
                case 59: {
                    return "dismissInattentiveSleepWarning";
                }
                case 60: {
                    return "showToast";
                }
                case 61: {
                    return "hideToast";
                }
                case 62: {
                    return "startTracing";
                }
                case 63: {
                    return "stopTracing";
                }
                case 64: {
                    return "suppressAmbientDisplay";
                }
                case 65: {
                    return "requestMagnificationConnection";
                }
                case 66: {
                    return "passThroughShellCommand";
                }
                case 67: {
                    return "setNavigationBarLumaSamplingEnabled";
                }
                case 68: {
                    return "runGcForTest";
                }
                case 69: {
                    return "requestTileServiceListeningState";
                }
                case 70: {
                    return "requestAddTile";
                }
                case 71: {
                    return "cancelRequestAddTile";
                }
                case 72: {
                    return "updateMediaTapToTransferSenderDisplay";
                }
                case 73: {
                    return "updateMediaTapToTransferReceiverDisplay";
                }
                case 74: {
                    return "registerNearbyMediaDevicesProvider";
                }
                case 75: {
                    return "unregisterNearbyMediaDevicesProvider";
                }
                case 76: {
                    return "dumpProto";
                }
                case 77: {
                    return "showRearDisplayDialog";
                }
                case 78: {
                    return "moveFocusedTaskToFullscreen";
                }
                case 79: {
                    return "moveFocusedTaskToStageSplit";
                }
                case 80: {
                    return "setSplitscreenFocus";
                }
                case 81: {
                    return "showMediaOutputSwitcher";
                }
                case 82: {
                    return "moveFocusedTaskToDesktop";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    StatusBarIcon _arg1 = data.readTypedObject(StatusBarIcon.CREATOR);
                    data.enforceNoDataAvail();
                    this.setIcon(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeIcon(_arg0);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disable(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    DisableStates _arg0 = data.readTypedObject(DisableStates.CREATOR);
                    data.enforceNoDataAvail();
                    this.disableForAllDisplays(_arg0);
                    break;
                }
                case 5: {
                    this.animateExpandNotificationsPanel();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.animateExpandSettingsPanel(_arg0);
                    break;
                }
                case 7: {
                    this.animateCollapsePanels();
                    break;
                }
                case 8: {
                    this.toggleNotificationsPanel();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showWirelessChargingAnimation(_arg0);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setImeWindowStatus(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWindowState(_arg0, _arg1, _arg2);
                    break;
                }
                case 12: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showRecentApps(_arg0);
                    break;
                }
                case 13: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.hideRecentApps(_arg0, _arg1);
                    break;
                }
                case 14: {
                    this.toggleRecentApps();
                    break;
                }
                case 15: {
                    this.toggleTaskbar();
                    break;
                }
                case 16: {
                    this.toggleSplitScreen();
                    break;
                }
                case 17: {
                    this.preloadRecentApps();
                    break;
                }
                case 18: {
                    this.cancelPreloadRecentApps();
                    break;
                }
                case 19: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showScreenPinningRequest(_arg0);
                    break;
                }
                case 20: {
                    this.confirmImmersivePrompt();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.immersiveModeChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 22: {
                    this.dismissKeyboardShortcutsMenu();
                    break;
                }
                case 23: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.toggleKeyboardShortcutsMenu(_arg0);
                    break;
                }
                case 24: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.appTransitionPending(_arg0);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.appTransitionCancelled(_arg0);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    long _arg2 = data.readLong();
                    data.enforceNoDataAvail();
                    this.appTransitionStarting(_arg0, _arg1, _arg2);
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.appTransitionFinished(_arg0);
                    break;
                }
                case 28: {
                    this.showAssistDisclosure();
                    break;
                }
                case 29: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.startAssist(_arg0);
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCameraLaunchGestureDetected(_arg0);
                    break;
                }
                case 31: {
                    this.onWalletLaunchGestureDetected();
                    break;
                }
                case 32: {
                    this.onEmergencyActionLaunchGestureDetected();
                    break;
                }
                case 33: {
                    this.showPictureInPictureMenu();
                    break;
                }
                case 34: {
                    this.showGlobalActionsMenu();
                    break;
                }
                case 35: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onProposedRotationChanged(_arg0, _arg1);
                    break;
                }
                case 36: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTopAppHidesStatusBar(_arg0);
                    break;
                }
                case 37: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.addQsTile(_arg0);
                    break;
                }
                case 38: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.addQsTileToFrontOrEnd(_arg0, _arg1);
                    break;
                }
                case 39: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.remQsTile(_arg0);
                    break;
                }
                case 40: {
                    String[] _arg0 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.setQsTiles(_arg0);
                    break;
                }
                case 41: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.clickQsTile(_arg0);
                    break;
                }
                case 42: {
                    KeyEvent _arg0 = data.readTypedObject(KeyEvent.CREATOR);
                    data.enforceNoDataAvail();
                    this.handleSystemKey(_arg0);
                    break;
                }
                case 43: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showPinningEnterExitToast(_arg0);
                    break;
                }
                case 44: {
                    this.showPinningEscapeToast();
                    break;
                }
                case 45: {
                    boolean _arg0 = data.readBoolean();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.showShutdownUi(_arg0, _arg1);
                    break;
                }
                case 46: {
                    PromptInfo _arg0 = data.readTypedObject(PromptInfo.CREATOR);
                    IBiometricSysuiReceiver _arg1 = IBiometricSysuiReceiver.Stub.asInterface(data.readStrongBinder());
                    int[] _arg2 = data.createIntArray();
                    boolean _arg3 = data.readBoolean();
                    boolean _arg4 = data.readBoolean();
                    int _arg5 = data.readInt();
                    long _arg6 = data.readLong();
                    String _arg7 = data.readString();
                    long _arg8 = data.readLong();
                    data.enforceNoDataAvail();
                    this.showAuthenticationDialog(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8);
                    break;
                }
                case 47: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBiometricAuthenticated(_arg0);
                    break;
                }
                case 48: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onBiometricHelp(_arg0, _arg1);
                    break;
                }
                case 49: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onBiometricError(_arg0, _arg1, _arg2);
                    break;
                }
                case 50: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.hideAuthenticationDialog(_arg0);
                    break;
                }
                case 51: {
                    IBiometricContextListener _arg0 = IBiometricContextListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setBiometicContextListener(_arg0);
                    break;
                }
                case 52: {
                    IUdfpsRefreshRateRequestCallback _arg0 = IUdfpsRefreshRateRequestCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setUdfpsRefreshRateCallback(_arg0);
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDisplayAddSystemDecorations(_arg0);
                    break;
                }
                case 54: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDisplayRemoveSystemDecorations(_arg0);
                    break;
                }
                case 55: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    AppearanceRegion[] _arg2 = data.createTypedArray(AppearanceRegion.CREATOR);
                    boolean _arg3 = data.readBoolean();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    String _arg6 = data.readString();
                    LetterboxDetails[] _arg7 = data.createTypedArray(LetterboxDetails.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSystemBarAttributesChanged(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 56: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showTransient(_arg0, _arg1, _arg2);
                    break;
                }
                case 57: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.abortTransient(_arg0, _arg1);
                    break;
                }
                case 58: {
                    this.showInattentiveSleepWarning();
                    break;
                }
                case 59: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.dismissInattentiveSleepWarning(_arg0);
                    break;
                }
                case 60: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IBinder _arg2 = data.readStrongBinder();
                    CharSequence _arg3 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    IBinder _arg4 = data.readStrongBinder();
                    int _arg5 = data.readInt();
                    ITransientNotificationCallback _arg6 = ITransientNotificationCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg7 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showToast(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    break;
                }
                case 61: {
                    String _arg0 = data.readString();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.hideToast(_arg0, _arg1);
                    break;
                }
                case 62: {
                    this.startTracing();
                    break;
                }
                case 63: {
                    this.stopTracing();
                    break;
                }
                case 64: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.suppressAmbientDisplay(_arg0);
                    break;
                }
                case 65: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.requestMagnificationConnection(_arg0);
                    break;
                }
                case 66: {
                    String[] _arg0 = data.createStringArray();
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.passThroughShellCommand(_arg0, _arg1);
                    break;
                }
                case 67: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNavigationBarLumaSamplingEnabled(_arg0, _arg1);
                    break;
                }
                case 68: {
                    this.runGcForTest();
                    break;
                }
                case 69: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestTileServiceListeningState(_arg0);
                    break;
                }
                case 70: {
                    int _arg0 = data.readInt();
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    CharSequence _arg2 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    CharSequence _arg3 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    Icon _arg4 = data.readTypedObject(Icon.CREATOR);
                    IAddTileResultCallback _arg5 = IAddTileResultCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestAddTile(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    break;
                }
                case 71: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.cancelRequestAddTile(_arg0);
                    break;
                }
                case 72: {
                    int _arg0 = data.readInt();
                    MediaRoute2Info _arg1 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    IUndoMediaTransferCallback _arg2 = IUndoMediaTransferCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updateMediaTapToTransferSenderDisplay(_arg0, _arg1, _arg2);
                    break;
                }
                case 73: {
                    int _arg0 = data.readInt();
                    MediaRoute2Info _arg1 = data.readTypedObject(MediaRoute2Info.CREATOR);
                    Icon _arg2 = data.readTypedObject(Icon.CREATOR);
                    CharSequence _arg3 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.updateMediaTapToTransferReceiverDisplay(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 74: {
                    INearbyMediaDevicesProvider _arg0 = INearbyMediaDevicesProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerNearbyMediaDevicesProvider(_arg0);
                    break;
                }
                case 75: {
                    INearbyMediaDevicesProvider _arg0 = INearbyMediaDevicesProvider.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterNearbyMediaDevicesProvider(_arg0);
                    break;
                }
                case 76: {
                    String[] _arg0 = data.createStringArray();
                    ParcelFileDescriptor _arg1 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.dumpProto(_arg0, _arg1);
                    break;
                }
                case 77: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.showRearDisplayDialog(_arg0);
                    break;
                }
                case 78: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.moveFocusedTaskToFullscreen(_arg0);
                    break;
                }
                case 79: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.moveFocusedTaskToStageSplit(_arg0, _arg1);
                    break;
                }
                case 80: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSplitscreenFocus(_arg0);
                    break;
                }
                case 81: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.showMediaOutputSwitcher(_arg0, _arg1);
                    break;
                }
                case 82: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.moveFocusedTaskToDesktop(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 81;
        }

        private static class Proxy
        implements IStatusBar {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIcon(String slot, StatusBarIcon icon) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    _data.writeTypedObject(icon, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeIcon(String slot) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(slot);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disable(int displayId, int state1, int state2) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(state1);
                    _data.writeInt(state2);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableForAllDisplays(DisableStates disableStates) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(disableStates, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void animateExpandNotificationsPanel() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateExpandSettingsPanel(String subPanel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(subPanel);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void animateCollapsePanels() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleNotificationsPanel() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showWirelessChargingAnimation(int batteryLevel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(batteryLevel);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setImeWindowStatus(int displayId, int vis, int backDisposition, boolean showImeSwitcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(vis);
                    _data.writeInt(backDisposition);
                    _data.writeBoolean(showImeSwitcher);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowState(int display, int window, int state) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(display);
                    _data.writeInt(window);
                    _data.writeInt(state);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showRecentApps(boolean triggeredFromAltTab) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(triggeredFromAltTab);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(triggeredFromAltTab);
                    _data.writeBoolean(triggeredFromHomeKey);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleTaskbar() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void toggleSplitScreen() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void preloadRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void cancelPreloadRecentApps() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showScreenPinningRequest(int taskId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void confirmImmersivePrompt() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void immersiveModeChanged(int rootDisplayAreaId, boolean isImmersiveMode, int windowType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rootDisplayAreaId);
                    _data.writeBoolean(isImmersiveMode);
                    _data.writeInt(windowType);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void dismissKeyboardShortcutsMenu() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toggleKeyboardShortcutsMenu(int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionPending(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionCancelled(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionStarting(int displayId, long statusBarAnimationsStartTime, long statusBarAnimationsDuration) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeLong(statusBarAnimationsStartTime);
                    _data.writeLong(statusBarAnimationsDuration);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void appTransitionFinished(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showAssistDisclosure() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAssist(Bundle args) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(args, 0);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCameraLaunchGestureDetected(int source) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(source);
                    boolean bl = this.mRemote.transact(30, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onWalletLaunchGestureDetected() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(31, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onEmergencyActionLaunchGestureDetected() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showPictureInPictureMenu() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(33, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showGlobalActionsMenu() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProposedRotationChanged(int rotation, boolean isValid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    _data.writeBoolean(isValid);
                    boolean bl = this.mRemote.transact(35, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTopAppHidesStatusBar(boolean hidesStatusBar) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(hidesStatusBar);
                    boolean bl = this.mRemote.transact(36, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    boolean bl = this.mRemote.transact(37, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addQsTileToFrontOrEnd(ComponentName tile, boolean end) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    _data.writeBoolean(end);
                    boolean bl = this.mRemote.transact(38, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    boolean bl = this.mRemote.transact(39, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setQsTiles(String[] tiles) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(tiles);
                    boolean bl = this.mRemote.transact(40, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clickQsTile(ComponentName tile) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(tile, 0);
                    boolean bl = this.mRemote.transact(41, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleSystemKey(KeyEvent key) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(key, 0);
                    boolean bl = this.mRemote.transact(42, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showPinningEnterExitToast(boolean entering) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(entering);
                    boolean bl = this.mRemote.transact(43, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showPinningEscapeToast() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(44, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showShutdownUi(boolean isReboot, String reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(isReboot);
                    _data.writeString(reason);
                    boolean bl = this.mRemote.transact(45, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showAuthenticationDialog(PromptInfo promptInfo, IBiometricSysuiReceiver sysuiReceiver, int[] sensorIds, boolean credentialAllowed, boolean requireConfirmation, int userId, long operationId, String opPackageName, long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(promptInfo, 0);
                    _data.writeStrongInterface(sysuiReceiver);
                    _data.writeIntArray(sensorIds);
                    _data.writeBoolean(credentialAllowed);
                    _data.writeBoolean(requireConfirmation);
                    _data.writeInt(userId);
                    _data.writeLong(operationId);
                    _data.writeString(opPackageName);
                    _data.writeLong(requestId);
                    boolean bl = this.mRemote.transact(46, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricAuthenticated(int modality) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    boolean bl = this.mRemote.transact(47, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricHelp(int modality, String message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    _data.writeString(message);
                    boolean bl = this.mRemote.transact(48, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBiometricError(int modality, int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(modality);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean bl = this.mRemote.transact(49, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideAuthenticationDialog(long requestId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(requestId);
                    boolean bl = this.mRemote.transact(50, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setBiometicContextListener(IBiometricContextListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean bl = this.mRemote.transact(51, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUdfpsRefreshRateCallback(IUdfpsRefreshRateRequestCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(52, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayAddSystemDecorations(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(53, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDisplayRemoveSystemDecorations(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(54, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSystemBarAttributesChanged(int displayId, int appearance, AppearanceRegion[] appearanceRegions, boolean navbarColorManagedByIme, int behavior, int requestedVisibleTypes, String packageName, LetterboxDetails[] letterboxDetails) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(appearance);
                    _data.writeTypedArray(appearanceRegions, 0);
                    _data.writeBoolean(navbarColorManagedByIme);
                    _data.writeInt(behavior);
                    _data.writeInt(requestedVisibleTypes);
                    _data.writeString(packageName);
                    _data.writeTypedArray(letterboxDetails, 0);
                    boolean bl = this.mRemote.transact(55, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showTransient(int displayId, int types, boolean isGestureOnSystemBar) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(types);
                    _data.writeBoolean(isGestureOnSystemBar);
                    boolean bl = this.mRemote.transact(56, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void abortTransient(int displayId, int types) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(types);
                    boolean bl = this.mRemote.transact(57, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void showInattentiveSleepWarning() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(58, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissInattentiveSleepWarning(boolean animated) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(animated);
                    boolean bl = this.mRemote.transact(59, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showToast(int uid, String packageName, IBinder token, CharSequence text, IBinder windowToken, int duration, ITransientNotificationCallback callback, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(token);
                    if (text != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(text, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(windowToken);
                    _data.writeInt(duration);
                    _data.writeStrongInterface(callback);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(60, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideToast(String packageName, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(61, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void startTracing() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(62, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void stopTracing() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(63, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suppressAmbientDisplay(boolean suppress) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(suppress);
                    boolean bl = this.mRemote.transact(64, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestMagnificationConnection(boolean connect) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(connect);
                    boolean bl = this.mRemote.transact(65, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void passThroughShellCommand(String[] args, ParcelFileDescriptor pfd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(args);
                    _data.writeTypedObject(pfd, 0);
                    boolean bl = this.mRemote.transact(66, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavigationBarLumaSamplingEnabled(int displayId, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(enable);
                    boolean bl = this.mRemote.transact(67, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void runGcForTest() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(68, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestTileServiceListeningState(ComponentName componentName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(componentName, 0);
                    boolean bl = this.mRemote.transact(69, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAddTile(int callingUid, ComponentName componentName, CharSequence appName, CharSequence label, Icon icon, IAddTileResultCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(callingUid);
                    _data.writeTypedObject(componentName, 0);
                    if (appName != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(appName, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (label != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(label, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedObject(icon, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(70, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelRequestAddTile(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean bl = this.mRemote.transact(71, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateMediaTapToTransferSenderDisplay(int displayState, MediaRoute2Info routeInfo, IUndoMediaTransferCallback undoCallback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayState);
                    _data.writeTypedObject(routeInfo, 0);
                    _data.writeStrongInterface(undoCallback);
                    boolean bl = this.mRemote.transact(72, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateMediaTapToTransferReceiverDisplay(int displayState, MediaRoute2Info routeInfo, Icon appIcon, CharSequence appName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayState);
                    _data.writeTypedObject(routeInfo, 0);
                    _data.writeTypedObject(appIcon, 0);
                    if (appName != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(appName, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean bl = this.mRemote.transact(73, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(provider);
                    boolean bl = this.mRemote.transact(74, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(provider);
                    boolean bl = this.mRemote.transact(75, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dumpProto(String[] args, ParcelFileDescriptor pfd) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringArray(args);
                    _data.writeTypedObject(pfd, 0);
                    boolean bl = this.mRemote.transact(76, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showRearDisplayDialog(int currentBaseState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(currentBaseState);
                    boolean bl = this.mRemote.transact(77, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveFocusedTaskToFullscreen(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(78, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveFocusedTaskToStageSplit(int displayId, boolean leftOrTop) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(leftOrTop);
                    boolean bl = this.mRemote.transact(79, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSplitscreenFocus(boolean leftOrTop) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(leftOrTop);
                    boolean bl = this.mRemote.transact(80, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showMediaOutputSwitcher(String targetPackageName, UserHandle targetUserHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(targetPackageName);
                    _data.writeTypedObject(targetUserHandle, 0);
                    boolean bl = this.mRemote.transact(81, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void moveFocusedTaskToDesktop(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(82, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IStatusBar {
        @Override
        public void setIcon(String slot, StatusBarIcon icon) throws RemoteException {
        }

        @Override
        public void removeIcon(String slot) throws RemoteException {
        }

        @Override
        public void disable(int displayId, int state1, int state2) throws RemoteException {
        }

        @Override
        public void disableForAllDisplays(DisableStates disableStates) throws RemoteException {
        }

        @Override
        public void animateExpandNotificationsPanel() throws RemoteException {
        }

        @Override
        public void animateExpandSettingsPanel(String subPanel) throws RemoteException {
        }

        @Override
        public void animateCollapsePanels() throws RemoteException {
        }

        @Override
        public void toggleNotificationsPanel() throws RemoteException {
        }

        @Override
        public void showWirelessChargingAnimation(int batteryLevel) throws RemoteException {
        }

        @Override
        public void setImeWindowStatus(int displayId, int vis, int backDisposition, boolean showImeSwitcher) throws RemoteException {
        }

        @Override
        public void setWindowState(int display, int window, int state) throws RemoteException {
        }

        @Override
        public void showRecentApps(boolean triggeredFromAltTab) throws RemoteException {
        }

        @Override
        public void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) throws RemoteException {
        }

        @Override
        public void toggleRecentApps() throws RemoteException {
        }

        @Override
        public void toggleTaskbar() throws RemoteException {
        }

        @Override
        public void toggleSplitScreen() throws RemoteException {
        }

        @Override
        public void preloadRecentApps() throws RemoteException {
        }

        @Override
        public void cancelPreloadRecentApps() throws RemoteException {
        }

        @Override
        public void showScreenPinningRequest(int taskId) throws RemoteException {
        }

        @Override
        public void confirmImmersivePrompt() throws RemoteException {
        }

        @Override
        public void immersiveModeChanged(int rootDisplayAreaId, boolean isImmersiveMode, int windowType) throws RemoteException {
        }

        @Override
        public void dismissKeyboardShortcutsMenu() throws RemoteException {
        }

        @Override
        public void toggleKeyboardShortcutsMenu(int deviceId) throws RemoteException {
        }

        @Override
        public void appTransitionPending(int displayId) throws RemoteException {
        }

        @Override
        public void appTransitionCancelled(int displayId) throws RemoteException {
        }

        @Override
        public void appTransitionStarting(int displayId, long statusBarAnimationsStartTime, long statusBarAnimationsDuration) throws RemoteException {
        }

        @Override
        public void appTransitionFinished(int displayId) throws RemoteException {
        }

        @Override
        public void showAssistDisclosure() throws RemoteException {
        }

        @Override
        public void startAssist(Bundle args) throws RemoteException {
        }

        @Override
        public void onCameraLaunchGestureDetected(int source) throws RemoteException {
        }

        @Override
        public void onWalletLaunchGestureDetected() throws RemoteException {
        }

        @Override
        public void onEmergencyActionLaunchGestureDetected() throws RemoteException {
        }

        @Override
        public void showPictureInPictureMenu() throws RemoteException {
        }

        @Override
        public void showGlobalActionsMenu() throws RemoteException {
        }

        @Override
        public void onProposedRotationChanged(int rotation, boolean isValid) throws RemoteException {
        }

        @Override
        public void setTopAppHidesStatusBar(boolean hidesStatusBar) throws RemoteException {
        }

        @Override
        public void addQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void addQsTileToFrontOrEnd(ComponentName tile, boolean end) throws RemoteException {
        }

        @Override
        public void remQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void setQsTiles(String[] tiles) throws RemoteException {
        }

        @Override
        public void clickQsTile(ComponentName tile) throws RemoteException {
        }

        @Override
        public void handleSystemKey(KeyEvent key) throws RemoteException {
        }

        @Override
        public void showPinningEnterExitToast(boolean entering) throws RemoteException {
        }

        @Override
        public void showPinningEscapeToast() throws RemoteException {
        }

        @Override
        public void showShutdownUi(boolean isReboot, String reason) throws RemoteException {
        }

        @Override
        public void showAuthenticationDialog(PromptInfo promptInfo, IBiometricSysuiReceiver sysuiReceiver, int[] sensorIds, boolean credentialAllowed, boolean requireConfirmation, int userId, long operationId, String opPackageName, long requestId) throws RemoteException {
        }

        @Override
        public void onBiometricAuthenticated(int modality) throws RemoteException {
        }

        @Override
        public void onBiometricHelp(int modality, String message) throws RemoteException {
        }

        @Override
        public void onBiometricError(int modality, int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void hideAuthenticationDialog(long requestId) throws RemoteException {
        }

        @Override
        public void setBiometicContextListener(IBiometricContextListener listener) throws RemoteException {
        }

        @Override
        public void setUdfpsRefreshRateCallback(IUdfpsRefreshRateRequestCallback callback) throws RemoteException {
        }

        @Override
        public void onDisplayAddSystemDecorations(int displayId) throws RemoteException {
        }

        @Override
        public void onDisplayRemoveSystemDecorations(int displayId) throws RemoteException {
        }

        @Override
        public void onSystemBarAttributesChanged(int displayId, int appearance, AppearanceRegion[] appearanceRegions, boolean navbarColorManagedByIme, int behavior, int requestedVisibleTypes, String packageName, LetterboxDetails[] letterboxDetails) throws RemoteException {
        }

        @Override
        public void showTransient(int displayId, int types, boolean isGestureOnSystemBar) throws RemoteException {
        }

        @Override
        public void abortTransient(int displayId, int types) throws RemoteException {
        }

        @Override
        public void showInattentiveSleepWarning() throws RemoteException {
        }

        @Override
        public void dismissInattentiveSleepWarning(boolean animated) throws RemoteException {
        }

        @Override
        public void showToast(int uid, String packageName, IBinder token, CharSequence text, IBinder windowToken, int duration, ITransientNotificationCallback callback, int displayId) throws RemoteException {
        }

        @Override
        public void hideToast(String packageName, IBinder token) throws RemoteException {
        }

        @Override
        public void startTracing() throws RemoteException {
        }

        @Override
        public void stopTracing() throws RemoteException {
        }

        @Override
        public void suppressAmbientDisplay(boolean suppress) throws RemoteException {
        }

        @Override
        public void requestMagnificationConnection(boolean connect) throws RemoteException {
        }

        @Override
        public void passThroughShellCommand(String[] args, ParcelFileDescriptor pfd) throws RemoteException {
        }

        @Override
        public void setNavigationBarLumaSamplingEnabled(int displayId, boolean enable) throws RemoteException {
        }

        @Override
        public void runGcForTest() throws RemoteException {
        }

        @Override
        public void requestTileServiceListeningState(ComponentName componentName) throws RemoteException {
        }

        @Override
        public void requestAddTile(int callingUid, ComponentName componentName, CharSequence appName, CharSequence label, Icon icon, IAddTileResultCallback callback) throws RemoteException {
        }

        @Override
        public void cancelRequestAddTile(String packageName) throws RemoteException {
        }

        @Override
        public void updateMediaTapToTransferSenderDisplay(int displayState, MediaRoute2Info routeInfo, IUndoMediaTransferCallback undoCallback) throws RemoteException {
        }

        @Override
        public void updateMediaTapToTransferReceiverDisplay(int displayState, MediaRoute2Info routeInfo, Icon appIcon, CharSequence appName) throws RemoteException {
        }

        @Override
        public void registerNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider) throws RemoteException {
        }

        @Override
        public void unregisterNearbyMediaDevicesProvider(INearbyMediaDevicesProvider provider) throws RemoteException {
        }

        @Override
        public void dumpProto(String[] args, ParcelFileDescriptor pfd) throws RemoteException {
        }

        @Override
        public void showRearDisplayDialog(int currentBaseState) throws RemoteException {
        }

        @Override
        public void moveFocusedTaskToFullscreen(int displayId) throws RemoteException {
        }

        @Override
        public void moveFocusedTaskToStageSplit(int displayId, boolean leftOrTop) throws RemoteException {
        }

        @Override
        public void setSplitscreenFocus(boolean leftOrTop) throws RemoteException {
        }

        @Override
        public void showMediaOutputSwitcher(String targetPackageName, UserHandle targetUserHandle) throws RemoteException {
        }

        @Override
        public void moveFocusedTaskToDesktop(int displayId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

