/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.protolog;

import android.os.ServiceManager;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import android.tracing.Flags;
import android.tracing.perfetto.DataSourceParams;
import android.tracing.perfetto.InitArguments;
import android.tracing.perfetto.Producer;
import com.android.internal.protolog.LogcatOnlyProtoLogImpl;
import com.android.internal.protolog.PerfettoProtoLogImpl;
import com.android.internal.protolog.ProtoLogDataSource;
import com.android.internal.protolog.UnprocessedPerfettoProtoLogImpl;
import com.android.internal.protolog.common.IProtoLog;
import com.android.internal.protolog.common.IProtoLogGroup;
import com.android.internal.protolog.common.LogLevel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

@RavenwoodKeepWholeClass
public class ProtoLog {
    @Deprecated
    public static boolean REQUIRE_PROTOLOGTOOL = true;
    private static IProtoLog sProtoLogInstance;
    private static ProtoLogDataSource sDataSource;
    private static final Object sInitLock;

    public static void init(IProtoLogGroup ... groups) {
        if (ProtoLog.logOnlyToLogcat()) {
            sProtoLogInstance = new LogcatOnlyProtoLogImpl();
        } else {
            ProtoLog.initializePerfettoProtoLog(groups);
        }
    }

    @RavenwoodReplace(reason="Always use the Log backend on ravenwood, not Perfetto")
    private static boolean logOnlyToLogcat() {
        return !Flags.perfettoProtologTracing();
    }

    private static boolean logOnlyToLogcat$ravenwood() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializePerfettoProtoLog(IProtoLogGroup ... groups) {
        ProtoLogDataSource datasource = ProtoLog.getSharedSingleInstanceDataSource();
        Object object = sInitLock;
        synchronized (object) {
            HashSet<IProtoLogGroup> allGroups = new HashSet<IProtoLogGroup>(Arrays.stream(groups).toList());
            IProtoLog previousProtoLogImpl = sProtoLogInstance;
            if (previousProtoLogImpl != null) {
                List<IProtoLogGroup> alreadyRegisteredGroups = previousProtoLogImpl.getRegisteredGroups();
                allGroups.addAll(alreadyRegisteredGroups);
            }
            sProtoLogInstance = ProtoLog.createAndEnableNewPerfettoProtoLogImpl(datasource, allGroups.toArray(new IProtoLogGroup[0]));
            if (previousProtoLogImpl instanceof PerfettoProtoLogImpl) {
                ((PerfettoProtoLogImpl)previousProtoLogImpl).disable();
            }
        }
    }

    private static PerfettoProtoLogImpl createAndEnableNewPerfettoProtoLogImpl(ProtoLogDataSource datasource, IProtoLogGroup[] groups) {
        try {
            UnprocessedPerfettoProtoLogImpl unprocessedPerfettoProtoLogImpl = new UnprocessedPerfettoProtoLogImpl(datasource, groups);
            unprocessedPerfettoProtoLogImpl.enable();
            return unprocessedPerfettoProtoLogImpl;
        }
        catch (ServiceManager.ServiceNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void d(IProtoLogGroup group, String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.DEBUG, group, messageString, args);
    }

    public static void v(IProtoLogGroup group, String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.VERBOSE, group, messageString, args);
    }

    public static void i(IProtoLogGroup group, String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.INFO, group, messageString, args);
    }

    public static void w(IProtoLogGroup group, String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.WARN, group, messageString, args);
    }

    public static void e(IProtoLogGroup group, String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.ERROR, group, messageString, args);
    }

    public static void wtf(IProtoLogGroup group, String messageString, Object ... args) {
        ProtoLog.logStringMessage(LogLevel.WTF, group, messageString, args);
    }

    public static boolean isEnabled(IProtoLogGroup group, LogLevel level) {
        return sProtoLogInstance.isEnabled(group, level);
    }

    public static IProtoLog getSingleInstance() {
        return sProtoLogInstance;
    }

    public static synchronized ProtoLogDataSource getSharedSingleInstanceDataSource() {
        if (sDataSource == null) {
            Producer.init(InitArguments.DEFAULTS);
            sDataSource = new ProtoLogDataSource();
            DataSourceParams params = new DataSourceParams.Builder().setBufferExhaustedPolicy(0).build();
            sDataSource.register(params);
        }
        return sDataSource;
    }

    private static void logStringMessage(LogLevel logLevel, IProtoLogGroup group, String stringMessage, Object ... args) {
        if (sProtoLogInstance == null) {
            throw new IllegalStateException("Trying to use ProtoLog before it is initialized in this process.");
        }
        if (sProtoLogInstance.isEnabled(group, logLevel)) {
            sProtoLogInstance.log(logLevel, group, stringMessage, args);
        }
    }

    static {
        sInitLock = new Object();
    }
}

