/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.protolog;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IProtoLogClient
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.protolog.IProtoLogClient";

    public void toggleLogcat(boolean var1, String[] var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IProtoLogClient {
        static final int TRANSACTION_toggleLogcat = 1;

        public Stub() {
            this.attachInterface(this, IProtoLogClient.DESCRIPTOR);
        }

        public static IProtoLogClient asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IProtoLogClient.DESCRIPTOR);
            if (iin != null && iin instanceof IProtoLogClient) {
                return (IProtoLogClient)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "toggleLogcat";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IProtoLogClient.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    String[] _arg1 = data.createStringArray();
                    data.enforceNoDataAvail();
                    this.toggleLogcat(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IProtoLogClient {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IProtoLogClient.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void toggleLogcat(boolean enabled, String[] groups) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IProtoLogClient.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    _data.writeStringArray(groups);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IProtoLogClient {
        @Override
        public void toggleLogcat(boolean enabled, String[] groups) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

