/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.pm.pkg.component;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.ArraySet;
import com.android.internal.R;
import com.android.internal.pm.pkg.component.ParsedAttribution;
import com.android.internal.pm.pkg.component.ParsedAttributionImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedAttributionUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static ParseResult<ParsedAttribution> parseAttribution(Resources res, XmlResourceParser parser, ParseInput input) throws IOException, XmlPullParserException {
        int type;
        int label;
        String attributionTag;
        List<String> inheritFrom = null;
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestAttribution);
        if (sa == null) {
            return input.error("<attribution> could not be parsed");
        }
        try {
            attributionTag = sa.getNonConfigurationString(1, 0);
            if (attributionTag == null) {
                ParseResult<ParsedAttribution> parseResult = input.error("<attribution> does not specify android:tag");
                return parseResult;
            }
            if (attributionTag.length() > 50) {
                ParseResult<ParsedAttribution> parseResult = input.error("android:tag is too long. Max length is 50");
                return parseResult;
            }
            label = sa.getResourceId(0, 0);
            if (label == 0) {
                ParseResult<ParsedAttribution> parseResult = input.error("<attribution> does not specify android:label");
                return parseResult;
            }
        }
        finally {
            sa.recycle();
        }
        int innerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("inherit-from")) {
                sa = res.obtainAttributes(parser, R.styleable.AndroidManifestAttributionInheritFrom);
                if (sa == null) {
                    return input.error("<inherit-from> could not be parsed");
                }
                try {
                    String inheritFromId = sa.getNonConfigurationString(0, 0);
                    if (inheritFrom == null) {
                        inheritFrom = new ArrayList<String>();
                    }
                    inheritFrom.add(inheritFromId);
                    continue;
                }
                finally {
                    sa.recycle();
                    continue;
                }
            }
            return input.error("Bad element under <attribution>: " + tagName);
        }
        if (inheritFrom == null) {
            inheritFrom = Collections.emptyList();
        } else {
            ((ArrayList)inheritFrom).trimToSize();
        }
        return input.success(new ParsedAttributionImpl(attributionTag, label, inheritFrom));
    }

    public static boolean isCombinationValid(@Nullable List<ParsedAttribution> attributions) {
        int attributionNum;
        if (attributions == null) {
            return true;
        }
        ArraySet<String> attributionTags = new ArraySet<String>(attributions.size());
        ArraySet<String> inheritFromAttributionTags = new ArraySet<String>();
        int numAttributions = attributions.size();
        if (numAttributions > 400) {
            return false;
        }
        for (attributionNum = 0; attributionNum < numAttributions; ++attributionNum) {
            boolean wasAdded = attributionTags.add(attributions.get(attributionNum).getTag());
            if (wasAdded) continue;
            return false;
        }
        for (attributionNum = 0; attributionNum < numAttributions; ++attributionNum) {
            ParsedAttribution feature = attributions.get(attributionNum);
            List<String> inheritFromList = feature.getInheritFrom();
            int numInheritFrom = inheritFromList.size();
            for (int inheritFromNum = 0; inheritFromNum < numInheritFrom; ++inheritFromNum) {
                String inheritFrom = inheritFromList.get(inheritFromNum);
                if (attributionTags.contains(inheritFrom)) {
                    return false;
                }
                boolean wasAdded = inheritFromAttributionTags.add(inheritFrom);
                if (wasAdded) continue;
                return false;
            }
        }
        return true;
    }
}

