/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.pm.ApplicationInfo;
import android.net.Credentials;
import android.net.LocalSocket;
import android.os.Parcel;
import android.os.Process;
import android.os.Trace;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructPollfd;
import android.util.Log;
import com.android.internal.lang.System_Delegate;
import com.android.internal.os.StatsdHiddenApiUsageLogger;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteArguments;
import com.android.internal.os.ZygoteCommandBuffer;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import com.android.internal.os.ZygoteServer;
import dalvik.system.VMRuntime;
import dalvik.system.ZygoteHooks;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;

class ZygoteConnection {
    private static final String TAG = "Zygote";
    @UnsupportedAppUsage
    private final LocalSocket mSocket;
    @UnsupportedAppUsage
    private final DataOutputStream mSocketOutStream;
    @UnsupportedAppUsage
    private final Credentials peer;
    private final String abiList;
    private boolean isEof;

    ZygoteConnection(LocalSocket socket, String abiList) throws IOException {
        this.mSocket = socket;
        this.abiList = abiList;
        this.mSocketOutStream = new DataOutputStream(socket.getOutputStream());
        this.mSocket.setSoTimeout(1000);
        try {
            this.peer = this.mSocket.getPeerCredentials();
        }
        catch (IOException ex) {
            Log.e(TAG, "Cannot read peer credentials", ex);
            throw ex;
        }
        if (this.peer.getUid() != 1000) {
            throw new ZygoteSecurityException("Only system UID is allowed to connect to Zygote.");
        }
        this.isEof = false;
    }

    FileDescriptor getFileDescriptor() {
        return this.mSocket.getFileDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runnable processCommand(ZygoteServer zygoteServer, boolean multipleOK) {
        ZygoteArguments parsedArgs;
        block40: {
            Runnable result;
            ZygoteCommandBuffer argBuffer = new ZygoteCommandBuffer(this.mSocket);
            while (true) {
                FileDescriptor zygoteFd;
                Runnable runnable;
                try {
                    parsedArgs = ZygoteArguments.getInstance(argBuffer);
                }
                catch (IOException ex) {
                    throw new IllegalStateException("IOException on command socket", ex);
                }
                if (parsedArgs == null) {
                    this.isEof = true;
                    Runnable ex = null;
                    return ex;
                }
                FileDescriptor childPipeFd = null;
                FileDescriptor serverPipeFd = null;
                if (parsedArgs.mBootCompleted) {
                    this.handleBootCompleted();
                    runnable = null;
                    return runnable;
                }
                if (parsedArgs.mAbiListQuery) {
                    this.handleAbiListQuery();
                    runnable = null;
                    return runnable;
                }
                if (parsedArgs.mPidQuery) {
                    this.handlePidQuery();
                    runnable = null;
                    return runnable;
                }
                if (parsedArgs.mUsapPoolStatusSpecified || parsedArgs.mApiDenylistExemptions != null || parsedArgs.mHiddenApiAccessLogSampleRate != -1) break block40;
                if (parsedArgs.mHiddenApiAccessStatslogSampleRate != -1) {
                    break block40;
                }
                if (parsedArgs.mPreloadDefault) {
                    this.handlePreload();
                    runnable = null;
                    return runnable;
                }
                if (this.canPreloadApp() && parsedArgs.mPreloadApp != null) {
                    byte[] rawParcelData = Base64.getDecoder().decode(parsedArgs.mPreloadApp);
                    Parcel appInfoParcel = Parcel.obtain();
                    appInfoParcel.unmarshall(rawParcelData, 0, rawParcelData.length);
                    appInfoParcel.setDataPosition(0);
                    ApplicationInfo appInfo = ApplicationInfo.CREATOR.createFromParcel(appInfoParcel);
                    appInfoParcel.recycle();
                    if (appInfo == null) {
                        throw new IllegalArgumentException("Failed to deserialize --preload-app");
                    }
                    this.handlePreloadApp(appInfo);
                    Runnable runnable2 = null;
                    return runnable2;
                }
                if (parsedArgs.mPermittedCapabilities != 0L || parsedArgs.mEffectiveCapabilities != 0L) {
                    throw new ZygoteSecurityException("Client may not specify capabilities: permitted=0x" + Long.toHexString(parsedArgs.mPermittedCapabilities) + ", effective=0x" + Long.toHexString(parsedArgs.mEffectiveCapabilities));
                }
                Zygote.applyUidSecurityPolicy(parsedArgs, this.peer);
                Zygote.applyInvokeWithSecurityPolicy(parsedArgs, this.peer);
                Zygote.applyDebuggerSystemProperty(parsedArgs);
                Zygote.applyInvokeWithSystemProperty(parsedArgs);
                int[][] rlimits = null;
                if (parsedArgs.mRLimits != null) {
                    rlimits = (int[][])parsedArgs.mRLimits.toArray((T[])Zygote.INT_ARRAY_2D);
                }
                int[] fdsToIgnore = null;
                if (parsedArgs.mInvokeWith != null) {
                    try {
                        FileDescriptor[] pipeFds = Os.pipe2(OsConstants.O_CLOEXEC);
                        childPipeFd = pipeFds[1];
                        serverPipeFd = pipeFds[0];
                        Os.fcntlInt(childPipeFd, OsConstants.F_SETFD, 0);
                        fdsToIgnore = new int[]{childPipeFd.getInt$(), serverPipeFd.getInt$()};
                    }
                    catch (ErrnoException errnoEx) {
                        throw new IllegalStateException("Unable to set up pipe for invoke-with", errnoEx);
                    }
                }
                int[] fdsToClose = new int[]{-1, -1};
                FileDescriptor fd = this.mSocket.getFileDescriptor();
                if (fd != null) {
                    fdsToClose[0] = fd.getInt$();
                }
                if ((zygoteFd = zygoteServer.getZygoteSocketFileDescriptor()) != null) {
                    fdsToClose[1] = zygoteFd.getInt$();
                }
                if (parsedArgs.mInvokeWith != null || parsedArgs.mStartChildZygote || !multipleOK || this.peer.getUid() != 1000) {
                    Runnable runnable3;
                    int pid = Zygote.forkAndSpecialize(parsedArgs.mUid, parsedArgs.mGid, parsedArgs.mGids, parsedArgs.mRuntimeFlags, rlimits, parsedArgs.mMountExternal, parsedArgs.mSeInfo, parsedArgs.mNiceName, fdsToClose, fdsToIgnore, parsedArgs.mStartChildZygote, parsedArgs.mInstructionSet, parsedArgs.mAppDataDir, parsedArgs.mIsTopApp, parsedArgs.mPkgDataInfoList, parsedArgs.mAllowlistedDataInfoList, parsedArgs.mBindMountAppDataDirs, parsedArgs.mBindMountAppStorageDirs, parsedArgs.mBindMountSyspropOverrides);
                    if (pid == 0) {
                        zygoteServer.setForkChild();
                        zygoteServer.closeServerSocket();
                        IoUtils.closeQuietly(serverPipeFd);
                        serverPipeFd = null;
                        runnable3 = this.handleChildProc(parsedArgs, childPipeFd, parsedArgs.mStartChildZygote);
                        return runnable3;
                    }
                    IoUtils.closeQuietly(childPipeFd);
                    childPipeFd = null;
                    this.handleParentProc(pid, serverPipeFd);
                    runnable3 = null;
                    return runnable3;
                    finally {
                        IoUtils.closeQuietly(childPipeFd);
                        IoUtils.closeQuietly(serverPipeFd);
                    }
                }
                ZygoteHooks.preFork();
                result = Zygote.forkSimpleApps(argBuffer, zygoteServer.getZygoteSocketFileDescriptor(), this.peer.getUid(), Zygote.minChildUid(this.peer), parsedArgs.mNiceName);
                if (result != null) break;
                ZygoteHooks.postForkCommon();
            }
            zygoteServer.setForkChild();
            Runnable runnable = result;
            return runnable;
            finally {
                argBuffer.close();
            }
        }
        if (parsedArgs.mUsapPoolStatusSpecified) {
            return this.handleUsapPoolStatusChange(zygoteServer, parsedArgs.mUsapPoolEnabled);
        }
        if (parsedArgs.mApiDenylistExemptions != null) {
            return this.handleApiDenylistExemptions(zygoteServer, parsedArgs.mApiDenylistExemptions);
        }
        if (parsedArgs.mHiddenApiAccessLogSampleRate != -1 || parsedArgs.mHiddenApiAccessStatslogSampleRate != -1) {
            return this.handleHiddenApiAccessLogSampleRate(zygoteServer, parsedArgs.mHiddenApiAccessLogSampleRate, parsedArgs.mHiddenApiAccessStatslogSampleRate);
        }
        throw new AssertionError((Object)"Shouldn't get here");
    }

    private void handleAbiListQuery() {
        try {
            byte[] abiListBytes = this.abiList.getBytes(StandardCharsets.US_ASCII);
            this.mSocketOutStream.writeInt(abiListBytes.length);
            this.mSocketOutStream.write(abiListBytes);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private void handlePidQuery() {
        try {
            String pidString = String.valueOf(Process.myPid());
            byte[] pidStringBytes = pidString.getBytes(StandardCharsets.US_ASCII);
            this.mSocketOutStream.writeInt(pidStringBytes.length);
            this.mSocketOutStream.write(pidStringBytes);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private void handleBootCompleted() {
        try {
            this.mSocketOutStream.writeInt(0);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
        VMRuntime.bootCompleted();
    }

    private void handlePreload() {
        try {
            if (this.isPreloadComplete()) {
                this.mSocketOutStream.writeInt(1);
            } else {
                this.preload();
                this.mSocketOutStream.writeInt(0);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private Runnable stateChangeWithUsapPoolReset(ZygoteServer zygoteServer, Runnable stateChangeCode) {
        try {
            if (zygoteServer.isUsapPoolEnabled()) {
                Log.i(TAG, "Emptying USAP Pool due to state change.");
                Zygote.emptyUsapPool();
            }
            stateChangeCode.run();
            if (zygoteServer.isUsapPoolEnabled()) {
                Runnable fpResult = zygoteServer.fillUsapPool(new int[]{this.mSocket.getFileDescriptor().getInt$()}, false);
                if (fpResult != null) {
                    zygoteServer.setForkChild();
                    return fpResult;
                }
                Log.i(TAG, "Finished refilling USAP Pool after state change.");
            }
            this.mSocketOutStream.writeInt(0);
            return null;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private Runnable handleApiDenylistExemptions(ZygoteServer zygoteServer, String[] exemptions) {
        return this.stateChangeWithUsapPoolReset(zygoteServer, () -> ZygoteInit.setApiDenylistExemptions(exemptions));
    }

    private Runnable handleUsapPoolStatusChange(ZygoteServer zygoteServer, boolean newStatus) {
        try {
            Runnable fpResult = zygoteServer.setUsapPoolStatus(newStatus, this.mSocket);
            if (fpResult == null) {
                this.mSocketOutStream.writeInt(0);
            } else {
                zygoteServer.setForkChild();
            }
            return fpResult;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error writing to command socket", ioe);
        }
    }

    private Runnable handleHiddenApiAccessLogSampleRate(ZygoteServer zygoteServer, int samplingRate, int statsdSamplingRate) {
        return this.stateChangeWithUsapPoolReset(zygoteServer, () -> {
            int maxSamplingRate = Math.max(samplingRate, statsdSamplingRate);
            ZygoteInit.setHiddenApiAccessLogSampleRate(maxSamplingRate);
            StatsdHiddenApiUsageLogger.setHiddenApiAccessLogSampleRates(samplingRate, statsdSamplingRate);
            ZygoteInit.setHiddenApiUsageLogger(StatsdHiddenApiUsageLogger.getInstance());
        });
    }

    protected void preload() {
        ZygoteInit.lazyPreload();
    }

    protected boolean isPreloadComplete() {
        return ZygoteInit.isPreloadComplete();
    }

    protected DataOutputStream getSocketOutputStream() {
        return this.mSocketOutStream;
    }

    protected boolean canPreloadApp() {
        return false;
    }

    protected void handlePreloadApp(ApplicationInfo aInfo) {
        throw new RuntimeException("Zygote does not support app preloading");
    }

    @UnsupportedAppUsage
    void closeSocket() {
        try {
            this.mSocket.close();
        }
        catch (IOException ex) {
            Log.e(TAG, "Exception while closing command socket in parent", ex);
        }
    }

    boolean isClosedByPeer() {
        return this.isEof;
    }

    private Runnable handleChildProc(ZygoteArguments parsedArgs, FileDescriptor pipeFd, boolean isZygote) {
        this.closeSocket();
        Zygote.setAppProcessName(parsedArgs, TAG);
        Trace.traceEnd(64L);
        if (parsedArgs.mInvokeWith != null) {
            WrapperInit.execApplication(parsedArgs.mInvokeWith, parsedArgs.mNiceName, parsedArgs.mTargetSdkVersion, VMRuntime.getCurrentInstructionSet(), pipeFd, parsedArgs.mRemainingArgs);
            throw new IllegalStateException("WrapperInit.execApplication unexpectedly returned");
        }
        if (!isZygote) {
            return ZygoteInit.zygoteInit(parsedArgs.mTargetSdkVersion, parsedArgs.mDisabledCompatChanges, parsedArgs.mRemainingArgs, null);
        }
        return ZygoteInit.childZygoteInit(parsedArgs.mRemainingArgs);
    }

    private void handleParentProc(int pid, FileDescriptor pipeFd) {
        if (pid > 0) {
            this.setChildPgid(pid);
        }
        boolean usingWrapper = false;
        if (pipeFd != null && pid > 0) {
            int innerPid = -1;
            try {
                int BYTES_REQUIRED = 4;
                StructPollfd[] fds = new StructPollfd[]{new StructPollfd()};
                byte[] data = new byte[4];
                int remainingSleepTime = 20000;
                int dataIndex = 0;
                long startTime = System_Delegate.nanoTime();
                while (dataIndex < data.length && remainingSleepTime > 0) {
                    fds[0].fd = pipeFd;
                    fds[0].events = (short)OsConstants.POLLIN;
                    fds[0].revents = 0;
                    fds[0].userData = null;
                    int res = Os.poll(fds, remainingSleepTime);
                    long endTime = System_Delegate.nanoTime();
                    int elapsedTimeMs = (int)TimeUnit.MILLISECONDS.convert(endTime - startTime, TimeUnit.NANOSECONDS);
                    remainingSleepTime = 20000 - elapsedTimeMs;
                    if (res > 0) {
                        if ((fds[0].revents & OsConstants.POLLIN) == 0) break;
                        int readBytes = Os.read(pipeFd, data, dataIndex, 1);
                        if (readBytes < 0) {
                            throw new RuntimeException("Some error");
                        }
                        dataIndex += readBytes;
                        continue;
                    }
                    if (res != 0) continue;
                    Log.w(TAG, "Timed out waiting for child.");
                }
                if (dataIndex == data.length) {
                    DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
                    innerPid = is.readInt();
                }
                if (innerPid == -1) {
                    Log.w(TAG, "Error reading pid from wrapped process, child may have died");
                }
            }
            catch (Exception ex) {
                Log.w(TAG, "Error reading pid from wrapped process, child may have died", ex);
            }
            if (innerPid > 0) {
                int parentPid = innerPid;
                while (parentPid > 0 && parentPid != pid) {
                    parentPid = Process.getParentPid(parentPid);
                }
                if (parentPid > 0) {
                    Log.i(TAG, "Wrapped process has pid " + innerPid);
                    pid = innerPid;
                    usingWrapper = true;
                } else {
                    Log.w(TAG, "Wrapped process reported a pid that is not a child of the process that we forked: childPid=" + pid + " innerPid=" + innerPid);
                }
            }
        }
        try {
            this.mSocketOutStream.writeInt(pid);
            this.mSocketOutStream.writeBoolean(usingWrapper);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error writing to command socket", ex);
        }
    }

    private void setChildPgid(int pid) {
        try {
            Os.setpgid(pid, Os.getpgid(this.peer.getPid()));
        }
        catch (ErrnoException ex) {
            Log.i(TAG, "Zygote: setpgid failed. This is normal if peer is not in our session");
        }
    }
}

