/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Intent;
import android.content.pm.ServiceInfo;
import com.android.internal.annotations.VisibleForTesting;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DebugStore {
    private static final boolean DEBUG_EVENTS = false;
    private static final String TAG = "DebugStore";
    private static DebugStoreNative sDebugStoreNative = new DebugStoreNativeImpl();

    @UnsupportedAppUsage
    @VisibleForTesting
    public static void setDebugStoreNative(DebugStoreNative nativeImpl) {
        sDebugStoreNative = nativeImpl;
    }

    @UnsupportedAppUsage
    public static long recordServiceOnStart(int startId, int flags, @Nullable Intent intent) {
        return sDebugStoreNative.beginEvent("SvcStart", List.of("stId", String.valueOf(startId), "flg", Integer.toHexString(flags), "act", Objects.toString(intent != null ? intent.getAction() : null), "comp", Objects.toString(intent != null ? intent.getComponent() : null), "pkg", Objects.toString(intent != null ? intent.getPackage() : null)));
    }

    @UnsupportedAppUsage
    public static long recordServiceCreate(@Nullable ServiceInfo serviceInfo) {
        return sDebugStoreNative.beginEvent("SvcCreate", List.of("name", Objects.toString(serviceInfo != null ? serviceInfo.name : null), "pkg", Objects.toString(serviceInfo != null ? serviceInfo.packageName : null)));
    }

    @UnsupportedAppUsage
    public static long recordServiceBind(boolean isRebind, @Nullable Intent intent) {
        return sDebugStoreNative.beginEvent("SvcBind", List.of("rebind", String.valueOf(isRebind), "act", Objects.toString(intent != null ? intent.getAction() : null), "cmp", Objects.toString(intent != null ? intent.getComponent() : null), "pkg", Objects.toString(intent != null ? intent.getPackage() : null)));
    }

    @UnsupportedAppUsage
    public static void recordGoAsync(int pendingResultId) {
        sDebugStoreNative.recordEvent("GoAsync", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static void recordFinish(int pendingResultId) {
        sDebugStoreNative.recordEvent("Finish", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static void recordLongLooperMessage(int messageCode, String targetClass, long elapsedTimeMs) {
        sDebugStoreNative.recordEvent("LooperMsg", List.of("code", String.valueOf(messageCode), "trgt", Objects.toString(targetClass), "elapsed", String.valueOf(elapsedTimeMs)));
    }

    @UnsupportedAppUsage
    public static long recordBroadcastReceive(@Nullable Intent intent, int pendingResultId) {
        return sDebugStoreNative.beginEvent("BcRcv", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "act", Objects.toString(intent != null ? intent.getAction() : null), "cmp", Objects.toString(intent != null ? intent.getComponent() : null), "pkg", Objects.toString(intent != null ? intent.getPackage() : null), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static long recordBroadcastReceiveReg(@Nullable Intent intent, int pendingResultId) {
        return sDebugStoreNative.beginEvent("BcRcvReg", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId()), "act", Objects.toString(intent != null ? intent.getAction() : null), "cmp", Objects.toString(intent != null ? intent.getComponent() : null), "pkg", Objects.toString(intent != null ? intent.getPackage() : null), "prid", Integer.toHexString(pendingResultId)));
    }

    @UnsupportedAppUsage
    public static long recordHandleBindApplication() {
        return sDebugStoreNative.beginEvent("BindApp", List.of());
    }

    @UnsupportedAppUsage
    public static long recordScheduleReceiver() {
        return sDebugStoreNative.beginEvent("SchRcv", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId())));
    }

    @UnsupportedAppUsage
    public static long recordScheduleRegisteredReceiver() {
        return sDebugStoreNative.beginEvent("SchRcvReg", List.of("tname", Thread.currentThread().getName(), "tid", String.valueOf(Thread.currentThread().getId())));
    }

    @UnsupportedAppUsage
    public static void recordEventEnd(long id2) {
        sDebugStoreNative.endEvent(id2, Collections.emptyList());
    }

    private static long beginEventNative(String string2, List<String> list) {
        return OverrideMethod.invokeL("com.android.internal.os.DebugStore#beginEventNative(Ljava/lang/String;Ljava/util/List;)J", true, null);
    }

    private static void endEventNative(long l, List<String> list) {
        OverrideMethod.invokeV("com.android.internal.os.DebugStore#endEventNative(JLjava/util/List;)V", true, null);
    }

    private static void recordEventNative(String string2, List<String> list) {
        OverrideMethod.invokeV("com.android.internal.os.DebugStore#recordEventNative(Ljava/lang/String;Ljava/util/List;)V", true, null);
    }

    @VisibleForTesting
    public static interface DebugStoreNative {
        public long beginEvent(String var1, List<String> var2);

        public void endEvent(long var1, List<String> var3);

        public void recordEvent(String var1, List<String> var2);
    }

    private static class DebugStoreNativeImpl
    implements DebugStoreNative {
        private DebugStoreNativeImpl() {
        }

        @Override
        public long beginEvent(String eventName, List<String> attributes) {
            long id2 = DebugStore.beginEventNative(eventName, attributes);
            return id2;
        }

        @Override
        public void endEvent(long id2, List<String> attributes) {
            DebugStore.endEventNative(id2, attributes);
        }

        @Override
        public void recordEvent(String eventName, List<String> attributes) {
            DebugStore.recordEventNative(eventName, attributes);
        }

        private String attributeString(List<String> attributes) {
            StringBuilder sb = new StringBuilder().append("[");
            for (int i = 0; i < attributes.size(); ++i) {
                sb.append(attributes.get(i));
                if (i % 2 == 0) {
                    sb.append("=");
                    continue;
                }
                if (i >= attributes.size() - 1) continue;
                sb.append(", ");
            }
            return sb.append("]").toString();
        }
    }
}

