/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Binder;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.Flags;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class BinderTransactionNameResolver {
    private static final Method NO_GET_DEFAULT_TRANSACTION_NAME_METHOD;
    private static final boolean USE_TRANSACTION_CODES_FOR_UNKNOWN_METHODS;
    private final HashMap<Class<? extends Binder>, Method> mGetDefaultTransactionNameMethods = new HashMap();

    public static String noDefaultTransactionName(int transactionCode) {
        return String.valueOf(transactionCode);
    }

    public String getMethodName(Class<? extends Binder> binderClass, int transactionCode) {
        Method method = this.mGetDefaultTransactionNameMethods.get(binderClass);
        if (method == null) {
            try {
                method = binderClass.getMethod("getDefaultTransactionName", Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                method = NO_GET_DEFAULT_TRANSACTION_NAME_METHOD;
            }
            if (method.getReturnType() != String.class || !Modifier.isStatic(method.getModifiers())) {
                method = NO_GET_DEFAULT_TRANSACTION_NAME_METHOD;
            }
            this.mGetDefaultTransactionNameMethods.put(binderClass, method);
        }
        try {
            String methodName = (String)method.invoke(null, transactionCode);
            if (USE_TRANSACTION_CODES_FOR_UNKNOWN_METHODS) {
                return TextUtils.isEmpty(methodName) ? String.valueOf(transactionCode) : methodName;
            }
            return methodName;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        USE_TRANSACTION_CODES_FOR_UNKNOWN_METHODS = Flags.useTransactionCodesForUnknownMethods();
        try {
            NO_GET_DEFAULT_TRANSACTION_NAME_METHOD = BinderTransactionNameResolver.class.getMethod("noDefaultTransactionName", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

