/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.annotation.NonNull;
import android.os.BatteryStats;
import android.os.Parcel;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.os.BatteryStatsHistory;
import com.android.internal.os.PowerStats;
import java.util.Iterator;
import java.util.Queue;

@RavenwoodKeepWholeClass
public class BatteryStatsHistoryIterator
implements Iterator<BatteryStats.HistoryItem>,
AutoCloseable {
    private static final boolean DEBUG = false;
    private static final String TAG = "BatteryStatsHistoryItr";
    private final BatteryStatsHistory mBatteryStatsHistory;
    private final long mStartTimeMs;
    private final long mEndTimeMs;
    private final BatteryStats.HistoryStepDetails mReadHistoryStepDetails = new BatteryStats.HistoryStepDetails();
    private final SparseArray<BatteryStats.HistoryTag> mHistoryTags = new SparseArray();
    private final PowerStats.DescriptorRegistry mDescriptorRegistry = new PowerStats.DescriptorRegistry();
    private BatteryStats.HistoryItem mHistoryItem = new BatteryStats.HistoryItem();
    private boolean mNextItemReady;
    private boolean mTimeInitialized;
    private boolean mClosed;
    private long mBaseMonotonicTime;
    private long mBaseTimeUtc;
    private int mItemIndex = 0;
    private final int mMaxHistoryItems;
    private int mParcelDataPosition;
    private Queue<BatteryStatsHistory.BatteryHistoryParcelContainer> mParcelContainers;

    public BatteryStatsHistoryIterator(@NonNull BatteryStatsHistory history, long startTimeMs, long endTimeMs) {
        this.mBatteryStatsHistory = history;
        this.mStartTimeMs = startTimeMs;
        this.mEndTimeMs = endTimeMs != -1L ? endTimeMs : Long.MAX_VALUE;
        this.mHistoryItem.clear();
        this.mMaxHistoryItems = history.getEstimatedItemCount();
    }

    @Override
    public boolean hasNext() {
        if (!this.mNextItemReady) {
            if (!this.advance()) {
                this.mHistoryItem = null;
                this.close();
            }
            this.mNextItemReady = true;
        }
        return this.mHistoryItem != null;
    }

    @Override
    public BatteryStats.HistoryItem next() {
        if (!this.mNextItemReady && !this.advance()) {
            this.mHistoryItem = null;
            this.close();
        }
        this.mNextItemReady = false;
        return this.mHistoryItem;
    }

    private boolean advance() {
        BatteryStatsHistory.BatteryHistoryParcelContainer container;
        if (this.mParcelContainers == null) {
            this.mParcelContainers = this.mBatteryStatsHistory.getParcelContainers(this.mStartTimeMs, this.mEndTimeMs);
        }
        while ((container = this.mParcelContainers.peek()) != null) {
            Parcel p = container.getParcel();
            if (p == null || p.dataPosition() >= p.dataSize()) {
                container.close();
                this.mParcelContainers.remove();
                this.mParcelDataPosition = 0;
                continue;
            }
            if (!this.mTimeInitialized) {
                this.mHistoryItem.time = this.mBaseMonotonicTime = container.getMonotonicStartTime();
                this.mTimeInitialized = true;
            }
            try {
                this.readHistoryDelta(p, this.mHistoryItem);
                int dataPosition = p.dataPosition();
                if (dataPosition <= this.mParcelDataPosition) {
                    Slog.wtf(TAG, "Corrupted battery history, parcel is not progressing: " + dataPosition + " of " + p.dataSize());
                    return false;
                }
                this.mParcelDataPosition = dataPosition;
            }
            catch (Throwable t) {
                Slog.wtf(TAG, "Corrupted battery history", t);
                return false;
            }
            if (this.mHistoryItem.cmd == 5 || this.mHistoryItem.cmd == 7) {
                this.mBaseTimeUtc = this.mHistoryItem.currentTime - (this.mHistoryItem.time - this.mBaseMonotonicTime);
            }
            if (this.mHistoryItem.time < this.mStartTimeMs) continue;
            if (this.mEndTimeMs != 0L && this.mEndTimeMs != -1L && this.mHistoryItem.time >= this.mEndTimeMs) {
                return false;
            }
            if (this.mItemIndex++ > this.mMaxHistoryItems) {
                Slog.wtfStack(TAG, "Number of battery history items is too large: " + this.mItemIndex);
                return false;
            }
            this.mHistoryItem.currentTime = this.mBaseTimeUtc + (this.mHistoryItem.time - this.mBaseMonotonicTime);
            return true;
        }
        return false;
    }

    private void readHistoryDelta(Parcel src, BatteryStats.HistoryItem cur) {
        int batteryLevelInt;
        int firstToken = src.readInt();
        int deltaTimeToken = firstToken & 0x7FFFF;
        cur.cmd = 0;
        cur.numReadInts = 1;
        if (deltaTimeToken < 524285) {
            cur.time += (long)deltaTimeToken;
        } else {
            if (deltaTimeToken == 524285) {
                cur.readFromParcel(src);
                return;
            }
            if (deltaTimeToken == 524286) {
                int delta = src.readInt();
                cur.time += (long)delta;
                ++cur.numReadInts;
            } else {
                long delta = src.readLong();
                cur.time += delta;
                cur.numReadInts += 2;
            }
        }
        if ((firstToken & 0x80000) != 0) {
            batteryLevelInt = src.readInt();
            ++cur.numReadInts;
            boolean overflow = (batteryLevelInt & 2) != 0;
            int extendedBatteryLevelInt = 0;
            if (overflow) {
                extendedBatteryLevelInt = src.readInt();
                ++cur.numReadInts;
            }
            BatteryStatsHistoryIterator.readBatteryLevelInts(batteryLevelInt, extendedBatteryLevelInt, cur);
        } else {
            batteryLevelInt = 0;
        }
        if ((firstToken & 0x100000) != 0) {
            int stateInt = src.readInt();
            cur.states = firstToken & 0xFE000000 | stateInt & 0xFFFFFF;
            cur.batteryStatus = (byte)(stateInt >> 29 & 7);
            cur.batteryHealth = (byte)(stateInt >> 26 & 7);
            cur.batteryPlugType = (byte)(stateInt >> 24 & 3);
            switch (cur.batteryPlugType) {
                case 1: {
                    cur.batteryPlugType = 1;
                    break;
                }
                case 2: {
                    cur.batteryPlugType = (byte)2;
                    break;
                }
                case 3: {
                    cur.batteryPlugType = (byte)4;
                }
            }
            ++cur.numReadInts;
        } else {
            cur.states = firstToken & 0xFE000000 | cur.states & 0xFFFFFF;
        }
        if ((firstToken & 0x200000) != 0) {
            cur.states2 = src.readInt();
        }
        if ((firstToken & 0x400000) != 0) {
            int indexes = src.readInt();
            int wakeLockIndex = indexes & 0xFFFF;
            int wakeReasonIndex = indexes >> 16 & 0xFFFF;
            cur.wakelockTag = this.readHistoryTag(src, wakeLockIndex, cur.localWakelockTag) ? cur.localWakelockTag : null;
            cur.wakeReasonTag = this.readHistoryTag(src, wakeReasonIndex, cur.localWakeReasonTag) ? cur.localWakeReasonTag : null;
            ++cur.numReadInts;
        } else {
            cur.wakelockTag = null;
            cur.wakeReasonTag = null;
        }
        if ((firstToken & 0x800000) != 0) {
            cur.eventTag = cur.localEventTag;
            int codeAndIndex = src.readInt();
            cur.eventCode = codeAndIndex & 0xFFFF;
            int index = codeAndIndex >> 16 & 0xFFFF;
            cur.eventTag = this.readHistoryTag(src, index, cur.localEventTag) ? cur.localEventTag : null;
            ++cur.numReadInts;
        } else {
            cur.eventCode = 0;
        }
        if ((batteryLevelInt & 1) != 0) {
            cur.stepDetails = this.mReadHistoryStepDetails;
            cur.stepDetails.readFromParcel(src);
        } else {
            cur.stepDetails = null;
        }
        if ((firstToken & 0x1000000) != 0) {
            cur.batteryChargeUah = src.readInt();
        }
        cur.modemRailChargeMah = src.readDouble();
        cur.wifiRailChargeMah = src.readDouble();
        if ((cur.states2 & 0x20000) != 0) {
            PowerStats.Descriptor descriptor;
            int extensionFlags = src.readInt();
            if ((extensionFlags & 1) != 0 && (descriptor = PowerStats.Descriptor.readSummaryFromParcel(src)) != null) {
                this.mDescriptorRegistry.register(descriptor);
            }
            cur.powerStats = (extensionFlags & 2) != 0 ? PowerStats.readFromParcel(src, this.mDescriptorRegistry) : null;
            if ((extensionFlags & 4) != 0) {
                cur.processStateChange = cur.localProcessStateChange;
                cur.processStateChange.readFromParcel(src);
            } else {
                cur.processStateChange = null;
            }
        } else {
            cur.powerStats = null;
            cur.processStateChange = null;
        }
    }

    private boolean readHistoryTag(Parcel src, int index, BatteryStats.HistoryTag outTag) {
        if (index == 65535) {
            return false;
        }
        if ((index & 0x8000) != 0) {
            BatteryStats.HistoryTag tag = new BatteryStats.HistoryTag();
            tag.readFromParcel(src);
            tag.poolIdx = index & 0xFFFF7FFF;
            if (tag.poolIdx < 32766) {
                this.mHistoryTags.put(tag.poolIdx, tag);
            } else {
                tag.poolIdx = -1;
            }
            outTag.setTo(tag);
        } else {
            BatteryStats.HistoryTag historyTag = this.mHistoryTags.get(index);
            if (historyTag != null) {
                outTag.setTo(historyTag);
            } else {
                outTag.string = null;
                outTag.uid = 0;
            }
            outTag.poolIdx = index;
        }
        return true;
    }

    private static int extractSignedBitField(int bits, int mask, int shift) {
        int msbMask;
        int value = (bits >>>= shift) & (mask >>>= shift);
        if ((value & (msbMask = mask ^ mask >>> 1)) != 0) {
            value |= ~mask;
        }
        return value;
    }

    private static void readBatteryLevelInts(int batteryInt, int extendedBatteryInt, BatteryStats.HistoryItem out) {
        out.batteryLevel = (byte)(out.batteryLevel + BatteryStatsHistoryIterator.extractSignedBitField(batteryInt, -16777216, 24));
        if ((batteryInt & 2) == 0) {
            out.batteryTemperature = (short)(out.batteryTemperature + BatteryStatsHistoryIterator.extractSignedBitField(batteryInt, 0xFF8000, 15));
            out.batteryVoltage = (short)(out.batteryVoltage + BatteryStatsHistoryIterator.extractSignedBitField(batteryInt, 32764, 2));
        } else {
            out.batteryTemperature = (short)BatteryStatsHistoryIterator.extractSignedBitField(extendedBatteryInt, -65536, 16);
            out.batteryVoltage = (short)BatteryStatsHistoryIterator.extractSignedBitField(extendedBatteryInt, 65535, 0);
        }
    }

    @Override
    public void close() {
        if (!this.mClosed) {
            this.mClosed = true;
            this.mBatteryStatsHistory.iteratorFinished();
        }
    }
}

