/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.utils;

import android.annotation.Nullable;

public class HexDump {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] HEX_LOWER_CASE_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String dumpHexString(@Nullable byte[] array2) {
        if (array2 == null) {
            return "(null)";
        }
        return HexDump.dumpHexString(array2, 0, array2.length);
    }

    public static String dumpHexString(@Nullable byte[] array2, int offset, int length) {
        if (array2 == null) {
            return "(null)";
        }
        StringBuilder result = new StringBuilder();
        byte[] line = new byte[16];
        int lineIndex = 0;
        result.append("\n0x");
        result.append(HexDump.toHexString(offset));
        for (int i = offset; i < offset + length; ++i) {
            if (lineIndex == 16) {
                result.append(" ");
                for (int j = 0; j < 16; ++j) {
                    if (line[j] > 32 && line[j] < 126) {
                        result.append(new String(line, j, 1));
                        continue;
                    }
                    result.append(".");
                }
                result.append("\n0x");
                result.append(HexDump.toHexString(i));
                lineIndex = 0;
            }
            byte b = array2[i];
            result.append(" ");
            result.append(HEX_DIGITS[b >>> 4 & 0xF]);
            result.append(HEX_DIGITS[b & 0xF]);
            line[lineIndex++] = b;
        }
        if (lineIndex != 16) {
            int i;
            int count = (16 - lineIndex) * 3;
            ++count;
            for (i = 0; i < count; ++i) {
                result.append(" ");
            }
            for (i = 0; i < lineIndex; ++i) {
                if (line[i] > 32 && line[i] < 126) {
                    result.append(new String(line, i, 1));
                    continue;
                }
                result.append(".");
            }
        }
        return result.toString();
    }

    public static String toHexString(byte b) {
        return HexDump.toHexString(HexDump.toByteArray(b));
    }

    public static String toHexString(byte[] array2) {
        return HexDump.toHexString(array2, 0, array2.length, true);
    }

    public static String toHexString(byte[] array2, boolean upperCase) {
        return HexDump.toHexString(array2, 0, array2.length, upperCase);
    }

    public static String toHexString(byte[] array2, int offset, int length) {
        return HexDump.toHexString(array2, offset, length, true);
    }

    public static String toHexString(byte[] array2, int offset, int length, boolean upperCase) {
        char[] digits = upperCase ? HEX_DIGITS : HEX_LOWER_CASE_DIGITS;
        char[] buf = new char[length * 2];
        int bufIndex = 0;
        for (int i = offset; i < offset + length; ++i) {
            byte b = array2[i];
            buf[bufIndex++] = digits[b >>> 4 & 0xF];
            buf[bufIndex++] = digits[b & 0xF];
        }
        return new String(buf);
    }

    public static String toHexString(int i) {
        return HexDump.toHexString(HexDump.toByteArray(i));
    }

    public static byte[] toByteArray(byte b) {
        byte[] array2 = new byte[]{b};
        return array2;
    }

    public static byte[] toByteArray(int i) {
        byte[] array2 = new byte[4];
        array2[3] = (byte)(i & 0xFF);
        array2[2] = (byte)(i >> 8 & 0xFF);
        array2[1] = (byte)(i >> 16 & 0xFF);
        array2[0] = (byte)(i >> 24 & 0xFF);
        return array2;
    }

    private static int toByte(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("Invalid hex char '" + c + "'");
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int length = hexString.length();
        byte[] buffer = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            buffer[i / 2] = (byte)(HexDump.toByte(hexString.charAt(i)) << 4 | HexDump.toByte(hexString.charAt(i + 1)));
        }
        return buffer;
    }

    public static StringBuilder appendByteAsHex(StringBuilder sb, byte b, boolean upperCase) {
        char[] digits = upperCase ? HEX_DIGITS : HEX_LOWER_CASE_DIGITS;
        sb.append(digits[b >> 4 & 0xF]);
        sb.append(digits[b & 0xF]);
        return sb;
    }
}

