/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net.ipsec.ike.message;

import android.util.SparseArray;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public abstract class IkePayload {
    private static final byte PAYLOAD_HEADER_CRITICAL_BIT_UNSET = 0;
    public static final int GENERIC_HEADER_LENGTH = 4;
    public static final int PAYLOAD_TYPE_NO_NEXT = 0;
    public static final int PAYLOAD_TYPE_SA = 33;
    public static final int PAYLOAD_TYPE_KE = 34;
    public static final int PAYLOAD_TYPE_ID_INITIATOR = 35;
    public static final int PAYLOAD_TYPE_ID_RESPONDER = 36;
    public static final int PAYLOAD_TYPE_CERT = 37;
    public static final int PAYLOAD_TYPE_CERT_REQUEST = 38;
    public static final int PAYLOAD_TYPE_AUTH = 39;
    public static final int PAYLOAD_TYPE_NONCE = 40;
    public static final int PAYLOAD_TYPE_NOTIFY = 41;
    public static final int PAYLOAD_TYPE_DELETE = 42;
    public static final int PAYLOAD_TYPE_VENDOR = 43;
    public static final int PAYLOAD_TYPE_TS_INITIATOR = 44;
    public static final int PAYLOAD_TYPE_TS_RESPONDER = 45;
    public static final int PAYLOAD_TYPE_SK = 46;
    public static final int PAYLOAD_TYPE_CP = 47;
    public static final int PAYLOAD_TYPE_EAP = 48;
    public static final int PAYLOAD_TYPE_SKF = 53;
    public static final int PROTOCOL_ID_UNSET = 0;
    public static final int PROTOCOL_ID_IKE = 1;
    public static final int PROTOCOL_ID_AH = 2;
    public static final int PROTOCOL_ID_ESP = 3;
    private static final SparseArray<String> PROTOCOL_TO_STR = new SparseArray();
    public static final byte SPI_LEN_NOT_INCLUDED = 0;
    public static final byte SPI_LEN_IPSEC = 4;
    public static final byte SPI_LEN_IKE = 8;
    public static final int SPI_NOT_INCLUDED = 0;
    public static final int IP_PORT_LEN = 2;
    public final int payloadType;
    public final boolean isCritical;

    IkePayload(int payload, boolean critical) {
        this.payloadType = payload;
        this.isCritical = critical;
    }

    public static <T extends IkePayload> List<T> getPayloadListForTypeInProvidedList(int payloadType, Class<T> payloadClass, List<IkePayload> searchList) {
        LinkedList<IkePayload> payloadList = new LinkedList<IkePayload>();
        for (IkePayload payload : searchList) {
            if (payloadType != payload.payloadType) continue;
            payloadList.add((IkePayload)payloadClass.cast(payload));
        }
        return payloadList;
    }

    public static <T extends IkePayload> T getPayloadForTypeInProvidedList(int payloadType, Class<T> payloadClass, List<IkePayload> searchList) {
        List<T> payloadList = IkePayload.getPayloadListForTypeInProvidedList(payloadType, payloadClass, searchList);
        return (T)(payloadList.isEmpty() ? null : (IkePayload)payloadList.get(0));
    }

    protected static void encodePayloadHeaderToByteBuffer(int nextPayload, int payloadLength, ByteBuffer byteBuffer) {
        byteBuffer.put((byte)nextPayload).put((byte)0).putShort((short)payloadLength);
    }

    public static String getProtocolTypeString(int protocol) {
        return PROTOCOL_TO_STR.get(protocol);
    }

    protected abstract void encodeToByteBuffer(int var1, ByteBuffer var2);

    protected abstract int getPayloadLength();

    public abstract String getTypeString();

    static {
        PROTOCOL_TO_STR.put(0, "Protocol Unset");
        PROTOCOL_TO_STR.put(1, "IKE");
        PROTOCOL_TO_STR.put(2, "AH");
        PROTOCOL_TO_STR.put(3, "ESP");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProtocolId {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PayloadType {
    }
}

