/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.jank;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.app.ActivityThread;
import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.os._Original_Build;
import android.provider.DeviceConfig;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.Choreographer;
import android.view.SurfaceControl;
import android.view.View;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.jank.Cuj;
import com.android.internal.jank.DisplayResolutionTracker;
import com.android.internal.jank.EventLogTags;
import com.android.internal.jank.FrameTracker;
import com.android.internal.jank.InteractionMonitorDebugOverlay;
import com.android.internal.util.PerfettoTrigger;
import java.time.Instant;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class InteractionJankMonitor {
    private static final String TAG = InteractionJankMonitor.class.getSimpleName();
    private static final String ACTION_PREFIX = InteractionJankMonitor.class.getCanonicalName();
    private static final String DEFAULT_WORKER_NAME = TAG + "-Worker";
    private static final long DEFAULT_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(2L);
    static final long EXECUTOR_TASK_TIMEOUT = 500L;
    private static final String SETTINGS_ENABLED_KEY = "enabled";
    private static final String SETTINGS_SAMPLING_INTERVAL_KEY = "sampling_interval";
    private static final String SETTINGS_THRESHOLD_MISSED_FRAMES_KEY = "trace_threshold_missed_frames";
    private static final String SETTINGS_THRESHOLD_FRAME_TIME_MILLIS_KEY = "trace_threshold_frame_time_millis";
    private static final String SETTINGS_DEBUG_OVERLAY_ENABLED_KEY = "debug_overlay_enabled";
    private static final boolean DEFAULT_ENABLED = _Original_Build.IS_DEBUGGABLE;
    private static final int DEFAULT_SAMPLING_INTERVAL = 1;
    private static final int DEFAULT_TRACE_THRESHOLD_MISSED_FRAMES = 3;
    private static final int DEFAULT_TRACE_THRESHOLD_FRAME_TIME_MILLIS = 64;
    private static final boolean DEFAULT_DEBUG_OVERLAY_ENABLED = false;
    private static final int MAX_LENGTH_SESSION_NAME = 100;
    public static final String ACTION_SESSION_END = ACTION_PREFIX + ".ACTION_SESSION_END";
    public static final String ACTION_SESSION_CANCEL = ACTION_PREFIX + ".ACTION_SESSION_CANCEL";
    @Deprecated
    public static final int CUJ_NOTIFICATION_SHADE_EXPAND_COLLAPSE = 0;
    @Deprecated
    public static final int CUJ_NOTIFICATION_SHADE_SCROLL_FLING = 2;
    @Deprecated
    public static final int CUJ_NOTIFICATION_SHADE_ROW_EXPAND = 3;
    @Deprecated
    public static final int CUJ_NOTIFICATION_SHADE_ROW_SWIPE = 4;
    @Deprecated
    public static final int CUJ_NOTIFICATION_SHADE_QS_EXPAND_COLLAPSE = 5;
    @Deprecated
    public static final int CUJ_NOTIFICATION_SHADE_QS_SCROLL_SWIPE = 6;
    @Deprecated
    public static final int CUJ_NOTIFICATION_HEADS_UP_APPEAR = 12;
    @Deprecated
    public static final int CUJ_NOTIFICATION_HEADS_UP_DISAPPEAR = 13;
    @Deprecated
    public static final int CUJ_NOTIFICATION_ADD = 14;
    @Deprecated
    public static final int CUJ_NOTIFICATION_REMOVE = 15;
    @Deprecated
    public static final int CUJ_NOTIFICATION_APP_START = 16;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_PASSWORD_APPEAR = 17;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_PATTERN_APPEAR = 18;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_PIN_APPEAR = 19;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_PASSWORD_DISAPPEAR = 20;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_PATTERN_DISAPPEAR = 21;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_PIN_DISAPPEAR = 22;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_TRANSITION_FROM_AOD = 23;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_TRANSITION_TO_AOD = 24;
    @Deprecated
    public static final int CUJ_SETTINGS_PAGE_SCROLL = 28;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_UNLOCK_ANIMATION = 29;
    @Deprecated
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_HISTORY_BUTTON = 30;
    @Deprecated
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_MEDIA_PLAYER = 31;
    @Deprecated
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_QS_TILE = 32;
    @Deprecated
    public static final int CUJ_SHADE_APP_LAUNCH_FROM_SETTINGS_BUTTON = 33;
    @Deprecated
    public static final int CUJ_STATUS_BAR_APP_LAUNCH_FROM_CALL_CHIP = 34;
    @Deprecated
    public static final int CUJ_PIP_TRANSITION = 35;
    @Deprecated
    public static final int CUJ_USER_SWITCH = 37;
    @Deprecated
    public static final int CUJ_SPLASHSCREEN_AVD = 38;
    @Deprecated
    public static final int CUJ_SPLASHSCREEN_EXIT_ANIM = 39;
    @Deprecated
    public static final int CUJ_SCREEN_OFF = 40;
    @Deprecated
    public static final int CUJ_SCREEN_OFF_SHOW_AOD = 41;
    @Deprecated
    public static final int CUJ_UNFOLD_ANIM = 44;
    @Deprecated
    public static final int CUJ_SUW_LOADING_TO_SHOW_INFO_WITH_ACTIONS = 45;
    @Deprecated
    public static final int CUJ_SUW_SHOW_FUNCTION_SCREEN_WITH_ACTIONS = 46;
    @Deprecated
    public static final int CUJ_SUW_LOADING_TO_NEXT_FLOW = 47;
    @Deprecated
    public static final int CUJ_SUW_LOADING_SCREEN_FOR_STATUS = 48;
    @Deprecated
    public static final int CUJ_SPLIT_SCREEN_RESIZE = 52;
    @Deprecated
    public static final int CUJ_SETTINGS_SLIDER = 53;
    @Deprecated
    public static final int CUJ_TAKE_SCREENSHOT = 54;
    @Deprecated
    public static final int CUJ_VOLUME_CONTROL = 55;
    @Deprecated
    public static final int CUJ_BIOMETRIC_PROMPT_TRANSITION = 56;
    @Deprecated
    public static final int CUJ_SETTINGS_TOGGLE = 57;
    @Deprecated
    public static final int CUJ_SHADE_DIALOG_OPEN = 58;
    @Deprecated
    public static final int CUJ_USER_DIALOG_OPEN = 59;
    @Deprecated
    public static final int CUJ_TASKBAR_EXPAND = 60;
    @Deprecated
    public static final int CUJ_TASKBAR_COLLAPSE = 61;
    @Deprecated
    public static final int CUJ_SHADE_CLEAR_ALL = 62;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_OCCLUSION = 64;
    @Deprecated
    public static final int CUJ_LOCKSCREEN_CLOCK_MOVE_ANIMATION = 70;
    @Deprecated
    public static final int CUJ_SPLIT_SCREEN_DOUBLE_TAP_DIVIDER = 82;
    @Deprecated
    public static final int CUJ_PREDICTIVE_BACK_CROSS_ACTIVITY = 84;
    @Deprecated
    public static final int CUJ_PREDICTIVE_BACK_CROSS_TASK = 85;
    @Deprecated
    public static final int CUJ_PREDICTIVE_BACK_HOME = 86;
    @Deprecated
    public static final int CUJ_LAUNCHER_LAUNCH_APP_PAIR_FROM_WORKSPACE = 91;
    @Deprecated
    public static final int CUJ_LAUNCHER_LAUNCH_APP_PAIR_FROM_TASKBAR = 92;
    @Deprecated
    public static final int CUJ_LAUNCHER_SAVE_APP_PAIR = 93;
    @Deprecated
    public static final int CUJ_LAUNCHER_ALL_APPS_SEARCH_BACK = 95;
    @Deprecated
    public static final int CUJ_LAUNCHER_TASKBAR_ALL_APPS_CLOSE_BACK = 96;
    @Deprecated
    public static final int CUJ_LAUNCHER_TASKBAR_ALL_APPS_SEARCH_BACK = 97;
    @Deprecated
    public static final int CUJ_LAUNCHER_WIDGET_PICKER_CLOSE_BACK = 98;
    @Deprecated
    public static final int CUJ_LAUNCHER_WIDGET_PICKER_SEARCH_BACK = 99;
    @Deprecated
    public static final int CUJ_LAUNCHER_WIDGET_BOTTOM_SHEET_CLOSE_BACK = 100;
    @Deprecated
    public static final int CUJ_LAUNCHER_WIDGET_EDU_SHEET_CLOSE_BACK = 101;
    @GuardedBy(value={"mLock"})
    private final SparseArray<RunningTracker> mRunningTrackers = new SparseArray();
    private final Handler mWorker;
    private final Application mCurrentApplication;
    private final DisplayResolutionTracker mDisplayResolutionTracker;
    private final Object mLock = new Object();
    private int mDebugBgColor = -16711681;
    private double mDebugYOffset = 0.1;
    @GuardedBy(value={"mLock"})
    private InteractionMonitorDebugOverlay mDebugOverlay;
    private volatile boolean mEnabled = DEFAULT_ENABLED;
    private int mSamplingInterval = 1;
    private int mTraceThresholdMissedFrames = 3;
    private int mTraceThresholdFrameTimeMillis = 64;

    public static InteractionJankMonitor getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @VisibleForTesting
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public InteractionJankMonitor(@NonNull HandlerThread worker) {
        worker.start();
        this.mWorker = worker.getThreadHandler();
        this.mDisplayResolutionTracker = new DisplayResolutionTracker(this.mWorker);
        this.mCurrentApplication = ActivityThread.currentApplication();
        if (this.mCurrentApplication == null || this.mCurrentApplication.checkCallingOrSelfPermission("android.permission.READ_DEVICE_CONFIG") != 0) {
            Log.w(TAG, "Initializing without READ_DEVICE_CONFIG permission. enabled=" + this.mEnabled + ", interval=" + this.mSamplingInterval + ", missedFrameThreshold=" + this.mTraceThresholdMissedFrames + ", frameTimeThreshold=" + this.mTraceThresholdFrameTimeMillis + ", package=" + (this.mCurrentApplication == null ? "null" : this.mCurrentApplication.getPackageName()));
            return;
        }
        this.mWorker.post(() -> {
            try {
                this.updateProperties(DeviceConfig.getProperties("interaction_jank_monitor", new String[0]));
                DeviceConfig.addOnPropertiesChangedListener("interaction_jank_monitor", new HandlerExecutor(this.mWorker), this::updateProperties);
            }
            catch (SecurityException ex) {
                Log.d(TAG, "Can't get properties: READ_DEVICE_CONFIG granted=" + this.mCurrentApplication.checkCallingOrSelfPermission("android.permission.READ_DEVICE_CONFIG") + ", package=" + this.mCurrentApplication.getPackageName());
            }
        });
    }

    @VisibleForTesting
    public FrameTracker createFrameTracker(final Configuration config) {
        View view = config.mView;
        FrameTracker.ThreadedRendererWrapper threadedRenderer = view == null ? null : new FrameTracker.ThreadedRendererWrapper(view.getThreadedRenderer());
        FrameTracker.ViewRootWrapper viewRoot = view == null ? null : new FrameTracker.ViewRootWrapper(view.getViewRootImpl());
        FrameTracker.SurfaceControlWrapper surfaceControl = new FrameTracker.SurfaceControlWrapper();
        FrameTracker.ChoreographerWrapper choreographer = new FrameTracker.ChoreographerWrapper(Choreographer.getInstance());
        FrameTracker.FrameTrackerListener eventsListener = new FrameTracker.FrameTrackerListener(){

            @Override
            public void onCujEvents(FrameTracker tracker, String action, int reason) {
                config.getHandler().runWithScissors(() -> InteractionJankMonitor.this.handleCujEvents(config2.mCujType, tracker, action, reason), 500L);
            }

            @Override
            public void triggerPerfetto(Configuration config2) {
                InteractionJankMonitor.this.mWorker.post(() -> PerfettoTrigger.trigger(config2.getPerfettoTrigger()));
            }
        };
        FrameTracker.FrameMetricsWrapper frameMetrics = new FrameTracker.FrameMetricsWrapper();
        return new FrameTracker(config, threadedRenderer, viewRoot, surfaceControl, choreographer, frameMetrics, new FrameTracker.StatsLogWrapper(this.mDisplayResolutionTracker), this.mTraceThresholdMissedFrames, this.mTraceThresholdFrameTimeMillis, eventsListener);
    }

    private void handleCujEvents(int cuj, FrameTracker tracker, String action, int reason) {
        if (InteractionJankMonitor.needRemoveTasks(action, reason)) {
            this.removeTrackerIfCurrent(cuj, tracker, reason);
        }
    }

    private static boolean needRemoveTasks(String action, int reason) {
        boolean badEnd = action.equals(ACTION_SESSION_END) && reason != 0;
        boolean badCancel = action.equals(ACTION_SESSION_CANCEL) && reason != 16 && reason != 19;
        return badEnd || badCancel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInstrumenting(int cujType) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunningTrackers.contains(cujType);
        }
    }

    public boolean begin(View v, int cujType) {
        try {
            return this.begin(Configuration.Builder.withView(cujType, v));
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Build configuration failed!", ex);
            return false;
        }
    }

    public boolean begin(SurfaceControl surface, Context context, Handler handler, int cujType) {
        try {
            return this.begin(Configuration.Builder.withSurface(cujType, context, surface, handler));
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Build configuration failed!", ex);
            return false;
        }
    }

    public boolean begin(SurfaceControl surface, Context context, Handler handler, int cujType, String tag) {
        try {
            Configuration.Builder builder = Configuration.Builder.withSurface(cujType, context, surface, handler);
            if (!TextUtils.isEmpty(tag)) {
                builder.setTag(tag);
            }
            return this.begin(builder);
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Build configuration failed!", ex);
            return false;
        }
    }

    public boolean begin(@NonNull Configuration.Builder builder) {
        try {
            Configuration config = builder.build();
            this.postEventLogToWorkerThread((unixNanos, elapsedNanos, realtimeNanos) -> EventLogTags.writeJankCujEventsBeginRequest(config.mCujType, unixNanos, elapsedNanos, realtimeNanos, config.mTag));
            TrackerResult result = new TrackerResult();
            boolean success = config.getHandler().runWithScissors(() -> {
                result.mResult = this.beginInternal(config);
            }, 500L);
            if (!success) {
                Log.d(TAG, "begin failed due to timeout, CUJ=" + Cuj.getNameOfCuj(config.mCujType));
                return false;
            }
            return result.mResult;
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Build configuration failed!", ex);
            return false;
        }
    }

    private boolean beginInternal(@NonNull Configuration conf) {
        int cujType = conf.mCujType;
        if (!this.shouldMonitor()) {
            return false;
        }
        if (!conf.hasValidView()) {
            Log.w(TAG, "The view has since become invalid, aborting the CUJ.");
            return false;
        }
        RunningTracker tracker = this.putTrackerIfNoCurrent(cujType, () -> new RunningTracker(conf, this.createFrameTracker(conf), () -> {
            Log.w(TAG, "CUJ cancelled due to timeout, CUJ=" + Cuj.getNameOfCuj(cujType));
            this.cancel(cujType, 19);
        }));
        if (tracker == null) {
            return false;
        }
        tracker.mTracker.begin();
        this.scheduleTimeoutAction(tracker.mConfig, tracker.mTimeoutAction);
        return true;
    }

    @VisibleForTesting
    public boolean shouldMonitor() {
        return this.mEnabled && ThreadLocalRandom.current().nextInt(this.mSamplingInterval) == 0;
    }

    @VisibleForTesting
    public void scheduleTimeoutAction(Configuration config, Runnable action) {
        config.getHandler().postDelayed(action, config.mTimeout);
    }

    public boolean end(int cujType) {
        this.postEventLogToWorkerThread((unixNanos, elapsedNanos, realtimeNanos) -> EventLogTags.writeJankCujEventsEndRequest(cujType, unixNanos, elapsedNanos, realtimeNanos));
        RunningTracker tracker = this.getTracker(cujType);
        if (tracker == null) {
            return false;
        }
        try {
            TrackerResult result = new TrackerResult();
            boolean success = tracker.mConfig.getHandler().runWithScissors(() -> {
                result.mResult = this.endInternal(tracker);
            }, 500L);
            if (!success) {
                Log.d(TAG, "end failed due to timeout, CUJ=" + Cuj.getNameOfCuj(cujType));
                return false;
            }
            return result.mResult;
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Execute end task failed!", ex);
            return false;
        }
    }

    private boolean endInternal(RunningTracker tracker) {
        if (this.removeTrackerIfCurrent(tracker, 0)) {
            return false;
        }
        tracker.mTracker.end(0);
        return true;
    }

    public boolean cancel(int cujType) {
        this.postEventLogToWorkerThread((unixNanos, elapsedNanos, realtimeNanos) -> EventLogTags.writeJankCujEventsCancelRequest(cujType, unixNanos, elapsedNanos, realtimeNanos));
        return this.cancel(cujType, 16);
    }

    @VisibleForTesting
    public boolean cancel(int cujType, int reason) {
        RunningTracker tracker = this.getTracker(cujType);
        if (tracker == null) {
            return false;
        }
        try {
            TrackerResult result = new TrackerResult();
            boolean success = tracker.mConfig.getHandler().runWithScissors(() -> {
                result.mResult = this.cancelInternal(tracker, reason);
            }, 500L);
            if (!success) {
                Log.d(TAG, "cancel failed due to timeout, CUJ=" + Cuj.getNameOfCuj(cujType));
                return false;
            }
            return result.mResult;
        }
        catch (IllegalArgumentException ex) {
            Log.d(TAG, "Execute cancel task failed!", ex);
            return false;
        }
    }

    private boolean cancelInternal(RunningTracker tracker, int reason) {
        if (this.removeTrackerIfCurrent(tracker, reason)) {
            return false;
        }
        tracker.mTracker.cancel(reason);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunningTracker putTrackerIfNoCurrent(int cuj, Supplier<RunningTracker> supplier) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRunningTrackers.contains(cuj)) {
                return null;
            }
            RunningTracker tracker = supplier.get();
            if (tracker == null) {
                return null;
            }
            this.mRunningTrackers.put(cuj, tracker);
            if (this.mDebugOverlay != null) {
                this.mDebugOverlay.onTrackerAdded(cuj, tracker.mTracker.hashCode());
            }
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunningTracker getTracker(int cuj) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunningTrackers.get(cuj);
        }
    }

    private boolean removeTrackerIfCurrent(RunningTracker tracker, int reason) {
        return this.removeTrackerIfCurrent(tracker.mConfig.mCujType, tracker.mTracker, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeTrackerIfCurrent(int cuj, FrameTracker tracker, int reason) {
        Object object = this.mLock;
        synchronized (object) {
            RunningTracker running = this.mRunningTrackers.get(cuj);
            if (running == null || running.mTracker != tracker) {
                return true;
            }
            running.mConfig.getHandler().removeCallbacks(running.mTimeoutAction);
            this.mRunningTrackers.remove(cuj);
            if (this.mDebugOverlay != null) {
                this.mDebugOverlay.onTrackerRemoved(cuj, reason, tracker.hashCode());
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void updateProperties(DeviceConfig.Properties properties) {
        Iterator<String> iterator = properties.getKeyset().iterator();
        while (iterator.hasNext()) {
            String property;
            switch (property = iterator.next()) {
                case "sampling_interval": {
                    this.mSamplingInterval = properties.getInt(property, 1);
                    break;
                }
                case "trace_threshold_missed_frames": {
                    this.mTraceThresholdMissedFrames = properties.getInt(property, 3);
                    break;
                }
                case "trace_threshold_frame_time_millis": {
                    this.mTraceThresholdFrameTimeMillis = properties.getInt(property, 64);
                    break;
                }
                case "enabled": {
                    this.mEnabled = properties.getBoolean(property, DEFAULT_ENABLED);
                    break;
                }
                case "debug_overlay_enabled": {
                    if (_Original_Build.IS_USER) break;
                    boolean debugOverlayEnabled = properties.getBoolean(property, false);
                    Object object = this.mLock;
                    synchronized (object) {
                        if (debugOverlayEnabled && this.mDebugOverlay == null) {
                            this.mDebugOverlay = new InteractionMonitorDebugOverlay(this.mCurrentApplication, this.mWorker, this.mDebugBgColor, this.mDebugYOffset);
                        } else if (!debugOverlayEnabled && this.mDebugOverlay != null) {
                            this.mDebugOverlay.dispose();
                            this.mDebugOverlay = null;
                        }
                        break;
                    }
                }
                default: {
                    Log.w(TAG, "Got a change event for an unknown property: " + property + " => " + properties.getString(property, ""));
                }
            }
        }
    }

    @Deprecated
    public static String getNameOfInteraction(int interactionType) {
        return Cuj.getNameOfInteraction(interactionType);
    }

    @Deprecated
    public static String getNameOfCuj(int cujType) {
        return Cuj.getNameOfCuj(cujType);
    }

    public void configDebugOverlay(int bgColor, double yOffset) {
        this.mDebugBgColor = bgColor;
        this.mDebugYOffset = yOffset;
    }

    private void postEventLogToWorkerThread(TimeFunction logFunction) {
        Instant now = Instant.now();
        long unixNanos = TimeUnit.NANOSECONDS.convert(now.getEpochSecond(), TimeUnit.SECONDS) + (long)now.getNano();
        long elapsedNanos = SystemClock.elapsedRealtimeNanos();
        long realtimeNanos = SystemClock.uptimeNanos();
        this.mWorker.post(() -> logFunction.invoke(unixNanos, elapsedNanos, realtimeNanos));
    }

    private static class InstanceHolder {
        public static final InteractionJankMonitor INSTANCE = new InteractionJankMonitor(new HandlerThread(DEFAULT_WORKER_NAME));

        private InstanceHolder() {
        }
    }

    public static class Configuration {
        private final View mView;
        private final Context mContext;
        private final long mTimeout;
        private final String mTag;
        private final String mSessionName;
        private final boolean mSurfaceOnly;
        private final SurfaceControl mSurfaceControl;
        private final int mCujType;
        private final boolean mDeferMonitor;
        private final Handler mHandler;

        private Configuration(int cuj, View view, @NonNull String tag, long timeout, boolean surfaceOnly, Context context, SurfaceControl surfaceControl, boolean deferMonitor, Handler handler) {
            this.mCujType = cuj;
            this.mTag = tag;
            this.mSessionName = Configuration.generateSessionName(Cuj.getNameOfCuj(cuj), tag);
            this.mTimeout = timeout;
            this.mView = view;
            this.mSurfaceOnly = surfaceOnly;
            this.mContext = context != null ? context : (view != null ? view.getContext().getApplicationContext() : null);
            this.mSurfaceControl = surfaceControl;
            this.mDeferMonitor = deferMonitor;
            if (handler != null) {
                this.mHandler = handler;
            } else if (this.mSurfaceOnly) {
                Log.w(TAG, "No UIThread provided for " + this.mSessionName + " (surface only). Defaulting to app main thread.");
                this.mHandler = this.mContext.getMainThreadHandler();
            } else {
                this.mHandler = this.mView.getHandler();
            }
            this.validate();
        }

        @VisibleForTesting
        public static String generateSessionName(@NonNull String cujName, @NonNull String cujPostfix) {
            boolean hasPostfix;
            boolean bl = hasPostfix = !TextUtils.isEmpty(cujPostfix);
            if (hasPostfix) {
                int remaining = 100 - cujName.length();
                if (cujPostfix.length() > remaining) {
                    cujPostfix = cujPostfix.substring(0, remaining - 3).concat("...");
                }
            }
            return hasPostfix ? TextUtils.formatSimple("J<%s::%s>", cujName, cujPostfix) : TextUtils.formatSimple("J<%s>", cujName);
        }

        private void validate() {
            boolean shouldThrow = false;
            StringBuilder msg = new StringBuilder();
            if (this.mTag == null) {
                shouldThrow = true;
                msg.append("Invalid tag; ");
            }
            if (this.mTimeout < 0L) {
                shouldThrow = true;
                msg.append("Invalid timeout value; ");
            }
            if (this.mSurfaceOnly) {
                if (this.mContext == null) {
                    shouldThrow = true;
                    msg.append("Must pass in a context if only instrument surface; ");
                }
                if (this.mSurfaceControl == null || !this.mSurfaceControl.isValid()) {
                    shouldThrow = true;
                    msg.append("Must pass in a valid surface control if only instrument surface; ");
                }
                if (this.mHandler == null) {
                    shouldThrow = true;
                    msg.append("Must pass a UI thread handler when only a surface control is provided.");
                }
            } else if (!this.hasValidView()) {
                shouldThrow = true;
                boolean attached = false;
                boolean hasViewRoot = false;
                boolean hasRenderer = false;
                if (this.mView != null) {
                    attached = this.mView.isAttachedToWindow();
                    hasViewRoot = this.mView.getViewRootImpl() != null;
                    hasRenderer = this.mView.getThreadedRenderer() != null;
                }
                String err = "invalid view: view=" + this.mView + ", attached=" + attached + ", hasViewRoot=" + hasViewRoot + ", hasRenderer=" + hasRenderer;
                msg.append(err);
            }
            if (shouldThrow) {
                throw new IllegalArgumentException(msg.toString());
            }
        }

        boolean hasValidView() {
            return this.mSurfaceOnly || this.mView != null && this.mView.isAttachedToWindow() && this.mView.getViewRootImpl() != null && this.mView.getThreadedRenderer() != null;
        }

        public boolean isSurfaceOnly() {
            return this.mSurfaceOnly;
        }

        public SurfaceControl getSurfaceControl() {
            return this.mSurfaceControl;
        }

        @VisibleForTesting
        public View getView() {
            return this.mView;
        }

        public boolean shouldDeferMonitor() {
            return this.mDeferMonitor;
        }

        @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
        public Handler getHandler() {
            return this.mHandler;
        }

        @VisibleForTesting
        public int getDisplayId() {
            return (this.mSurfaceOnly ? this.mContext : this.mView.getContext()).getDisplayId();
        }

        public String getSessionName() {
            return this.mSessionName;
        }

        public int getStatsdInteractionType() {
            return Cuj.getStatsdInteractionType(this.mCujType);
        }

        public boolean logToStatsd() {
            return Cuj.logToStatsd(this.mCujType);
        }

        public String getPerfettoTrigger() {
            return TextUtils.formatSimple("com.android.telemetry.interaction-jank-monitor-%d", this.mCujType);
        }

        public int getCujType() {
            return this.mCujType;
        }

        public static class Builder {
            private View mAttrView = null;
            private Context mAttrContext = null;
            private long mAttrTimeout = DEFAULT_TIMEOUT_MS;
            private String mAttrTag = "";
            private boolean mAttrSurfaceOnly;
            private SurfaceControl mAttrSurfaceControl;
            private final int mAttrCujType;
            private boolean mAttrDeferMonitor = true;
            private Handler mHandler = null;

            public static Builder withSurface(int cuj, @NonNull Context context, @NonNull SurfaceControl surfaceControl, @NonNull Handler uiThreadHandler) {
                return new Builder(cuj).setContext(context).setSurfaceControl(surfaceControl).setSurfaceOnly(true).setHandler(uiThreadHandler);
            }

            public static Builder withView(int cuj, @NonNull View view) {
                return new Builder(cuj).setView(view).setContext(view.getContext());
            }

            private Builder(int cuj) {
                this.mAttrCujType = cuj;
            }

            public Builder setHandler(Handler uiThreadHandler) {
                this.mHandler = uiThreadHandler;
                return this;
            }

            private Builder setView(@NonNull View view) {
                this.mAttrView = view;
                return this;
            }

            public Builder setTimeout(long timeout) {
                this.mAttrTimeout = timeout;
                return this;
            }

            public Builder setTag(@NonNull String tag) {
                this.mAttrTag = tag;
                return this;
            }

            private Builder setSurfaceOnly(boolean surfaceOnly) {
                this.mAttrSurfaceOnly = surfaceOnly;
                return this;
            }

            private Builder setContext(Context context) {
                this.mAttrContext = context;
                return this;
            }

            private Builder setSurfaceControl(SurfaceControl surfaceControl) {
                this.mAttrSurfaceControl = surfaceControl;
                return this;
            }

            public Builder setDeferMonitorForAnimationStart(boolean defer) {
                this.mAttrDeferMonitor = defer;
                return this;
            }

            public Configuration build() throws IllegalArgumentException {
                return new Configuration(this.mAttrCujType, this.mAttrView, this.mAttrTag, this.mAttrTimeout, this.mAttrSurfaceOnly, this.mAttrContext, this.mAttrSurfaceControl, this.mAttrDeferMonitor, this.mHandler);
            }
        }
    }

    @FunctionalInterface
    private static interface TimeFunction {
        public void invoke(long var1, long var3, long var5);
    }

    private static class TrackerResult {
        private boolean mResult;

        private TrackerResult() {
        }
    }

    static class RunningTracker {
        public final Configuration mConfig;
        public final FrameTracker mTracker;
        public final Runnable mTimeoutAction;

        RunningTracker(Configuration config, FrameTracker tracker, Runnable timeoutAction) {
            this.mConfig = config;
            this.mTracker = tracker;
            this.mTimeoutAction = timeoutAction;
        }
    }
}

