/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.IBinder;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.InputMethodPrivilegedOperations;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public class InputMethodPrivilegedOperationsRegistry {
    private static final Object sLock = new Object();
    @Nullable
    @GuardedBy(value={"sLock"})
    private static WeakHashMap<IBinder, WeakReference<InputMethodPrivilegedOperations>> sRegistry;
    @Nullable
    private static InputMethodPrivilegedOperations sNop;

    private InputMethodPrivilegedOperationsRegistry() {
    }

    @NonNull
    private static InputMethodPrivilegedOperations getNopOps() {
        if (sNop == null) {
            sNop = new InputMethodPrivilegedOperations();
        }
        return sNop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void put(IBinder token, InputMethodPrivilegedOperations ops) {
        Object object = sLock;
        synchronized (object) {
            if (sRegistry == null) {
                sRegistry = new WeakHashMap();
            }
            sRegistry.put(token, new WeakReference<InputMethodPrivilegedOperations>(ops));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static InputMethodPrivilegedOperations get(IBinder token) {
        Object object = sLock;
        synchronized (object) {
            if (sRegistry == null) {
                return InputMethodPrivilegedOperationsRegistry.getNopOps();
            }
            WeakReference<InputMethodPrivilegedOperations> wrapperRef = sRegistry.get(token);
            if (wrapperRef == null) {
                return InputMethodPrivilegedOperationsRegistry.getNopOps();
            }
            InputMethodPrivilegedOperations wrapper = (InputMethodPrivilegedOperations)wrapperRef.get();
            if (wrapper == null) {
                return InputMethodPrivilegedOperationsRegistry.getNopOps();
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(IBinder token) {
        Object object = sLock;
        synchronized (object) {
            if (sRegistry == null) {
                return;
            }
            sRegistry.remove(token);
            if (sRegistry.isEmpty()) {
                sRegistry = null;
            }
        }
    }
}

