/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.SystemClock;
import android.os.Trace;
import android.tracing.inputmethod.InputMethodDataSource;
import android.tracing.perfetto.DataSourceParams;
import android.tracing.perfetto.InitArguments;
import android.tracing.perfetto.Producer;
import android.util.proto.ProtoOutputStream;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.inputmethod.ImeTracing;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class ImeTracingPerfettoImpl
extends ImeTracing {
    private final AtomicInteger mTracingSessionsCount = new AtomicInteger(0);
    private final AtomicBoolean mIsClientDumpInProgress = new AtomicBoolean(false);
    private final AtomicBoolean mIsServiceDumpInProgress = new AtomicBoolean(false);
    private final AtomicBoolean mIsManagerServiceDumpInProgress = new AtomicBoolean(false);
    private final InputMethodDataSource mDataSource = new InputMethodDataSource(this.mTracingSessionsCount::incrementAndGet, this.mTracingSessionsCount::decrementAndGet);

    ImeTracingPerfettoImpl() {
        Producer.init(InitArguments.DEFAULTS);
        DataSourceParams params = new DataSourceParams.Builder().setBufferExhaustedPolicy(1).setNoFlush(true).setWillNotifyOnStop(false).build();
        this.mDataSource.register(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerClientDump(String where, InputMethodManager immInstance, @Nullable byte[] icProto) {
        if (!this.isEnabled() || !this.isAvailable()) {
            return;
        }
        if (!this.mIsClientDumpInProgress.compareAndSet(false, true)) {
            return;
        }
        if (immInstance == null) {
            return;
        }
        try {
            Trace.beginSection("inputmethod_client_dump");
            this.mDataSource.trace(ctx -> {
                ProtoOutputStream os = ctx.newTracePacket();
                os.write(1116691496968L, SystemClock.elapsedRealtimeNanos());
                long tokenWinscopeExtensions = os.start(1146756268144L);
                long tokenExtensionsField = os.start(0x10B00000001L);
                os.write(1138166333442L, where);
                long tokenClient = os.start(1146756268035L);
                immInstance.dumpDebug(os, icProto);
                os.end(tokenClient);
                os.end(tokenExtensionsField);
                os.end(tokenWinscopeExtensions);
            });
        }
        finally {
            this.mIsClientDumpInProgress.set(false);
            Trace.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggerServiceDump(String where, @NonNull ImeTracing.ServiceDumper dumper, @Nullable byte[] icProto) {
        if (!this.isEnabled() || !this.isAvailable()) {
            return;
        }
        if (!this.mIsServiceDumpInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            Trace.beginSection("inputmethod_service_dump");
            this.mDataSource.trace(ctx -> {
                ProtoOutputStream os = ctx.newTracePacket();
                os.write(1116691496968L, SystemClock.elapsedRealtimeNanos());
                long tokenWinscopeExtensions = os.start(1146756268144L);
                long tokenExtensionsField = os.start(1146756268034L);
                os.write(1138166333442L, where);
                dumper.dumpToProto(os, icProto);
                os.end(tokenExtensionsField);
                os.end(tokenWinscopeExtensions);
            });
        }
        finally {
            this.mIsServiceDumpInProgress.set(false);
            Trace.endSection();
        }
    }

    @Override
    public void triggerManagerServiceDump(@NonNull String where, @NonNull ImeTracing.ServiceDumper dumper) {
        if (!this.isEnabled() || !this.isAvailable()) {
            return;
        }
        if (!this.mIsManagerServiceDumpInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            Trace.beginSection("inputmethod_manager_service_dump");
            this.mDataSource.trace(ctx -> {
                ProtoOutputStream os = ctx.newTracePacket();
                os.write(1116691496968L, SystemClock.elapsedRealtimeNanos());
                long tokenWinscopeExtensions = os.start(1146756268144L);
                long tokenExtensionsField = os.start(1146756268035L);
                os.write(1138166333442L, where);
                dumper.dumpToProto(os, null);
                os.end(tokenExtensionsField);
                os.end(tokenWinscopeExtensions);
            });
        }
        finally {
            this.mIsManagerServiceDumpInProgress.set(false);
            Trace.endSection();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.mTracingSessionsCount.get() > 0;
    }

    @Override
    public void startTrace(@Nullable PrintWriter pw) {
    }

    @Override
    public void stopTrace(@Nullable PrintWriter pw) {
    }

    @Override
    public void addToBuffer(ProtoOutputStream proto, int source) {
    }
}

