/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.hidden_from_bootclasspath.com.android.art.flags;

import android.os._Original_Build;
import android.os.flagging.AconfigPackage;
import android.util.Log;
import com.android.internal.hidden_from_bootclasspath.com.android.art.flags.FeatureFlags;

public class FeatureFlagsImpl
implements FeatureFlags {
    private static final String TAG = "FeatureFlagsImplExport";
    private static volatile boolean isCached = false;
    private static boolean alwaysEnableProfileCode = false;
    private static boolean artServiceV3 = false;
    private static boolean executableMethodFileOffsets = false;
    private static boolean executableMethodFileOffsetsV2 = false;

    private void init() {
        try {
            AconfigPackage reader = AconfigPackage.load("com.android.art.flags");
            artServiceV3 = reader.getBooleanFlagValue("art_service_v3", false);
            alwaysEnableProfileCode = reader.getBooleanFlagValue("always_enable_profile_code", false);
            executableMethodFileOffsets = _Original_Build.VERSION.SDK_INT >= 36 ? true : reader.getBooleanFlagValue("executable_method_file_offsets", false);
            executableMethodFileOffsetsV2 = reader.getBooleanFlagValue("executable_method_file_offsets_v2", false);
        }
        catch (Exception e) {
            Log.e(TAG, ((Object)e).toString());
        }
        catch (LinkageError e) {
            Log.w(TAG, ((Object)e).toString());
        }
        isCached = true;
    }

    @Override
    public boolean alwaysEnableProfileCode() {
        if (!isCached) {
            this.init();
        }
        return alwaysEnableProfileCode;
    }

    @Override
    public boolean artServiceV3() {
        if (!isCached) {
            this.init();
        }
        return artServiceV3;
    }

    @Override
    public boolean executableMethodFileOffsets() {
        if (!isCached) {
            this.init();
        }
        return executableMethodFileOffsets;
    }

    @Override
    public boolean executableMethodFileOffsetsV2() {
        if (!isCached) {
            this.init();
        }
        return executableMethodFileOffsetsV2;
    }
}

