/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.annotations.WeaklyReferencedCallback;
import com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags;
import com.android.internal.os.BackgroundThread;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.Executor;

@WeaklyReferencedCallback
public abstract class PackageMonitor
extends BroadcastReceiver {
    static final String TAG = "PackageMonitor";
    Context mRegisteredContext;
    Handler mRegisteredHandler;
    String[] mDisappearingPackages;
    String[] mAppearingPackages;
    String[] mModifiedPackages;
    int mChangeType;
    int mChangeUserId = -10000;
    boolean mSomePackagesChanged;
    String[] mModifiedComponents;
    String[] mTempArray = new String[1];
    PackageMonitorCallback mPackageMonitorCallback;
    private Executor mExecutor;
    final boolean mSupportsPackageRestartQuery;
    public static final int PACKAGE_UNCHANGED = 0;
    public static final int PACKAGE_UPDATING = 1;
    public static final int PACKAGE_TEMPORARY_CHANGE = 2;
    public static final int PACKAGE_PERMANENT_CHANGE = 3;

    @UnsupportedAppUsage
    public PackageMonitor() {
        this(!Flags.packageRestartQueryDisabledByDefault());
    }

    public PackageMonitor(boolean supportsPackageRestartQuery) {
        this.mSupportsPackageRestartQuery = supportsPackageRestartQuery;
    }

    private IntentFilter getPackageFilter() {
        boolean isCore = UserHandle.isCore(Process.myUid());
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        filter.addDataScheme("package");
        if (isCore) {
            filter.setPriority(1000);
        }
        return filter;
    }

    @UnsupportedAppUsage
    public void register(Context context, Looper thread, boolean externalStorage) {
        this.register(context, thread, null, externalStorage);
    }

    @UnsupportedAppUsage
    public void register(Context context, Looper thread, UserHandle user, boolean externalStorage) {
        this.register(context, user, thread == null ? BackgroundThread.getHandler() : new Handler(thread));
    }

    public void register(Context context, UserHandle user, Handler handler) {
        PackageManager pm;
        if (this.mRegisteredContext != null) {
            throw new IllegalStateException("Already registered");
        }
        this.mRegisteredContext = context;
        this.mRegisteredHandler = Objects.requireNonNull(handler);
        if (this.mSupportsPackageRestartQuery) {
            IntentFilter filter = this.getPackageFilter();
            if (user != null) {
                context.registerReceiverAsUser(this, user, filter, null, this.mRegisteredHandler);
            } else {
                context.registerReceiver(this, filter, null, this.mRegisteredHandler);
            }
        }
        if (this.mPackageMonitorCallback == null && (pm = this.mRegisteredContext.getPackageManager()) != null) {
            this.mExecutor = new HandlerExecutor(this.mRegisteredHandler);
            this.mPackageMonitorCallback = new PackageMonitorCallback(this);
            int userId = user != null ? user.getIdentifier() : this.mRegisteredContext.getUserId();
            pm.registerPackageMonitorCallback(this.mPackageMonitorCallback, userId);
        }
    }

    public Handler getRegisteredHandler() {
        return this.mRegisteredHandler;
    }

    @UnsupportedAppUsage
    public void unregister() {
        PackageManager pm;
        if (this.mRegisteredContext == null) {
            throw new IllegalStateException("Not registered");
        }
        if (this.mSupportsPackageRestartQuery) {
            this.mRegisteredContext.unregisterReceiver(this);
        }
        if ((pm = this.mRegisteredContext.getPackageManager()) != null && this.mPackageMonitorCallback != null) {
            pm.unregisterPackageMonitorCallback(this.mPackageMonitorCallback);
        }
        this.mPackageMonitorCallback = null;
        this.mRegisteredContext = null;
        this.mExecutor = null;
    }

    public void onBeginPackageChanges() {
    }

    public void onPackageAdded(String packageName, int uid) {
    }

    public void onPackageAddedWithExtras(String packageName, int uid, Bundle extras) {
    }

    @UnsupportedAppUsage
    public void onPackageRemoved(String packageName, int uid) {
    }

    public void onPackageRemovedWithExtras(String packageName, int uid, Bundle extras) {
    }

    public void onPackageRemovedAllUsers(String packageName, int uid) {
    }

    public void onPackageRemovedAllUsersWithExtras(String packageName, int uid, Bundle extras) {
    }

    public void onPackageUpdateStarted(String packageName, int uid) {
    }

    public void onPackageUpdateStartedWithExtras(String packageName, int uid, Bundle extras) {
    }

    public void onPackageUpdateFinished(String packageName, int uid) {
    }

    public void onPackageUpdateFinishedWithExtras(String packageName, int uid, Bundle extras) {
    }

    @UnsupportedAppUsage
    public boolean onPackageChanged(String packageName, int uid, String[] components) {
        if (components != null) {
            for (String name : components) {
                if (!packageName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public void onPackageChangedWithExtras(String packageName, Bundle extras) {
    }

    public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit, Bundle extras) {
        return this.onHandleForceStop(intent, packages, uid, doit);
    }

    public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
        return false;
    }

    public void onUidRemoved(int uid) {
    }

    public void onPackagesAvailable(String[] packages) {
    }

    public void onPackagesUnavailable(String[] packages) {
    }

    public void onPackagesSuspended(String[] packages) {
    }

    public void onPackagesUnsuspended(String[] packages) {
    }

    public void onPackageDisappeared(String packageName, int reason) {
    }

    public void onPackageDisappearedWithExtras(String packageName, Bundle extras) {
    }

    public void onPackageAppeared(String packageName, int reason) {
    }

    public void onPackageAppearedWithExtras(String packageName, Bundle extras) {
    }

    public void onPackageModified(@NonNull String packageName) {
    }

    public void onPackageModifiedWithExtras(@NonNull String packageName, Bundle extras) {
    }

    public void onPackageUnstopped(String packageName, int uid, Bundle extras) {
    }

    public boolean didSomePackagesChange() {
        return this.mSomePackagesChanged;
    }

    public int isPackageAppearing(String packageName) {
        if (this.mAppearingPackages != null) {
            for (int i = this.mAppearingPackages.length - 1; i >= 0; --i) {
                if (!packageName.equals(this.mAppearingPackages[i])) continue;
                return this.mChangeType;
            }
        }
        return 0;
    }

    public boolean anyPackagesAppearing() {
        return this.mAppearingPackages != null;
    }

    @UnsupportedAppUsage
    public int isPackageDisappearing(String packageName) {
        if (this.mDisappearingPackages != null) {
            for (int i = this.mDisappearingPackages.length - 1; i >= 0; --i) {
                if (!packageName.equals(this.mDisappearingPackages[i])) continue;
                return this.mChangeType;
            }
        }
        return 0;
    }

    public boolean anyPackagesDisappearing() {
        return this.mDisappearingPackages != null;
    }

    public boolean isReplacing() {
        return this.mChangeType == 1;
    }

    @UnsupportedAppUsage
    public boolean isPackageModified(String packageName) {
        if (this.mModifiedPackages != null) {
            for (int i = this.mModifiedPackages.length - 1; i >= 0; --i) {
                if (!packageName.equals(this.mModifiedPackages[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isComponentModified(String className) {
        if (className == null || this.mModifiedComponents == null) {
            return false;
        }
        for (int i = this.mModifiedComponents.length - 1; i >= 0; --i) {
            if (!className.equals(this.mModifiedComponents[i])) continue;
            return true;
        }
        return false;
    }

    public void onSomePackagesChanged() {
    }

    public void onFinishPackageChanges() {
    }

    public void onPackageDataCleared(String packageName, int uid) {
    }

    public void onPackageStateChanged(String packageName, int uid) {
    }

    public int getChangingUserId() {
        return this.mChangeUserId;
    }

    String getPackageName(Intent intent) {
        Uri uri = intent.getData();
        String pkg = uri != null ? uri.getSchemeSpecificPart() : null;
        return pkg;
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        this.doHandlePackageEvent(intent);
    }

    private void postHandlePackageEvent(Intent intent) {
        if (this.mExecutor != null) {
            this.mExecutor.execute(() -> this.doHandlePackageEvent(intent));
        }
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public void doHandlePackageEvent(Intent intent) {
        this.mChangeUserId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
        if (this.mChangeUserId == -10000) {
            Slog.w(TAG, "Intent broadcast does not contain user handle: " + intent);
            return;
        }
        this.onBeginPackageChanges();
        this.mAppearingPackages = null;
        this.mDisappearingPackages = null;
        this.mSomePackagesChanged = false;
        this.mModifiedComponents = null;
        String action = intent.getAction();
        if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
            String pkg = this.getPackageName(intent);
            int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            this.mSomePackagesChanged = true;
            if (pkg != null) {
                this.mAppearingPackages = this.mTempArray;
                this.mTempArray[0] = pkg;
                if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    this.mModifiedPackages = this.mTempArray;
                    this.mChangeType = 1;
                    this.onPackageUpdateFinished(pkg, uid);
                    this.onPackageUpdateFinishedWithExtras(pkg, uid, intent.getExtras());
                    this.onPackageModified(pkg);
                    this.onPackageModifiedWithExtras(pkg, intent.getExtras());
                } else {
                    this.mChangeType = 3;
                    this.onPackageAdded(pkg, uid);
                    this.onPackageAddedWithExtras(pkg, uid, intent.getExtras());
                }
                this.onPackageAppearedWithExtras(pkg, intent.getExtras());
                this.onPackageAppeared(pkg, this.mChangeType);
            }
        } else if ("android.intent.action.PACKAGE_REMOVED".equals(action)) {
            String pkg = this.getPackageName(intent);
            int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            if (pkg != null) {
                this.mDisappearingPackages = this.mTempArray;
                this.mTempArray[0] = pkg;
                if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    this.mChangeType = 1;
                    this.onPackageUpdateStarted(pkg, uid);
                    this.onPackageUpdateStartedWithExtras(pkg, uid, intent.getExtras());
                    if (intent.getBooleanExtra("android.intent.extra.ARCHIVAL", false)) {
                        this.onPackageModified(pkg);
                        this.onPackageModifiedWithExtras(pkg, intent.getExtras());
                    }
                } else {
                    this.mChangeType = 3;
                    this.mSomePackagesChanged = true;
                    this.onPackageRemoved(pkg, uid);
                    this.onPackageRemovedWithExtras(pkg, uid, intent.getExtras());
                    if (intent.getBooleanExtra("android.intent.extra.REMOVED_FOR_ALL_USERS", false)) {
                        this.onPackageRemovedAllUsers(pkg, uid);
                        this.onPackageRemovedAllUsersWithExtras(pkg, uid, intent.getExtras());
                    }
                }
                this.onPackageDisappearedWithExtras(pkg, intent.getExtras());
                this.onPackageDisappeared(pkg, this.mChangeType);
            }
        } else if ("android.intent.action.PACKAGE_CHANGED".equals(action)) {
            String pkg = this.getPackageName(intent);
            int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            this.mModifiedComponents = intent.getStringArrayExtra("android.intent.extra.changed_component_name_list");
            if (pkg != null) {
                this.mModifiedPackages = this.mTempArray;
                this.mTempArray[0] = pkg;
                this.mChangeType = 3;
                if (this.onPackageChanged(pkg, uid, this.mModifiedComponents)) {
                    this.mSomePackagesChanged = true;
                }
                this.onPackageChangedWithExtras(pkg, intent.getExtras());
                this.onPackageModified(pkg);
                this.onPackageModifiedWithExtras(pkg, intent.getExtras());
            }
        } else if ("android.intent.action.PACKAGE_DATA_CLEARED".equals(action)) {
            String pkg = this.getPackageName(intent);
            int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            if (pkg != null) {
                this.onPackageDataCleared(pkg, uid);
            }
        } else if ("android.intent.action.QUERY_PACKAGE_RESTART".equals(action)) {
            this.mDisappearingPackages = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
            this.mChangeType = 2;
            boolean canRestart = this.onHandleForceStop(intent, this.mDisappearingPackages, intent.getIntExtra("android.intent.extra.UID", 0), false, intent.getExtras());
            if (canRestart) {
                this.setResultCode(-1);
            }
        } else if ("android.intent.action.PACKAGE_RESTARTED".equals(action)) {
            this.mDisappearingPackages = new String[]{this.getPackageName(intent)};
            this.mChangeType = 2;
            this.onHandleForceStop(intent, this.mDisappearingPackages, intent.getIntExtra("android.intent.extra.UID", 0), true, intent.getExtras());
        } else if ("android.intent.action.UID_REMOVED".equals(action)) {
            this.onUidRemoved(intent.getIntExtra("android.intent.extra.UID", 0));
        } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action)) {
            String[] pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            this.mAppearingPackages = pkgList;
            this.mChangeType = intent.getBooleanExtra("android.intent.extra.REPLACING", false) ? 1 : 2;
            this.mSomePackagesChanged = true;
            if (pkgList != null) {
                this.onPackagesAvailable(pkgList);
                for (int i = 0; i < pkgList.length; ++i) {
                    this.onPackageAppeared(pkgList[i], this.mChangeType);
                }
            }
        } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
            String[] pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            this.mDisappearingPackages = pkgList;
            this.mChangeType = intent.getBooleanExtra("android.intent.extra.REPLACING", false) ? 1 : 2;
            this.mSomePackagesChanged = true;
            if (pkgList != null) {
                this.onPackagesUnavailable(pkgList);
                for (int i = 0; i < pkgList.length; ++i) {
                    this.onPackageDisappeared(pkgList[i], this.mChangeType);
                }
            }
        } else if ("android.intent.action.PACKAGES_SUSPENDED".equals(action)) {
            String[] pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            this.mSomePackagesChanged = true;
            this.onPackagesSuspended(pkgList);
        } else if ("android.intent.action.PACKAGES_UNSUSPENDED".equals(action)) {
            String[] pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            this.mSomePackagesChanged = true;
            this.onPackagesUnsuspended(pkgList);
        } else if ("android.intent.action.PACKAGE_UNSTOPPED".equals(action)) {
            String pkgName = this.getPackageName(intent);
            this.mAppearingPackages = new String[]{pkgName};
            this.mChangeType = 2;
            this.onPackageUnstopped(pkgName, intent.getIntExtra("android.intent.extra.UID", 0), intent.getExtras());
        }
        if (this.mSomePackagesChanged) {
            this.onSomePackagesChanged();
        }
        this.onFinishPackageChanges();
        this.mChangeUserId = -10000;
    }

    private static class PackageMonitorCallback
    extends IRemoteCallback.Stub {
        private final WeakReference<PackageMonitor> mMonitorWeakReference;

        PackageMonitorCallback(PackageMonitor monitor) {
            this.mMonitorWeakReference = new WeakReference<PackageMonitor>(monitor);
        }

        @Override
        public void sendResult(Bundle data) throws RemoteException {
            this.onHandlePackageMonitorCallback(data);
        }

        private void onHandlePackageMonitorCallback(Bundle bundle) {
            Intent intent = bundle.getParcelable("android.content.pm.extra.EXTRA_PACKAGE_MONITOR_CALLBACK_RESULT", Intent.class);
            if (intent == null) {
                Log.w(PackageMonitor.TAG, "No intent is set for PackageMonitorCallback");
                return;
            }
            PackageMonitor monitor = (PackageMonitor)this.mMonitorWeakReference.get();
            if (monitor != null) {
                monitor.postHandlePackageEvent(intent);
            }
        }
    }
}

