/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.compat;

import android.annotation.EnforcePermission;
import android.annotation.RequiresNoPermission;
import android.app.ActivityThread;
import android.content.pm.ApplicationInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PermissionEnforcer;
import android.os.RemoteException;
import com.android.internal.compat.CompatibilityChangeConfig;
import com.android.internal.compat.CompatibilityChangeInfo;
import com.android.internal.compat.CompatibilityOverrideConfig;
import com.android.internal.compat.CompatibilityOverridesByPackageConfig;
import com.android.internal.compat.CompatibilityOverridesToRemoveByPackageConfig;
import com.android.internal.compat.CompatibilityOverridesToRemoveConfig;
import com.android.internal.compat.IOverrideValidator;

public interface IPlatformCompat
extends IInterface {
    public static final String DESCRIPTOR = "com.android.internal.compat.IPlatformCompat";

    @EnforcePermission(value="android.permission.LOG_COMPAT_CHANGE")
    public void reportChange(long var1, ApplicationInfo var3) throws RemoteException;

    @EnforcePermission(value="android.permission.LOG_COMPAT_CHANGE")
    public void reportChangeByPackageName(long var1, String var3, int var4) throws RemoteException;

    @EnforcePermission(value="android.permission.LOG_COMPAT_CHANGE")
    public void reportChangeByUid(long var1, int var3) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.LOG_COMPAT_CHANGE", "android.permission.READ_COMPAT_CHANGE_CONFIG"})
    public boolean isChangeEnabled(long var1, ApplicationInfo var3) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.LOG_COMPAT_CHANGE", "android.permission.READ_COMPAT_CHANGE_CONFIG"})
    public boolean isChangeEnabledByPackageName(long var1, String var3, int var4) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.LOG_COMPAT_CHANGE", "android.permission.READ_COMPAT_CHANGE_CONFIG"})
    public boolean isChangeEnabledByUid(long var1, int var3) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG")
    public void setOverrides(CompatibilityChangeConfig var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public void putAllOverridesOnReleaseBuilds(CompatibilityOverridesByPackageConfig var1) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public void putOverridesOnReleaseBuilds(CompatibilityOverrideConfig var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG")
    public void setOverridesForTest(CompatibilityChangeConfig var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG")
    public boolean clearOverride(long var1, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG")
    public boolean clearOverrideForTest(long var1, String var3) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public void removeAllOverridesOnReleaseBuilds(CompatibilityOverridesToRemoveByPackageConfig var1) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD")
    public void removeOverridesOnReleaseBuilds(CompatibilityOverridesToRemoveConfig var1, String var2) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG")
    public int enableTargetSdkChanges(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG")
    public int disableTargetSdkChanges(String var1, int var2) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG")
    public void clearOverrides(String var1) throws RemoteException;

    @EnforcePermission(value="android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG")
    public void clearOverridesForTest(String var1) throws RemoteException;

    @EnforcePermission(allOf={"android.permission.LOG_COMPAT_CHANGE", "android.permission.READ_COMPAT_CHANGE_CONFIG"})
    public CompatibilityChangeConfig getAppConfig(ApplicationInfo var1) throws RemoteException;

    @EnforcePermission(value="android.permission.READ_COMPAT_CHANGE_CONFIG")
    public CompatibilityChangeInfo[] listAllChanges() throws RemoteException;

    @RequiresNoPermission
    public CompatibilityChangeInfo[] listUIChanges() throws RemoteException;

    @RequiresNoPermission
    public IOverrideValidator getOverrideValidator() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPlatformCompat {
        private final PermissionEnforcer mEnforcer;
        static final int TRANSACTION_reportChange = 1;
        static final int TRANSACTION_reportChangeByPackageName = 2;
        static final int TRANSACTION_reportChangeByUid = 3;
        static final int TRANSACTION_isChangeEnabled = 4;
        static final String[] PERMISSIONS_isChangeEnabled = new String[]{"android.permission.LOG_COMPAT_CHANGE", "android.permission.READ_COMPAT_CHANGE_CONFIG"};
        static final int TRANSACTION_isChangeEnabledByPackageName = 5;
        static final String[] PERMISSIONS_isChangeEnabledByPackageName = new String[]{"android.permission.LOG_COMPAT_CHANGE", "android.permission.READ_COMPAT_CHANGE_CONFIG"};
        static final int TRANSACTION_isChangeEnabledByUid = 6;
        static final String[] PERMISSIONS_isChangeEnabledByUid = new String[]{"android.permission.LOG_COMPAT_CHANGE", "android.permission.READ_COMPAT_CHANGE_CONFIG"};
        static final int TRANSACTION_setOverrides = 7;
        static final int TRANSACTION_putAllOverridesOnReleaseBuilds = 8;
        static final int TRANSACTION_putOverridesOnReleaseBuilds = 9;
        static final int TRANSACTION_setOverridesForTest = 10;
        static final int TRANSACTION_clearOverride = 11;
        static final int TRANSACTION_clearOverrideForTest = 12;
        static final int TRANSACTION_removeAllOverridesOnReleaseBuilds = 13;
        static final int TRANSACTION_removeOverridesOnReleaseBuilds = 14;
        static final int TRANSACTION_enableTargetSdkChanges = 15;
        static final int TRANSACTION_disableTargetSdkChanges = 16;
        static final int TRANSACTION_clearOverrides = 17;
        static final int TRANSACTION_clearOverridesForTest = 18;
        static final int TRANSACTION_getAppConfig = 19;
        static final String[] PERMISSIONS_getAppConfig = new String[]{"android.permission.LOG_COMPAT_CHANGE", "android.permission.READ_COMPAT_CHANGE_CONFIG"};
        static final int TRANSACTION_listAllChanges = 20;
        static final int TRANSACTION_listUIChanges = 21;
        static final int TRANSACTION_getOverrideValidator = 22;

        public Stub(PermissionEnforcer enforcer) {
            this.attachInterface(this, IPlatformCompat.DESCRIPTOR);
            if (enforcer == null) {
                throw new IllegalArgumentException("enforcer cannot be null");
            }
            this.mEnforcer = enforcer;
        }

        @Deprecated
        public Stub() {
            this(PermissionEnforcer.fromContext(ActivityThread.currentActivityThread().getSystemContext()));
        }

        public static IPlatformCompat asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IPlatformCompat.DESCRIPTOR);
            if (iin != null && iin instanceof IPlatformCompat) {
                return (IPlatformCompat)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "reportChange";
                }
                case 2: {
                    return "reportChangeByPackageName";
                }
                case 3: {
                    return "reportChangeByUid";
                }
                case 4: {
                    return "isChangeEnabled";
                }
                case 5: {
                    return "isChangeEnabledByPackageName";
                }
                case 6: {
                    return "isChangeEnabledByUid";
                }
                case 7: {
                    return "setOverrides";
                }
                case 8: {
                    return "putAllOverridesOnReleaseBuilds";
                }
                case 9: {
                    return "putOverridesOnReleaseBuilds";
                }
                case 10: {
                    return "setOverridesForTest";
                }
                case 11: {
                    return "clearOverride";
                }
                case 12: {
                    return "clearOverrideForTest";
                }
                case 13: {
                    return "removeAllOverridesOnReleaseBuilds";
                }
                case 14: {
                    return "removeOverridesOnReleaseBuilds";
                }
                case 15: {
                    return "enableTargetSdkChanges";
                }
                case 16: {
                    return "disableTargetSdkChanges";
                }
                case 17: {
                    return "clearOverrides";
                }
                case 18: {
                    return "clearOverridesForTest";
                }
                case 19: {
                    return "getAppConfig";
                }
                case 20: {
                    return "listAllChanges";
                }
                case 21: {
                    return "listUIChanges";
                }
                case 22: {
                    return "getOverrideValidator";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IPlatformCompat.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    long _arg0 = data.readLong();
                    ApplicationInfo _arg1 = data.readTypedObject(ApplicationInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.reportChange(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportChangeByPackageName(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reportChangeByUid(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    long _arg0 = data.readLong();
                    ApplicationInfo _arg1 = data.readTypedObject(ApplicationInfo.CREATOR);
                    data.enforceNoDataAvail();
                    boolean _result = this.isChangeEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 5: {
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isChangeEnabledByPackageName(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isChangeEnabledByUid(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 7: {
                    CompatibilityChangeConfig _arg0 = data.readTypedObject(CompatibilityChangeConfig.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setOverrides(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    CompatibilityOverridesByPackageConfig _arg0 = data.readTypedObject(CompatibilityOverridesByPackageConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.putAllOverridesOnReleaseBuilds(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    CompatibilityOverrideConfig _arg0 = data.readTypedObject(CompatibilityOverrideConfig.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.putOverridesOnReleaseBuilds(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    CompatibilityChangeConfig _arg0 = data.readTypedObject(CompatibilityChangeConfig.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.setOverridesForTest(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.clearOverride(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 12: {
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    boolean _result = this.clearOverrideForTest(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 13: {
                    CompatibilityOverridesToRemoveByPackageConfig _arg0 = data.readTypedObject(CompatibilityOverridesToRemoveByPackageConfig.CREATOR);
                    data.enforceNoDataAvail();
                    this.removeAllOverridesOnReleaseBuilds(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    CompatibilityOverridesToRemoveConfig _arg0 = data.readTypedObject(CompatibilityOverridesToRemoveConfig.CREATOR);
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.removeOverridesOnReleaseBuilds(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.enableTargetSdkChanges(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 16: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.disableTargetSdkChanges(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 17: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.clearOverrides(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 18: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.clearOverridesForTest(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    ApplicationInfo _arg0 = data.readTypedObject(ApplicationInfo.CREATOR);
                    data.enforceNoDataAvail();
                    CompatibilityChangeConfig _result = this.getAppConfig(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 20: {
                    Parcelable[] _result = this.listAllChanges();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 21: {
                    Parcelable[] _result = this.listUIChanges();
                    reply.writeNoException();
                    reply.writeTypedArray(_result, 1);
                    break;
                }
                case 22: {
                    IOverrideValidator _result = this.getOverrideValidator();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        protected void reportChange_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LOG_COMPAT_CHANGE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void reportChangeByPackageName_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LOG_COMPAT_CHANGE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void reportChangeByUid_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.LOG_COMPAT_CHANGE", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isChangeEnabled_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_isChangeEnabled, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isChangeEnabledByPackageName_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_isChangeEnabledByPackageName, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void isChangeEnabledByUid_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_isChangeEnabledByUid, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setOverrides_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void putAllOverridesOnReleaseBuilds_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void putOverridesOnReleaseBuilds_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void setOverridesForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearOverride_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearOverrideForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeAllOverridesOnReleaseBuilds_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void removeOverridesOnReleaseBuilds_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG_ON_RELEASE_BUILD", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void enableTargetSdkChanges_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void disableTargetSdkChanges_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearOverrides_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void clearOverridesForTest_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.OVERRIDE_COMPAT_CHANGE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void getAppConfig_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermissionAllOf(PERMISSIONS_getAppConfig, Stub.getCallingPid(), Stub.getCallingUid());
        }

        protected void listAllChanges_enforcePermission() throws SecurityException {
            this.mEnforcer.enforcePermission("android.permission.READ_COMPAT_CHANGE_CONFIG", Stub.getCallingPid(), Stub.getCallingUid());
        }

        @Override
        public int getMaxTransactionId() {
            return 21;
        }

        private static class Proxy
        implements IPlatformCompat {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IPlatformCompat.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportChange(long changeId, ApplicationInfo appInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeTypedObject(appInfo, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportChangeByPackageName(long changeId, String packageName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reportChangeByUid(long changeId, int uid) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isChangeEnabled(long changeId, ApplicationInfo appInfo) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeTypedObject(appInfo, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isChangeEnabledByPackageName(long changeId, String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isChangeEnabledByUid(long changeId, int uid) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeInt(uid);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOverrides(CompatibilityChangeConfig overrides, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeTypedObject(overrides, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void putAllOverridesOnReleaseBuilds(CompatibilityOverridesByPackageConfig overridesByPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeTypedObject(overridesByPackage, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void putOverridesOnReleaseBuilds(CompatibilityOverrideConfig overrides, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeTypedObject(overrides, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOverridesForTest(CompatibilityChangeConfig overrides, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeTypedObject(overrides, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean clearOverride(long changeId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean clearOverrideForTest(long changeId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeLong(changeId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAllOverridesOnReleaseBuilds(CompatibilityOverridesToRemoveByPackageConfig overridesToRemoveByPackage) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeTypedObject(overridesToRemoveByPackage, 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOverridesOnReleaseBuilds(CompatibilityOverridesToRemoveConfig overridesToRemove, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeTypedObject(overridesToRemove, 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int enableTargetSdkChanges(String packageName, int targetSdkVersion) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int disableTargetSdkChanges(String packageName, int targetSdkVersion) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(targetSdkVersion);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearOverrides(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearOverridesForTest(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompatibilityChangeConfig getAppConfig(ApplicationInfo appInfo) throws RemoteException {
                CompatibilityChangeConfig _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    _data.writeTypedObject(appInfo, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(CompatibilityChangeConfig.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompatibilityChangeInfo[] listAllChanges() throws RemoteException {
                CompatibilityChangeInfo[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(CompatibilityChangeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CompatibilityChangeInfo[] listUIChanges() throws RemoteException {
                CompatibilityChangeInfo[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArray(CompatibilityChangeInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IOverrideValidator getOverrideValidator() throws RemoteException {
                IOverrideValidator _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IPlatformCompat.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                    _result = IOverrideValidator.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IPlatformCompat {
        @Override
        public void reportChange(long changeId, ApplicationInfo appInfo) throws RemoteException {
        }

        @Override
        public void reportChangeByPackageName(long changeId, String packageName, int userId) throws RemoteException {
        }

        @Override
        public void reportChangeByUid(long changeId, int uid) throws RemoteException {
        }

        @Override
        public boolean isChangeEnabled(long changeId, ApplicationInfo appInfo) throws RemoteException {
            return false;
        }

        @Override
        public boolean isChangeEnabledByPackageName(long changeId, String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public boolean isChangeEnabledByUid(long changeId, int uid) throws RemoteException {
            return false;
        }

        @Override
        public void setOverrides(CompatibilityChangeConfig overrides, String packageName) throws RemoteException {
        }

        @Override
        public void putAllOverridesOnReleaseBuilds(CompatibilityOverridesByPackageConfig overridesByPackage) throws RemoteException {
        }

        @Override
        public void putOverridesOnReleaseBuilds(CompatibilityOverrideConfig overrides, String packageName) throws RemoteException {
        }

        @Override
        public void setOverridesForTest(CompatibilityChangeConfig overrides, String packageName) throws RemoteException {
        }

        @Override
        public boolean clearOverride(long changeId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean clearOverrideForTest(long changeId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void removeAllOverridesOnReleaseBuilds(CompatibilityOverridesToRemoveByPackageConfig overridesToRemoveByPackage) throws RemoteException {
        }

        @Override
        public void removeOverridesOnReleaseBuilds(CompatibilityOverridesToRemoveConfig overridesToRemove, String packageName) throws RemoteException {
        }

        @Override
        public int enableTargetSdkChanges(String packageName, int targetSdkVersion) throws RemoteException {
            return 0;
        }

        @Override
        public int disableTargetSdkChanges(String packageName, int targetSdkVersion) throws RemoteException {
            return 0;
        }

        @Override
        public void clearOverrides(String packageName) throws RemoteException {
        }

        @Override
        public void clearOverridesForTest(String packageName) throws RemoteException {
        }

        @Override
        public CompatibilityChangeConfig getAppConfig(ApplicationInfo appInfo) throws RemoteException {
            return null;
        }

        @Override
        public CompatibilityChangeInfo[] listAllChanges() throws RemoteException {
            return null;
        }

        @Override
        public CompatibilityChangeInfo[] listUIChanges() throws RemoteException {
            return null;
        }

        @Override
        public IOverrideValidator getOverrideValidator() throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

