/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.media.MediaRouter;
import android.util.TypedValue;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.SeekBar;

public class MediaRouteControllerContentManager {
    private final Context mContext;
    private final Delegate mDelegate;
    private static final int VOLUME_UPDATE_DELAY_MILLIS = 250;
    private final MediaRouter mRouter;
    private final MediaRouterCallback mCallback;
    private final MediaRouter.RouteInfo mRoute;
    private Drawable mMediaRouteButtonDrawable;
    private final int[] mMediaRouteConnectingState = new int[]{0x10100A0, 16842910};
    private final int[] mMediaRouteOnState = new int[]{16843518, 16842910};
    private Drawable mCurrentIconDrawable;
    private boolean mAttachedToWindow;
    private LinearLayout mVolumeLayout;
    private SeekBar mVolumeSlider;
    private boolean mVolumeSliderTouched;

    public MediaRouteControllerContentManager(Context context, Delegate delegate) {
        this.mContext = context;
        this.mDelegate = delegate;
        this.mRouter = context.getSystemService(MediaRouter.class);
        this.mCallback = new MediaRouterCallback();
        this.mRoute = this.mRouter.getSelectedRoute();
    }

    public void bindViews(View containerView) {
        this.mDelegate.setMediaRouteDeviceTitle(this.mRoute.getName());
        this.mVolumeLayout = (LinearLayout)containerView.findViewById(16909283);
        this.mVolumeSlider = (SeekBar)containerView.findViewById(16909284);
        this.mVolumeSlider.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){
            private final Runnable mStopTrackingTouch = new Runnable(){

                @Override
                public void run() {
                    if (MediaRouteControllerContentManager.this.mVolumeSliderTouched) {
                        MediaRouteControllerContentManager.this.mVolumeSliderTouched = false;
                        MediaRouteControllerContentManager.this.updateVolume();
                    }
                }
            };

            @Override
            public void onStartTrackingTouch(SeekBar seekBar) {
                if (MediaRouteControllerContentManager.this.mVolumeSliderTouched) {
                    MediaRouteControllerContentManager.this.mVolumeSlider.removeCallbacks(this.mStopTrackingTouch);
                } else {
                    MediaRouteControllerContentManager.this.mVolumeSliderTouched = true;
                }
            }

            @Override
            public void onStopTrackingTouch(SeekBar seekBar) {
                MediaRouteControllerContentManager.this.mVolumeSlider.postDelayed(this.mStopTrackingTouch, 250L);
            }

            @Override
            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (fromUser) {
                    MediaRouteControllerContentManager.this.mRoute.requestSetVolume(progress);
                }
            }
        });
        this.mMediaRouteButtonDrawable = this.obtainMediaRouteButtonDrawable();
    }

    public void onAttachedToWindow() {
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(0, this.mCallback, 2);
        this.update();
    }

    public void onDetachedFromWindow() {
        this.mRouter.removeCallback(this.mCallback);
        this.mAttachedToWindow = false;
    }

    public void update() {
        if (!this.mRoute.isSelected() || this.mRoute.isDefault()) {
            this.mDelegate.dismissView();
        }
        this.mDelegate.setMediaRouteDeviceTitle(this.mRoute.getName());
        this.updateVolume();
        Drawable icon = this.getIconDrawable();
        if (icon != this.mCurrentIconDrawable) {
            this.mCurrentIconDrawable = icon;
            if (icon instanceof AnimationDrawable) {
                AnimationDrawable animDrawable = (AnimationDrawable)icon;
                if (!this.mAttachedToWindow && !this.mRoute.isConnecting()) {
                    if (animDrawable.isRunning()) {
                        animDrawable.stop();
                    }
                    icon = animDrawable.getFrame(animDrawable.getNumberOfFrames() - 1);
                } else if (!animDrawable.isRunning()) {
                    animDrawable.start();
                }
            }
            this.mDelegate.setMediaRouteDeviceIcon(icon);
        }
    }

    private void updateVolume() {
        if (!this.mVolumeSliderTouched) {
            if (this.isVolumeControlAvailable()) {
                this.mVolumeLayout.setVisibility(0);
                this.mVolumeSlider.setMax(this.mRoute.getVolumeMax());
                this.mVolumeSlider.setProgress(this.mRoute.getVolume());
            } else {
                this.mVolumeLayout.setVisibility(8);
            }
        }
    }

    public void onDisconnectButtonClick() {
        if (this.mRoute.isSelected()) {
            if (this.mRoute.isBluetooth()) {
                this.mRouter.getDefaultRoute().select();
            } else {
                this.mRouter.getFallbackRoute().select();
            }
        }
        this.mDelegate.dismissView();
    }

    public void requestUpdateRouteVolume(int direction) {
        this.mRoute.requestUpdateVolume(direction);
    }

    private boolean isVolumeControlAvailable() {
        return this.mRoute.getVolumeHandling() == 1;
    }

    private Drawable obtainMediaRouteButtonDrawable() {
        TypedValue value = new TypedValue();
        if (!this.mContext.getTheme().resolveAttribute(16843693, value, true)) {
            return null;
        }
        int[] drawableAttrs = new int[]{17956942};
        TypedArray a = this.mContext.obtainStyledAttributes(value.data, drawableAttrs);
        Drawable drawable2 = a.getDrawable(0);
        a.recycle();
        return drawable2;
    }

    private Drawable getIconDrawable() {
        if (!(this.mMediaRouteButtonDrawable instanceof StateListDrawable)) {
            return this.mMediaRouteButtonDrawable;
        }
        if (this.mRoute.isConnecting()) {
            StateListDrawable stateListDrawable = (StateListDrawable)this.mMediaRouteButtonDrawable;
            stateListDrawable.setState(this.mMediaRouteConnectingState);
            return stateListDrawable.getCurrent();
        }
        StateListDrawable stateListDrawable = (StateListDrawable)this.mMediaRouteButtonDrawable;
        stateListDrawable.setState(this.mMediaRouteOnState);
        return stateListDrawable.getCurrent();
    }

    public static interface Delegate {
        public void setMediaRouteDeviceTitle(CharSequence var1);

        public void setMediaRouteDeviceIcon(Drawable var1);

        public void dismissView();
    }

    private class MediaRouterCallback
    extends MediaRouter.SimpleCallback {
        private MediaRouterCallback() {
        }

        @Override
        public void onRouteUnselected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            MediaRouteControllerContentManager.this.update();
        }

        @Override
        public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteControllerContentManager.this.update();
        }

        @Override
        public void onRouteVolumeChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            if (route == MediaRouteControllerContentManager.this.mRoute) {
                MediaRouteControllerContentManager.this.updateVolume();
            }
        }

        @Override
        public void onRouteGrouped(MediaRouter router, MediaRouter.RouteInfo info, MediaRouter.RouteGroup group, int index) {
            MediaRouteControllerContentManager.this.update();
        }

        @Override
        public void onRouteUngrouped(MediaRouter router, MediaRouter.RouteInfo info, MediaRouter.RouteGroup group) {
            MediaRouteControllerContentManager.this.update();
        }
    }
}

