/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.annotation.Nullable;
import android.app.Activity;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.admin.DevicePolicyManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.graphics.Insets;
import android.graphics.drawable.Drawable;
import android.metrics.LogMaker;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.telecom.TelecomManager;
import android.util.Log;
import android.util.Slog;
import android.view.View;
import android.view.WindowInsets;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.ChooserActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.chooser.TargetInfo;
import com.android.internal.hidden_from_bootclasspath.android.os.Flags;
import com.android.internal.logging.MetricsLogger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class IntentForwarderActivity
extends Activity {
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static String TAG = "IntentForwarderActivity";
    public static String FORWARD_INTENT_TO_PARENT = "com.android.internal.app.ForwardIntentToParent";
    public static String FORWARD_INTENT_TO_MANAGED_PROFILE = "com.android.internal.app.ForwardIntentToManagedProfile";
    public static final String EXTRA_SKIP_USER_CONFIRMATION = "com.android.internal.app.EXTRA_SKIP_USER_CONFIRMATION";
    private static final Set<String> ALLOWED_TEXT_MESSAGE_SCHEMES = new HashSet<String>(Arrays.asList("sms", "smsto", "mms", "mmsto"));
    private static final String TEL_SCHEME = "tel";
    private static final ComponentName RESOLVER_COMPONENT_NAME = new ComponentName("android", ResolverActivity.class.getName());
    private Injector mInjector;
    private MetricsLogger mMetricsLogger;
    protected ExecutorService mExecutorService;

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.mExecutorService.shutdown();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setMiniresolverPadding();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        UserInfo managedProfile;
        int targetUserId;
        String userMessage;
        super.onCreate(savedInstanceState);
        this.mInjector = this.createInjector();
        this.mExecutorService = Executors.newSingleThreadExecutor();
        Intent intentReceived = this.getIntent();
        String className = intentReceived.getComponent().getClassName();
        if (className.equals(FORWARD_INTENT_TO_PARENT)) {
            userMessage = this.getForwardToPersonalMessage();
            targetUserId = this.getProfileParent();
            managedProfile = null;
            this.getMetricsLogger().write(new LogMaker(1661).setSubtype(1));
        } else if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            userMessage = this.getForwardToWorkMessage();
            managedProfile = this.getManagedProfile();
            targetUserId = managedProfile == null ? -10000 : managedProfile.id;
            this.getMetricsLogger().write(new LogMaker(1661).setSubtype(2));
        } else {
            Slog.wtf(TAG, IntentForwarderActivity.class.getName() + " cannot be called directly");
            userMessage = null;
            targetUserId = -10000;
            managedProfile = null;
        }
        if (targetUserId == -10000) {
            this.finish();
            return;
        }
        if ("android.intent.action.CHOOSER".equals(intentReceived.getAction())) {
            this.launchChooserActivityWithCorrectTab(intentReceived, className);
            return;
        }
        int callingUserId = this.getUserId();
        Intent newIntent = IntentForwarderActivity.canForward(intentReceived, this.getUserId(), targetUserId, this.mInjector.getIPackageManager(), this.getContentResolver());
        if (newIntent == null) {
            Slog.wtf(TAG, "the intent: " + intentReceived + " cannot be forwarded from user " + callingUserId + " to user " + targetUserId);
            this.finish();
            return;
        }
        newIntent.prepareToLeaveUser(callingUserId);
        CompletableFuture<ResolveInfo> targetResolveInfoFuture = this.mInjector.resolveActivityAsUser(newIntent, 65536, targetUserId);
        if (this.isPrivateProfile(callingUserId)) {
            this.buildAndExecuteForPrivateProfile(intentReceived, className, newIntent, callingUserId, targetUserId);
        } else {
            this.buildAndExecute(targetResolveInfoFuture, intentReceived, className, newIntent, callingUserId, targetUserId, userMessage, managedProfile);
        }
    }

    private void buildAndExecute(CompletableFuture<ResolveInfo> targetResolveInfoFuture, Intent intentReceived, String className, Intent newIntent, int callingUserId, int targetUserId, String userMessage, UserInfo managedProfile) {
        ((CompletableFuture)targetResolveInfoFuture.thenApplyAsync(targetResolveInfo -> {
            if (this.isResolverActivityResolveInfo((ResolveInfo)targetResolveInfo)) {
                this.launchResolverActivityWithCorrectTab(intentReceived, className, newIntent, callingUserId, targetUserId, false);
            } else if (className.equals(FORWARD_INTENT_TO_PARENT)) {
                this.startActivityAsCaller(newIntent, targetUserId);
            }
            return targetResolveInfo;
        }, (Executor)this.mExecutorService)).thenAcceptAsync(result -> {
            if (className.equals(FORWARD_INTENT_TO_PARENT)) {
                this.maybeShowDisclosure(intentReceived, (ResolveInfo)result, userMessage);
                this.finish();
            } else if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
                this.maybeShowUserConsentMiniResolver((ResolveInfo)result, newIntent, managedProfile);
            }
        }, this.getApplicationContext().getMainExecutor());
    }

    private void buildAndExecuteForPrivateProfile(Intent intentReceived, String className, Intent newIntent, int callingUserId, int targetUserId) {
        CompletableFuture<ResolveInfo> targetResolveInfoFuture = this.mInjector.resolveActivityAsUser(newIntent, 65536, targetUserId);
        targetResolveInfoFuture.thenAcceptAsync(targetResolveInfo -> {
            if (this.isResolverActivityResolveInfo((ResolveInfo)targetResolveInfo)) {
                this.launchResolverActivityWithCorrectTab(intentReceived, className, newIntent, callingUserId, targetUserId, true);
            } else {
                this.maybeShowUserConsentMiniResolverPrivate((ResolveInfo)targetResolveInfo, newIntent, targetUserId);
            }
        }, this.getApplicationContext().getMainExecutor());
    }

    private void maybeShowUserConsentMiniResolver(ResolveInfo target, Intent launchIntent, UserInfo managedProfile) {
        boolean intentToLaunchProfileOwner;
        if (target == null || this.isIntentForwarderResolveInfo(target) || !this.isDeviceProvisioned()) {
            this.finish();
            return;
        }
        int targetUserId = managedProfile == null ? -10000 : managedProfile.id;
        String callingPackage = this.getCallingPackage();
        boolean privilegedCallerAskedToSkipUserConsent = launchIntent.getBooleanExtra(EXTRA_SKIP_USER_CONFIRMATION, false) && callingPackage != null && 0 == this.getPackageManager().checkPermission("android.permission.INTERACT_ACROSS_USERS", callingPackage);
        DevicePolicyManager devicePolicyManager = this.getSystemService(DevicePolicyManager.class);
        ComponentName profileOwnerName = devicePolicyManager.getProfileOwnerAsUser(targetUserId);
        boolean bl = intentToLaunchProfileOwner = profileOwnerName != null && profileOwnerName.getPackageName().equals(target.getComponentInfo().packageName);
        if (privilegedCallerAskedToSkipUserConsent || intentToLaunchProfileOwner) {
            Log.i("IntentForwarderActivity", String.format("Skipping user consent for redirection into the managed profile for intent [%s], privilegedCallerAskedToSkipUserConsent=[%s], intentToLaunchProfileOwner=[%s]", launchIntent, privilegedCallerAskedToSkipUserConsent, intentToLaunchProfileOwner));
            this.startActivityAsCaller(launchIntent, targetUserId);
            this.finish();
            return;
        }
        Log.i("IntentForwarderActivity", String.format("Showing user consent for redirection into the managed profile for intent [%s] and  calling package [%s]", launchIntent, callingPackage));
        PackageManager packageManagerForTargetUser = this.createContextAsUser(UserHandle.of(targetUserId), 0).getPackageManager();
        this.buildMiniResolver(target, launchIntent, targetUserId, this.getOpenInWorkMessage(launchIntent, target.loadLabel(packageManagerForTargetUser)), packageManagerForTargetUser);
        ((Button)this.findViewById(16908893)).setText(this.getOpenInWorkButtonString(launchIntent));
        Object telephonyInfo = this.findViewById(16909301);
        if ((this.isDialerIntent(launchIntent) || this.isTextMessageIntent(launchIntent)) && devicePolicyManager.getManagedSubscriptionsPolicy().getPolicyType() == 1) {
            ((View)telephonyInfo).setVisibility(0);
            ((TextView)this.findViewById(16909303)).setText(this.getWorkTelephonyInfoSectionMessage(launchIntent));
        } else {
            ((View)telephonyInfo).setVisibility(8);
        }
    }

    private void maybeShowUserConsentMiniResolverPrivate(ResolveInfo target, Intent launchIntent, int targetUserId) {
        if (target == null || this.isIntentForwarderResolveInfo(target)) {
            this.finish();
            return;
        }
        String callingPackage = this.getCallingPackage();
        Log.i("IntentForwarderActivity", String.format("Showing user consent for redirection into the main profile for intent [%s] and  calling package [%s]", launchIntent, callingPackage));
        PackageManager packageManagerForTargetUser = this.createContextAsUser(UserHandle.of(targetUserId), 0).getPackageManager();
        this.buildMiniResolver(target, launchIntent, targetUserId, this.getString(17041005, target.loadLabel(packageManagerForTargetUser)), packageManagerForTargetUser);
        Object telephonyInfo = this.findViewById(16909301);
        ((View)telephonyInfo).setVisibility(0);
        if (this.isTextMessageIntent(launchIntent)) {
            ((TextView)this.findViewById(16909303)).setText(17041008);
        } else {
            ((TextView)this.findViewById(16909303)).setText(17041009);
        }
    }

    private void buildMiniResolver(ResolveInfo target, Intent launchIntent, int targetUserId, String resolverTitle, PackageManager pmForTargetUser) {
        int layoutId = 17367220;
        this.setContentView(layoutId);
        ((View)this.findViewById(16909726)).setElevation(0.0f);
        ImageView icon = (ImageView)this.findViewById(16908294);
        icon.setImageDrawable(this.getAppIcon(target, launchIntent, targetUserId, pmForTargetUser));
        this.setMiniresolverPadding();
        ((TextView)this.findViewById(16909386)).setText(resolverTitle);
        ((Button)this.findViewById(16909790)).setText(0x1040000);
        ((View)this.findViewById(16909790)).setOnClickListener(v -> this.finish());
        ((View)this.findViewById(16908893)).setOnClickListener(v -> {
            TargetInfo.refreshIntentCreatorToken(launchIntent);
            this.startActivityAsCaller(launchIntent, ActivityOptions.makeCustomAnimation(this.getApplicationContext(), 17432591, 17432700).toBundle(), false, targetUserId);
            this.finish();
        });
    }

    private Drawable getAppIcon(ResolveInfo target, Intent launchIntent, int targetUserId, PackageManager packageManagerForTargetUser) {
        if (this.isDialerIntent(launchIntent)) {
            TelecomManager telecomManager = this.getApplicationContext().getSystemService(TelecomManager.class);
            String defaultDialerPackageName = telecomManager.getDefaultDialerPackage(UserHandle.of(targetUserId));
            try {
                return packageManagerForTargetUser.getApplicationInfo(defaultDialerPackageName, 0).loadIcon(packageManagerForTargetUser);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w(TAG, "Cannot load icon for default dialer package");
            }
        }
        return target.loadIcon(packageManagerForTargetUser);
    }

    private int getOpenInWorkButtonString(Intent launchIntent) {
        if (this.isDialerIntent(launchIntent)) {
            return 17041002;
        }
        if (this.isTextMessageIntent(launchIntent)) {
            return 17041011;
        }
        return 17042131;
    }

    private String getOpenInWorkMessage(Intent launchIntent, CharSequence targetLabel) {
        if (this.isDialerIntent(launchIntent)) {
            return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_CALL_FROM_WORK", () -> this.getString(17041003));
        }
        if (this.isTextMessageIntent(launchIntent)) {
            return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_SWITCH_TO_WORK", () -> this.getString(17041012));
        }
        return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_OPEN_WORK", () -> this.getString(17041007, targetLabel), targetLabel);
    }

    private String getWorkTelephonyInfoSectionMessage(Intent launchIntent) {
        if (this.isDialerIntent(launchIntent)) {
            return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_WORK_TELEPHONY_INFORMATION", () -> this.getString(17041004));
        }
        if (this.isTextMessageIntent(launchIntent)) {
            return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.MINIRESOLVER_WORK_TELEPHONY_INFORMATION", () -> this.getString(17041010));
        }
        return "";
    }

    private String getForwardToPersonalMessage() {
        return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.FORWARD_INTENT_TO_PERSONAL", () -> this.getString(17040489));
    }

    private String getForwardToWorkMessage() {
        return this.getSystemService(DevicePolicyManager.class).getResources().getString("Core.FORWARD_INTENT_TO_WORK", () -> this.getString(17040490));
    }

    private boolean isIntentForwarderResolveInfo(ResolveInfo resolveInfo) {
        if (resolveInfo == null) {
            return false;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return false;
        }
        if (!"android".equals(activityInfo.packageName)) {
            return false;
        }
        return activityInfo.name.equals(FORWARD_INTENT_TO_PARENT) || activityInfo.name.equals(FORWARD_INTENT_TO_MANAGED_PROFILE);
    }

    private boolean isResolverActivityResolveInfo(@Nullable ResolveInfo resolveInfo) {
        return resolveInfo != null && resolveInfo.activityInfo != null && RESOLVER_COMPONENT_NAME.equals(resolveInfo.activityInfo.getComponentName());
    }

    private void maybeShowDisclosure(Intent intentReceived, ResolveInfo resolveInfo, @Nullable String message) {
        if (this.shouldShowDisclosure(resolveInfo, intentReceived) && message != null) {
            this.mInjector.showToast(message, 1);
        }
    }

    private void startActivityAsCaller(Intent newIntent, int userId) {
        try {
            TargetInfo.refreshIntentCreatorToken(newIntent);
            this.startActivityAsCaller(newIntent, null, false, userId);
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unable to launch as UID " + this.getLaunchedFromUid() + " package " + this.getLaunchedFromPackage() + ", while running in " + ActivityThread.currentProcessName(), e);
        }
    }

    private void launchChooserActivityWithCorrectTab(Intent intentReceived, String className) {
        int selectedProfile = this.findSelectedProfile(className);
        IntentForwarderActivity.sanitizeIntent(intentReceived);
        intentReceived.putExtra("com.android.internal.app.ResolverActivity.EXTRA_SELECTED_PROFILE", selectedProfile);
        Intent innerIntent = intentReceived.getParcelableExtra("android.intent.extra.INTENT", Intent.class);
        if (innerIntent == null) {
            Slog.wtf(TAG, "Cannot start a chooser intent with no extra android.intent.extra.INTENT");
            return;
        }
        IntentForwarderActivity.sanitizeIntent(innerIntent);
        TargetInfo.refreshIntentCreatorToken(intentReceived);
        this.startActivityAsCaller(intentReceived, null, false, this.getUserId());
        this.finish();
    }

    private void launchResolverActivityWithCorrectTab(Intent intentReceived, String className, Intent newIntent, int callingUserId, int targetUserId, boolean singleTabOnly) {
        ResolveInfo callingResolveInfo = this.mInjector.resolveActivityAsUser(newIntent, 65536, callingUserId).join();
        int userId = this.isIntentForwarderResolveInfo(callingResolveInfo) ? targetUserId : callingUserId;
        int selectedProfile = this.findSelectedProfile(className);
        IntentForwarderActivity.sanitizeIntent(intentReceived);
        intentReceived.putExtra("com.android.internal.app.ResolverActivity.EXTRA_SELECTED_PROFILE", selectedProfile);
        intentReceived.putExtra("com.android.internal.app.ResolverActivity.EXTRA_CALLING_USER", UserHandle.of(callingUserId));
        if (singleTabOnly) {
            intentReceived.putExtra("com.android.internal.app.ResolverActivity.EXTRA_RESTRICT_TO_SINGLE_USER", true);
        }
        TargetInfo.refreshIntentCreatorToken(intentReceived);
        this.startActivityAsCaller(intentReceived, null, false, userId);
        this.finish();
    }

    private int findSelectedProfile(String className) {
        if (className.equals(FORWARD_INTENT_TO_PARENT)) {
            return 0;
        }
        if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            return 1;
        }
        return -1;
    }

    private boolean shouldShowDisclosure(@Nullable ResolveInfo ri, Intent intent) {
        if (!this.isDeviceProvisioned()) {
            return false;
        }
        if (ri == null || ri.activityInfo == null) {
            return true;
        }
        if (ri.activityInfo.applicationInfo.isSystemApp() && (this.isDialerIntent(intent) || this.isTextMessageIntent(intent))) {
            return false;
        }
        return !this.isTargetResolverOrChooserActivity(ri.activityInfo);
    }

    private boolean isDeviceProvisioned() {
        return Settings.Global.getInt(this.getContentResolver(), "device_provisioned", 0) != 0;
    }

    private boolean isTextMessageIntent(Intent intent) {
        return ("android.intent.action.SENDTO".equals(intent.getAction()) || this.isViewActionIntent(intent)) && ALLOWED_TEXT_MESSAGE_SCHEMES.contains(intent.getScheme());
    }

    private boolean isDialerIntent(Intent intent) {
        return "android.intent.action.DIAL".equals(intent.getAction()) || "android.intent.action.CALL".equals(intent.getAction()) || "android.intent.action.CALL_PRIVILEGED".equals(intent.getAction()) || "android.intent.action.CALL_EMERGENCY".equals(intent.getAction()) || this.isViewActionIntent(intent) && TEL_SCHEME.equals(intent.getScheme());
    }

    private boolean isViewActionIntent(Intent intent) {
        return "android.intent.action.VIEW".equals(intent.getAction()) && intent.hasCategory("android.intent.category.BROWSABLE");
    }

    private boolean isTargetResolverOrChooserActivity(ActivityInfo activityInfo) {
        if (!"android".equals(activityInfo.packageName)) {
            return false;
        }
        return ResolverActivity.class.getName().equals(activityInfo.name) || ChooserActivity.class.getName().equals(activityInfo.name);
    }

    static Intent canForward(Intent incomingIntent, int sourceUserId, int targetUserId, IPackageManager packageManager, ContentResolver contentResolver) {
        Intent forwardIntent = new Intent(incomingIntent);
        forwardIntent.addFlags(0x3000000);
        IntentForwarderActivity.sanitizeIntent(forwardIntent);
        if (!IntentForwarderActivity.canForwardInner(forwardIntent, sourceUserId, targetUserId, packageManager, contentResolver)) {
            return null;
        }
        if (forwardIntent.getSelector() != null) {
            IntentForwarderActivity.sanitizeIntent(forwardIntent.getSelector());
            if (!IntentForwarderActivity.canForwardInner(forwardIntent.getSelector(), sourceUserId, targetUserId, packageManager, contentResolver)) {
                return null;
            }
        }
        return forwardIntent;
    }

    private static boolean canForwardInner(Intent intent, int sourceUserId, int targetUserId, IPackageManager packageManager, ContentResolver contentResolver) {
        if ("android.intent.action.CHOOSER".equals(intent.getAction())) {
            return false;
        }
        String resolvedType = intent.resolveTypeIfNeeded(contentResolver);
        try {
            if (packageManager.canForwardTo(intent, resolvedType, sourceUserId, targetUserId)) {
                return true;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "PackageManagerService is dead?");
        }
        return false;
    }

    @Nullable
    private UserInfo getManagedProfile() {
        List<UserInfo> relatedUsers = this.mInjector.getUserManager().getProfiles(UserHandle.myUserId());
        for (UserInfo userInfo : relatedUsers) {
            if (!userInfo.isManagedProfile()) continue;
            return userInfo;
        }
        Slog.wtf(TAG, FORWARD_INTENT_TO_MANAGED_PROFILE + " has been called, but there is no managed profile");
        return null;
    }

    @Nullable
    private UserInfo getPrivateProfile() {
        List<UserInfo> relatedUsers = this.mInjector.getUserManager().getProfiles(UserHandle.myUserId());
        for (UserInfo userInfo : relatedUsers) {
            if (!userInfo.isPrivateProfile()) continue;
            return userInfo;
        }
        return null;
    }

    private int getProfileParent() {
        UserInfo parent = this.mInjector.getUserManager().getProfileParent(UserHandle.myUserId());
        if (parent == null) {
            Slog.wtf(TAG, FORWARD_INTENT_TO_PARENT + " has been called, but there is no parent");
            return -10000;
        }
        return parent.id;
    }

    private static void sanitizeIntent(Intent intent) {
        intent.setPackage(null);
        intent.setComponent(null);
    }

    protected MetricsLogger getMetricsLogger() {
        if (this.mMetricsLogger == null) {
            this.mMetricsLogger = new MetricsLogger();
        }
        return this.mMetricsLogger;
    }

    private boolean isPrivateProfile(int userId) {
        UserInfo privateProfile = this.getPrivateProfile();
        return this.privateSpaceFlagsEnabled() && privateProfile != null && privateProfile.id == userId;
    }

    private boolean privateSpaceFlagsEnabled() {
        return Flags.allowPrivateProfile() && android.multiuser.Flags.enablePrivateSpaceFeatures() && android.multiuser.Flags.enablePrivateSpaceIntentRedirection();
    }

    private void setMiniresolverPadding() {
        Object buttonContainer = this.findViewById(16908891);
        if (buttonContainer != null) {
            Insets systemWindowInsets = this.getWindowManager().getCurrentWindowMetrics().getWindowInsets().getInsets(WindowInsets.Type.systemBars());
            ((View)buttonContainer).setPadding(0, 0, 0, systemWindowInsets.bottom + this.getResources().getDimensionPixelOffset(17105701));
        }
    }

    @VisibleForTesting
    protected Injector createInjector() {
        return new InjectorImpl();
    }

    public static interface Injector {
        public IPackageManager getIPackageManager();

        public UserManager getUserManager();

        public PackageManager getPackageManager();

        public CompletableFuture<ResolveInfo> resolveActivityAsUser(Intent var1, int var2, int var3);

        public void showToast(String var1, int var2);
    }

    private class InjectorImpl
    implements Injector {
        private InjectorImpl() {
        }

        @Override
        public IPackageManager getIPackageManager() {
            return AppGlobals.getPackageManager();
        }

        @Override
        public UserManager getUserManager() {
            return IntentForwarderActivity.this.getSystemService(UserManager.class);
        }

        @Override
        public PackageManager getPackageManager() {
            return IntentForwarderActivity.this.getPackageManager();
        }

        @Override
        @Nullable
        public CompletableFuture<ResolveInfo> resolveActivityAsUser(Intent intent, int flags, int userId) {
            return CompletableFuture.supplyAsync(() -> this.getPackageManager().resolveActivityAsUser(intent, flags, userId));
        }

        @Override
        public void showToast(String message, int duration) {
            Toast.makeText((Context)IntentForwarderActivity.this, message, duration).show();
        }
    }
}

