/*
 * Decompiled with CFR 0.152.
 */
package com.android.healthfitness.flags;

import com.android.healthfitness.flags.Flags;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BooleanSupplier;

public class AconfigFlagHelper {
    private static final String TAG = "HC" + AconfigFlagHelper.class.getSimpleName();
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static final TreeMap<Integer, BooleanSupplier> DB_VERSION_TO_DB_FLAG_MAP = new TreeMap();

    public static synchronized int getDbVersion() {
        if (!Flags.infraToGuardDbChanges()) {
            return 14;
        }
        int dbVersion = 14;
        for (Map.Entry<Integer, BooleanSupplier> entry : AconfigFlagHelper.getDbVersionToDbFlagMap().entrySet()) {
            if (!entry.getValue().getAsBoolean()) break;
            dbVersion = entry.getKey();
        }
        return dbVersion;
    }

    private static synchronized boolean isDbFlagEnabled(int dbVersion) {
        return AconfigFlagHelper.getDbVersion() >= dbVersion;
    }

    private AconfigFlagHelper() {
    }

    private static Map<Integer, BooleanSupplier> getDbVersionToDbFlagMap() {
        if (!DB_VERSION_TO_DB_FLAG_MAP.isEmpty()) {
            return DB_VERSION_TO_DB_FLAG_MAP;
        }
        DB_VERSION_TO_DB_FLAG_MAP.put(15, Flags::personalHealthRecordDatabase);
        DB_VERSION_TO_DB_FLAG_MAP.put(16, Flags::activityIntensityDb);
        DB_VERSION_TO_DB_FLAG_MAP.put(17, Flags::ecosystemMetricsDbChanges);
        DB_VERSION_TO_DB_FLAG_MAP.put(18, Flags::cloudBackupAndRestoreDb);
        return DB_VERSION_TO_DB_FLAG_MAP;
    }

    public static synchronized boolean isPersonalHealthRecordEnabled() {
        return Flags.personalHealthRecord() && AconfigFlagHelper.isDbFlagEnabled(15);
    }

    public static boolean isActivityIntensityEnabled() {
        return Flags.activityIntensity() && AconfigFlagHelper.isDbFlagEnabled(16) && Flags.healthConnectMappings();
    }

    public static boolean isEcosystemMetricsEnabled() {
        return Flags.ecosystemMetrics() && AconfigFlagHelper.isDbFlagEnabled(17);
    }

    public static boolean isCloudBackupRestoreEnabled() {
        return Flags.cloudBackupAndRestore() && AconfigFlagHelper.isDbFlagEnabled(18);
    }
}

