/*
 * Decompiled with CFR 0.152.
 */
package com.android.bluetooth.jarjar.android.sysprop;

import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;

public class BluetoothProperties {
    private BluetoothProperties() {
    }

    private static Boolean tryParseBoolean(String str) {
        if (str == null) {
            return null;
        }
        switch (str.toLowerCase(Locale.US)) {
            case "1": 
            case "true": {
                return Boolean.TRUE;
            }
            case "0": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static Integer tryParseInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer tryParseUInt(String str) {
        try {
            return Integer.parseUnsignedInt(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseULong(String str) {
        try {
            return Long.parseUnsignedLong(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double tryParseDouble(String str) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String tryParseString(String str) {
        return "".equals(str) ? null : str;
    }

    private static <T extends Enum<T>> T tryParseEnum(Class<T> enumType, String str) {
        try {
            return Enum.valueOf(enumType, str.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> List<T> tryParseList(Function<String, T> elementParser, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        int p = 0;
        while (true) {
            StringBuilder sb = new StringBuilder();
            while (p < str.length() && str.charAt(p) != ',') {
                if (str.charAt(p) == '\\') {
                    ++p;
                }
                if (p == str.length()) break;
                sb.append(str.charAt(p++));
            }
            ret.add(elementParser.apply(sb.toString()));
            if (p == str.length()) break;
            ++p;
        }
        return ret;
    }

    private static <T extends Enum<T>> List<T> tryParseEnumList(Class<T> enumType, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(BluetoothProperties.tryParseEnum(enumType, element));
        }
        return ret;
    }

    private static String escape(String str) {
        return str.replaceAll("([\\\\,])", "\\\\$1");
    }

    private static <T> String formatList(List<T> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (T element : list) {
            joiner.add(element == null ? "" : BluetoothProperties.escape(element.toString()));
        }
        return ((Object)joiner).toString();
    }

    private static String formatUIntList(List<Integer> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Integer element : list) {
            joiner.add(element == null ? "" : BluetoothProperties.escape(Integer.toUnsignedString(element)));
        }
        return ((Object)joiner).toString();
    }

    private static String formatULongList(List<Long> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (Long element : list) {
            joiner.add(element == null ? "" : BluetoothProperties.escape(Long.toUnsignedString(element)));
        }
        return ((Object)joiner).toString();
    }

    private static <T extends Enum<T>> String formatEnumList(List<T> list, Function<T, String> elementFormatter) {
        StringJoiner joiner = new StringJoiner(",");
        for (Enum element : list) {
            joiner.add(element == null ? "" : (CharSequence)elementFormatter.apply(element));
        }
        return ((Object)joiner).toString();
    }

    public static Optional<snoop_default_mode_values> snoop_default_mode() {
        String value = SystemProperties.get("persist.bluetooth.btsnoopdefaultmode");
        return Optional.ofNullable(BluetoothProperties.tryParseEnum(snoop_default_mode_values.class, value));
    }

    public static void snoop_default_mode(snoop_default_mode_values value) {
        SystemProperties.set("persist.bluetooth.btsnoopdefaultmode", value == null ? "" : value.getPropValue());
    }

    public static Optional<snoop_log_mode_values> snoop_log_mode() {
        String value = SystemProperties.get("persist.bluetooth.btsnooplogmode");
        return Optional.ofNullable(BluetoothProperties.tryParseEnum(snoop_log_mode_values.class, value));
    }

    public static void snoop_log_mode(snoop_log_mode_values value) {
        SystemProperties.set("persist.bluetooth.btsnooplogmode", value == null ? "" : value.getPropValue());
    }

    public static Optional<Boolean> snoop_log_filter_snoop_headers_enabled() {
        String value = SystemProperties.get("persist.bluetooth.snooplogfilter.headers.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static void snoop_log_filter_snoop_headers_enabled(Boolean value) {
        SystemProperties.set("persist.bluetooth.snooplogfilter.headers.enabled", value == null ? "" : ((Object)value).toString());
    }

    public static Optional<Boolean> snoop_log_filter_profile_a2dp_enabled() {
        String value = SystemProperties.get("persist.bluetooth.snooplogfilter.profiles.a2dp.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static void snoop_log_filter_profile_a2dp_enabled(Boolean value) {
        SystemProperties.set("persist.bluetooth.snooplogfilter.profiles.a2dp.enabled", value == null ? "" : ((Object)value).toString());
    }

    public static Optional<snoop_log_filter_profile_map_values> snoop_log_filter_profile_map() {
        String value = SystemProperties.get("persist.bluetooth.snooplogfilter.profiles.map");
        return Optional.ofNullable(BluetoothProperties.tryParseEnum(snoop_log_filter_profile_map_values.class, value));
    }

    public static void snoop_log_filter_profile_map(snoop_log_filter_profile_map_values value) {
        SystemProperties.set("persist.bluetooth.snooplogfilter.profiles.map", value == null ? "" : value.getPropValue());
    }

    public static Optional<snoop_log_filter_profile_pbap_values> snoop_log_filter_profile_pbap() {
        String value = SystemProperties.get("persist.bluetooth.snooplogfilter.profiles.pbap");
        return Optional.ofNullable(BluetoothProperties.tryParseEnum(snoop_log_filter_profile_pbap_values.class, value));
    }

    public static void snoop_log_filter_profile_pbap(snoop_log_filter_profile_pbap_values value) {
        SystemProperties.set("persist.bluetooth.snooplogfilter.profiles.pbap", value == null ? "" : value.getPropValue());
    }

    public static Optional<Boolean> snoop_log_filter_profile_rfcomm_enabled() {
        String value = SystemProperties.get("persist.bluetooth.snooplogfilter.profiles.rfcomm.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static void snoop_log_filter_profile_rfcomm_enabled(Boolean value) {
        SystemProperties.set("persist.bluetooth.snooplogfilter.profiles.rfcomm.enabled", value == null ? "" : ((Object)value).toString());
    }

    public static Optional<Boolean> factory_reset() {
        String value = SystemProperties.get("persist.bluetooth.factoryreset");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static void factory_reset(Boolean value) {
        SystemProperties.set("persist.bluetooth.factoryreset", value == null ? "" : ((Object)value).toString());
    }

    public static List<String> le_audio_allow_list() {
        String value = SystemProperties.get("persist.bluetooth.leaudio.allow_list");
        return BluetoothProperties.tryParseList(v -> BluetoothProperties.tryParseString(v), value);
    }

    public static void le_audio_allow_list(List<String> value) {
        SystemProperties.set("persist.bluetooth.leaudio.allow_list", value == null ? "" : BluetoothProperties.formatList(value));
    }

    public static Optional<Boolean> isGapLePrivacyEnabled() {
        String value = SystemProperties.get("bluetooth.core.gap.le.privacy.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Integer> getGapLeConnMinLimit() {
        String value = SystemProperties.get("bluetooth.core.gap.le.conn.min.limit");
        return Optional.ofNullable(BluetoothProperties.tryParseInteger(value));
    }

    public static Optional<Boolean> isLeAudioInbandRingtoneSupported() {
        String value = SystemProperties.get("bluetooth.core.le_audio.inband_ringtone.supported");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isLeAudioCodecExtensionAidlEnabled() {
        String value = SystemProperties.get("bluetooth.core.le_audio.codec_extension_aidl.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<String> getDefaultDeviceName() {
        String value = SystemProperties.get("bluetooth.device.default_name");
        return Optional.ofNullable(BluetoothProperties.tryParseString(value));
    }

    public static List<Integer> getClassOfDevice() {
        String value = SystemProperties.get("bluetooth.device.class_of_device");
        return BluetoothProperties.tryParseList(v -> BluetoothProperties.tryParseUInt(v), value);
    }

    public static Optional<Integer> getDefaultOutputOnlyAudioProfile() {
        String value = SystemProperties.get("bluetooth.device.default_output_only_audio_profile");
        return Optional.ofNullable(BluetoothProperties.tryParseInteger(value));
    }

    public static Optional<Integer> getDefaultDuplexAudioProfile() {
        String value = SystemProperties.get("bluetooth.device.default_duplex_audio_profile");
        return Optional.ofNullable(BluetoothProperties.tryParseInteger(value));
    }

    public static Optional<Integer> getHardwareOperatingVoltageMv() {
        String value = SystemProperties.get("bluetooth.hardware.power.operating_voltage_mv");
        return Optional.ofNullable(BluetoothProperties.tryParseInteger(value));
    }

    public static Optional<Integer> getHardwareIdleCurrentMa() {
        String value = SystemProperties.get("bluetooth.hardware.power.idle_cur_ma");
        return Optional.ofNullable(BluetoothProperties.tryParseInteger(value));
    }

    public static Optional<Integer> getHardwareTxCurrentMa() {
        String value = SystemProperties.get("bluetooth.hardware.power.tx_cur_ma");
        return Optional.ofNullable(BluetoothProperties.tryParseInteger(value));
    }

    public static Optional<Integer> getHardwareRxCurrentMa() {
        String value = SystemProperties.get("bluetooth.hardware.power.rx_cur_ma");
        return Optional.ofNullable(BluetoothProperties.tryParseInteger(value));
    }

    public static Optional<Boolean> isSupportPersistedStateEnabled() {
        String value = SystemProperties.get("bluetooth.framework.support_persisted_state");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isAdapterAddressValidationEnabled() {
        String value = SystemProperties.get("bluetooth.framework.adapter_address_validation");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileA2dpSinkEnabled() {
        String value = SystemProperties.get("bluetooth.profile.a2dp.sink.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileA2dpSourceEnabled() {
        String value = SystemProperties.get("bluetooth.profile.a2dp.source.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileAshaCentralEnabled() {
        String value = SystemProperties.get("bluetooth.profile.asha.central.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileAvrcpControllerEnabled() {
        String value = SystemProperties.get("bluetooth.profile.avrcp.controller.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileAvrcpTargetEnabled() {
        String value = SystemProperties.get("bluetooth.profile.avrcp.target.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileBapBroadcastAssistEnabled() {
        String value = SystemProperties.get("bluetooth.profile.bap.broadcast.assist.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileBapBroadcastSourceEnabled() {
        String value = SystemProperties.get("bluetooth.profile.bap.broadcast.source.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileBapUnicastClientEnabled() {
        String value = SystemProperties.get("bluetooth.profile.bap.unicast.client.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileBasClientEnabled() {
        String value = SystemProperties.get("bluetooth.profile.bas.client.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileBassClientEnabled() {
        String value = SystemProperties.get("bluetooth.profile.bass.client.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileCsipSetCoordinatorEnabled() {
        String value = SystemProperties.get("bluetooth.profile.csip.set_coordinator.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileGattEnabled() {
        String value = SystemProperties.get("bluetooth.profile.gatt.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileGmapEnabled() {
        String value = SystemProperties.get("bluetooth.profile.gmap.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileHapClientEnabled() {
        String value = SystemProperties.get("bluetooth.profile.hap.client.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileHfpAgEnabled() {
        String value = SystemProperties.get("bluetooth.profile.hfp.ag.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileHfpHfEnabled() {
        String value = SystemProperties.get("bluetooth.profile.hfp.hf.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isHfpSoftwareDatapathEnabled() {
        String value = SystemProperties.get("bluetooth.hfp.software_datapath.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileHidDeviceEnabled() {
        String value = SystemProperties.get("bluetooth.profile.hid.device.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileHidHostEnabled() {
        String value = SystemProperties.get("bluetooth.profile.hid.host.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileMapClientEnabled() {
        String value = SystemProperties.get("bluetooth.profile.map.client.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileMapServerEnabled() {
        String value = SystemProperties.get("bluetooth.profile.map.server.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileMcpServerEnabled() {
        String value = SystemProperties.get("bluetooth.profile.mcp.server.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileOppEnabled() {
        String value = SystemProperties.get("bluetooth.profile.opp.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfilePanNapEnabled() {
        String value = SystemProperties.get("bluetooth.profile.pan.nap.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfilePanPanuEnabled() {
        String value = SystemProperties.get("bluetooth.profile.pan.panu.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfilePbapClientEnabled() {
        String value = SystemProperties.get("bluetooth.profile.pbap.client.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfilePbapServerEnabled() {
        String value = SystemProperties.get("bluetooth.profile.pbap.server.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfilePbapSimEnabled() {
        String value = SystemProperties.get("bluetooth.profile.pbap.sim.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileSapServerEnabled() {
        String value = SystemProperties.get("bluetooth.profile.sap.server.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileCcpServerEnabled() {
        String value = SystemProperties.get("bluetooth.profile.ccp.server.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> isProfileVcpControllerEnabled() {
        String value = SystemProperties.get("bluetooth.profile.vcp.controller.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Integer> getLeMaxNumberOfConcurrentConnections() {
        String value = SystemProperties.get("bluetooth.core.le.max_number_of_concurrent_connections");
        return Optional.ofNullable(BluetoothProperties.tryParseUInt(value));
    }

    public static List<String> dsa_transport_preference() {
        String value = SystemProperties.get("bluetooth.core.le.dsa_transport_preference");
        return BluetoothProperties.tryParseList(v -> BluetoothProperties.tryParseString(v), value);
    }

    public static Optional<Boolean> isScoManagedByAudioEnabled() {
        String value = SystemProperties.get("bluetooth.sco.managed_by_audio");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static Optional<Boolean> enable_sniff_offload() {
        String value = SystemProperties.get("persist.bluetooth.sniff_offload.enabled");
        return Optional.ofNullable(BluetoothProperties.tryParseBoolean(value));
    }

    public static enum snoop_default_mode_values {
        EMPTY("empty"),
        DISABLED("disabled"),
        FILTERED("filtered"),
        FULL("full");

        private final String propValue;

        private snoop_default_mode_values(String propValue) {
            this.propValue = propValue;
        }

        public String getPropValue() {
            return this.propValue;
        }
    }

    public static enum snoop_log_mode_values {
        EMPTY("empty"),
        DISABLED("disabled"),
        FILTERED("filtered"),
        FULL("full");

        private final String propValue;

        private snoop_log_mode_values(String propValue) {
            this.propValue = propValue;
        }

        public String getPropValue() {
            return this.propValue;
        }
    }

    public static enum snoop_log_filter_profile_map_values {
        EMPTY("empty"),
        DISABLED("disabled"),
        FULLFILTER("fullfilter"),
        HEADER("header"),
        MAGIC("magic");

        private final String propValue;

        private snoop_log_filter_profile_map_values(String propValue) {
            this.propValue = propValue;
        }

        public String getPropValue() {
            return this.propValue;
        }
    }

    public static enum snoop_log_filter_profile_pbap_values {
        EMPTY("empty"),
        DISABLED("disabled"),
        FULLFILTER("fullfilter"),
        HEADER("header"),
        MAGIC("magic");

        private final String propValue;

        private snoop_log_filter_profile_pbap_values(String propValue) {
            this.propValue = propValue;
        }

        public String getPropValue() {
            return this.propValue;
        }
    }
}

