/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.app.LoadedApk;
import android.app.Service;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacksController;
import android.content.Context;
import android.content.res.Configuration;
import android.hardware.display.DisplayManager;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.window.ConfigurationDispatcher;
import android.window.WindowContextController;
import android.window.WindowProvider;
import android.window.WindowTokenClient;

public abstract class WindowProviderService
extends Service
implements WindowProvider,
ConfigurationDispatcher {
    private static final String TAG = WindowProviderService.class.getSimpleName();
    private final Bundle mOptions;
    private final WindowTokenClient mWindowToken = new WindowTokenClient();
    private final WindowContextController mController = new WindowContextController(this.mWindowToken);
    private WindowManager mWindowManager;
    private boolean mInitialized;
    private final ComponentCallbacksController mCallbacksController = new ComponentCallbacksController();

    public static boolean isWindowProviderService(@Nullable Bundle windowContextOptions) {
        if (windowContextOptions == null) {
            return false;
        }
        return windowContextOptions.getBoolean("android.windowContext.isWindowProviderService", false);
    }

    public WindowProviderService() {
        this.mOptions = new Bundle();
        this.mOptions.putBoolean("android.windowContext.isWindowProviderService", true);
    }

    @Override
    @SuppressLint(value={"OnNameExpected"})
    public abstract int getWindowType();

    @Override
    @SuppressLint(value={"OnNameExpected", "NullableCollection"})
    @Nullable
    public Bundle getWindowContextOptions() {
        return this.mOptions;
    }

    @Override
    @SuppressLint(value={"OnNameExpected", "ExecutorRegistration"})
    public void registerComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.registerCallbacks(callback);
    }

    @Override
    @SuppressLint(value={"OnNameExpected"})
    public void unregisterComponentCallbacks(@NonNull ComponentCallbacks callback) {
        this.mCallbacksController.unregisterCallbacks(callback);
    }

    @Override
    @SuppressLint(value={"OnNameExpected"})
    public void onConfigurationChanged(@NonNull Configuration configuration) {
        this.mCallbacksController.dispatchConfigurationChanged(configuration);
    }

    @Override
    public void onLowMemory() {
        this.mCallbacksController.dispatchLowMemory();
    }

    @Override
    public void onTrimMemory(int level) {
        this.mCallbacksController.dispatchTrimMemory(level);
    }

    @SuppressLint(value={"OnNameExpected"})
    @NonNull
    public int getInitialDisplayId() {
        return 0;
    }

    public void attachToWindowToken(@NonNull IBinder windowToken) {
        this.mController.attachToWindowToken(windowToken);
    }

    @Override
    public Context createServiceBaseContext(ActivityThread mainThread, LoadedApk packageInfo) {
        int initialDisplayId;
        Context context = super.createServiceBaseContext(mainThread, packageInfo);
        DisplayManager displayManager = context.getSystemService(DisplayManager.class);
        Display display = displayManager.getDisplay(initialDisplayId = this.getInitialDisplayId());
        if (display == null) {
            Log.e(TAG, "Display with id " + initialDisplayId + " not found, falling back to DEFAULT_DISPLAY");
            display = displayManager.getDisplay(0);
        }
        return context.createTokenContext(this.mWindowToken, display);
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(newBase);
        if (!this.mInitialized) {
            this.mWindowToken.attachContext(this);
            this.mController.attachToDisplayArea(this.getWindowType(), this.getDisplayId(), this.getWindowContextOptions());
            this.mWindowManager = WindowManagerImpl.createWindowContextWindowManager((Context)this);
            this.mInitialized = true;
        }
    }

    @Override
    @SuppressLint(value={"OnNameExpected"})
    @Nullable
    public Object getSystemService(@NonNull String name) {
        if ("window".equals(name)) {
            return this.mWindowManager;
        }
        return super.getSystemService(name);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mController.detachIfNeeded();
        this.mCallbacksController.clearCallbacks();
    }

    @Override
    public void dispatchConfigurationChanged(@NonNull Configuration configuration) {
        this.onConfigurationChanged(configuration);
    }
}

