/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.WindowManager;
import android.window.RemoteTransition;
import android.window.WindowContainerToken;
import com.android.internal.util.AnnotationValidations;

public class TransitionRequestInfo
implements Parcelable {
    private final int mType;
    @Nullable
    private ActivityManager.RunningTaskInfo mTriggerTask;
    @Nullable
    private PipChange mPipChange;
    @Nullable
    private RemoteTransition mRemoteTransition;
    @Nullable
    private DisplayChange mDisplayChange;
    private final int mFlags;
    private final int mDebugId;
    @NonNull
    public static final Parcelable.Creator<TransitionRequestInfo> CREATOR = new Parcelable.Creator<TransitionRequestInfo>(){

        public TransitionRequestInfo[] newArray(int size) {
            return new TransitionRequestInfo[size];
        }

        @Override
        public TransitionRequestInfo createFromParcel(@NonNull Parcel in) {
            return new TransitionRequestInfo(in);
        }
    };

    public TransitionRequestInfo(int type, @Nullable ActivityManager.RunningTaskInfo triggerTask, @Nullable RemoteTransition remoteTransition) {
        this(type, triggerTask, null, remoteTransition, null, 0, -1);
    }

    public TransitionRequestInfo(int type, @Nullable ActivityManager.RunningTaskInfo triggerTask, @Nullable RemoteTransition remoteTransition, int flags) {
        this(type, triggerTask, null, remoteTransition, null, flags, -1);
    }

    public TransitionRequestInfo(int type, @Nullable ActivityManager.RunningTaskInfo triggerTask, @Nullable RemoteTransition remoteTransition, @Nullable DisplayChange displayChange, int flags) {
        this(type, triggerTask, null, remoteTransition, displayChange, flags, -1);
    }

    public TransitionRequestInfo(int type, @Nullable ActivityManager.RunningTaskInfo triggerTask, @Nullable ActivityManager.RunningTaskInfo pipTask, @Nullable RemoteTransition remoteTransition, @Nullable DisplayChange displayChange, int flags) {
        this(type, triggerTask, pipTask != null ? new PipChange(pipTask) : null, remoteTransition, displayChange, flags, -1);
    }

    String typeToString() {
        return WindowManager.transitTypeToString(this.mType);
    }

    public TransitionRequestInfo(int type, @Nullable ActivityManager.RunningTaskInfo triggerTask, @Nullable PipChange pipChange, @Nullable RemoteTransition remoteTransition, @Nullable DisplayChange displayChange, int flags, int debugId) {
        this.mType = type;
        AnnotationValidations.validate(WindowManager.TransitionType.class, null, this.mType);
        this.mTriggerTask = triggerTask;
        this.mPipChange = pipChange;
        this.mRemoteTransition = remoteTransition;
        this.mDisplayChange = displayChange;
        this.mFlags = flags;
        this.mDebugId = debugId;
    }

    public int getType() {
        return this.mType;
    }

    @Nullable
    public ActivityManager.RunningTaskInfo getTriggerTask() {
        return this.mTriggerTask;
    }

    @Nullable
    public PipChange getPipChange() {
        return this.mPipChange;
    }

    @Nullable
    public RemoteTransition getRemoteTransition() {
        return this.mRemoteTransition;
    }

    @Nullable
    public DisplayChange getDisplayChange() {
        return this.mDisplayChange;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public int getDebugId() {
        return this.mDebugId;
    }

    @NonNull
    public TransitionRequestInfo setTriggerTask(@NonNull ActivityManager.RunningTaskInfo value) {
        this.mTriggerTask = value;
        return this;
    }

    @NonNull
    public TransitionRequestInfo setPipChange(@NonNull PipChange value) {
        this.mPipChange = value;
        return this;
    }

    @NonNull
    public TransitionRequestInfo setRemoteTransition(@NonNull RemoteTransition value) {
        this.mRemoteTransition = value;
        return this;
    }

    @NonNull
    public TransitionRequestInfo setDisplayChange(@NonNull DisplayChange value) {
        this.mDisplayChange = value;
        return this;
    }

    public String toString() {
        return "TransitionRequestInfo { type = " + this.typeToString() + ", triggerTask = " + this.mTriggerTask + ", pipChange = " + this.mPipChange + ", remoteTransition = " + this.mRemoteTransition + ", displayChange = " + this.mDisplayChange + ", flags = " + this.mFlags + ", debugId = " + this.mDebugId + " }";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mTriggerTask != null) {
            flg = (byte)(flg | 2);
        }
        if (this.mPipChange != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mRemoteTransition != null) {
            flg = (byte)(flg | 8);
        }
        if (this.mDisplayChange != null) {
            flg = (byte)(flg | 0x10);
        }
        dest.writeByte(flg);
        dest.writeInt(this.mType);
        if (this.mTriggerTask != null) {
            dest.writeTypedObject(this.mTriggerTask, flags);
        }
        if (this.mPipChange != null) {
            dest.writeTypedObject(this.mPipChange, flags);
        }
        if (this.mRemoteTransition != null) {
            dest.writeTypedObject(this.mRemoteTransition, flags);
        }
        if (this.mDisplayChange != null) {
            dest.writeTypedObject(this.mDisplayChange, flags);
        }
        dest.writeInt(this.mFlags);
        dest.writeInt(this.mDebugId);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    TransitionRequestInfo(@NonNull Parcel in) {
        byte flg = in.readByte();
        int type = in.readInt();
        ActivityManager.RunningTaskInfo triggerTask = (flg & 2) == 0 ? null : in.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
        PipChange pipChange = (flg & 4) == 0 ? null : in.readTypedObject(PipChange.CREATOR);
        RemoteTransition remoteTransition = (flg & 8) == 0 ? null : in.readTypedObject(RemoteTransition.CREATOR);
        DisplayChange displayChange = (flg & 0x10) == 0 ? null : in.readTypedObject(DisplayChange.CREATOR);
        int flags = in.readInt();
        int debugId = in.readInt();
        this.mType = type;
        AnnotationValidations.validate(WindowManager.TransitionType.class, null, this.mType);
        this.mTriggerTask = triggerTask;
        this.mPipChange = pipChange;
        this.mRemoteTransition = remoteTransition;
        this.mDisplayChange = displayChange;
        this.mFlags = flags;
        this.mDebugId = debugId;
    }

    @Deprecated
    private void __metadata() {
    }

    public static class PipChange
    implements Parcelable {
        @NonNull
        private WindowContainerToken mTaskFragmentToken;
        @NonNull
        private ActivityManager.RunningTaskInfo mTaskInfo;
        @NonNull
        public static final Parcelable.Creator<PipChange> CREATOR = new Parcelable.Creator<PipChange>(){

            public PipChange[] newArray(int size) {
                return new PipChange[size];
            }

            @Override
            public PipChange createFromParcel(@NonNull Parcel in) {
                return new PipChange(in);
            }
        };

        public PipChange(ActivityManager.RunningTaskInfo taskInfo) {
            this.mTaskFragmentToken = taskInfo.token;
            this.mTaskInfo = taskInfo;
        }

        public PipChange(WindowContainerToken taskFragmentToken, ActivityManager.RunningTaskInfo taskInfo) {
            this.mTaskFragmentToken = taskFragmentToken;
            this.mTaskInfo = taskInfo;
        }

        @NonNull
        public WindowContainerToken getTaskFragmentToken() {
            return this.mTaskFragmentToken;
        }

        @NonNull
        public ActivityManager.RunningTaskInfo getTaskInfo() {
            return this.mTaskInfo;
        }

        @NonNull
        public PipChange setTaskFragmentToken(@NonNull WindowContainerToken value) {
            this.mTaskFragmentToken = value;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mTaskFragmentToken);
            return this;
        }

        @NonNull
        public PipChange setTaskInfo(@NonNull ActivityManager.RunningTaskInfo value) {
            this.mTaskInfo = value;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mTaskInfo);
            return this;
        }

        public String toString() {
            return "PipChange { taskFragmentToken = " + this.mTaskFragmentToken + ", taskInfo = " + this.mTaskInfo + " }";
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeTypedObject(this.mTaskFragmentToken, flags);
            dest.writeTypedObject(this.mTaskInfo, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        PipChange(@NonNull Parcel in) {
            WindowContainerToken taskFragmentToken = in.readTypedObject(WindowContainerToken.CREATOR);
            ActivityManager.RunningTaskInfo taskInfo = in.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
            this.mTaskFragmentToken = taskFragmentToken;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mTaskFragmentToken);
            this.mTaskInfo = taskInfo;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mTaskInfo);
        }

        @Deprecated
        private void __metadata() {
        }
    }

    public static class DisplayChange
    implements Parcelable {
        private final int mDisplayId;
        @Nullable
        private Rect mStartAbsBounds = null;
        @Nullable
        private Rect mEndAbsBounds = null;
        private int mStartRotation = -1;
        private int mEndRotation = -1;
        private boolean mPhysicalDisplayChanged = false;
        @NonNull
        public static final Parcelable.Creator<DisplayChange> CREATOR = new Parcelable.Creator<DisplayChange>(){

            public DisplayChange[] newArray(int size) {
                return new DisplayChange[size];
            }

            @Override
            public DisplayChange createFromParcel(@NonNull Parcel in) {
                return new DisplayChange(in);
            }
        };

        public DisplayChange(int displayId) {
            this.mDisplayId = displayId;
        }

        public DisplayChange(int displayId, int startRotation, int endRotation) {
            this.mDisplayId = displayId;
            this.mStartRotation = startRotation;
            this.mEndRotation = endRotation;
        }

        public int getDisplayId() {
            return this.mDisplayId;
        }

        @Nullable
        public Rect getStartAbsBounds() {
            return this.mStartAbsBounds;
        }

        @Nullable
        public Rect getEndAbsBounds() {
            return this.mEndAbsBounds;
        }

        public int getStartRotation() {
            return this.mStartRotation;
        }

        public int getEndRotation() {
            return this.mEndRotation;
        }

        public boolean isPhysicalDisplayChanged() {
            return this.mPhysicalDisplayChanged;
        }

        @NonNull
        public DisplayChange setStartAbsBounds(@NonNull Rect value) {
            this.mStartAbsBounds = value;
            return this;
        }

        @NonNull
        public DisplayChange setEndAbsBounds(@NonNull Rect value) {
            this.mEndAbsBounds = value;
            return this;
        }

        @NonNull
        public DisplayChange setStartRotation(int value) {
            this.mStartRotation = value;
            return this;
        }

        @NonNull
        public DisplayChange setEndRotation(int value) {
            this.mEndRotation = value;
            return this;
        }

        @NonNull
        public DisplayChange setPhysicalDisplayChanged(boolean value) {
            this.mPhysicalDisplayChanged = value;
            return this;
        }

        public String toString() {
            return "DisplayChange { displayId = " + this.mDisplayId + ", startAbsBounds = " + this.mStartAbsBounds + ", endAbsBounds = " + this.mEndAbsBounds + ", startRotation = " + this.mStartRotation + ", endRotation = " + this.mEndRotation + ", physicalDisplayChanged = " + this.mPhysicalDisplayChanged + " }";
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            byte flg = 0;
            if (this.mPhysicalDisplayChanged) {
                flg = (byte)(flg | 0x20);
            }
            if (this.mStartAbsBounds != null) {
                flg = (byte)(flg | 2);
            }
            if (this.mEndAbsBounds != null) {
                flg = (byte)(flg | 4);
            }
            dest.writeByte(flg);
            dest.writeInt(this.mDisplayId);
            if (this.mStartAbsBounds != null) {
                dest.writeTypedObject(this.mStartAbsBounds, flags);
            }
            if (this.mEndAbsBounds != null) {
                dest.writeTypedObject(this.mEndAbsBounds, flags);
            }
            dest.writeInt(this.mStartRotation);
            dest.writeInt(this.mEndRotation);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        DisplayChange(@NonNull Parcel in) {
            byte flg = in.readByte();
            boolean physicalDisplayChanged = (flg & 0x20) != 0;
            int displayId = in.readInt();
            Rect startAbsBounds = (flg & 2) == 0 ? null : in.readTypedObject(Rect.CREATOR);
            Rect endAbsBounds = (flg & 4) == 0 ? null : in.readTypedObject(Rect.CREATOR);
            int startRotation = in.readInt();
            int endRotation = in.readInt();
            this.mDisplayId = displayId;
            this.mStartAbsBounds = startAbsBounds;
            this.mEndAbsBounds = endAbsBounds;
            this.mStartRotation = startRotation;
            this.mEndRotation = endRotation;
            this.mPhysicalDisplayChanged = physicalDisplayChanged;
        }

        @Deprecated
        private void __metadata() {
        }
    }
}

