/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.HardwareBuffer;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.function.Consumer;

public class TaskSnapshot
implements Parcelable {
    private final long mId;
    private final long mCaptureTime;
    private final ComponentName mTopActivityComponent;
    private final HardwareBuffer mSnapshot;
    private final int mOrientation;
    private final int mRotation;
    private final Point mTaskSize;
    private final Rect mContentInsets;
    private final Rect mLetterboxInsets;
    private final boolean mIsLowResolution;
    private final boolean mIsRealSnapshot;
    private final int mWindowingMode;
    private final int mAppearance;
    private final boolean mIsTranslucent;
    private final boolean mHasImeSurface;
    private final int mUiMode;
    private final ColorSpace mColorSpace;
    private int mInternalReferences;
    private Consumer<HardwareBuffer> mSafeSnapshotReleaser;
    public static final int REFERENCE_NONE = 0;
    public static final int REFERENCE_BROADCAST = 1;
    public static final int REFERENCE_CACHE = 2;
    public static final int REFERENCE_PERSIST = 4;
    public static final int REFERENCE_CONTENT_SUGGESTION = 8;
    public static final int REFERENCE_WRITE_TO_PARCEL = 16;
    @NonNull
    public static final Parcelable.Creator<TaskSnapshot> CREATOR = new Parcelable.Creator<TaskSnapshot>(){

        @Override
        public TaskSnapshot createFromParcel(Parcel source) {
            return new TaskSnapshot(source);
        }

        public TaskSnapshot[] newArray(int size) {
            return new TaskSnapshot[size];
        }
    };

    public TaskSnapshot(long id2, long captureTime, @NonNull ComponentName topActivityComponent, HardwareBuffer snapshot, @NonNull ColorSpace colorSpace, int orientation, int rotation, Point taskSize, Rect contentInsets, Rect letterboxInsets, boolean isLowResolution, boolean isRealSnapshot, int windowingMode, int appearance, boolean isTranslucent, boolean hasImeSurface, int uiMode) {
        this.mId = id2;
        this.mCaptureTime = captureTime;
        this.mTopActivityComponent = topActivityComponent;
        this.mSnapshot = snapshot;
        this.mColorSpace = colorSpace.getId() < 0 ? ColorSpace.get(ColorSpace.Named.SRGB) : colorSpace;
        this.mOrientation = orientation;
        this.mRotation = rotation;
        this.mTaskSize = new Point(taskSize);
        this.mContentInsets = new Rect(contentInsets);
        this.mLetterboxInsets = new Rect(letterboxInsets);
        this.mIsLowResolution = isLowResolution;
        this.mIsRealSnapshot = isRealSnapshot;
        this.mWindowingMode = windowingMode;
        this.mAppearance = appearance;
        this.mIsTranslucent = isTranslucent;
        this.mHasImeSurface = hasImeSurface;
        this.mUiMode = uiMode;
    }

    private TaskSnapshot(Parcel source) {
        this.mId = source.readLong();
        this.mCaptureTime = SystemClock.elapsedRealtimeNanos();
        this.mTopActivityComponent = ComponentName.readFromParcel(source);
        this.mSnapshot = source.readTypedObject(HardwareBuffer.CREATOR);
        int colorSpaceId = source.readInt();
        this.mColorSpace = colorSpaceId >= 0 && colorSpaceId < ColorSpace.Named.values().length ? ColorSpace.get(ColorSpace.Named.values()[colorSpaceId]) : ColorSpace.get(ColorSpace.Named.SRGB);
        this.mOrientation = source.readInt();
        this.mRotation = source.readInt();
        this.mTaskSize = source.readTypedObject(Point.CREATOR);
        this.mContentInsets = source.readTypedObject(Rect.CREATOR);
        this.mLetterboxInsets = source.readTypedObject(Rect.CREATOR);
        this.mIsLowResolution = source.readBoolean();
        this.mIsRealSnapshot = source.readBoolean();
        this.mWindowingMode = source.readInt();
        this.mAppearance = source.readInt();
        this.mIsTranslucent = source.readBoolean();
        this.mHasImeSurface = source.readBoolean();
        this.mUiMode = source.readInt();
    }

    public long getId() {
        return this.mId;
    }

    public long getCaptureTime() {
        return this.mCaptureTime;
    }

    public ComponentName getTopActivityComponent() {
        return this.mTopActivityComponent;
    }

    @UnsupportedAppUsage
    public GraphicBuffer getSnapshot() {
        return GraphicBuffer.createFromHardwareBuffer(this.mSnapshot);
    }

    public HardwareBuffer getHardwareBuffer() {
        return this.mSnapshot;
    }

    public ColorSpace getColorSpace() {
        return this.mColorSpace;
    }

    @UnsupportedAppUsage
    public int getOrientation() {
        return this.mOrientation;
    }

    public int getRotation() {
        return this.mRotation;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public Point getTaskSize() {
        return this.mTaskSize;
    }

    @UnsupportedAppUsage
    public Rect getContentInsets() {
        return this.mContentInsets;
    }

    public Rect getLetterboxInsets() {
        return this.mLetterboxInsets;
    }

    @UnsupportedAppUsage
    public boolean isLowResolution() {
        return this.mIsLowResolution;
    }

    @UnsupportedAppUsage
    public boolean isRealSnapshot() {
        return this.mIsRealSnapshot;
    }

    public boolean isTranslucent() {
        return this.mIsTranslucent;
    }

    public boolean hasImeSurface() {
        return this.mHasImeSurface;
    }

    public int getWindowingMode() {
        return this.mWindowingMode;
    }

    public int getAppearance() {
        return this.mAppearance;
    }

    public int getUiMode() {
        return this.mUiMode;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mId);
        ComponentName.writeToParcel(this.mTopActivityComponent, dest);
        dest.writeTypedObject(this.mSnapshot != null && !this.mSnapshot.isClosed() ? this.mSnapshot : null, 0);
        dest.writeInt(this.mColorSpace.getId());
        dest.writeInt(this.mOrientation);
        dest.writeInt(this.mRotation);
        dest.writeTypedObject(this.mTaskSize, 0);
        dest.writeTypedObject(this.mContentInsets, 0);
        dest.writeTypedObject(this.mLetterboxInsets, 0);
        dest.writeBoolean(this.mIsLowResolution);
        dest.writeBoolean(this.mIsRealSnapshot);
        dest.writeInt(this.mWindowingMode);
        dest.writeInt(this.mAppearance);
        dest.writeBoolean(this.mIsTranslucent);
        dest.writeBoolean(this.mHasImeSurface);
        dest.writeInt(this.mUiMode);
        TaskSnapshot taskSnapshot = this;
        synchronized (taskSnapshot) {
            if ((this.mInternalReferences & 0x10) != 0) {
                this.removeReference(16);
            }
        }
    }

    public String toString() {
        int width = this.mSnapshot != null ? this.mSnapshot.getWidth() : 0;
        int height = this.mSnapshot != null ? this.mSnapshot.getHeight() : 0;
        return "TaskSnapshot{ mId=" + this.mId + " mCaptureTime=" + this.mCaptureTime + " mTopActivityComponent=" + this.mTopActivityComponent.flattenToShortString() + " mSnapshot=" + this.mSnapshot + " (" + width + "x" + height + ") mColorSpace=" + this.mColorSpace.toString() + " mOrientation=" + this.mOrientation + " mRotation=" + this.mRotation + " mTaskSize=" + this.mTaskSize.toString() + " mContentInsets=" + this.mContentInsets.toShortString() + " mLetterboxInsets=" + this.mLetterboxInsets.toShortString() + " mIsLowResolution=" + this.mIsLowResolution + " mIsRealSnapshot=" + this.mIsRealSnapshot + " mWindowingMode=" + this.mWindowingMode + " mAppearance=" + this.mAppearance + " mIsTranslucent=" + this.mIsTranslucent + " mHasImeSurface=" + this.mHasImeSurface + " mInternalReferences=" + this.mInternalReferences + " mUiMode=" + Integer.toHexString(this.mUiMode);
    }

    public synchronized void addReference(int usage) {
        this.mInternalReferences |= usage;
    }

    public synchronized void removeReference(int usage) {
        this.mInternalReferences &= ~usage;
        if (Flags.releaseSnapshotAggressively() && this.mInternalReferences == 0 && this.mSnapshot != null && !this.mSnapshot.isClosed()) {
            if (this.mSafeSnapshotReleaser != null) {
                this.mSafeSnapshotReleaser.accept(this.mSnapshot);
            } else {
                this.mSnapshot.close();
            }
        }
    }

    public synchronized void setSafeRelease(Consumer<HardwareBuffer> releaser) {
        if (!Flags.safeReleaseSnapshotAggressively()) {
            return;
        }
        this.mSafeSnapshotReleaser = releaser;
    }

    public static class Builder {
        private long mId;
        private long mCaptureTime;
        private ComponentName mTopActivity;
        private HardwareBuffer mSnapshot;
        private ColorSpace mColorSpace;
        private int mOrientation;
        private int mRotation;
        private Point mTaskSize;
        private Rect mContentInsets;
        private Rect mLetterboxInsets;
        private boolean mIsRealSnapshot;
        private int mWindowingMode;
        private int mAppearance;
        private boolean mIsTranslucent;
        private boolean mHasImeSurface;
        private int mPixelFormat;
        private int mUiMode;

        public Builder setId(long id2) {
            this.mId = id2;
            return this;
        }

        public Builder setCaptureTime(long captureTime) {
            this.mCaptureTime = captureTime;
            return this;
        }

        public Builder setTopActivityComponent(ComponentName name) {
            this.mTopActivity = name;
            return this;
        }

        public Builder setSnapshot(HardwareBuffer buffer) {
            this.mSnapshot = buffer;
            return this;
        }

        public Builder setColorSpace(ColorSpace colorSpace) {
            this.mColorSpace = colorSpace;
            return this;
        }

        public Builder setOrientation(int orientation) {
            this.mOrientation = orientation;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.mRotation = rotation;
            return this;
        }

        public Builder setTaskSize(Point size) {
            this.mTaskSize = size;
            return this;
        }

        public Builder setContentInsets(Rect contentInsets) {
            this.mContentInsets = contentInsets;
            return this;
        }

        public Builder setLetterboxInsets(Rect letterboxInsets) {
            this.mLetterboxInsets = letterboxInsets;
            return this;
        }

        public Builder setIsRealSnapshot(boolean realSnapshot) {
            this.mIsRealSnapshot = realSnapshot;
            return this;
        }

        public Builder setWindowingMode(int windowingMode) {
            this.mWindowingMode = windowingMode;
            return this;
        }

        public Builder setAppearance(int appearance) {
            this.mAppearance = appearance;
            return this;
        }

        public Builder setIsTranslucent(boolean isTranslucent) {
            this.mIsTranslucent = isTranslucent;
            return this;
        }

        public Builder setHasImeSurface(boolean hasImeSurface) {
            this.mHasImeSurface = hasImeSurface;
            return this;
        }

        public Builder setUiMode(int uiMode) {
            this.mUiMode = uiMode;
            return this;
        }

        public int getPixelFormat() {
            return this.mPixelFormat;
        }

        public Builder setPixelFormat(int pixelFormat) {
            this.mPixelFormat = pixelFormat;
            return this;
        }

        public TaskSnapshot build() {
            return new TaskSnapshot(this.mId, this.mCaptureTime, this.mTopActivity, this.mSnapshot, this.mColorSpace, this.mOrientation, this.mRotation, this.mTaskSize, this.mContentInsets, this.mLetterboxInsets, false, this.mIsRealSnapshot, this.mWindowingMode, this.mAppearance, this.mIsTranslucent, this.mHasImeSurface, this.mUiMode);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ReferenceFlags {
    }
}

