/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.SurfaceControl;
import android.window.TaskFragmentAnimationParams;
import android.window.TaskFragmentCreationParams;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class TaskFragmentOperation
implements Parcelable {
    public static final int OP_TYPE_UNKNOWN = -1;
    public static final int OP_TYPE_CREATE_TASK_FRAGMENT = 0;
    public static final int OP_TYPE_DELETE_TASK_FRAGMENT = 1;
    public static final int OP_TYPE_START_ACTIVITY_IN_TASK_FRAGMENT = 2;
    public static final int OP_TYPE_REPARENT_ACTIVITY_TO_TASK_FRAGMENT = 3;
    public static final int OP_TYPE_SET_ADJACENT_TASK_FRAGMENTS = 4;
    public static final int OP_TYPE_CLEAR_ADJACENT_TASK_FRAGMENTS = 5;
    public static final int OP_TYPE_REQUEST_FOCUS_ON_TASK_FRAGMENT = 6;
    public static final int OP_TYPE_SET_COMPANION_TASK_FRAGMENT = 7;
    public static final int OP_TYPE_SET_ANIMATION_PARAMS = 8;
    public static final int OP_TYPE_SET_RELATIVE_BOUNDS = 9;
    public static final int OP_TYPE_REORDER_TO_FRONT = 10;
    public static final int OP_TYPE_SET_ISOLATED_NAVIGATION = 11;
    public static final int OP_TYPE_CREATE_OR_MOVE_TASK_FRAGMENT_DECOR_SURFACE = 12;
    public static final int OP_TYPE_REMOVE_TASK_FRAGMENT_DECOR_SURFACE = 13;
    public static final int OP_TYPE_SET_DIM_ON_TASK = 14;
    public static final int OP_TYPE_SET_DECOR_SURFACE_BOOSTED = 15;
    public static final int OP_TYPE_SET_PINNED = 16;
    public static final int PRIVILEGED_OP_START = 1000;
    public static final int OP_TYPE_PRIVILEGED_REORDER_TO_BOTTOM_OF_TASK = 1001;
    public static final int OP_TYPE_PRIVILEGED_REORDER_TO_TOP_OF_TASK = 1002;
    public static final int OP_TYPE_PRIVILEGED_SET_MOVE_TO_BOTTOM_IF_CLEAR_WHEN_LAUNCH = 1003;
    public static final int OP_TYPE_PRIVILEGED_SET_CAN_AFFECT_SYSTEM_UI_FLAGS = 1004;
    private final int mOpType;
    @Nullable
    private final TaskFragmentCreationParams mTaskFragmentCreationParams;
    @Nullable
    private final IBinder mActivityToken;
    @Nullable
    private final Intent mActivityIntent;
    @Nullable
    private final Bundle mBundle;
    @Nullable
    private final IBinder mSecondaryFragmentToken;
    @Nullable
    private final TaskFragmentAnimationParams mAnimationParams;
    private final boolean mBooleanValue;
    @Nullable
    private final SurfaceControl.Transaction mSurfaceTransaction;
    @NonNull
    public static final Parcelable.Creator<TaskFragmentOperation> CREATOR = new Parcelable.Creator<TaskFragmentOperation>(){

        @Override
        public TaskFragmentOperation createFromParcel(Parcel in) {
            return new TaskFragmentOperation(in);
        }

        public TaskFragmentOperation[] newArray(int size) {
            return new TaskFragmentOperation[size];
        }
    };

    private TaskFragmentOperation(int opType, @Nullable TaskFragmentCreationParams taskFragmentCreationParams, @Nullable IBinder activityToken, @Nullable Intent activityIntent, @Nullable Bundle bundle, @Nullable IBinder secondaryFragmentToken, @Nullable TaskFragmentAnimationParams animationParams, boolean booleanValue, @Nullable SurfaceControl.Transaction surfaceTransaction) {
        this.mOpType = opType;
        this.mTaskFragmentCreationParams = taskFragmentCreationParams;
        this.mActivityToken = activityToken;
        this.mActivityIntent = activityIntent;
        this.mBundle = bundle;
        this.mSecondaryFragmentToken = secondaryFragmentToken;
        this.mAnimationParams = animationParams;
        this.mBooleanValue = booleanValue;
        this.mSurfaceTransaction = surfaceTransaction;
    }

    private TaskFragmentOperation(Parcel in) {
        this.mOpType = in.readInt();
        this.mTaskFragmentCreationParams = in.readTypedObject(TaskFragmentCreationParams.CREATOR);
        this.mActivityToken = in.readStrongBinder();
        this.mActivityIntent = in.readTypedObject(Intent.CREATOR);
        this.mBundle = in.readBundle(this.getClass().getClassLoader());
        this.mSecondaryFragmentToken = in.readStrongBinder();
        this.mAnimationParams = in.readTypedObject(TaskFragmentAnimationParams.CREATOR);
        this.mBooleanValue = in.readBoolean();
        this.mSurfaceTransaction = in.readTypedObject(SurfaceControl.Transaction.CREATOR);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mOpType);
        dest.writeTypedObject(this.mTaskFragmentCreationParams, flags);
        dest.writeStrongBinder(this.mActivityToken);
        dest.writeTypedObject(this.mActivityIntent, flags);
        dest.writeBundle(this.mBundle);
        dest.writeStrongBinder(this.mSecondaryFragmentToken);
        dest.writeTypedObject(this.mAnimationParams, flags);
        dest.writeBoolean(this.mBooleanValue);
        dest.writeTypedObject(this.mSurfaceTransaction, flags);
    }

    public int getOpType() {
        return this.mOpType;
    }

    @Nullable
    public TaskFragmentCreationParams getTaskFragmentCreationParams() {
        return this.mTaskFragmentCreationParams;
    }

    @Nullable
    public IBinder getActivityToken() {
        return this.mActivityToken;
    }

    @Nullable
    public Intent getActivityIntent() {
        return this.mActivityIntent;
    }

    @Nullable
    public Bundle getBundle() {
        return this.mBundle;
    }

    @Nullable
    public IBinder getSecondaryFragmentToken() {
        return this.mSecondaryFragmentToken;
    }

    @Nullable
    public TaskFragmentAnimationParams getAnimationParams() {
        return this.mAnimationParams;
    }

    public boolean getBooleanValue() {
        return this.mBooleanValue;
    }

    @Nullable
    public SurfaceControl.Transaction getSurfaceTransaction() {
        return this.mSurfaceTransaction;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskFragmentOperation{ opType=").append(this.mOpType);
        if (this.mTaskFragmentCreationParams != null) {
            sb.append(", taskFragmentCreationParams=").append(this.mTaskFragmentCreationParams);
        }
        if (this.mActivityToken != null) {
            sb.append(", activityToken=").append(this.mActivityToken);
        }
        if (this.mActivityIntent != null) {
            sb.append(", activityIntent=").append(this.mActivityIntent);
        }
        if (this.mBundle != null) {
            sb.append(", bundle=").append(this.mBundle);
        }
        if (this.mSecondaryFragmentToken != null) {
            sb.append(", secondaryFragmentToken=").append(this.mSecondaryFragmentToken);
        }
        if (this.mAnimationParams != null) {
            sb.append(", animationParams=").append(this.mAnimationParams);
        }
        sb.append(", booleanValue=").append(this.mBooleanValue);
        if (this.mSurfaceTransaction != null) {
            sb.append(", surfaceTransaction=").append(this.mSurfaceTransaction);
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mOpType, this.mTaskFragmentCreationParams, this.mActivityToken, this.mActivityIntent, this.mBundle, this.mSecondaryFragmentToken, this.mAnimationParams, this.mBooleanValue, this.mSurfaceTransaction);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TaskFragmentOperation)) {
            return false;
        }
        TaskFragmentOperation other = (TaskFragmentOperation)obj;
        return this.mOpType == other.mOpType && Objects.equals(this.mTaskFragmentCreationParams, other.mTaskFragmentCreationParams) && Objects.equals(this.mActivityToken, other.mActivityToken) && Objects.equals(this.mActivityIntent, other.mActivityIntent) && Objects.equals(this.mBundle, other.mBundle) && Objects.equals(this.mSecondaryFragmentToken, other.mSecondaryFragmentToken) && Objects.equals(this.mAnimationParams, other.mAnimationParams) && this.mBooleanValue == other.mBooleanValue && Objects.equals(this.mSurfaceTransaction, other.mSurfaceTransaction);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private final int mOpType;
        @Nullable
        private TaskFragmentCreationParams mTaskFragmentCreationParams;
        @Nullable
        private IBinder mActivityToken;
        @Nullable
        private Intent mActivityIntent;
        @Nullable
        private Bundle mBundle;
        @Nullable
        private IBinder mSecondaryFragmentToken;
        @Nullable
        private TaskFragmentAnimationParams mAnimationParams;
        private boolean mBooleanValue;
        @Nullable
        private SurfaceControl.Transaction mSurfaceTransaction;

        public Builder(int opType) {
            this.mOpType = opType;
        }

        @NonNull
        public Builder setTaskFragmentCreationParams(@Nullable TaskFragmentCreationParams taskFragmentCreationParams) {
            this.mTaskFragmentCreationParams = taskFragmentCreationParams;
            return this;
        }

        @NonNull
        public Builder setActivityToken(@Nullable IBinder activityToken) {
            this.mActivityToken = activityToken;
            return this;
        }

        @NonNull
        public Builder setActivityIntent(@Nullable Intent activityIntent) {
            this.mActivityIntent = activityIntent;
            return this;
        }

        @NonNull
        public Builder setBundle(@Nullable Bundle bundle) {
            this.mBundle = bundle;
            return this;
        }

        @NonNull
        public Builder setSecondaryFragmentToken(@Nullable IBinder secondaryFragmentToken) {
            this.mSecondaryFragmentToken = secondaryFragmentToken;
            return this;
        }

        @NonNull
        public Builder setAnimationParams(@Nullable TaskFragmentAnimationParams animationParams) {
            this.mAnimationParams = animationParams;
            return this;
        }

        @NonNull
        public Builder setBooleanValue(boolean booleanValue) {
            this.mBooleanValue = booleanValue;
            return this;
        }

        @NonNull
        public Builder setSurfaceTransaction(@Nullable SurfaceControl.Transaction surfaceTransaction) {
            this.mSurfaceTransaction = surfaceTransaction;
            return this;
        }

        @NonNull
        public TaskFragmentOperation build() {
            return new TaskFragmentOperation(this.mOpType, this.mTaskFragmentCreationParams, this.mActivityToken, this.mActivityIntent, this.mBundle, this.mSecondaryFragmentToken, this.mAnimationParams, this.mBooleanValue, this.mSurfaceTransaction);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OperationType {
    }
}

