/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.content.pm.ActivityInfo;
import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.window.IWindowlessStartingSurfaceCallback;
import android.window.TaskSnapshot;

public class StartingWindowInfo
implements Parcelable {
    public static final int STARTING_WINDOW_TYPE_NONE = 0;
    public static final int STARTING_WINDOW_TYPE_SPLASH_SCREEN = 1;
    public static final int STARTING_WINDOW_TYPE_SNAPSHOT = 2;
    public static final int STARTING_WINDOW_TYPE_SOLID_COLOR_SPLASH_SCREEN = 3;
    public static final int STARTING_WINDOW_TYPE_LEGACY_SPLASH_SCREEN = 4;
    public static final int STARTING_WINDOW_TYPE_WINDOWLESS = 5;
    @NonNull
    public ActivityManager.RunningTaskInfo taskInfo;
    @NonNull
    public final Rect taskBounds = new Rect();
    @Nullable
    public ActivityInfo targetActivityInfo;
    @Nullable
    public WindowManager.LayoutParams mainWindowLayoutParams;
    public static final int TYPE_PARAMETER_NEW_TASK = 1;
    public static final int TYPE_PARAMETER_TASK_SWITCH = 2;
    public static final int TYPE_PARAMETER_PROCESS_RUNNING = 4;
    public static final int TYPE_PARAMETER_ALLOW_TASK_SNAPSHOT = 8;
    public static final int TYPE_PARAMETER_ACTIVITY_CREATED = 16;
    public static final int TYPE_PARAMETER_USE_SOLID_COLOR_SPLASH_SCREEN = 32;
    public static final int TYPE_PARAMETER_ACTIVITY_DRAWN = 64;
    public static final int TYPE_PARAMETER_ALLOW_HANDLE_SOLID_COLOR_SCREEN = 128;
    public static final int TYPE_PARAMETER_WINDOWLESS = 256;
    public static final int TYPE_PARAMETER_APP_PREFERS_ICON = 512;
    public static final int TYPE_PARAMETER_LEGACY_SPLASH_SCREEN = Integer.MIN_VALUE;
    public int startingWindowTypeParameter;
    public int splashScreenThemeResId;
    public boolean isKeyguardOccluded = false;
    public TaskSnapshot taskSnapshot;
    public int requestedVisibleTypes = WindowInsets.Type.defaultVisible();
    public IBinder appToken;
    public IWindowlessStartingSurfaceCallback windowlessStartingSurfaceCallback;
    public SurfaceControl rootSurface;
    @NonNull
    public static final Parcelable.Creator<StartingWindowInfo> CREATOR = new Parcelable.Creator<StartingWindowInfo>(){

        @Override
        public StartingWindowInfo createFromParcel(@NonNull Parcel source) {
            return new StartingWindowInfo(source);
        }

        public StartingWindowInfo[] newArray(int size) {
            return new StartingWindowInfo[size];
        }
    };

    public void notifyAddComplete(SurfaceControl addedSurface) {
        if (this.windowlessStartingSurfaceCallback != null) {
            try {
                this.windowlessStartingSurfaceCallback.onSurfaceAdded(addedSurface);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    public StartingWindowInfo() {
    }

    private StartingWindowInfo(@NonNull Parcel source) {
        this.readFromParcel(source);
    }

    public boolean allowHandleSolidColorSplashScreen() {
        return (this.startingWindowTypeParameter & 0x80) != 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.taskInfo, flags);
        this.taskBounds.writeToParcel(dest, flags);
        dest.writeTypedObject(this.targetActivityInfo, flags);
        dest.writeInt(this.startingWindowTypeParameter);
        dest.writeTypedObject(this.mainWindowLayoutParams, flags);
        dest.writeInt(this.splashScreenThemeResId);
        dest.writeBoolean(this.isKeyguardOccluded);
        dest.writeTypedObject(this.taskSnapshot, flags);
        dest.writeInt(this.requestedVisibleTypes);
        dest.writeStrongBinder(this.appToken);
        dest.writeStrongInterface(this.windowlessStartingSurfaceCallback);
        dest.writeTypedObject(this.rootSurface, flags);
    }

    void readFromParcel(@NonNull Parcel source) {
        this.taskInfo = source.readTypedObject(ActivityManager.RunningTaskInfo.CREATOR);
        this.taskBounds.readFromParcel(source);
        this.targetActivityInfo = source.readTypedObject(ActivityInfo.CREATOR);
        this.startingWindowTypeParameter = source.readInt();
        this.mainWindowLayoutParams = source.readTypedObject(WindowManager.LayoutParams.CREATOR);
        this.splashScreenThemeResId = source.readInt();
        this.isKeyguardOccluded = source.readBoolean();
        this.taskSnapshot = source.readTypedObject(TaskSnapshot.CREATOR);
        this.requestedVisibleTypes = source.readInt();
        this.appToken = source.readStrongBinder();
        this.windowlessStartingSurfaceCallback = IWindowlessStartingSurfaceCallback.Stub.asInterface(source.readStrongBinder());
        this.rootSurface = source.readTypedObject(SurfaceControl.CREATOR);
    }

    public String toString() {
        return "StartingWindowInfo{taskId=" + this.taskInfo.taskId + " targetActivityInfo=" + this.targetActivityInfo + " displayId=" + this.taskInfo.displayId + " topActivityType=" + this.taskInfo.topActivityType + " preferredStartingWindowType=" + Integer.toHexString(this.startingWindowTypeParameter) + " mainWindowLayoutParams=" + this.mainWindowLayoutParams + " splashScreenThemeResId " + Integer.toHexString(this.splashScreenThemeResId);
    }

    public static @interface StartingTypeParams {
    }

    public static @interface StartingWindowType {
    }
}

