/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.Trace;
import android.os._Original_Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.AttachedSurfaceControl;
import android.view.LayoutInflater;
import android.view.SurfaceControlViewHost;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.android.internal.jank.InteractionJankMonitor;
import com.android.internal.policy.DecorView;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.LongConsumer;

public class SplashScreenView
extends FrameLayout {
    private static final String TAG = SplashScreenView.class.getSimpleName();
    private static final boolean DEBUG = _Original_Build.IS_DEBUGGABLE;
    private boolean mNotCopyable;
    private boolean mIsCopied;
    private int mInitBackgroundColor;
    private View mIconView;
    private Bitmap mParceledIconBitmap;
    private View mBrandingImageView;
    private Bitmap mParceledBrandingBitmap;
    private Bitmap mParceledIconBackgroundBitmap;
    private Duration mIconAnimationDuration;
    private Instant mIconAnimationStart;
    private final Rect mTmpRect = new Rect();
    private final int[] mTmpPos = new int[2];
    @Nullable
    private SurfaceControlViewHost.SurfacePackage mSurfacePackageCopy;
    @Nullable
    private SurfaceControlViewHost.SurfacePackage mSurfacePackage;
    @Nullable
    private SurfaceView mSurfaceView;
    @Nullable
    private SurfaceControlViewHost mSurfaceHost;
    @Nullable
    private RemoteCallback mClientCallback;
    private Window mWindow;
    private boolean mHasRemoved;

    public SplashScreenView(Context context) {
        super(context);
    }

    public SplashScreenView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public void setNotCopyable() {
        this.mNotCopyable = true;
    }

    public boolean isCopyable() {
        return !this.mNotCopyable;
    }

    public void onCopied() {
        this.mIsCopied = true;
        if (this.mSurfaceView == null) {
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "Setting SurfaceView's SurfacePackage to null.");
        }
        this.mSurfacePackage.release();
        this.mSurfacePackage = null;
    }

    @Nullable
    public SurfaceControlViewHost getSurfaceHost() {
        return this.mSurfaceHost;
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        if (this.mSurfaceView != null) {
            this.mSurfaceView.setAlpha(this.mSurfaceView.getAlpha() * alpha);
        }
    }

    @Nullable
    public Duration getIconAnimationDuration() {
        return this.mIconAnimationDuration;
    }

    @Nullable
    public Instant getIconAnimationStart() {
        return this.mIconAnimationStart;
    }

    public void syncTransferSurfaceOnDraw() {
        if (this.mSurfacePackage == null) {
            return;
        }
        if (DEBUG) {
            this.mSurfacePackage.getSurfaceControl().addOnReparentListener((transaction, parent) -> Log.e(TAG, String.format("SurfacePackage'surface reparented to %s", parent)));
            Log.d(TAG, "Transferring surface " + this.mSurfaceView.toString());
        }
        this.mSurfaceView.setChildSurfacePackage(this.mSurfacePackage);
    }

    void initIconAnimation(Drawable iconDrawable) {
        if (!(iconDrawable instanceof IconAnimateListener)) {
            return;
        }
        IconAnimateListener aniDrawable = (IconAnimateListener)((Object)iconDrawable);
        aniDrawable.prepareAnimate(this::animationStartCallback);
        aniDrawable.setAnimationJankMonitoring(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationCancel(Animator animation) {
                InteractionJankMonitor.getInstance().cancel(38);
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                InteractionJankMonitor.getInstance().end(38);
            }

            @Override
            public void onAnimationStart(Animator animation) {
                InteractionJankMonitor.getInstance().begin(SplashScreenView.this, 38);
            }
        });
    }

    private void animationStartCallback(long animDuration) {
        this.mIconAnimationStart = Instant.now();
        if (animDuration >= 0L) {
            this.mIconAnimationDuration = Duration.ofMillis(animDuration);
        }
    }

    public void remove() {
        if (this.mHasRemoved) {
            return;
        }
        this.setVisibility(8);
        if (this.mParceledIconBitmap != null) {
            if (this.mIconView instanceof ImageView) {
                ((ImageView)this.mIconView).setImageDrawable(null);
            } else if (this.mIconView != null) {
                this.mIconView.setBackground(null);
            }
            this.mParceledIconBitmap.recycle();
            this.mParceledIconBitmap = null;
        }
        if (this.mParceledBrandingBitmap != null) {
            this.mBrandingImageView.setBackground(null);
            this.mParceledBrandingBitmap.recycle();
            this.mParceledBrandingBitmap = null;
        }
        if (this.mParceledIconBackgroundBitmap != null) {
            if (this.mIconView != null) {
                this.mIconView.setBackground(null);
            }
            this.mParceledIconBackgroundBitmap.recycle();
            this.mParceledIconBackgroundBitmap = null;
        }
        if (this.mWindow != null) {
            DecorView decorView = (DecorView)this.mWindow.peekDecorView();
            if (DEBUG) {
                Log.d(TAG, "remove starting view");
            }
            if (decorView != null) {
                decorView.removeView(this);
            }
            this.mWindow = null;
        }
        this.mHasRemoved = true;
    }

    @Override
    protected void onDetachedFromWindow() {
        ImageView imageView;
        super.onDetachedFromWindow();
        this.releaseAnimationSurfaceHost();
        Object object = this.mIconView;
        if (object instanceof ImageView && (object = (imageView = (ImageView)object).getDrawable()) instanceof Closeable) {
            Closeable closeableDrawable = (Closeable)object;
            try {
                closeableDrawable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mBrandingImageView.getDrawingRect(this.mTmpRect);
        int brandingHeight = this.mTmpRect.height();
        if (brandingHeight == 0 || this.mIconView == null) {
            return;
        }
        int visibility = this.mBrandingImageView.getVisibility();
        if (visibility != 0) {
            return;
        }
        int currentHeight = b - t;
        this.mIconView.getLocationInWindow(this.mTmpPos);
        this.mIconView.getDrawingRect(this.mTmpRect);
        int iconHeight = this.mTmpRect.height();
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mBrandingImageView.getLayoutParams();
        if (params == null) {
            Log.e(TAG, "Unable to adjust branding image layout, layout changed?");
            return;
        }
        int marginBottom = params.bottomMargin;
        int remainingHeight = currentHeight - this.mTmpPos[1] - iconHeight;
        int remainingMaxMargin = remainingHeight - brandingHeight;
        if (remainingHeight < brandingHeight) {
            this.mBrandingImageView.setVisibility(8);
        } else if (remainingMaxMargin < marginBottom) {
            params.bottomMargin = (int)Math.round((double)remainingMaxMargin / 2.0);
            this.mBrandingImageView.setLayoutParams(params);
        }
    }

    private void releaseAnimationSurfaceHost() {
        if (this.mSurfaceHost != null && !this.mIsCopied) {
            if (DEBUG) {
                Log.d(TAG, "Shell removed splash screen. Releasing SurfaceControlViewHost on thread #" + Thread.currentThread().getId());
            }
            SplashScreenView.releaseIconHost(this.mSurfaceHost);
            this.mSurfaceHost = null;
        } else if (this.mSurfacePackage != null && this.mSurfaceHost == null) {
            this.mSurfacePackage = null;
            this.mClientCallback.sendResult(null);
        }
    }

    public static void releaseIconHost(SurfaceControlViewHost host) {
        Drawable background = host.getView().getBackground();
        if (background instanceof IconAnimateListener) {
            ((IconAnimateListener)((Object)background)).stopAnimation();
        }
        host.release();
    }

    public void attachHostWindow(Window window) {
        this.mWindow = window;
    }

    @Nullable
    public View getIconView() {
        return this.mIconView;
    }

    @Nullable
    public View getBrandingView() {
        return this.mBrandingImageView;
    }

    public int getInitBackgroundColor() {
        return this.mInitBackgroundColor;
    }

    public static interface IconAnimateListener {
        public void prepareAnimate(LongConsumer var1);

        public void stopAnimation();

        default public void setAnimationJankMonitoring(AnimatorListenerAdapter listener) {
        }
    }

    public static class SplashScreenViewParcelable
    implements Parcelable {
        private int mIconSize;
        private int mBackgroundColor;
        private Bitmap mIconBackground;
        private Bitmap mIconBitmap = null;
        private int mBrandingWidth;
        private int mBrandingHeight;
        private Bitmap mBrandingBitmap;
        private long mIconAnimationStartMillis;
        private long mIconAnimationDurationMillis;
        private SurfaceControlViewHost.SurfacePackage mSurfacePackage;
        private RemoteCallback mClientCallback;
        @NonNull
        public static final Parcelable.Creator<SplashScreenViewParcelable> CREATOR = new Parcelable.Creator<SplashScreenViewParcelable>(){

            @Override
            public SplashScreenViewParcelable createFromParcel(@NonNull Parcel source) {
                return new SplashScreenViewParcelable(source);
            }

            public SplashScreenViewParcelable[] newArray(int size) {
                return new SplashScreenViewParcelable[size];
            }
        };

        public SplashScreenViewParcelable(SplashScreenView view) {
            View iconView = view.getIconView();
            this.mIconSize = iconView != null ? iconView.getWidth() : 0;
            this.mBackgroundColor = view.getInitBackgroundColor();
            this.mIconBackground = iconView != null ? this.copyDrawable(iconView.getBackground()) : null;
            this.mSurfacePackage = view.mSurfacePackageCopy;
            if (this.mSurfacePackage == null) {
                this.mIconBitmap = iconView != null ? this.copyDrawable(((ImageView)view.getIconView()).getDrawable()) : null;
            }
            ViewGroup.LayoutParams params = view.getBrandingView().getLayoutParams();
            this.mBrandingWidth = params.width;
            this.mBrandingHeight = params.height;
            this.mBrandingBitmap = this.copyDrawableWithSize(view.getBrandingView().getBackground(), this.mBrandingWidth, this.mBrandingHeight);
            if (view.getIconAnimationStart() != null) {
                this.mIconAnimationStartMillis = view.getIconAnimationStart().toEpochMilli();
            }
            if (view.getIconAnimationDuration() != null) {
                this.mIconAnimationDurationMillis = view.getIconAnimationDuration().toMillis();
            }
        }

        private Bitmap copyDrawable(Drawable drawable2) {
            if (drawable2 != null) {
                Rect initialBounds = drawable2.copyBounds();
                int width = initialBounds.width();
                int height = initialBounds.height();
                return this.copyDrawableWithSize(drawable2, width, height);
            }
            return null;
        }

        private Bitmap copyDrawableWithSize(Drawable drawable2, int width, int height) {
            if (drawable2 != null) {
                if (width <= 0 || height <= 0) {
                    return null;
                }
                Bitmap snapshot = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
                Canvas bmpCanvas = new Canvas(snapshot);
                drawable2.setBounds(0, 0, width, height);
                drawable2.draw(bmpCanvas);
                Bitmap copyBitmap = snapshot.createAshmemBitmap();
                snapshot.recycle();
                return copyBitmap;
            }
            return null;
        }

        private SplashScreenViewParcelable(@NonNull Parcel source) {
            this.readParcel(source);
        }

        private void readParcel(@NonNull Parcel source) {
            this.mIconSize = source.readInt();
            this.mBackgroundColor = source.readInt();
            this.mIconBitmap = source.readTypedObject(Bitmap.CREATOR);
            this.mBrandingWidth = source.readInt();
            this.mBrandingHeight = source.readInt();
            this.mBrandingBitmap = source.readTypedObject(Bitmap.CREATOR);
            this.mIconAnimationStartMillis = source.readLong();
            this.mIconAnimationDurationMillis = source.readLong();
            this.mIconBackground = source.readTypedObject(Bitmap.CREATOR);
            this.mSurfacePackage = source.readTypedObject(SurfaceControlViewHost.SurfacePackage.CREATOR);
            this.mClientCallback = source.readTypedObject(RemoteCallback.CREATOR);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mIconSize);
            dest.writeInt(this.mBackgroundColor);
            dest.writeTypedObject(this.mIconBitmap, flags);
            dest.writeInt(this.mBrandingWidth);
            dest.writeInt(this.mBrandingHeight);
            dest.writeTypedObject(this.mBrandingBitmap, flags);
            dest.writeLong(this.mIconAnimationStartMillis);
            dest.writeLong(this.mIconAnimationDurationMillis);
            dest.writeTypedObject(this.mIconBackground, flags);
            dest.writeTypedObject(this.mSurfacePackage, flags);
            dest.writeTypedObject(this.mClientCallback, flags);
        }

        public void clearIfNeeded() {
            if (this.mIconBitmap != null) {
                this.mIconBitmap.recycle();
                this.mIconBitmap = null;
            }
            if (this.mBrandingBitmap != null) {
                this.mBrandingBitmap.recycle();
                this.mBrandingBitmap = null;
            }
        }

        int getIconSize() {
            return this.mIconSize;
        }

        int getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public void setClientCallback(@NonNull RemoteCallback clientCallback) {
            this.mClientCallback = clientCallback;
        }
    }

    public static class Builder {
        private final Context mContext;
        private int mIconSize;
        private int mBackgroundColor;
        private Bitmap mParceledIconBitmap;
        private Bitmap mParceledIconBackgroundBitmap;
        private Drawable mIconDrawable;
        private Drawable mOverlayDrawable;
        private Drawable mIconBackground;
        private SurfaceControlViewHost.SurfacePackage mSurfacePackage;
        private RemoteCallback mClientCallback;
        private int mBrandingImageWidth;
        private int mBrandingImageHeight;
        private Drawable mBrandingDrawable;
        private Bitmap mParceledBrandingBitmap;
        private Instant mIconAnimationStart;
        private Duration mIconAnimationDuration;
        private Consumer<Runnable> mUiThreadInitTask;
        private boolean mAllowHandleSolidColor = true;

        public Builder(@NonNull Context context) {
            this.mContext = context;
        }

        public Builder createFromParcel(SplashScreenViewParcelable parcelable) {
            this.mIconSize = parcelable.getIconSize();
            this.mBackgroundColor = parcelable.getBackgroundColor();
            this.mSurfacePackage = parcelable.mSurfacePackage;
            if (this.mSurfacePackage == null && parcelable.mIconBitmap != null) {
                this.mIconDrawable = new BitmapDrawable(this.mContext.getResources(), parcelable.mIconBitmap);
                this.mParceledIconBitmap = parcelable.mIconBitmap;
            }
            if (parcelable.mIconBackground != null) {
                this.mIconBackground = new BitmapDrawable(this.mContext.getResources(), parcelable.mIconBackground);
                this.mParceledIconBackgroundBitmap = parcelable.mIconBackground;
            }
            if (parcelable.mBrandingBitmap != null) {
                this.setBrandingDrawable(new BitmapDrawable(this.mContext.getResources(), parcelable.mBrandingBitmap), parcelable.mBrandingWidth, parcelable.mBrandingHeight);
                this.mParceledBrandingBitmap = parcelable.mBrandingBitmap;
            }
            this.mIconAnimationStart = Instant.ofEpochMilli(parcelable.mIconAnimationStartMillis);
            this.mIconAnimationDuration = Duration.ofMillis(parcelable.mIconAnimationDurationMillis);
            this.mClientCallback = parcelable.mClientCallback;
            if (DEBUG) {
                Log.d(TAG, String.format("Building from parcel drawable: %s", this.mIconDrawable));
            }
            return this;
        }

        public Builder setIconSize(int iconSize) {
            this.mIconSize = iconSize;
            return this;
        }

        public Builder setBackgroundColor(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            return this;
        }

        public Builder setOverlayDrawable(@Nullable Drawable drawable2) {
            this.mOverlayDrawable = drawable2;
            return this;
        }

        public Builder setCenterViewDrawable(@Nullable Drawable drawable2) {
            this.mIconDrawable = drawable2;
            return this;
        }

        public Builder setIconBackground(Drawable iconBackground) {
            this.mIconBackground = iconBackground;
            return this;
        }

        public Builder setUiThreadInitConsumer(Consumer<Runnable> uiThreadInitTask) {
            this.mUiThreadInitTask = uiThreadInitTask;
            return this;
        }

        public Builder setBrandingDrawable(@Nullable Drawable branding, int width, int height) {
            this.mBrandingDrawable = branding;
            this.mBrandingImageWidth = width;
            this.mBrandingImageHeight = height;
            return this;
        }

        public Builder setAllowHandleSolidColor(boolean allowHandleSolidColor) {
            this.mAllowHandleSolidColor = allowHandleSolidColor;
            return this;
        }

        public SplashScreenView build() {
            Trace.traceBegin(32L, "SplashScreenView#build");
            LayoutInflater layoutInflater = LayoutInflater.from(this.mContext);
            SplashScreenView view = (SplashScreenView)layoutInflater.inflate(17367382, null, false);
            view.mInitBackgroundColor = this.mBackgroundColor;
            if (this.mOverlayDrawable != null) {
                view.setBackground(this.mOverlayDrawable);
            } else {
                view.setBackgroundColor(this.mBackgroundColor);
            }
            view.mClientCallback = this.mClientCallback;
            view.mBrandingImageView = view.findViewById(16909633);
            boolean hasIcon = false;
            if (this.mIconDrawable instanceof IconAnimateListener || this.mSurfacePackage != null) {
                hasIcon = true;
                if (this.mUiThreadInitTask != null) {
                    this.mUiThreadInitTask.accept(() -> {
                        view.mIconView = this.createSurfaceView(view);
                    });
                } else {
                    view.mIconView = this.createSurfaceView(view);
                }
                view.initIconAnimation(this.mIconDrawable);
                view.mIconAnimationStart = this.mIconAnimationStart;
                view.mIconAnimationDuration = this.mIconAnimationDuration;
            } else if (this.mIconSize != 0) {
                ImageView imageView = (ImageView)view.findViewById(16909634);
                assert (imageView != null);
                ViewGroup.LayoutParams params = imageView.getLayoutParams();
                params.width = this.mIconSize;
                params.height = this.mIconSize;
                imageView.setLayoutParams(params);
                if (this.mIconDrawable != null) {
                    imageView.setImageDrawable(this.mIconDrawable);
                }
                if (this.mIconBackground != null) {
                    imageView.setBackground(this.mIconBackground);
                }
                hasIcon = true;
                view.mIconView = imageView;
            }
            if (this.mOverlayDrawable != null || !hasIcon && !this.mAllowHandleSolidColor) {
                view.setNotCopyable();
            }
            view.mParceledIconBackgroundBitmap = this.mParceledIconBackgroundBitmap;
            view.mParceledIconBitmap = this.mParceledIconBitmap;
            if (this.mBrandingImageHeight > 0 && this.mBrandingImageWidth > 0 && this.mBrandingDrawable != null) {
                ViewGroup.LayoutParams params = view.mBrandingImageView.getLayoutParams();
                params.width = this.mBrandingImageWidth;
                params.height = this.mBrandingImageHeight;
                view.mBrandingImageView.setLayoutParams(params);
                view.mBrandingImageView.setBackground(this.mBrandingDrawable);
            } else {
                view.mBrandingImageView.setVisibility(8);
            }
            if (this.mParceledBrandingBitmap != null) {
                view.mParceledBrandingBitmap = this.mParceledBrandingBitmap;
            }
            if (DEBUG) {
                Log.d(TAG, "Build " + view + "\nIcon: view: " + view.mIconView + " drawable: " + this.mIconDrawable + " size: " + this.mIconSize + "\nBranding: view: " + view.mBrandingImageView + " drawable: " + this.mBrandingDrawable + " size w: " + this.mBrandingImageWidth + " h: " + this.mBrandingImageHeight);
            }
            Trace.traceEnd(32L);
            return view;
        }

        private SurfaceView createSurfaceView(@NonNull SplashScreenView view) {
            Trace.traceBegin(32L, "SplashScreenView#createSurfaceView");
            Context viewContext = view.getContext();
            SurfaceView surfaceView = new SurfaceView(viewContext);
            surfaceView.setPadding(0, 0, 0, 0);
            surfaceView.setBackground(this.mIconBackground);
            if (this.mSurfacePackage == null) {
                if (DEBUG) {
                    Log.d(TAG, "SurfaceControlViewHost created on thread " + Thread.currentThread().getId());
                }
                AttachedSurfaceControl attachedSurfaceControl = surfaceView.getRootSurfaceControl();
                SurfaceControlViewHost viewHost = new SurfaceControlViewHost(viewContext, viewContext.getDisplay(), attachedSurfaceControl == null ? null : attachedSurfaceControl.getInputTransferToken(), "SplashScreenView");
                ImageView imageView = new ImageView(viewContext);
                imageView.setBackground(this.mIconDrawable);
                int windowFlag = 131096;
                WindowManager.LayoutParams lp = new WindowManager.LayoutParams(this.mIconSize, this.mIconSize, 2, 131096, -2);
                viewHost.setView(imageView, lp);
                SurfaceControlViewHost.SurfacePackage surfacePackage = viewHost.getSurfacePackage();
                surfaceView.setChildSurfacePackage(surfacePackage);
                view.mSurfacePackage = surfacePackage;
                view.mSurfaceHost = viewHost;
                view.mSurfacePackageCopy = new SurfaceControlViewHost.SurfacePackage(surfacePackage);
            } else {
                if (DEBUG) {
                    Log.d(TAG, "Using copy of SurfacePackage in the client");
                }
                view.mSurfacePackage = this.mSurfacePackage;
            }
            if (this.mIconSize != 0) {
                FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(this.mIconSize, this.mIconSize);
                lp.gravity = 17;
                surfaceView.setLayoutParams(lp);
                if (DEBUG) {
                    Log.d(TAG, "Icon size " + this.mIconSize);
                }
            }
            surfaceView.setUseAlpha();
            surfaceView.setZOrderOnTop(true);
            surfaceView.getHolder().setFormat(-3);
            view.addView(surfaceView);
            view.mSurfaceView = surfaceView;
            Trace.traceEnd(32L);
            return surfaceView;
        }
    }
}

