/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.NonNull;
import android.app.ActivityManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.database.ContentObserver;
import android.icu.text.DateTimePatternGenerator;
import android.net.Uri;
import android.os.Handler;
import android.os.Process;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.Preconditions;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;

@RemoteViews.RemoteView
public class TextClock
extends TextView {
    @Deprecated
    public static final CharSequence DEFAULT_FORMAT_12_HOUR = "h:mm a";
    @Deprecated
    public static final CharSequence DEFAULT_FORMAT_24_HOUR = "H:mm";
    private CharSequence mFormat12;
    private CharSequence mFormat24;
    private CharSequence mDescFormat12;
    private CharSequence mDescFormat24;
    @ViewDebug.ExportedProperty
    private CharSequence mFormat;
    @ViewDebug.ExportedProperty
    private boolean mHasSeconds;
    private CharSequence mDescFormat;
    private boolean mRegistered;
    private boolean mShouldRunTicker;
    private ClockEventDelegate mClockEventDelegate;
    private Calendar mTime;
    private String mTimeZone;
    private boolean mShowCurrentUserTime;
    private ContentObserver mFormatChangeObserver;
    private boolean mStopTicking;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (TextClock.this.mStopTicking) {
                return;
            }
            if (TextClock.this.mTimeZone == null && "android.intent.action.TIMEZONE_CHANGED".equals(intent.getAction())) {
                String timeZone = intent.getStringExtra("time-zone");
                TextClock.this.createTime(timeZone);
            } else if (!TextClock.this.mShouldRunTicker && "android.intent.action.TIME_SET".equals(intent.getAction())) {
                return;
            }
            TextClock.this.onTimeChanged();
        }
    };
    private final Runnable mTicker = new Runnable(){

        @Override
        public void run() {
            TextClock.this.removeCallbacks(this);
            if (TextClock.this.mStopTicking || !TextClock.this.mShouldRunTicker) {
                return;
            }
            TextClock.this.onTimeChanged();
            Instant now = TextClock.this.mTime.toInstant();
            ZoneId zone = TextClock.this.mTime.getTimeZone().toZoneId();
            ZonedDateTime nextTick = TextClock.this.mHasSeconds ? now.atZone(zone).plusSeconds(1L).withNano(0) : now.atZone(zone).plusMinutes(1L).withSecond(0).withNano(0);
            long millisUntilNextTick = Duration.between(now, nextTick.toInstant()).toMillis();
            if (millisUntilNextTick <= 0L) {
                millisUntilNextTick = 1000L;
            }
            TextClock.this.postDelayed(this, millisUntilNextTick);
        }
    };

    public TextClock(Context context) {
        super(context);
        this.init();
    }

    public TextClock(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TextClock(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextClock(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextClock, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.TextClock, attrs, a, defStyleAttr, defStyleRes);
        try {
            this.mFormat12 = a.getText(0);
            this.mFormat24 = a.getText(1);
            this.mTimeZone = a.getString(2);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private void init() {
        if (this.mFormat12 == null) {
            this.mFormat12 = this.getBestDateTimePattern("hm");
        }
        if (this.mFormat24 == null) {
            this.mFormat24 = this.getBestDateTimePattern("Hm");
        }
        this.mClockEventDelegate = new ClockEventDelegate(this.getContext());
        this.createTime(this.mTimeZone);
        this.chooseFormat();
    }

    private void createTime(String timeZone) {
        TimeZone tz = null;
        if (timeZone == null) {
            tz = TimeZone.getDefault();
        } else {
            tz = TimeZone.getTimeZone(timeZone);
            try {
                tz.toZoneId();
            }
            catch (DateTimeException ex) {
                tz = TimeZone.getDefault();
                this.mTimeZone = tz.getID();
            }
        }
        this.mTime = Calendar.getInstance(tz);
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat12Hour() {
        return this.mFormat12;
    }

    @RemotableViewMethod
    public void setFormat12Hour(CharSequence format) {
        this.mFormat12 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    public void setContentDescriptionFormat12Hour(CharSequence format) {
        this.mDescFormat12 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    @ViewDebug.ExportedProperty
    public CharSequence getFormat24Hour() {
        return this.mFormat24;
    }

    @RemotableViewMethod
    public void setFormat24Hour(CharSequence format) {
        this.mFormat24 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    public void setContentDescriptionFormat24Hour(CharSequence format) {
        this.mDescFormat24 = format;
        this.chooseFormat();
        this.onTimeChanged();
    }

    public void setShowCurrentUserTime(boolean showCurrentUserTime) {
        this.mShowCurrentUserTime = showCurrentUserTime;
        this.chooseFormat();
        this.onTimeChanged();
        this.unregisterObserver();
        this.registerObserver();
    }

    public void setClockEventDelegate(ClockEventDelegate delegate) {
        Preconditions.checkState(!this.mRegistered, "Clock events already registered");
        this.mClockEventDelegate = delegate;
    }

    public void refreshTime() {
        this.onTimeChanged();
        this.invalidate();
    }

    public boolean is24HourModeEnabled() {
        if (this.mShowCurrentUserTime) {
            return DateFormat.is24HourFormat(this.getContext(), ActivityManager.getCurrentUser());
        }
        return DateFormat.is24HourFormat(this.getContext());
    }

    public String getTimeZone() {
        return this.mTimeZone;
    }

    @RemotableViewMethod
    public void setTimeZone(String timeZone) {
        this.mTimeZone = timeZone;
        this.createTime(timeZone);
        this.onTimeChanged();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public CharSequence getFormat() {
        return this.mFormat;
    }

    private void chooseFormat() {
        boolean format24Requested = this.is24HourModeEnabled();
        if (format24Requested) {
            this.mFormat = TextClock.abc(this.mFormat24, this.mFormat12, this.getBestDateTimePattern("Hm"));
            this.mDescFormat = TextClock.abc(this.mDescFormat24, this.mDescFormat12, this.mFormat);
        } else {
            this.mFormat = TextClock.abc(this.mFormat12, this.mFormat24, this.getBestDateTimePattern("hm"));
            this.mDescFormat = TextClock.abc(this.mDescFormat12, this.mDescFormat24, this.mFormat);
        }
        boolean hadSeconds = this.mHasSeconds;
        this.mHasSeconds = DateFormat.hasSeconds(this.mFormat);
        if (this.mShouldRunTicker && hadSeconds != this.mHasSeconds) {
            this.mTicker.run();
        }
    }

    private String getBestDateTimePattern(String skeleton) {
        DateTimePatternGenerator dtpg = DateTimePatternGenerator.getInstance(this.getContext().getResources().getConfiguration().locale);
        return dtpg.getBestPattern(skeleton);
    }

    private static CharSequence abc(CharSequence a, CharSequence b, CharSequence c) {
        return a == null ? (b == null ? c : b) : a;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mRegistered) {
            this.mRegistered = true;
            this.mClockEventDelegate.registerTimeChangeReceiver(this.mIntentReceiver, this.getHandler());
            this.registerObserver();
            this.createTime(this.mTimeZone);
        }
    }

    @Override
    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (!this.mShouldRunTicker && isVisible) {
            this.mShouldRunTicker = true;
            this.mTicker.run();
        } else if (this.mShouldRunTicker && !isVisible) {
            this.mShouldRunTicker = false;
            this.removeCallbacks(this.mTicker);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mRegistered) {
            this.mClockEventDelegate.unregisterTimeChangeReceiver(this.mIntentReceiver);
            this.unregisterObserver();
            this.mRegistered = false;
        }
    }

    public void disableClockTick() {
        this.mStopTicking = true;
    }

    private void registerObserver() {
        if (this.mRegistered) {
            if (this.mFormatChangeObserver == null) {
                this.mFormatChangeObserver = new FormatChangeObserver(this.getHandler());
            }
            int userHandle = this.mShowCurrentUserTime ? -1 : UserHandle.myUserId();
            this.mClockEventDelegate.registerFormatChangeObserver(this.mFormatChangeObserver, userHandle);
        }
    }

    private void unregisterObserver() {
        if (this.mFormatChangeObserver != null) {
            this.mClockEventDelegate.unregisterFormatChangeObserver(this.mFormatChangeObserver);
        }
    }

    @UnsupportedAppUsage
    private void onTimeChanged() {
        this.mTime.setTimeInMillis(System_Delegate.currentTimeMillis());
        this.setText(DateFormat.format(this.mFormat, this.mTime));
        this.setContentDescription(DateFormat.format(this.mDescFormat, this.mTime));
    }

    @Override
    protected void encodeProperties(@NonNull ViewHierarchyEncoder stream) {
        super.encodeProperties(stream);
        CharSequence s = this.getFormat12Hour();
        stream.addProperty("format12Hour", s == null ? null : s.toString());
        s = this.getFormat24Hour();
        stream.addProperty("format24Hour", s == null ? null : s.toString());
        stream.addProperty("format", this.mFormat == null ? null : this.mFormat.toString());
        stream.addProperty("hasSeconds", this.mHasSeconds);
    }

    public static class ClockEventDelegate {
        private final Context mContext;

        public ClockEventDelegate(Context context) {
            this.mContext = context;
        }

        public void registerTimeChangeReceiver(BroadcastReceiver receiver, Handler handler) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.mContext.registerReceiverAsUser(receiver, Process.myUserHandle(), filter, null, handler);
        }

        public void unregisterTimeChangeReceiver(BroadcastReceiver receiver) {
            this.mContext.unregisterReceiver(receiver);
        }

        public void registerFormatChangeObserver(ContentObserver observer, int userHandle) {
            Uri uri = Settings.System.getUriFor("time_12_24");
            this.mContext.getContentResolver().registerContentObserver(uri, true, observer, userHandle);
        }

        public void unregisterFormatChangeObserver(ContentObserver observer) {
            this.mContext.getContentResolver().unregisterContentObserver(observer);
        }
    }

    private class FormatChangeObserver
    extends ContentObserver {
        public FormatChangeObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean selfChange) {
            TextClock.this.chooseFormat();
            TextClock.this.onTimeChanged();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            TextClock.this.chooseFormat();
            TextClock.this.onTimeChanged();
        }
    }
}

