/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.PluralsMessageFormatter;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsSeekBar;
import com.android.internal.R;
import java.util.HashMap;

public class RatingBar
extends AbsSeekBar {
    public static final String PLURALS_RATING = "rating";
    public static final String PLURALS_MAX = "max";
    private int mNumStars = 5;
    private int mProgressOnStartTracking;
    @UnsupportedAppUsage
    private OnRatingBarChangeListener mOnRatingBarChangeListener;

    public RatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RatingBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RatingBar, defStyleAttr, defStyleRes);
        this.saveAttributeDataForStyleable(context, R.styleable.RatingBar, attrs, a, defStyleAttr, defStyleRes);
        int numStars = a.getInt(0, this.mNumStars);
        this.setIsIndicator(a.getBoolean(3, !this.mIsUserSeekable));
        float rating = a.getFloat(1, -1.0f);
        float stepSize = a.getFloat(2, -1.0f);
        a.recycle();
        if (numStars > 0 && numStars != this.mNumStars) {
            this.setNumStars(numStars);
        }
        if (stepSize >= 0.0f) {
            this.setStepSize(stepSize);
        } else {
            this.setStepSize(0.5f);
        }
        if (rating >= 0.0f) {
            this.setRating(rating);
        }
        this.mTouchProgressOffset = 0.6f;
    }

    public RatingBar(Context context, AttributeSet attrs) {
        this(context, attrs, 16842876);
    }

    public RatingBar(Context context) {
        this(context, null);
    }

    public void setOnRatingBarChangeListener(OnRatingBarChangeListener listener) {
        this.mOnRatingBarChangeListener = listener;
    }

    public OnRatingBarChangeListener getOnRatingBarChangeListener() {
        return this.mOnRatingBarChangeListener;
    }

    public void setIsIndicator(boolean isIndicator) {
        boolean bl = this.mIsUserSeekable = !isIndicator;
        if (isIndicator) {
            this.setFocusable(16);
        } else {
            this.setFocusable(1);
        }
    }

    public boolean isIndicator() {
        return !this.mIsUserSeekable;
    }

    public void setNumStars(int numStars) {
        if (numStars <= 0) {
            return;
        }
        this.mNumStars = numStars;
        this.requestLayout();
    }

    public int getNumStars() {
        return this.mNumStars;
    }

    public void setRating(float rating) {
        this.setProgress(Math.round(rating * this.getProgressPerStar()));
    }

    public float getRating() {
        return (float)this.getProgress() / this.getProgressPerStar();
    }

    public void setStepSize(float stepSize) {
        if (stepSize <= 0.0f) {
            return;
        }
        float newMax = (float)this.mNumStars / stepSize;
        int newProgress = (int)(newMax / (float)this.getMax() * (float)this.getProgress());
        this.setMax((int)newMax);
        this.setProgress(newProgress);
    }

    public float getStepSize() {
        return (float)this.getNumStars() / (float)this.getMax();
    }

    private float getProgressPerStar() {
        if (this.mNumStars > 0) {
            return 1.0f * (float)this.getMax() / (float)this.mNumStars;
        }
        return 1.0f;
    }

    @Override
    Shape getDrawableShape() {
        return new RectShape();
    }

    @Override
    void onProgressRefresh(float scale, boolean fromUser, int progress) {
        super.onProgressRefresh(scale, fromUser, progress);
        this.updateSecondaryProgress(progress);
        if (!fromUser) {
            this.dispatchRatingChange(false);
        }
    }

    private void updateSecondaryProgress(int progress) {
        float ratio = this.getProgressPerStar();
        if (ratio > 0.0f) {
            float progressInStars = (float)progress / ratio;
            int secondaryProgress = (int)(Math.ceil(progressInStars) * (double)ratio);
            this.setSecondaryProgress(secondaryProgress);
        }
    }

    @Override
    protected synchronized void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mSampleWidth > 0) {
            int width = this.mSampleWidth * this.mNumStars;
            this.setMeasuredDimension(RatingBar.resolveSizeAndState(width, widthMeasureSpec, 0), this.getMeasuredHeight());
        }
    }

    @Override
    void onStartTrackingTouch() {
        this.mProgressOnStartTracking = this.getProgress();
        super.onStartTrackingTouch();
    }

    @Override
    void onStopTrackingTouch() {
        super.onStopTrackingTouch();
        if (this.getProgress() != this.mProgressOnStartTracking) {
            this.dispatchRatingChange(true);
        }
    }

    @Override
    void onKeyChange() {
        super.onKeyChange();
        this.dispatchRatingChange(true);
    }

    void dispatchRatingChange(boolean fromUser) {
        if (this.mOnRatingBarChangeListener != null) {
            this.mOnRatingBarChangeListener.onRatingChanged(this, this.getRating(), fromUser);
        }
    }

    @Override
    public synchronized void setMax(int max) {
        if (max <= 0) {
            return;
        }
        super.setMax(max);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return RatingBar.class.getName();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        if (this.canUserSetProgress()) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SET_PROGRESS);
        }
        float scaledMax = (float)this.getMax() * this.getStepSize();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PLURALS_RATING, Float.valueOf(this.getRating()));
        params.put(PLURALS_MAX, Float.valueOf(scaledMax));
        info.setStateDescription(PluralsMessageFormatter.format(this.getContext().getResources(), params, 17041653));
    }

    @Override
    boolean canUserSetProgress() {
        return super.canUserSetProgress() && !this.isIndicator();
    }

    public static interface OnRatingBarChangeListener {
        public void onRatingChanged(RatingBar var1, float var2, boolean var3);
    }
}

