/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.Nullable;
import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.widget.flags.FeatureFlags;
import android.widget.flags.FeatureFlagsImpl;
import com.android.internal.annotations.VisibleForTesting;

public class DifferentialMotionFlingHelper {
    private final Context mContext;
    private final DifferentialMotionFlingTarget mTarget;
    private final FlingVelocityThresholdCalculator mVelocityThresholdCalculator;
    private final DifferentialVelocityProvider mVelocityProvider;
    private final FeatureFlags mWidgetFeatureFlags;
    @Nullable
    private VelocityTracker mVelocityTracker;
    private float mLastFlingVelocity;
    private int mLastProcessedAxis = -1;
    private int mLastProcessedSource = -1;
    private int mLastProcessedDeviceId = -1;
    private final int[] mFlingVelocityThresholds = new int[]{Integer.MAX_VALUE, 0};

    public DifferentialMotionFlingHelper(Context context, DifferentialMotionFlingTarget target) {
        this(context, target, DifferentialMotionFlingHelper::calculateFlingVelocityThresholds, DifferentialMotionFlingHelper::getCurrentVelocity, new FeatureFlagsImpl());
    }

    @VisibleForTesting
    public DifferentialMotionFlingHelper(Context context, DifferentialMotionFlingTarget target, FlingVelocityThresholdCalculator velocityThresholdCalculator, DifferentialVelocityProvider velocityProvider, FeatureFlags widgetFeatureFlags) {
        this.mContext = context;
        this.mTarget = target;
        this.mVelocityThresholdCalculator = velocityThresholdCalculator;
        this.mVelocityProvider = velocityProvider;
        this.mWidgetFeatureFlags = widgetFeatureFlags;
    }

    public void onMotionEvent(MotionEvent event, int axis) {
        if (!this.mWidgetFeatureFlags.enablePlatformWidgetDifferentialMotionFling()) {
            return;
        }
        boolean flingParamsChanged = this.calculateFlingVelocityThresholds(event, axis);
        if (this.mFlingVelocityThresholds[0] == Integer.MAX_VALUE) {
            this.recycleVelocityTracker();
            return;
        }
        float scaledVelocity = this.getCurrentVelocity(event, axis) * this.mTarget.getScaledScrollFactor();
        float velocityDirection = Math.signum(scaledVelocity);
        if (flingParamsChanged || velocityDirection != Math.signum(this.mLastFlingVelocity) && velocityDirection != 0.0f) {
            this.mTarget.stopDifferentialMotionFling();
        }
        if (Math.abs(scaledVelocity) < (float)this.mFlingVelocityThresholds[0]) {
            return;
        }
        boolean flung = this.mTarget.startDifferentialMotionFling(scaledVelocity = Math.max((float)(-this.mFlingVelocityThresholds[1]), Math.min(scaledVelocity, (float)this.mFlingVelocityThresholds[1])));
        this.mLastFlingVelocity = flung ? scaledVelocity : 0.0f;
    }

    private boolean calculateFlingVelocityThresholds(MotionEvent event, int axis) {
        int source = event.getSource();
        int deviceId = event.getDeviceId();
        if (this.mLastProcessedSource != source || this.mLastProcessedDeviceId != deviceId || this.mLastProcessedAxis != axis) {
            this.mVelocityThresholdCalculator.calculateFlingVelocityThresholds(this.mContext, this.mFlingVelocityThresholds, event, axis);
            this.mLastProcessedSource = source;
            this.mLastProcessedDeviceId = deviceId;
            this.mLastProcessedAxis = axis;
            return true;
        }
        return false;
    }

    private static void calculateFlingVelocityThresholds(Context context, int[] buffer, MotionEvent event, int axis) {
        int source = event.getSource();
        int deviceId = event.getDeviceId();
        ViewConfiguration vc = ViewConfiguration.get(context);
        buffer[0] = vc.getScaledMinimumFlingVelocity(deviceId, axis, source);
        buffer[1] = vc.getScaledMaximumFlingVelocity(deviceId, axis, source);
    }

    private float getCurrentVelocity(MotionEvent event, int axis) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        return this.mVelocityProvider.getCurrentVelocity(this.mVelocityTracker, event, axis);
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private static float getCurrentVelocity(VelocityTracker vt, MotionEvent event, int axis) {
        vt.addMovement(event);
        vt.computeCurrentVelocity(1000);
        return vt.getAxisVelocity(axis);
    }

    @VisibleForTesting
    public static interface FlingVelocityThresholdCalculator {
        public void calculateFlingVelocityThresholds(Context var1, int[] var2, MotionEvent var3, int var4);
    }

    @VisibleForTesting
    public static interface DifferentialVelocityProvider {
        public float getCurrentVelocity(VelocityTracker var1, MotionEvent var2, int var3);
    }

    public static interface DifferentialMotionFlingTarget {
        public boolean startDifferentialMotionFling(float var1);

        public void stopDifferentialMotionFling();

        public float getScaledScrollFactor();
    }
}

