/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.Flags;
import android.webkit.GeolocationPermissions;
import android.webkit.PacProcessor;
import android.webkit.ServiceWorkerController;
import android.webkit.TokenBindingService;
import android.webkit.TracingController;
import android.webkit.ValueCallback;
import android.webkit.WebIconDatabase;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewDatabase;
import android.webkit.WebViewProvider;
import java.util.List;

@SystemApi
public interface WebViewFactoryProvider {
    public static final int MINIMUM_SUPPORTED_TARGET_SDK = 33;
    public static final long MINIMUM_SUPPORTED_VERSION_CODE = 661308800L;

    public static boolean isCompatibleImplementationPackage(@NonNull PackageInfo packageInfo) {
        if (Flags.useBEntryPoint()) {
            return (long)packageInfo.versionCode >= 661308800L;
        }
        return packageInfo.applicationInfo.targetSdkVersion >= 33;
    }

    @NonNull
    public static String describeCompatibleImplementationPackage() {
        if (Flags.useBEntryPoint()) {
            return TextUtils.formatSimple("Minimum versionCode for OS support: %d", 661308800L);
        }
        return TextUtils.formatSimple("Minimum targetSdkVersion: %d", 33);
    }

    @NonNull
    public static String getWebViewFactoryClassName() {
        if (Flags.useBEntryPoint()) {
            return "com.android.webview.chromium.WebViewChromiumFactoryProviderForB";
        }
        return "com.android.webview.chromium.WebViewChromiumFactoryProviderForT";
    }

    public Statics getStatics();

    public WebViewProvider createWebView(WebView var1, WebView.PrivateAccess var2);

    public GeolocationPermissions getGeolocationPermissions();

    public CookieManager getCookieManager();

    public TokenBindingService getTokenBindingService();

    public TracingController getTracingController();

    public ServiceWorkerController getServiceWorkerController();

    public WebIconDatabase getWebIconDatabase();

    public WebStorage getWebStorage();

    public WebViewDatabase getWebViewDatabase(Context var1);

    @NonNull
    default public PacProcessor getPacProcessor() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NonNull
    default public PacProcessor createPacProcessor() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ClassLoader getWebViewClassLoader();

    public static interface Statics {
        public String findAddress(String var1);

        public String getDefaultUserAgent(Context var1);

        public void freeMemoryForTests();

        public void setWebContentsDebuggingEnabled(boolean var1);

        public void clearClientCertPreferences(Runnable var1);

        public void enableSlowWholeDocumentDraw();

        public Uri[] parseFileChooserResult(int var1, Intent var2);

        public void initSafeBrowsing(Context var1, ValueCallback<Boolean> var2);

        public void setSafeBrowsingWhitelist(List<String> var1, ValueCallback<Boolean> var2);

        @NonNull
        public Uri getSafeBrowsingPrivacyPolicyUrl();
    }
}

