/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.annotation.Nullable;
import android.app.RemoteAction;
import android.content.Intent;
import android.os.Bundle;
import android.view.textclassifier.TextClassification;
import java.util.ArrayList;

public class ExtrasUtils {
    private static final String ACTION_INTENT = "action-intent";
    private static final String ACTIONS_INTENTS = "actions-intents";
    private static final String FOREIGN_LANGUAGE = "foreign-language";
    private static final String ENTITY_TYPE = "entity-type";
    private static final String SCORE = "score";
    private static final String MODEL_NAME = "model-name";

    private ExtrasUtils() {
    }

    @Nullable
    public static Bundle getForeignLanguageExtra(@Nullable TextClassification classification) {
        if (classification == null) {
            return null;
        }
        return classification.getExtras().getBundle(FOREIGN_LANGUAGE);
    }

    @Nullable
    public static Intent getActionIntent(Bundle container) {
        return container.getParcelable(ACTION_INTENT, Intent.class);
    }

    @Nullable
    public static ArrayList<Intent> getActionsIntents(@Nullable TextClassification classification) {
        if (classification == null) {
            return null;
        }
        return classification.getExtras().getParcelableArrayList(ACTIONS_INTENTS, Intent.class);
    }

    @Nullable
    private static RemoteAction findAction(@Nullable TextClassification classification, @Nullable String intentAction) {
        if (classification == null || intentAction == null) {
            return null;
        }
        ArrayList<Intent> actionIntents = ExtrasUtils.getActionsIntents(classification);
        if (actionIntents != null) {
            int size = actionIntents.size();
            for (int i = 0; i < size; ++i) {
                Intent intent = actionIntents.get(i);
                if (intent == null || !intentAction.equals(intent.getAction())) continue;
                return classification.getActions().get(i);
            }
        }
        return null;
    }

    @Nullable
    public static RemoteAction findTranslateAction(@Nullable TextClassification classification) {
        return ExtrasUtils.findAction(classification, "android.intent.action.TRANSLATE");
    }

    @Nullable
    public static String getEntityType(@Nullable Bundle extra) {
        if (extra == null) {
            return null;
        }
        return extra.getString(ENTITY_TYPE);
    }

    @Nullable
    public static float getScore(Bundle extra) {
        int defaultValue = -1;
        if (extra == null) {
            return -1.0f;
        }
        return extra.getFloat(SCORE, -1.0f);
    }

    @Nullable
    public static String getModelName(@Nullable Bundle extra) {
        if (extra == null) {
            return null;
        }
        return extra.getString(MODEL_NAME);
    }
}

