/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.PreviewableHandwritingGesture;
import java.util.Objects;

public class SelectGesture
extends PreviewableHandwritingGesture
implements Parcelable {
    private int mGranularity;
    private RectF mArea;
    @NonNull
    public static final Parcelable.Creator<SelectGesture> CREATOR = new Parcelable.Creator<SelectGesture>(){

        @Override
        public SelectGesture createFromParcel(Parcel source) {
            return new SelectGesture(source);
        }

        public SelectGesture[] newArray(int size) {
            return new SelectGesture[size];
        }
    };

    private SelectGesture(int granularity, RectF area, String fallbackText) {
        this.mType = 1;
        this.mArea = area;
        this.mGranularity = granularity;
        this.mFallbackText = fallbackText;
    }

    private SelectGesture(@NonNull Parcel source) {
        this.mType = 1;
        this.mFallbackText = source.readString8();
        this.mGranularity = source.readInt();
        this.mArea = source.readTypedObject(RectF.CREATOR);
    }

    public int getGranularity() {
        return this.mGranularity;
    }

    @NonNull
    public RectF getSelectionArea() {
        return this.mArea;
    }

    public int hashCode() {
        return Objects.hash(this.mGranularity, this.mArea, this.mFallbackText);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SelectGesture)) {
            return false;
        }
        SelectGesture that = (SelectGesture)o;
        if (this.mGranularity != that.mGranularity) {
            return false;
        }
        if (!Objects.equals(this.mFallbackText, that.mFallbackText)) {
            return false;
        }
        return Objects.equals(this.mArea, that.mArea);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mFallbackText);
        dest.writeInt(this.mGranularity);
        dest.writeTypedObject(this.mArea, flags);
    }

    public static class Builder {
        private int mGranularity;
        private RectF mArea;
        private String mFallbackText;

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setGranularity(int granularity) {
            this.mGranularity = granularity;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder setSelectionArea(@NonNull RectF area) {
            this.mArea = area;
            return this;
        }

        @NonNull
        public Builder setFallbackText(@Nullable String fallbackText) {
            this.mFallbackText = fallbackText;
            return this;
        }

        @NonNull
        public SelectGesture build() {
            if (this.mArea == null || this.mArea.isEmpty()) {
                throw new IllegalArgumentException("Selection area must be set.");
            }
            if (this.mGranularity <= 0) {
                throw new IllegalArgumentException("Selection granularity must be set.");
            }
            return new SelectGesture(this.mGranularity, this.mArea, this.mFallbackText);
        }
    }
}

