/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.Application;
import android.app.PropertyInvalidatedCache;
import android.app.compat.CompatChanges;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.ResultReceiver;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.style.SuggestionSpan;
import android.util.Log;
import android.util.Pair;
import android.util.Pools;
import android.util.PrintWriterPrinter;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import android.view.ImeFocusController;
import android.view.ImeInsetsSourceConsumer;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.InputEventSender;
import android.view.InsetsController;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.view.WindowManager;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillManager;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.ConnectionlessHandwritingCallback;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.Flags;
import android.view.inputmethod.IAccessibilityInputMethodSessionInvoker;
import android.view.inputmethod.IInputMethodManagerGlobalInvoker;
import android.view.inputmethod.IInputMethodSessionInvoker;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager_Delegate;
import android.view.inputmethod.InputMethodSubtype;
import android.view.inputmethod.RemoteInputConnectionImpl;
import android.view.inputmethod.TextSnapshot;
import android.view.inputmethod.ViewFocusParameterInfo;
import android.window.ImeOnBackInvokedDispatcher;
import android.window.WindowOnBackInvokedDispatcher;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.inputmethod.IBooleanListener;
import com.android.internal.inputmethod.IConnectionlessHandwritingCallback;
import com.android.internal.inputmethod.IInputMethodClient;
import com.android.internal.inputmethod.IInputMethodSession;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;
import com.android.internal.inputmethod.ImeTracing;
import com.android.internal.inputmethod.InputBindResult;
import com.android.internal.inputmethod.InputMethodDebug;
import com.android.internal.inputmethod.InputMethodPrivilegedOperationsRegistry;
import com.android.internal.os.SomeArgs;
import com.android.internal.view.IInputMethodManager;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class InputMethodManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "InputMethodManager";
    private static final String PENDING_EVENT_COUNTER = "aq:imm";
    private static final int NOT_A_SUBTYPE_ID = -1;
    private static final String SUBTYPE_MODE_VOICE = "voice";
    private final ImeOnBackInvokedDispatcher mImeDispatcher = new ImeOnBackInvokedDispatcher(Handler.getMain()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WindowOnBackInvokedDispatcher getReceivingDispatcher() {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                return InputMethodManager.this.mCurRootView != null ? InputMethodManager.this.mCurRootView.getOnBackInvokedDispatcher() : null;
            }
        }
    };
    private ReportInputConnectionOpenedRunner mReportInputConnectionOpenedRunner;
    private static final Object sLock = new Object();
    @Deprecated
    @GuardedBy(value={"sLock"})
    @UnsupportedAppUsage(maxTargetSdk=35, publicAlternatives="Use {@code Context#getSystemService(InputMethodManager.class)}.")
    static InputMethodManager sInstance;
    @GuardedBy(value={"sLock"})
    private static final SparseArray<InputMethodManager> sInstanceMap;
    private static final long INPUT_METHOD_NOT_RESPONDING_TIMEOUT = 2500L;
    public static final int DISPATCH_IN_PROGRESS = -1;
    public static final int DISPATCH_NOT_HANDLED = 0;
    public static final int DISPATCH_HANDLED = 1;
    public static final int SHOW_IM_PICKER_MODE_AUTO = 0;
    public static final int SHOW_IM_PICKER_MODE_INCLUDE_AUXILIARY_SUBTYPES = 1;
    public static final int SHOW_IM_PICKER_MODE_EXCLUDE_AUXILIARY_SUBTYPES = 2;
    public static final long CLEAR_SHOW_FORCED_FLAG_WHEN_LEAVING = 214016041L;
    private static final long USE_ASYNC_SHOW_HIDE_METHOD = 352594277L;
    private static final long ALWAYS_RETURN_TRUE_HIDE_SOFT_INPUT_FROM_WINDOW = 395521150L;
    private static final boolean OPTIMIZE_NONEDITABLE_VIEWS;
    @FlaggedApi(value="android.view.inputmethod.home_screen_handwriting_delegator")
    public static final int HANDWRITING_DELEGATE_FLAG_HOME_DELEGATOR_ALLOWED = 1;
    @Deprecated
    @UnsupportedAppUsage
    final IInputMethodManager mService;
    private final Looper mMainLooper;
    @UnsupportedAppUsage(maxTargetSdk=28)
    final H mH;
    @NonNull
    private final RemoteInputConnectionImpl mFallbackInputConnection;
    private final int mDisplayId;
    @GuardedBy(value={"mH"})
    private boolean mActive = false;
    @GuardedBy(value={"mH"})
    private boolean mRestartOnNextWindowFocus = true;
    @GuardedBy(value={"mH"})
    private boolean mFullscreenMode;
    @Nullable
    @GuardedBy(value={"mH"})
    private View mServedView;
    @Nullable
    @GuardedBy(value={"mH"})
    private View mNextServedView;
    @Nullable
    @GuardedBy(value={"mH"})
    ViewRootImpl mCurRootView;
    @GuardedBy(value={"mH"})
    boolean mCurRootViewWindowFocused;
    @GuardedBy(value={"mH"})
    private boolean mServedConnecting;
    @GuardedBy(value={"mH"})
    private EditorInfo mCurrentEditorInfo;
    @GuardedBy(value={"mH"})
    @Nullable
    private ViewFocusParameterInfo mPreviousViewFocusParameters;
    @GuardedBy(value={"mH"})
    private RemoteInputConnectionImpl mServedInputConnection;
    @GuardedBy(value={"mH"})
    private CompletionInfo[] mCompletions;
    @GuardedBy(value={"mH"})
    private int mLastPendingStartSeqId = -1;
    @GuardedBy(value={"mH"})
    @UnsupportedAppUsage
    Rect mTmpCursorRect = new Rect();
    @GuardedBy(value={"mH"})
    @UnsupportedAppUsage
    Rect mCursorRect = new Rect();
    private final boolean mAsyncShowHideMethodEnabled = !Flags.compatchangeForZerojankproxy() || CompatChanges.isChangeEnabled(352594277L);
    @GuardedBy(value={"mH"})
    private PropertyInvalidatedCache<Integer, Boolean> mStylusHandwritingAvailableCache;
    @GuardedBy(value={"mH"})
    private PropertyInvalidatedCache<Integer, Boolean> mConnectionlessStylusHandwritingAvailableCache;
    private static final String CACHE_KEY_STYLUS_HANDWRITING_PROPERTY = "cache_key.system_server.stylus_handwriting";
    private static final String CACHE_KEY_CONNECTIONLESS_STYLUS_HANDWRITING_PROPERTY = "cache_key.system_server.connectionless_stylus_handwriting";
    static final int INVALID_SEQ_ID = -1;
    @GuardedBy(value={"mH"})
    private int mCursorSelStart;
    @GuardedBy(value={"mH"})
    private int mCursorSelEnd;
    @GuardedBy(value={"mH"})
    private int mCursorCandStart;
    @GuardedBy(value={"mH"})
    private int mCursorCandEnd;
    @GuardedBy(value={"mH"})
    private int mInitialSelStart;
    @GuardedBy(value={"mH"})
    private int mInitialSelEnd;
    @GuardedBy(value={"mH"})
    private Handler mServedInputConnectionHandler;
    @GuardedBy(value={"mH"})
    private CursorAnchorInfo mCursorAnchorInfo = null;
    @Deprecated
    @GuardedBy(value={"mH"})
    @UnsupportedAppUsage(trackingBug=236937383L, maxTargetSdk=34, publicAlternatives="Apps should not change behavior based on the currently connected IME. If absolutely needed, use {@link InputMethodInfo#getId()} instead.")
    String mCurId;
    @Deprecated
    @GuardedBy(value={"mH"})
    @Nullable
    @UnsupportedAppUsage(trackingBug=236937383L, maxTargetSdk=34, publicAlternatives="Use methods on {@link InputMethodManager} instead.")
    IInputMethodSession mCurMethod;
    @GuardedBy(value={"mH"})
    @Nullable
    private BindState mCurBindState;
    @Nullable
    @GuardedBy(value={"mH"})
    private final SparseArray<IAccessibilityInputMethodSessionInvoker> mAccessibilityInputMethodSession = new SparseArray();
    @GuardedBy(value={"mH"})
    private InputChannel mCurChannel;
    @GuardedBy(value={"mH"})
    private ImeInputEventSender mCurSender;
    private static final int REQUEST_UPDATE_CURSOR_ANCHOR_INFO_NONE = 0;
    @Deprecated
    @GuardedBy(value={"mH"})
    private int mRequestUpdateCursorAnchorInfoMonitorMode = 0;
    @GuardedBy(value={"mH"})
    private ImeInsetsSourceConsumer mImeInsetsConsumer;
    @GuardedBy(value={"mH"})
    private final Pools.Pool<PendingEvent> mPendingEventPool = new Pools.SimplePool<PendingEvent>(20);
    @GuardedBy(value={"mH"})
    private final SparseArray<PendingEvent> mPendingEvents = new SparseArray(20);
    private final DelegateImpl mDelegate = new DelegateImpl();
    private static boolean sPreventImeStartupUnlessTextEditor;
    private static final int MSG_DUMP = 1;
    private static final int MSG_BIND = 2;
    private static final int MSG_UNBIND = 3;
    private static final int MSG_SET_ACTIVE = 4;
    private static final int MSG_SEND_INPUT_EVENT = 5;
    private static final int MSG_TIMEOUT_INPUT_EVENT = 6;
    private static final int MSG_FLUSH_INPUT_EVENT = 7;
    private static final int MSG_REPORT_FULLSCREEN_MODE = 10;
    private static final int MSG_BIND_ACCESSIBILITY_SERVICE = 11;
    private static final int MSG_UNBIND_ACCESSIBILITY_SERVICE = 12;
    private static final int MSG_SET_INTERACTIVE = 13;
    private static final int MSG_SET_VISIBILITY = 14;
    private static final int MSG_ON_SHOW_REQUESTED = 31;
    private static final int MSG_START_INPUT_RESULT = 40;
    private final IInputMethodClient.Stub mClient = new IInputMethodClient.Stub(){

        @Override
        protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
            CountDownLatch latch = new CountDownLatch(1);
            SomeArgs sargs = SomeArgs.obtain();
            sargs.arg1 = fd;
            sargs.arg2 = fout;
            sargs.arg3 = args;
            sargs.arg4 = latch;
            InputMethodManager.this.mH.sendMessage(InputMethodManager.this.mH.obtainMessage(1, sargs));
            try {
                if (!latch.await(5L, TimeUnit.SECONDS)) {
                    fout.println("Timeout waiting for dump");
                }
            }
            catch (InterruptedException e) {
                fout.println("Interrupted waiting for dump");
            }
        }

        @Override
        public void onBindMethod(InputBindResult res) {
            InputMethodManager.this.mH.obtainMessage(2, res).sendToTarget();
        }

        @Override
        public void onStartInputResult(InputBindResult res, int startInputSeq) {
            InputMethodManager.this.mH.obtainMessage(40, startInputSeq, -1, res).sendToTarget();
        }

        @Override
        public void onBindAccessibilityService(InputBindResult res, int id2) {
            InputMethodManager.this.mH.obtainMessage(11, id2, 0, res).sendToTarget();
        }

        @Override
        public void onUnbindMethod(int sequence, int unbindReason) {
            InputMethodManager.this.mH.obtainMessage(3, sequence, unbindReason).sendToTarget();
        }

        @Override
        public void onUnbindAccessibilityService(int sequence, int id2) {
            InputMethodManager.this.mH.obtainMessage(12, sequence, id2).sendToTarget();
        }

        @Override
        public void setActive(boolean active, boolean fullscreen) {
            InputMethodManager.this.mH.obtainMessage(4, active ? 1 : 0, fullscreen ? 1 : 0).sendToTarget();
        }

        @Override
        public void setInteractive(boolean interactive, boolean fullscreen) {
            InputMethodManager.this.mH.obtainMessage(13, interactive ? 1 : 0, fullscreen ? 1 : 0).sendToTarget();
        }

        @Override
        public void setImeVisibility(boolean visible, @Nullable ImeTracker.Token statsToken) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = visible;
            args.arg2 = statsToken;
            ImeTracker.forLogging().onProgress(statsToken, 59);
            InputMethodManager.this.mH.obtainMessage(14, args).sendToTarget();
        }

        @Override
        public void scheduleStartInputIfNecessary(boolean fullscreen) {
            InputMethodManager.this.mH.obtainMessage(4, 0, fullscreen ? 1 : 0).sendToTarget();
            InputMethodManager.this.mH.obtainMessage(4, 1, fullscreen ? 1 : 0).sendToTarget();
        }

        @Override
        public void reportFullscreenMode(boolean fullscreen) {
            InputMethodManager.this.mH.obtainMessage(10, fullscreen ? 1 : 0, 0).sendToTarget();
        }

        @Override
        public void setImeTraceEnabled(boolean enabled) {
            ImeTracing.getInstance().setEnabled(enabled);
        }

        @Override
        public void throwExceptionFromSystem(String message) {
            throw new RuntimeException(message);
        }
    };
    public static final int SHOW_IMPLICIT = 1;
    @Deprecated
    public static final int SHOW_FORCED = 2;
    public static final int RESULT_UNCHANGED_SHOWN = 0;
    public static final int RESULT_UNCHANGED_HIDDEN = 1;
    public static final int RESULT_SHOWN = 2;
    public static final int RESULT_HIDDEN = 3;
    public static final int HIDE_IMPLICIT_ONLY = 1;
    public static final int HIDE_NOT_ALWAYS = 2;
    final AtomicBoolean mRequestCursorUpdateDisplayIdCheck = new AtomicBoolean(true);

    public static void ensureDefaultInstanceForDefaultDisplayIfNecessary() {
        if (!ActivityThread.isSystem()) {
            InputMethodManager.forContextInternal(0, Looper.getMainLooper());
        }
    }

    public static void invalidateLocalStylusHandwritingAvailabilityCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_STYLUS_HANDWRITING_PROPERTY);
    }

    public static void invalidateLocalConnectionlessStylusHandwritingAvailabilityCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_CONNECTIONLESS_STYLUS_HANDWRITING_PROPERTY);
    }

    private static boolean isAutofillUIShowing(View servedView) {
        AutofillManager afm = servedView.getContext().getSystemService(AutofillManager.class);
        return afm != null && afm.isAutofillUiShowing();
    }

    @Nullable
    private InputMethodManager getFallbackInputMethodManagerIfNecessary(@Nullable View view) {
        if (view == null) {
            return null;
        }
        ViewRootImpl viewRootImpl = view.getViewRootImpl();
        if (viewRootImpl == null) {
            return null;
        }
        int viewRootDisplayId = viewRootImpl.getDisplayId();
        if (viewRootDisplayId == this.mDisplayId) {
            return null;
        }
        InputMethodManager fallbackImm = viewRootImpl.mContext.getSystemService(InputMethodManager.class);
        if (fallbackImm == null) {
            Log.v(TAG, "b/117267690: Failed to get non-null fallback IMM. view=" + view);
            return null;
        }
        if (fallbackImm.mDisplayId != viewRootDisplayId) {
            Log.v(TAG, "b/117267690: Failed to get fallback IMM with expected displayId=" + viewRootDisplayId + " actual IMM#displayId=" + fallbackImm.mDisplayId + " view=" + view);
            return null;
        }
        Log.v(TAG, "b/117267690: Display ID mismatch found. ViewRootImpl displayId=" + viewRootDisplayId + " InputMethodManager displayId=" + this.mDisplayId + ". Use the right InputMethodManager instance to avoid performance overhead.", new Throwable());
        return fallbackImm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Context getFallbackContextFromServedView() {
        H h = this.mH;
        synchronized (h) {
            if (this.mCurRootView == null) {
                return null;
            }
            return this.mServedView != null ? this.mServedView.getContext() : null;
        }
    }

    private static boolean canStartInput(View servedView) {
        return servedView.hasWindowFocus() || InputMethodManager.isAutofillUIShowing(servedView);
    }

    public void reportPerceptible(@NonNull IBinder windowToken, boolean perceptible) {
        IInputMethodManagerGlobalInvoker.reportPerceptibleAsync(windowToken, perceptible);
    }

    private static boolean hasViewImeRequestedVisible(View view) {
        WindowInsetsController controller;
        if (Flags.refactorInsetsController() && view != null && (controller = view.getWindowInsetsController()) != null) {
            return (view.getWindowInsetsController().getRequestedVisibleTypes() & WindowInsets.Type.ime()) != 0;
        }
        return false;
    }

    private void onImeFocusLost(@NonNull ViewRootImpl previousRootView) {
        int softInputMode = previousRootView.mWindowAttributes.softInputMode;
        int state = softInputMode & 0xF;
        if (state == 3) {
            ImeTracker.Token statsToken = ImeTracker.forLogging().onStart(2, 5, 58, false);
            previousRootView.getInsetsController().hide(WindowInsets.Type.ime(), false, statsToken);
        }
    }

    public DelegateImpl getDelegate() {
        return this.mDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveInputConnection(@Nullable View view) {
        H h = this.mH;
        synchronized (h) {
            return this.mCurRootView != null && view != null && this.mServedView == view && this.mServedInputConnection != null && this.mServedInputConnection.isAssociatedWith(view) && this.isImeSessionAvailableLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasActiveInputConnectionInternal(@Nullable View view) {
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view) || !this.isImeSessionAvailableLocked()) {
                return false;
            }
            return this.mServedInputConnection != null && this.mServedInputConnection.isAssociatedWith(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startInputOnWindowFocusGainInternal(int startInputReason, View focusedView, int startInputFlags, int softInputMode, int windowFlags) {
        H h = this.mH;
        synchronized (h) {
            this.mCurrentEditorInfo = null;
            this.mCompletions = null;
            this.mServedConnecting = true;
        }
        return this.startInputInner(startInputReason, focusedView != null ? focusedView.getWindowToken() : null, startInputFlags, softInputMode, windowFlags);
    }

    @GuardedBy(value={"mH"})
    private View getServedViewLocked() {
        return this.mCurRootView != null ? this.mServedView : null;
    }

    @GuardedBy(value={"mH"})
    private View getNextServedViewLocked() {
        return this.mCurRootView != null ? this.mNextServedView : null;
    }

    @GuardedBy(value={"mH"})
    private boolean hasServedByInputMethodLocked(View view) {
        View servedView = this.getServedViewLocked();
        return servedView == view || servedView != null && servedView.checkInputConnectionProxy(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tearDownEditMode() {
        if (!InputMethodManager.isInEditMode()) {
            throw new UnsupportedOperationException("This method must be called only from layoutlib");
        }
        Object object = sLock;
        synchronized (object) {
            sInstance = null;
        }
    }

    static boolean isInEditMode_Original() {
        return false;
    }

    @LayoutlibDelegate
    private static boolean isInEditMode() {
        return InputMethodManager_Delegate.isInEditMode();
    }

    static boolean isInEditModeInternal() {
        return InputMethodManager.isInEditMode();
    }

    @NonNull
    private static InputMethodManager createInstance(int displayId, Looper looper) {
        return InputMethodManager.isInEditMode() ? InputMethodManager.createStubInstance(displayId, looper) : InputMethodManager.createRealInstance(displayId, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static InputMethodManager createRealInstance(int displayId, Looper looper) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            throw new IllegalStateException("IInputMethodManager is not available");
        }
        InputMethodManager imm = new InputMethodManager(service, displayId, looper);
        long identity = Binder.clearCallingIdentity();
        try {
            IInputMethodManagerGlobalInvoker.addClient(imm.mClient, imm.mFallbackInputConnection, displayId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return imm;
    }

    @NonNull
    private static InputMethodManager createStubInstance(int displayId, Looper looper) {
        Class<IInputMethodManager> c = IInputMethodManager.class;
        IInputMethodManager stubInterface = (IInputMethodManager)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, (proxy, method, args) -> {
            Class<?> returnType = method.getReturnType();
            if (returnType == Boolean.TYPE) {
                return false;
            }
            if (returnType == Integer.TYPE) {
                return 0;
            }
            if (returnType == Long.TYPE) {
                return 0L;
            }
            if (returnType == Short.TYPE) {
                return 0;
            }
            if (returnType == Character.TYPE) {
                return 0;
            }
            if (returnType == Byte.TYPE) {
                return 0;
            }
            if (returnType == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (returnType == Double.TYPE) {
                return 0.0;
            }
            return null;
        });
        return new InputMethodManager(stubInterface, displayId, looper);
    }

    private InputMethodManager(@NonNull IInputMethodManager service, int displayId, Looper looper) {
        this.mService = service;
        this.mMainLooper = looper;
        this.mH = new H(looper);
        this.mDisplayId = displayId;
        this.mFallbackInputConnection = new RemoteInputConnectionImpl(looper, new BaseInputConnection(this, false), this, null);
    }

    @NonNull
    public static InputMethodManager forContext(Context context) {
        int displayId = context.getDisplayId();
        Looper looper = displayId == 0 ? Looper.getMainLooper() : context.getMainLooper();
        sPreventImeStartupUnlessTextEditor = context.getResources().getBoolean(0x1110007);
        return InputMethodManager.forContextInternal(displayId, looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static InputMethodManager forContextInternal(int displayId, Looper looper) {
        boolean isDefaultDisplay = displayId == 0;
        Object object = sLock;
        synchronized (object) {
            InputMethodManager instance = sInstanceMap.get(displayId);
            if (instance != null) {
                return instance;
            }
            instance = InputMethodManager.createInstance(displayId, looper);
            if (sInstance == null && isDefaultDisplay) {
                sInstance = instance;
            }
            sInstanceMap.put(displayId, instance);
            return instance;
        }
    }

    @Deprecated
    @UnsupportedAppUsage
    public static InputMethodManager getInstance() {
        Log.w(TAG, "InputMethodManager.getInstance() is deprecated because it cannot be compatible with multi-display. Use context.getSystemService(InputMethodManager.class) instead.", new Throwable());
        InputMethodManager.ensureDefaultInstanceForDefaultDisplayIfNecessary();
        return InputMethodManager.peekInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage
    public static InputMethodManager peekInstance() {
        Log.w(TAG, "InputMethodManager.peekInstance() is deprecated because it cannot be compatible with multi-display. Use context.getSystemService(InputMethodManager.class) instead.", new Throwable());
        Object object = sLock;
        synchronized (object) {
            return sInstance;
        }
    }

    @NonNull
    public List<InputMethodInfo> getInputMethodList() {
        return IInputMethodManagerGlobalInvoker.getInputMethodList(UserHandle.myUserId(), 0);
    }

    public boolean isStylusHandwritingAvailable() {
        return this.isStylusHandwritingAvailableAsUser(UserHandle.of(UserHandle.myUserId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    @SuppressLint(value={"UserHandle"})
    public boolean isStylusHandwritingAvailableAsUser(@NonNull UserHandle user) {
        boolean isAvailable;
        Application fallbackContext = ActivityThread.currentApplication();
        if (fallbackContext == null) {
            return false;
        }
        H h = this.mH;
        synchronized (h) {
            if (this.mStylusHandwritingAvailableCache == null) {
                this.mStylusHandwritingAvailableCache = new PropertyInvalidatedCache<Integer, Boolean>(this, 4, CACHE_KEY_STYLUS_HANDWRITING_PROPERTY){

                    @Override
                    public Boolean recompute(Integer userId) {
                        return IInputMethodManagerGlobalInvoker.isStylusHandwritingAvailableAsUser(userId, false);
                    }
                };
            }
            isAvailable = this.mStylusHandwritingAvailableCache.query(user.getIdentifier());
        }
        return isAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FlaggedApi(value="android.view.inputmethod.connectionless_handwriting")
    public boolean isConnectionlessStylusHandwritingAvailable() {
        if (ActivityThread.currentApplication() == null) {
            return false;
        }
        H h = this.mH;
        synchronized (h) {
            if (this.mConnectionlessStylusHandwritingAvailableCache == null) {
                this.mConnectionlessStylusHandwritingAvailableCache = new PropertyInvalidatedCache<Integer, Boolean>(this, 4, CACHE_KEY_CONNECTIONLESS_STYLUS_HANDWRITING_PROPERTY){

                    @Override
                    public Boolean recompute(@NonNull Integer userId) {
                        return IInputMethodManagerGlobalInvoker.isStylusHandwritingAvailableAsUser(userId, true);
                    }
                };
            }
            return this.mConnectionlessStylusHandwritingAvailableCache.query(UserHandle.myUserId());
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public List<InputMethodInfo> getInputMethodListAsUser(int userId) {
        return IInputMethodManagerGlobalInvoker.getInputMethodList(userId, 0);
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    public List<InputMethodInfo> getInputMethodListAsUser(int userId, int directBootAwareness) {
        return IInputMethodManagerGlobalInvoker.getInputMethodList(userId, directBootAwareness);
    }

    @Nullable
    public InputMethodInfo getCurrentInputMethodInfo() {
        return IInputMethodManagerGlobalInvoker.getCurrentInputMethodInfoAsUser(UserHandle.myUserId());
    }

    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL")
    @Nullable
    @SuppressLint(value={"UserHandle"})
    public InputMethodInfo getCurrentInputMethodInfoAsUser(@NonNull UserHandle user) {
        Objects.requireNonNull(user);
        return IInputMethodManagerGlobalInvoker.getCurrentInputMethodInfoAsUser(user.getIdentifier());
    }

    @NonNull
    public List<InputMethodInfo> getEnabledInputMethodList() {
        return IInputMethodManagerGlobalInvoker.getEnabledInputMethodList(UserHandle.myUserId());
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    @SuppressLint(value={"UserHandle"})
    public List<InputMethodInfo> getEnabledInputMethodListAsUser(@NonNull UserHandle user) {
        return IInputMethodManagerGlobalInvoker.getEnabledInputMethodList(user.getIdentifier());
    }

    @NonNull
    public List<InputMethodSubtype> getEnabledInputMethodSubtypeList(@Nullable InputMethodInfo imi, boolean allowsImplicitlyEnabledSubtypes) {
        return IInputMethodManagerGlobalInvoker.getEnabledInputMethodSubtypeList(imi == null ? null : imi.getId(), allowsImplicitlyEnabledSubtypes, UserHandle.myUserId());
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    @SuppressLint(value={"UserHandle"})
    public List<InputMethodSubtype> getEnabledInputMethodSubtypeListAsUser(@NonNull String imeId, boolean allowsImplicitlyEnabledSubtypes, @NonNull UserHandle user) {
        return IInputMethodManagerGlobalInvoker.getEnabledInputMethodSubtypeList(Objects.requireNonNull(imeId), allowsImplicitlyEnabledSubtypes, user.getIdentifier());
    }

    @Deprecated
    public void showStatusIcon(IBinder imeToken, String packageName, int iconId) {
        InputMethodPrivilegedOperationsRegistry.get(imeToken).updateStatusIconAsync(packageName, iconId);
    }

    @Deprecated
    public void hideStatusIcon(IBinder imeToken) {
        InputMethodPrivilegedOperationsRegistry.get(imeToken).updateStatusIconAsync(null, 0);
    }

    @Deprecated
    @UnsupportedAppUsage
    public void registerSuggestionSpansForNotification(SuggestionSpan[] spans) {
        Log.w(TAG, "registerSuggestionSpansForNotification() is deprecated.  Does nothing.");
    }

    @Deprecated
    @UnsupportedAppUsage
    public void notifySuggestionPicked(SuggestionSpan span, String originalString, int index) {
        Log.w(TAG, "notifySuggestionPicked() is deprecated.  Does nothing.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFullscreenMode() {
        H h = this.mH;
        synchronized (h) {
            return this.mFullscreenMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive(View view) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            return fallbackImm.isActive(view);
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return this.hasServedByInputMethodLocked(view) && this.mCurrentEditorInfo != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return this.getServedViewLocked() != null && this.mCurrentEditorInfo != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    public boolean isCurrentRootView(@NonNull View attachedView) {
        H h = this.mH;
        synchronized (h) {
            return this.mCurRootView == attachedView.getViewRootImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAcceptingText() {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            return this.mServedInputConnection != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInputMethodSuppressingSpellChecker() {
        H h = this.mH;
        synchronized (h) {
            return this.mCurBindState != null && this.mCurBindState.mIsInputMethodSuppressingSpellChecker;
        }
    }

    @GuardedBy(value={"mH"})
    private void clearBindingLocked() {
        this.clearConnectionLocked();
        this.updateInputChannelLocked(null);
        this.mCurId = null;
        this.mCurMethod = null;
        this.mCurBindState = null;
    }

    @GuardedBy(value={"mH"})
    private void clearAccessibilityBindingLocked(int id2) {
        this.mAccessibilityInputMethodSession.remove(id2);
    }

    @GuardedBy(value={"mH"})
    private void clearAllAccessibilityBindingLocked() {
        this.mAccessibilityInputMethodSession.clear();
    }

    @GuardedBy(value={"mH"})
    private void updateInputChannelLocked(InputChannel channel) {
        if (InputMethodManager.areSameInputChannel(this.mCurChannel, channel)) {
            return;
        }
        if (this.mCurSender != null) {
            this.flushPendingEventsLocked();
            this.mCurSender.dispose();
            this.mCurSender = null;
        }
        if (this.mCurChannel != null) {
            this.mCurChannel.dispose();
        }
        this.mCurChannel = channel;
    }

    private static boolean areSameInputChannel(@Nullable InputChannel lhs, @Nullable InputChannel rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        return lhs.getToken() == rhs.getToken();
    }

    @GuardedBy(value={"mH"})
    private void clearConnectionLocked() {
        this.mCurrentEditorInfo = null;
        this.mPreviousViewFocusParameters = null;
        if (this.mServedInputConnection != null) {
            this.mServedInputConnection.deactivate();
            this.mServedInputConnection = null;
            this.mServedInputConnectionHandler = null;
        }
    }

    @UnsupportedAppUsage
    @GuardedBy(value={"mH"})
    void finishInputLocked() {
        View clearedView = null;
        this.mNextServedView = null;
        if (this.mServedView != null) {
            clearedView = this.mServedView;
            this.mServedView = null;
            if (Flags.initiationWithoutInputConnection() && clearedView.getViewRootImpl() != null) {
                clearedView.getViewRootImpl().getHandwritingInitiator().clearFocusedView(clearedView);
            }
        }
        if (clearedView != null) {
            this.mCompletions = null;
            this.mServedConnecting = false;
            this.mLastPendingStartSeqId = -1;
            this.clearConnectionLocked();
        }
        this.mReportInputConnectionOpenedRunner = null;
        this.mImeDispatcher.clear();
    }

    @GuardedBy(value={"mH"})
    private boolean clearCurRootViewIfNeeded() {
        if (!this.mActive && !this.mCurRootViewWindowFocused) {
            this.finishInputLocked();
            this.mDelegate.setCurrentRootViewLocked(null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayCompletions(View view, CompletionInfo[] completions) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.displayCompletions(view, completions);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view)) {
                return;
            }
            this.mCompletions = completions;
            if (this.isImeSessionAvailableLocked()) {
                this.mCurBindState.mImeSession.displayCompletions(this.mCompletions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExtractedText(View view, int token, ExtractedText text) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.updateExtractedText(view, token, text);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view)) {
                return;
            }
            if (this.isImeSessionAvailableLocked()) {
                this.mCurBindState.mImeSession.updateExtractedText(token, text);
            }
        }
    }

    public boolean showSoftInput_Original(View view, int flags) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            return fallbackImm.showSoftInput(view, flags);
        }
        return this.showSoftInput(view, flags, null);
    }

    @LayoutlibDelegate
    public boolean showSoftInput(View view, int n) {
        return InputMethodManager_Delegate.showSoftInput(this, view, n);
    }

    public boolean showSoftInput_Original(View view, int flags, ResultReceiver resultReceiver) {
        return this.showSoftInput(view, flags, resultReceiver, 1);
    }

    @LayoutlibDelegate
    public boolean showSoftInput(View view, int n, ResultReceiver resultReceiver) {
        return InputMethodManager_Delegate.showSoftInput(this, view, n, resultReceiver);
    }

    boolean showSoftInput_Original(View view, int flags, @Nullable ResultReceiver resultReceiver, int reason) {
        ImeTracker.Token statsToken = ImeTracker.forLogging().onStart(1, 5, reason, ImeTracker.isFromUser(view));
        return this.showSoftInput(view, statsToken, flags, resultReceiver, reason);
    }

    @LayoutlibDelegate
    private boolean showSoftInput(View view, int n, ResultReceiver resultReceiver, int n2) {
        return InputMethodManager_Delegate.showSoftInput(this, view, n, resultReceiver, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean showSoftInput_Original(View view, @NonNull ImeTracker.Token statsToken, int flags, @Nullable ResultReceiver resultReceiver, int reason) {
        ImeTracker.forLatency().onRequestShow(statsToken, 5, reason, ActivityThread::currentApplication);
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#showSoftInput", this, null);
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            return fallbackImm.showSoftInput(view, statsToken, flags, resultReceiver, reason);
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view)) {
                ImeTracker.forLogging().onFailed(statsToken, 1);
                ImeTracker.forLatency().onShowFailed(statsToken, 1, ActivityThread::currentApplication);
                Log.w(TAG, "Ignoring showSoftInput() as view=" + view + " is not served.");
                return false;
            }
            ImeTracker.forLogging().onProgress(statsToken, 1);
            if (Flags.refactorInsetsController()) {
                ViewRootImpl viewRootImpl = view.getViewRootImpl();
                if (viewRootImpl != null && ((viewRootImpl.getInsetsController().computeUserAnimatingTypes() & WindowInsets.Type.ime()) == 0 || viewRootImpl.getInsetsController().isPredictiveBackImeHideAnimInProgress())) {
                    Handler vh = view.getHandler();
                    ImeTracker.forLogging().onProgress(statsToken, 61);
                    if (resultReceiver != null) {
                        boolean imeReqVisible = InputMethodManager.hasViewImeRequestedVisible(viewRootImpl.getView());
                        resultReceiver.send(imeReqVisible ? 0 : 2, null);
                    }
                    if (vh.getLooper() != Looper.myLooper()) {
                        ImeTracker.Token finalStatsToken = statsToken;
                        vh.post(() -> viewRootImpl.getInsetsController().show(WindowInsets.Type.ime(), false, finalStatsToken));
                    } else {
                        viewRootImpl.getInsetsController().show(WindowInsets.Type.ime(), false, statsToken);
                    }
                    return true;
                }
                ImeTracker.forLogging().onCancelled(statsToken, 61);
                return false;
            }
            this.mH.executeOrSendMessage(Message.obtain((Handler)this.mH, 31));
            Log.d(TAG, "showSoftInput() view=" + view + " flags=" + flags + " reason=" + InputMethodDebug.softInputDisplayReasonToString(reason));
            return IInputMethodManagerGlobalInvoker.showSoftInput(this.mClient, view.getWindowToken(), statsToken, flags, this.mCurRootView.getLastClickToolType(), resultReceiver, reason, this.mAsyncShowHideMethodEnabled);
        }
    }

    @LayoutlibDelegate
    private boolean showSoftInput(View view, ImeTracker.Token token, int n, ResultReceiver resultReceiver, int n2) {
        return InputMethodManager_Delegate.showSoftInput(this, view, token, n, resultReceiver, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123768499L)
    public void showSoftInputUnchecked(int flags, ResultReceiver resultReceiver) {
        H h = this.mH;
        synchronized (h) {
            View rootView;
            boolean reason = true;
            ImeTracker.Token statsToken = ImeTracker.forLogging().onStart(1, 5, 1, false);
            Log.w(TAG, "showSoftInputUnchecked() is a hidden method, which will be removed soon. If you are using androidx.appcompat.widget.SearchView, please update to version 26.0 or newer version.");
            View view = rootView = this.mCurRootView != null ? this.mCurRootView.getView() : null;
            if (rootView == null) {
                ImeTracker.forLogging().onFailed(statsToken, 1);
                Log.w(TAG, "No current root view, ignoring showSoftInputUnchecked()");
                return;
            }
            if (Flags.refactorInsetsController()) {
                this.showSoftInput(rootView, statsToken, flags, resultReceiver, 1);
                return;
            }
            ImeTracker.forLogging().onProgress(statsToken, 1);
            this.mH.executeOrSendMessage(Message.obtain((Handler)this.mH, 31));
            IInputMethodManagerGlobalInvoker.showSoftInput(this.mClient, rootView.getWindowToken(), statsToken, flags, this.mCurRootView.getLastClickToolType(), resultReceiver, 1, this.mAsyncShowHideMethodEnabled);
        }
    }

    public boolean hideSoftInputFromWindow_Original(IBinder windowToken, int flags) {
        return this.hideSoftInputFromWindow(windowToken, flags, null);
    }

    @LayoutlibDelegate
    public boolean hideSoftInputFromWindow(IBinder iBinder, int n) {
        return InputMethodManager_Delegate.hideSoftInputFromWindow(this, iBinder, n);
    }

    public boolean hideSoftInputFromWindow_Original(IBinder windowToken, int flags, ResultReceiver resultReceiver) {
        return this.hideSoftInputFromWindow(windowToken, flags, resultReceiver, 4, null);
    }

    @LayoutlibDelegate
    public boolean hideSoftInputFromWindow(IBinder iBinder, int n, ResultReceiver resultReceiver) {
        return InputMethodManager_Delegate.hideSoftInputFromWindow(this, iBinder, n, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hideSoftInputFromWindow_Original(IBinder windowToken, int flags, ResultReceiver resultReceiver, int reason, @Nullable ImeTracker.Token statsToken) {
        View initialServedView;
        H h = this.mH;
        synchronized (h) {
            initialServedView = this.getServedViewLocked();
        }
        if (statsToken == null) {
            statsToken = ImeTracker.forLogging().onStart(2, 5, reason, ImeTracker.isFromUser(initialServedView));
            ImeTracker.forLatency().onRequestHide(statsToken, 5, reason, ActivityThread::currentApplication);
        }
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#hideSoftInputFromWindow", this, null);
        this.checkFocus();
        h = this.mH;
        synchronized (h) {
            View servedView = this.getServedViewLocked();
            if (servedView == null || servedView.getWindowToken() != windowToken) {
                ImeTracker.forLogging().onFailed(statsToken, 1);
                ImeTracker.forLatency().onHideFailed(statsToken, 1, ActivityThread::currentApplication);
                return Flags.refactorInsetsController() && CompatChanges.isChangeEnabled(395521150L);
            }
            ImeTracker.forLogging().onProgress(statsToken, 1);
            if (Flags.refactorInsetsController()) {
                ViewRootImpl viewRootImpl = servedView.getViewRootImpl();
                if (viewRootImpl != null) {
                    Handler vh = servedView.getHandler();
                    if (vh == null) {
                        ImeTracker.forLogging().onFailed(statsToken, 66);
                        return Flags.refactorInsetsController() && CompatChanges.isChangeEnabled(395521150L);
                    }
                    ImeTracker.forLogging().onProgress(statsToken, 66);
                    boolean imeReqVisible = InputMethodManager.hasViewImeRequestedVisible(viewRootImpl.getView());
                    if (resultReceiver != null) {
                        resultReceiver.send(!imeReqVisible ? 1 : 3, null);
                    }
                    if (vh.getLooper() != Looper.myLooper()) {
                        ImeTracker.Token finalStatsToken = statsToken;
                        vh.post(() -> viewRootImpl.getInsetsController().hide(WindowInsets.Type.ime(), false, finalStatsToken));
                    } else {
                        viewRootImpl.getInsetsController().hide(WindowInsets.Type.ime(), false, statsToken);
                    }
                    if (!CompatChanges.isChangeEnabled(395521150L)) {
                        return imeReqVisible;
                    }
                }
                return CompatChanges.isChangeEnabled(395521150L);
            }
            return IInputMethodManagerGlobalInvoker.hideSoftInput(this.mClient, windowToken, statsToken, flags, resultReceiver, reason, this.mAsyncShowHideMethodEnabled);
        }
    }

    @LayoutlibDelegate
    private boolean hideSoftInputFromWindow(IBinder iBinder, int n, ResultReceiver resultReceiver, int n2, ImeTracker.Token token) {
        return InputMethodManager_Delegate.hideSoftInputFromWindow(this, iBinder, n, resultReceiver, n2, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hideSoftInputFromView(@NonNull View view, int flags) {
        this.checkFocus();
        boolean isFocusedAndWindowFocused = view.hasWindowFocus() && view.isFocused();
        H h = this.mH;
        synchronized (h) {
            boolean hasServedByInputMethod = this.hasServedByInputMethodLocked(view);
            if (!isFocusedAndWindowFocused && !hasServedByInputMethod) {
                return false;
            }
            int reason = 39;
            ImeTracker.Token statsToken = ImeTracker.forLogging().onStart(2, 5, 39, ImeTracker.isFromUser(view));
            ImeTracker.forLatency().onRequestHide(statsToken, 5, 39, ActivityThread::currentApplication);
            ImeTracing.getInstance().triggerClientDump("InputMethodManager#hideSoftInputFromView", this, null);
            if (!hasServedByInputMethod) {
                ImeTracker.forLogging().onFailed(statsToken, 1);
                ImeTracker.forLatency().onShowFailed(statsToken, 1, ActivityThread::currentApplication);
                Log.w(TAG, "Ignoring hideSoftInputFromView() as view=" + view + " is not served.");
                return false;
            }
            ImeTracker.forLogging().onProgress(statsToken, 1);
            if (Flags.refactorInsetsController()) {
                return this.hideSoftInputFromWindow(view.getWindowToken(), flags, null, 39, statsToken);
            }
            return IInputMethodManagerGlobalInvoker.hideSoftInput(this.mClient, view.getWindowToken(), statsToken, flags, null, 39, this.mAsyncShowHideMethodEnabled);
        }
    }

    @SuppressLint(value={"UnflaggedApi"})
    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    public void hideSoftInputFromServerForTest() {
        IInputMethodManagerGlobalInvoker.hideSoftInputFromServerForTest();
    }

    public void startStylusHandwriting(@NonNull View view) {
        this.startStylusHandwritingInternal(view, null, 0);
    }

    private void sendFailureCallback(@NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        if (executor == null || callback == null) {
            return;
        }
        executor.execute(() -> callback.accept(false));
    }

    private boolean startStylusHandwritingInternal(@NonNull View view, @Nullable String delegatorPackageName, int handwritingDelegateFlags) {
        return this.startStylusHandwritingInternal(view, delegatorPackageName, handwritingDelegateFlags, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean startStylusHandwritingInternal(@NonNull View view, @Nullable String delegatorPackageName, int handwritingDelegateFlags, Executor executor, Consumer<Boolean> callback) {
        Objects.requireNonNull(view);
        boolean useCallback = callback != null;
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.startStylusHandwritingInternal(view, delegatorPackageName, handwritingDelegateFlags, executor, callback);
        }
        boolean useDelegation = !TextUtils.isEmpty(delegatorPackageName);
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view)) {
                Log.w(TAG, "Ignoring startStylusHandwriting as view=" + view + " is not served.");
                this.sendFailureCallback(executor, callback);
                return false;
            }
            if (view.getViewRootImpl() != this.mCurRootView) {
                Log.w(TAG, "Ignoring startStylusHandwriting: View's window does not have focus.");
                this.sendFailureCallback(executor, callback);
                return false;
            }
            if (useDelegation) {
                final WeakReference<Executor> executorRef = new WeakReference<Executor>(executor);
                final WeakReference<Consumer<Boolean>> callbackRef = new WeakReference<Consumer<Boolean>>(callback);
                if (useCallback) {
                    IBooleanListener.Stub listener = new IBooleanListener.Stub(this){

                        @Override
                        public void onResult(boolean value) {
                            Executor executor = (Executor)executorRef.get();
                            Consumer callback = (Consumer)callbackRef.get();
                            if (executor != null && callback != null) {
                                executor.execute(() -> callback.accept(value));
                            }
                        }
                    };
                    if (!IInputMethodManagerGlobalInvoker.acceptStylusHandwritingDelegationAsync(this.mClient, UserHandle.myUserId(), view.getContext().getOpPackageName(), delegatorPackageName, handwritingDelegateFlags, listener)) {
                        this.sendFailureCallback(executor, callback);
                    }
                    return true;
                }
                return IInputMethodManagerGlobalInvoker.acceptStylusHandwritingDelegation(this.mClient, UserHandle.myUserId(), view.getContext().getOpPackageName(), delegatorPackageName, handwritingDelegateFlags);
            }
            IInputMethodManagerGlobalInvoker.startStylusHandwriting(this.mClient);
            return false;
        }
    }

    @FlaggedApi(value="android.view.inputmethod.connectionless_handwriting")
    public void startConnectionlessStylusHandwriting(@NonNull View view, @Nullable CursorAnchorInfo cursorAnchorInfo, @NonNull Executor callbackExecutor, @NonNull ConnectionlessHandwritingCallback callback) {
        this.startConnectionlessStylusHandwritingInternal(view, cursorAnchorInfo, null, null, callbackExecutor, callback);
    }

    @FlaggedApi(value="android.view.inputmethod.connectionless_handwriting")
    public void startConnectionlessStylusHandwritingForDelegation(@NonNull View delegatorView, @Nullable CursorAnchorInfo cursorAnchorInfo, @NonNull Executor callbackExecutor, @NonNull ConnectionlessHandwritingCallback callback) {
        String delegatorPackageName = delegatorView.getContext().getOpPackageName();
        this.startConnectionlessStylusHandwritingInternal(delegatorView, cursorAnchorInfo, delegatorPackageName, delegatorPackageName, callbackExecutor, callback);
    }

    @FlaggedApi(value="android.view.inputmethod.connectionless_handwriting")
    public void startConnectionlessStylusHandwritingForDelegation(@NonNull View delegatorView, @Nullable CursorAnchorInfo cursorAnchorInfo, @NonNull String delegatePackageName, @NonNull Executor callbackExecutor, @NonNull ConnectionlessHandwritingCallback callback) {
        Objects.requireNonNull(delegatePackageName);
        String delegatorPackageName = delegatorView.getContext().getOpPackageName();
        this.startConnectionlessStylusHandwritingInternal(delegatorView, cursorAnchorInfo, delegatorPackageName, delegatePackageName, callbackExecutor, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startConnectionlessStylusHandwritingInternal(@NonNull View view, @Nullable CursorAnchorInfo cursorAnchorInfo, @Nullable String delegatorPackageName, @Nullable String delegatePackageName, @NonNull Executor callbackExecutor, @NonNull ConnectionlessHandwritingCallback callback) {
        Objects.requireNonNull(view);
        Objects.requireNonNull(callbackExecutor);
        Objects.requireNonNull(callback);
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.startConnectionlessStylusHandwritingInternal(view, cursorAnchorInfo, delegatorPackageName, delegatePackageName, callbackExecutor, callback);
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (view.getViewRootImpl() != this.mCurRootView) {
                Log.w(TAG, "Ignoring startConnectionlessStylusHandwriting: View's window does not have focus.");
                return;
            }
            IInputMethodManagerGlobalInvoker.startConnectionlessStylusHandwriting(this.mClient, UserHandle.myUserId(), cursorAnchorInfo, delegatePackageName, delegatorPackageName, new ConnectionlessHandwritingCallbackProxy(callbackExecutor, callback));
        }
    }

    public void prepareStylusHandwritingDelegation(@NonNull View delegatorView) {
        this.prepareStylusHandwritingDelegation(delegatorView, delegatorView.getContext().getOpPackageName());
    }

    public void prepareStylusHandwritingDelegation(@NonNull View delegatorView, @NonNull String delegatePackageName) {
        Objects.requireNonNull(delegatorView);
        Objects.requireNonNull(delegatePackageName);
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(delegatorView);
        if (fallbackImm != null) {
            fallbackImm.prepareStylusHandwritingDelegation(delegatorView, delegatePackageName);
        }
        IInputMethodManagerGlobalInvoker.prepareStylusHandwritingDelegation(this.mClient, UserHandle.myUserId(), delegatePackageName, delegatorView.getContext().getOpPackageName());
    }

    public boolean acceptStylusHandwritingDelegation(@NonNull View delegateView) {
        return this.startStylusHandwritingInternal(delegateView, delegateView.getContext().getOpPackageName(), delegateView.getHandwritingDelegateFlags());
    }

    public boolean acceptStylusHandwritingDelegation(@NonNull View delegateView, @NonNull String delegatorPackageName) {
        Objects.requireNonNull(delegatorPackageName);
        return this.startStylusHandwritingInternal(delegateView, delegatorPackageName, delegateView.getHandwritingDelegateFlags());
    }

    @FlaggedApi(value="android.view.inputmethod.use_zero_jank_proxy")
    public void acceptStylusHandwritingDelegation(@NonNull View delegateView, @NonNull String delegatorPackageName, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        Objects.requireNonNull(delegatorPackageName);
        int flags = 0;
        if (Flags.homeScreenHandwritingDelegator()) {
            flags = delegateView.getHandwritingDelegateFlags();
        }
        this.acceptStylusHandwritingDelegation(delegateView, delegatorPackageName, flags, executor, callback);
    }

    @FlaggedApi(value="android.view.inputmethod.home_screen_handwriting_delegator")
    public void acceptStylusHandwritingDelegation(@NonNull View delegateView, @NonNull String delegatorPackageName, int flags, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        Objects.requireNonNull(delegatorPackageName);
        Objects.requireNonNull(delegateView);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        this.startStylusHandwritingInternal(delegateView, delegatorPackageName, flags, executor, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void toggleSoftInputFromWindow(IBinder windowToken, int showFlags, int hideFlags) {
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#toggleSoftInputFromWindow", this, null);
        H h = this.mH;
        synchronized (h) {
            View servedView = this.getServedViewLocked();
            if (servedView == null || servedView.getWindowToken() != windowToken) {
                return;
            }
            this.toggleSoftInput(showFlags, hideFlags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void toggleSoftInput(int showFlags, int hideFlags) {
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#toggleSoftInput", this, null);
        H h = this.mH;
        synchronized (h) {
            View view = this.getServedViewLocked();
            if (view != null) {
                WindowInsets rootInsets = view.getRootWindowInsets();
                if (rootInsets != null && rootInsets.isVisible(WindowInsets.Type.ime())) {
                    this.hideSoftInputFromWindow(view.getWindowToken(), hideFlags, null, 25, null);
                } else {
                    this.showSoftInput(view, showFlags, null, 24);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartInput(View view) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.restartInput(view);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view)) {
                return;
            }
            this.mServedConnecting = true;
        }
        this.startInputInner(4, null, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doInvalidateInput(@NonNull RemoteInputConnectionImpl inputConnection, @NonNull TextSnapshot textSnapshot, int sessionId) {
        H h = this.mH;
        synchronized (h) {
            if (this.mServedInputConnection != inputConnection || this.mCurrentEditorInfo == null) {
                return true;
            }
            if (!this.isImeSessionAvailableLocked()) {
                return false;
            }
            EditorInfo editorInfo = this.mCurrentEditorInfo.createCopyInternal();
            editorInfo.initialSelStart = this.mCursorSelStart = textSnapshot.getSelectionStart();
            editorInfo.initialSelEnd = this.mCursorSelEnd = textSnapshot.getSelectionEnd();
            this.mCursorCandStart = textSnapshot.getCompositionStart();
            this.mCursorCandEnd = textSnapshot.getCompositionEnd();
            editorInfo.initialCapsMode = textSnapshot.getCursorCapsMode();
            editorInfo.setInitialSurroundingTextInternal(textSnapshot.getSurroundingText());
            this.mCurBindState.mImeSession.invalidateInput(editorInfo, this.mServedInputConnection, sessionId);
            IRemoteAccessibilityInputConnection accessibilityInputConnection = this.mServedInputConnection.asIRemoteAccessibilityInputConnection();
            this.forAccessibilitySessionsLocked(wrapper -> wrapper.invalidateInput(editorInfo, accessibilityInputConnection, sessionId));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateInput(@NonNull View view) {
        Objects.requireNonNull(view);
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.invalidateInput(view);
            return;
        }
        H h = this.mH;
        synchronized (h) {
            if (this.mServedInputConnection == null || this.getServedViewLocked() != view) {
                return;
            }
            this.mServedInputConnection.scheduleInvalidateInput(this.mLastPendingStartSeqId != -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    private boolean startInputInner(int startInputReason, @Nullable IBinder windowGainingFocus, int startInputFlags, int softInputMode, int windowFlags) {
        boolean hasServedView;
        Handler icHandler;
        View view;
        H h = this.mH;
        synchronized (h) {
            view = this.getServedViewLocked();
            if (view == null) {
                return false;
            }
        }
        Handler vh = view.getHandler();
        if (vh == null) {
            this.closeCurrentInput();
            return false;
        }
        if (vh.getLooper() != Looper.myLooper()) {
            vh.post(() -> this.startInputOnWindowFocusGainInternal(startInputReason, null, 0, 0, 0));
            return false;
        }
        if (windowGainingFocus == null) {
            windowGainingFocus = view.getWindowToken();
            if (windowGainingFocus == null) {
                Log.e(TAG, "ABORT input: ServedView must be attached to a Window");
                return false;
            }
            startInputFlags = this.getStartInputFlags(view, startInputFlags);
            softInputMode = view.getViewRootImpl().mWindowAttributes.softInputMode;
            windowFlags = view.getViewRootImpl().mWindowAttributes.flags;
        }
        Pair<InputConnection, EditorInfo> connectionPair = InputMethodManager.createInputConnection(view);
        final InputConnection ic = (InputConnection)connectionPair.first;
        final EditorInfo editorInfo = (EditorInfo)connectionPair.second;
        InputBindResult res = null;
        H h2 = this.mH;
        synchronized (h2) {
            RemoteInputConnectionImpl servedInputConnection;
            View servedView = this.getServedViewLocked();
            if (servedView != view || !this.mServedConnecting) {
                if (this.mServedInputConnection != null && startInputReason == 6) {
                    this.reportInputConnectionOpened(this.mServedInputConnection.getInputConnection(), this.mCurrentEditorInfo, this.mServedInputConnectionHandler, view);
                }
                return false;
            }
            if (this.mCurrentEditorInfo == null) {
                startInputFlags |= 4;
            }
            editorInfo.setInitialToolType(this.mCurRootView.getLastClickToolType());
            this.mCurrentEditorInfo = editorInfo.createCopyInternal();
            RemoteInputConnectionImpl previouslyServedConnection = this.mServedInputConnection;
            this.mServedConnecting = false;
            if (this.mServedInputConnection != null) {
                this.mServedInputConnection.deactivate();
                this.mServedInputConnection = null;
                this.mServedInputConnectionHandler = null;
            }
            if (ic != null) {
                this.mCursorSelStart = editorInfo.initialSelStart;
                this.mCursorSelEnd = editorInfo.initialSelEnd;
                this.mInitialSelStart = this.mCursorSelStart;
                this.mInitialSelEnd = this.mCursorSelEnd;
                this.mCursorCandStart = -1;
                this.mCursorCandEnd = -1;
                this.mCursorRect.setEmpty();
                this.mCursorAnchorInfo = null;
                Handler handler = null;
                try {
                    handler = ic.getHandler();
                }
                catch (AbstractMethodError abstractMethodError) {
                    // empty catch block
                }
                this.mServedInputConnectionHandler = icHandler = handler;
                servedInputConnection = new RemoteInputConnectionImpl(icHandler != null ? icHandler.getLooper() : vh.getLooper(), ic, this, view);
            } else {
                servedInputConnection = null;
                icHandler = null;
                this.mServedInputConnectionHandler = null;
            }
            this.mServedInputConnection = servedInputConnection;
            boolean imeRequestedVisible = InputMethodManager.hasViewImeRequestedVisible(servedView);
            boolean canSkip = OPTIMIZE_NONEDITABLE_VIEWS && previouslyServedConnection == null && ic == null && this.isSwitchingBetweenEquivalentNonEditableViews(this.mPreviousViewFocusParameters, startInputFlags, startInputReason, softInputMode, windowFlags);
            this.mPreviousViewFocusParameters = new ViewFocusParameterInfo(this.mCurrentEditorInfo, startInputFlags, startInputReason, softInputMode, windowFlags);
            if (canSkip) {
                return false;
            }
            int targetUserId = editorInfo.targetInputMethodUser != null ? editorInfo.targetInputMethodUser.getIdentifier() : UserHandle.myUserId();
            Trace.traceBegin(32L, "IMM.startInputOrWindowGainedFocus");
            int startInputSeq = -1;
            if (Flags.useZeroJankProxy()) {
                startInputSeq = IInputMethodManagerGlobalInvoker.startInputOrWindowGainedFocusAsync(startInputReason, this.mClient, windowGainingFocus, startInputFlags, softInputMode, windowFlags, editorInfo, servedInputConnection, servedInputConnection == null ? null : servedInputConnection.asIRemoteAccessibilityInputConnection(), view.getContext().getApplicationInfo().targetSdkVersion, targetUserId, this.mImeDispatcher, imeRequestedVisible, this.mAsyncShowHideMethodEnabled);
            } else {
                res = IInputMethodManagerGlobalInvoker.startInputOrWindowGainedFocus(startInputReason, this.mClient, windowGainingFocus, startInputFlags, softInputMode, windowFlags, editorInfo, servedInputConnection, servedInputConnection == null ? null : servedInputConnection.asIRemoteAccessibilityInputConnection(), view.getContext().getApplicationInfo().targetSdkVersion, targetUserId, this.mImeDispatcher, imeRequestedVisible);
            }
            Trace.traceEnd(32L);
            if (Flags.useZeroJankProxy()) {
                if (ic != null) {
                    final int seqId = startInputSeq;
                    if (Flags.invalidateInputCallsRestart()) {
                        this.mLastPendingStartSeqId = seqId;
                    }
                    this.mReportInputConnectionOpenedRunner = new ReportInputConnectionOpenedRunner(startInputSeq){

                        @Override
                        public void run() {
                            InputMethodManager.this.reportInputConnectionOpened(ic, editorInfo, icHandler, view);
                        }
                    };
                } else {
                    this.mReportInputConnectionOpenedRunner = null;
                }
                return true;
            }
            if (res == null) {
                Log.wtf(TAG, "startInputOrWindowGainedFocus must not return null. startInputReason=" + InputMethodDebug.startInputReasonToString(startInputReason) + " editorInfo=" + editorInfo + " startInputFlags=" + InputMethodDebug.startInputFlagsToString(startInputFlags));
                return false;
            }
            if (res.id != null) {
                this.updateInputChannelLocked(res.channel);
                this.mCurMethod = res.method;
                this.mCurBindState = new BindState(res);
                this.mAccessibilityInputMethodSession.clear();
                if (res.accessibilitySessions != null) {
                    for (int i = 0; i < res.accessibilitySessions.size(); ++i) {
                        IAccessibilityInputMethodSessionInvoker wrapper = IAccessibilityInputMethodSessionInvoker.createOrNull(res.accessibilitySessions.valueAt(i));
                        if (wrapper == null) continue;
                        this.mAccessibilityInputMethodSession.append(res.accessibilitySessions.keyAt(i), wrapper);
                    }
                }
                this.mCurId = res.id;
            } else if (res.channel != null && res.channel != this.mCurChannel) {
                res.channel.dispose();
            }
            switch (res.result) {
                case 12: {
                    this.mRestartOnNextWindowFocus = true;
                    if (Flags.initiationWithoutInputConnection()) {
                        this.mServedView.getViewRootImpl().getHandwritingInitiator().clearFocusedView(this.mServedView);
                    }
                    this.mServedView = null;
                }
            }
            if (this.mCompletions != null && this.isImeSessionAvailableLocked()) {
                this.mCurBindState.mImeSession.displayCompletions(this.mCompletions);
            }
            hasServedView = this.mServedView != null;
        }
        if (ic != null && res != null && res.method != null && hasServedView) {
            this.reportInputConnectionOpened(ic, editorInfo, icHandler, view);
        }
        return true;
    }

    @GuardedBy(value={"mH"})
    private boolean isSwitchingBetweenEquivalentNonEditableViews(@Nullable ViewFocusParameterInfo previousViewFocusParameters, int startInputFlags, int startInputReason, int softInputMode, int windowFlags) {
        return (startInputFlags & 8) == 0 && (startInputFlags & 2) == 0 && previousViewFocusParameters != null && previousViewFocusParameters.sameAs(this.mCurrentEditorInfo, startInputFlags, startInputReason, softInputMode, windowFlags);
    }

    private void reportInputConnectionOpened(InputConnection ic, EditorInfo editorInfo, Handler icHandler, View view) {
        view.onInputConnectionOpenedInternal(ic, editorInfo, icHandler);
        ViewRootImpl viewRoot = view.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.getHandwritingInitiator().onInputConnectionCreated(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    public void addVirtualStylusIdForTestSession() {
        H h = this.mH;
        synchronized (h) {
            IInputMethodManagerGlobalInvoker.addVirtualStylusIdForTestSession(this.mClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    public void setStylusWindowIdleTimeoutForTest(long timeout) {
        H h = this.mH;
        synchronized (h) {
            IInputMethodManagerGlobalInvoker.setStylusWindowIdleTimeoutForTest(this.mClient, timeout);
        }
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=37122102L, maxTargetSdk=29, publicAlternatives="{@code androidx.activity.ComponentActivity}")
    public void windowDismissed(IBinder appWindowToken) {
    }

    private int getStartInputFlags(View focusedView, int startInputFlags) {
        startInputFlags |= 1;
        if (focusedView.onCheckIsTextEditor()) {
            startInputFlags |= 2;
        }
        return startInputFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public void checkFocus() {
        H h = this.mH;
        synchronized (h) {
            if (this.mCurRootView == null) {
                return;
            }
            if (!this.checkFocusInternalLocked(false, this.mCurRootView)) {
                return;
            }
        }
        this.startInputOnWindowFocusGainInternal(5, null, 0, 0, 0);
    }

    public ImeOnBackInvokedDispatcher getImeOnBackInvokedDispatcher() {
        return this.mImeDispatcher;
    }

    @GuardedBy(value={"mH"})
    private boolean checkFocusInternalLocked(boolean forceNewFocus, ViewRootImpl viewRootImpl) {
        if (this.mCurRootView != viewRootImpl) {
            return false;
        }
        if (this.mServedView == this.mNextServedView && !forceNewFocus) {
            return false;
        }
        if (this.mNextServedView == null) {
            this.finishInputLocked();
            this.closeCurrentInput();
            return false;
        }
        this.mServedView = this.mNextServedView;
        if (this.mServedInputConnection != null) {
            this.mServedInputConnection.finishComposingTextFromImm();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onViewFocusChangedInternal(@Nullable View view, boolean hasFocus) {
        if (view == null || view.isTemporarilyDetached()) {
            return;
        }
        ViewRootImpl viewRootImpl = view.getViewRootImpl();
        H h = this.mH;
        synchronized (h) {
            if (this.mCurRootView != viewRootImpl) {
                return;
            }
            if (!view.hasImeFocus() || !view.hasWindowFocus()) {
                return;
            }
            if (hasFocus) {
                this.mNextServedView = view;
            }
        }
        viewRootImpl.dispatchCheckFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    void closeCurrentInput() {
        int reason = 38;
        ImeTracker.Token statsToken = ImeTracker.forLogging().onStart(2, 5, 38, false);
        ImeTracker.forLatency().onRequestHide(statsToken, 5, 38, ActivityThread::currentApplication);
        H h = this.mH;
        synchronized (h) {
            View rootView;
            View view = rootView = this.mCurRootView != null ? this.mCurRootView.getView() : null;
            if (rootView == null) {
                ImeTracker.forLogging().onFailed(statsToken, 1);
                ImeTracker.forLatency().onHideFailed(statsToken, 1, ActivityThread::currentApplication);
                Log.w(TAG, "No current root view, ignoring closeCurrentInput()");
                return;
            }
            ImeTracker.forLogging().onProgress(statsToken, 1);
            if (Flags.refactorInsetsController()) {
                H h2 = this.mH;
                synchronized (h2) {
                    Handler vh = rootView.getHandler();
                    if (vh == null) {
                        ImeTracker.forLogging().onFailed(statsToken, 66);
                        return;
                    }
                    ImeTracker.forLogging().onProgress(statsToken, 66);
                    if (vh.getLooper() != Looper.myLooper()) {
                        ViewRootImpl viewRootImpl = this.mCurRootView;
                        vh.post(() -> viewRootImpl.getInsetsController().hide(WindowInsets.Type.ime(), false, statsToken));
                    } else {
                        this.mCurRootView.getInsetsController().hide(WindowInsets.Type.ime(), false, statsToken);
                    }
                }
            } else {
                IInputMethodManagerGlobalInvoker.hideSoftInput(this.mClient, rootView.getWindowToken(), statsToken, 2, null, 38, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerImeConsumer(@NonNull ImeInsetsSourceConsumer imeInsetsConsumer) {
        if (imeInsetsConsumer == null) {
            throw new IllegalStateException("ImeInsetsSourceConsumer cannot be null.");
        }
        H h = this.mH;
        synchronized (h) {
            this.mImeInsetsConsumer = imeInsetsConsumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterImeConsumer(@NonNull ImeInsetsSourceConsumer imeInsetsConsumer) {
        if (imeInsetsConsumer == null) {
            throw new IllegalStateException("ImeInsetsSourceConsumer cannot be null.");
        }
        H h = this.mH;
        synchronized (h) {
            if (this.mImeInsetsConsumer == imeInsetsConsumer) {
                this.mImeInsetsConsumer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestImeShow(IBinder windowToken, @NonNull ImeTracker.Token statsToken) {
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            View servedView = this.getServedViewLocked();
            if (servedView == null || servedView.getWindowToken() != windowToken) {
                ImeTracker.forLogging().onFailed(statsToken, 37);
                return false;
            }
            ImeTracker.forLogging().onProgress(statsToken, 37);
            this.showSoftInput(servedView, statsToken, 0, null, 26);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyImeHidden(IBinder windowToken, @NonNull ImeTracker.Token statsToken) {
        ImeTracker.forLatency().onRequestHide(statsToken, 5, 28, ActivityThread::currentApplication);
        ImeTracing.getInstance().triggerClientDump("InputMethodManager#notifyImeHidden", this, null);
        H h = this.mH;
        synchronized (h) {
            if (!this.isImeSessionAvailableLocked() || this.mCurRootView == null || this.mCurRootView.getWindowToken() != windowToken) {
                ImeTracker.forLogging().onFailed(statsToken, 1);
                ImeTracker.forLatency().onHideFailed(statsToken, 1, ActivityThread::currentApplication);
                return;
            }
            ImeTracker.forLogging().onProgress(statsToken, 1);
            IInputMethodManagerGlobalInvoker.hideSoftInput(this.mClient, windowToken, statsToken, 0, null, 28, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImeSurface(@NonNull IBinder windowToken) {
        H h = this.mH;
        synchronized (h) {
            IInputMethodManagerGlobalInvoker.removeImeSurfaceFromWindowAsync(windowToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(View view, int selStart, int selEnd, int candidatesStart, int candidatesEnd) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.updateSelection(view, selStart, selEnd, candidatesStart, candidatesEnd);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentEditorInfo == null || !this.isImeSessionAvailableLocked()) {
                return;
            }
            if (this.mServedInputConnection != null && this.mServedInputConnection.hasPendingInvalidation()) {
                return;
            }
            if (this.mCursorSelStart != selStart || this.mCursorSelEnd != selEnd || this.mCursorCandStart != candidatesStart || this.mCursorCandEnd != candidatesEnd) {
                this.mCurBindState.mImeSession.updateSelection(this.mCursorSelStart, this.mCursorSelEnd, selStart, selEnd, candidatesStart, candidatesEnd);
                this.forAccessibilitySessionsLocked(wrapper -> wrapper.updateSelection(this.mCursorSelStart, this.mCursorSelEnd, selStart, selEnd, candidatesStart, candidatesEnd));
                this.mCursorSelStart = selStart;
                this.mCursorSelEnd = selEnd;
                this.mCursorCandStart = candidatesStart;
                this.mCursorCandEnd = candidatesEnd;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void viewClicked(View view) {
        View nextServedView;
        View servedView;
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.viewClicked(view);
            return;
        }
        H h = this.mH;
        synchronized (h) {
            servedView = this.getServedViewLocked();
            nextServedView = this.getNextServedViewLocked();
        }
        boolean focusChanged = servedView != nextServedView;
        this.checkFocus();
        H h2 = this.mH;
        synchronized (h2) {
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentEditorInfo == null || !this.isImeSessionAvailableLocked()) {
                return;
            }
            this.mCurBindState.mImeSession.viewClicked(focusChanged);
        }
    }

    @Deprecated
    public boolean isWatchingCursor(View view) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isCursorAnchorInfoEnabled() {
        H h = this.mH;
        synchronized (h) {
            boolean isImmediate = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 1) != 0;
            boolean isMonitoring = (this.mRequestUpdateCursorAnchorInfoMonitorMode & 2) != 0;
            return isImmediate || isMonitoring;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setUpdateCursorAnchorInfoMode(int flags) {
        H h = this.mH;
        synchronized (h) {
            this.mRequestUpdateCursorAnchorInfoMonitorMode = flags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void updateCursor(View view, int left, int top, int right, int bottom) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.updateCursor(view, left, top, right, bottom);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentEditorInfo == null || !this.isImeSessionAvailableLocked()) {
                return;
            }
            this.mTmpCursorRect.set(left, top, right, bottom);
            if (!this.mCursorRect.equals(this.mTmpCursorRect)) {
                this.mCurBindState.mImeSession.updateCursor(this.mTmpCursorRect);
                this.mCursorRect.set(this.mTmpCursorRect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCursorAnchorInfo(View view, CursorAnchorInfo cursorAnchorInfo) {
        if (view == null || cursorAnchorInfo == null) {
            return;
        }
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.updateCursorAnchorInfo(view, cursorAnchorInfo);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            boolean isImmediate;
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentEditorInfo == null || !this.isImeSessionAvailableLocked()) {
                return;
            }
            boolean bl = isImmediate = this.mServedInputConnection != null && this.mServedInputConnection.resetHasPendingImmediateCursorAnchorInfoUpdate();
            if (!isImmediate && Objects.equals(this.mCursorAnchorInfo, cursorAnchorInfo)) {
                return;
            }
            this.mCurBindState.mImeSession.updateCursorAnchorInfo(cursorAnchorInfo);
            this.mCursorAnchorInfo = cursorAnchorInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAppPrivateCommand(View view, String action, Bundle data) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(view);
        if (fallbackImm != null) {
            fallbackImm.sendAppPrivateCommand(view, action, data);
            return;
        }
        this.checkFocus();
        H h = this.mH;
        synchronized (h) {
            if (!this.hasServedByInputMethodLocked(view) || this.mCurrentEditorInfo == null || !this.isImeSessionAvailableLocked()) {
                return;
            }
            this.mCurBindState.mImeSession.appPrivateCommand(action, data);
        }
    }

    @Deprecated
    public void setInputMethod(IBinder token, String id2) {
        if (token == null) {
            if (id2 == null) {
                return;
            }
            if (Process.myUid() == 1000) {
                Log.w(TAG, "System process should not be calling setInputMethod() because almost always it is a bug under multi-user / multi-profile environment. Consider interacting with InputMethodManagerService directly via LocalServices.");
                return;
            }
            Application fallbackContext = ActivityThread.currentApplication();
            if (fallbackContext == null) {
                return;
            }
            if (((Context)fallbackContext).checkSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
                return;
            }
            List<InputMethodInfo> imis = this.getEnabledInputMethodList();
            int numImis = imis.size();
            boolean found = false;
            for (int i = 0; i < numImis; ++i) {
                InputMethodInfo imi = imis.get(i);
                if (!id2.equals(imi.getId())) continue;
                found = true;
                break;
            }
            if (!found) {
                Log.e(TAG, "Ignoring setInputMethod(null, " + id2 + ") because the specified id not found in enabled IMEs.");
                return;
            }
            Log.w(TAG, "The undocumented behavior that setInputMethod() accepts null token when the caller has WRITE_SECURE_SETTINGS is deprecated. This behavior may be completely removed in a future version.  Update secure settings directly instead.");
            ContentResolver resolver = ((Context)fallbackContext).getContentResolver();
            Settings.Secure.putInt(resolver, "selected_input_method_subtype", -1);
            Settings.Secure.putString(resolver, "default_input_method", id2);
            return;
        }
        InputMethodPrivilegedOperationsRegistry.get(token).setInputMethod(id2);
    }

    @Deprecated
    public void setInputMethodAndSubtype(@NonNull IBinder token, String id2, InputMethodSubtype subtype) {
        if (token == null) {
            Log.e(TAG, "setInputMethodAndSubtype() does not accept null token on Android Q and later.");
            return;
        }
        InputMethodPrivilegedOperationsRegistry.get(token).setInputMethodAndSubtype(id2, subtype);
    }

    @Deprecated
    public void hideSoftInputFromInputMethod(IBinder token, int flags) {
        int reason = 32;
        ImeTracker.Token statsToken = ImeTracker.forLogging().onStart(2, 5, 32, false);
        InputMethodPrivilegedOperationsRegistry.get(token).hideMySoftInput(statsToken, flags, 32);
    }

    @Deprecated
    public void showSoftInputFromInputMethod(IBinder token, int flags) {
        int reason = 54;
        ImeTracker.Token statsToken = ImeTracker.forLogging().onStart(1, 5, 54, false);
        InputMethodPrivilegedOperationsRegistry.get(token).showMySoftInput(statsToken, flags, 54);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dispatchInputEvent(InputEvent event, Object token, FinishedInputEventCallback callback, Handler handler) {
        H h = this.mH;
        synchronized (h) {
            if (this.isImeSessionAvailableLocked()) {
                KeyEvent keyEvent;
                if (event instanceof KeyEvent && (keyEvent = (KeyEvent)event).getAction() == 0 && keyEvent.getKeyCode() == 63 && keyEvent.getRepeatCount() == 0) {
                    this.showInputMethodPickerLocked();
                    return 1;
                }
                PendingEvent p = this.obtainPendingEventLocked(event, token, this.mCurBindState.mImeId, callback, handler);
                if (this.mMainLooper.isCurrentThread()) {
                    return this.sendInputEventOnMainLooperLocked(p);
                }
                Message msg = this.mH.obtainMessage(5, p);
                msg.setAsynchronous(true);
                this.mH.sendMessage(msg);
                return -1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchKeyEventFromInputMethod(@Nullable View targetView, @NonNull KeyEvent event) {
        InputMethodManager fallbackImm = this.getFallbackInputMethodManagerIfNecessary(targetView);
        if (fallbackImm != null) {
            fallbackImm.dispatchKeyEventFromInputMethod(targetView, event);
            return;
        }
        H h = this.mH;
        synchronized (h) {
            View servedView;
            ViewRootImpl viewRootImpl;
            ViewRootImpl viewRootImpl2 = viewRootImpl = targetView != null ? targetView.getViewRootImpl() : null;
            if (viewRootImpl == null && (servedView = this.getServedViewLocked()) != null) {
                viewRootImpl = servedView.getViewRootImpl();
            }
            if (viewRootImpl != null) {
                viewRootImpl.dispatchKeyFromIme(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendInputEventAndReportResultOnMainLooper(PendingEvent p) {
        boolean handled;
        H h = this.mH;
        synchronized (h) {
            int result = this.sendInputEventOnMainLooperLocked(p);
            if (result == -1) {
                return;
            }
            handled = result == 1;
        }
        this.invokeFinishedInputEventCallback(p, handled);
    }

    @GuardedBy(value={"mH"})
    private int sendInputEventOnMainLooperLocked(PendingEvent p) {
        if (this.mCurChannel != null) {
            InputEvent event;
            int seq;
            if (this.mCurSender == null) {
                this.mCurSender = new ImeInputEventSender(this.mCurChannel, this.mH.getLooper());
            }
            if (this.mCurSender.sendInputEvent(seq = (event = p.mEvent).getSequenceNumber(), event)) {
                this.mPendingEvents.put(seq, p);
                Trace.traceCounter(4L, PENDING_EVENT_COUNTER, this.mPendingEvents.size());
                Message msg = this.mH.obtainMessage(6, seq, 0, p);
                msg.setAsynchronous(true);
                this.mH.sendMessageDelayed(msg, 2500L);
                return -1;
            }
            if (sPreventImeStartupUnlessTextEditor) {
                Log.d(TAG, "Dropping event because IME is evicted: " + event);
            } else {
                Log.w(TAG, "Unable to send input event to IME: " + this.getImeIdLocked() + " dropping: " + event);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishedInputEvent(int seq, boolean handled, boolean timeout) {
        PendingEvent p;
        H h = this.mH;
        synchronized (h) {
            int index = this.mPendingEvents.indexOfKey(seq);
            if (index < 0) {
                return;
            }
            p = this.mPendingEvents.valueAt(index);
            this.mPendingEvents.removeAt(index);
            Trace.traceCounter(4L, PENDING_EVENT_COUNTER, this.mPendingEvents.size());
            if (timeout) {
                Log.w(TAG, "Timeout waiting for IME to handle input event after 2500 ms: " + p.mInputMethodId);
            } else {
                this.mH.removeMessages(6, p);
            }
        }
        this.invokeFinishedInputEventCallback(p, handled);
    }

    private void invokeFinishedInputEventCallback(PendingEvent p, boolean handled) {
        p.mHandled = handled;
        if (p.mHandler.getLooper().isCurrentThread()) {
            p.run();
        } else {
            Message msg = Message.obtain(p.mHandler, p);
            msg.setAsynchronous(true);
            msg.sendToTarget();
        }
    }

    @GuardedBy(value={"mH"})
    private void flushPendingEventsLocked() {
        this.mH.removeMessages(7);
        int count = this.mPendingEvents.size();
        for (int i = 0; i < count; ++i) {
            int seq = this.mPendingEvents.keyAt(i);
            Message msg = this.mH.obtainMessage(7, seq, 0);
            msg.setAsynchronous(true);
            msg.sendToTarget();
        }
    }

    @GuardedBy(value={"mH"})
    private PendingEvent obtainPendingEventLocked(InputEvent event, Object token, String inputMethodId, FinishedInputEventCallback callback, Handler handler) {
        PendingEvent p = this.mPendingEventPool.acquire();
        if (p == null) {
            p = new PendingEvent();
        }
        p.mEvent = event;
        p.mToken = token;
        p.mInputMethodId = inputMethodId;
        p.mCallback = callback;
        p.mHandler = handler;
        return p;
    }

    @GuardedBy(value={"mH"})
    private void recyclePendingEventLocked(PendingEvent p) {
        p.recycle();
        this.mPendingEventPool.release(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInputMethodPicker() {
        H h = this.mH;
        synchronized (h) {
            this.showInputMethodPickerLocked();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void showInputMethodPickerFromSystem(boolean showAuxiliarySubtypes, int displayId) {
        int mode = showAuxiliarySubtypes ? 1 : 2;
        IInputMethodManagerGlobalInvoker.showInputMethodPickerFromSystem(mode, displayId);
    }

    @GuardedBy(value={"mH"})
    private void showInputMethodPickerLocked() {
        IInputMethodManagerGlobalInvoker.showInputMethodPickerFromClient(this.mClient, 0);
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    public boolean isInputMethodPickerShown() {
        return IInputMethodManagerGlobalInvoker.isInputMethodPickerShownForTest();
    }

    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void onImeSwitchButtonClickFromSystem(int displayId) {
        IInputMethodManagerGlobalInvoker.onImeSwitchButtonClickFromSystem(displayId);
    }

    @SuppressLint(value={"UnflaggedApi"})
    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    public boolean shouldShowImeSwitcherButtonForTest() {
        return IInputMethodManagerGlobalInvoker.shouldShowImeSwitcherButtonForTest();
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    public boolean hasPendingImeVisibilityRequests() {
        return IInputMethodManagerGlobalInvoker.hasPendingImeVisibilityRequests();
    }

    @SuppressLint(value={"UnflaggedApi"})
    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    public void finishTrackingPendingImeVisibilityRequests() {
        IInputMethodManagerGlobalInvoker.finishTrackingPendingImeVisibilityRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showInputMethodAndSubtypeEnabler(@Nullable String imiId) {
        Context context = null;
        H h = this.mH;
        synchronized (h) {
            if (this.mCurRootView != null) {
                context = this.mCurRootView.mContext;
            }
        }
        if (context == null) {
            Application appContext = ActivityThread.currentApplication();
            DisplayManager displayManager = appContext.getSystemService(DisplayManager.class);
            context = ((Context)appContext).createDisplayContext(displayManager.getDisplay(this.mDisplayId));
        }
        Intent intent = new Intent("android.settings.INPUT_METHOD_SUBTYPE_SETTINGS");
        intent.setFlags(337641472);
        if (!TextUtils.isEmpty(imiId)) {
            intent.putExtra("input_method_id", imiId);
        }
        context.startActivity(intent);
    }

    @Nullable
    public InputMethodSubtype getCurrentInputMethodSubtype() {
        return IInputMethodManagerGlobalInvoker.getCurrentInputMethodSubtype(UserHandle.myUserId());
    }

    @Deprecated
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean setCurrentInputMethodSubtype(InputMethodSubtype subtype) {
        if (Process.myUid() == 1000) {
            Log.w(TAG, "System process should not call setCurrentInputMethodSubtype() because almost always it is a bug under multi-user / multi-profile environment. Consider directly interacting with InputMethodManagerService via LocalServices.");
            return false;
        }
        if (subtype == null) {
            return false;
        }
        Application fallbackContext = ActivityThread.currentApplication();
        if (fallbackContext == null) {
            return false;
        }
        if (((Context)fallbackContext).checkSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            return false;
        }
        ContentResolver contentResolver = ((Context)fallbackContext).getContentResolver();
        String imeId = Settings.Secure.getString(contentResolver, "default_input_method");
        if (ComponentName.unflattenFromString(imeId) == null) {
            return false;
        }
        List<InputMethodSubtype> enabledSubtypes = IInputMethodManagerGlobalInvoker.getEnabledInputMethodSubtypeList(imeId, true, UserHandle.myUserId());
        int numSubtypes = enabledSubtypes.size();
        for (int i = 0; i < numSubtypes; ++i) {
            InputMethodSubtype enabledSubtype = enabledSubtypes.get(i);
            if (!enabledSubtype.equals(subtype)) continue;
            Settings.Secure.putInt(contentResolver, "selected_input_method_subtype", enabledSubtype.hashCode());
            return true;
        }
        return false;
    }

    @Deprecated
    @UnsupportedAppUsage(trackingBug=114740982L, maxTargetSdk=28)
    public void notifyUserAction() {
        Log.w(TAG, "notifyUserAction() is a hidden method, which is now just a stub method that does nothing.  Leave comments in b.android.com/114740982 if your  application still depends on the previous behavior of this method.");
    }

    public Map<InputMethodInfo, List<InputMethodSubtype>> getShortcutInputMethodsAndSubtypes() {
        List<InputMethodInfo> enabledImes = this.getEnabledInputMethodList();
        enabledImes.sort(Comparator.comparingInt(imi -> imi.isSystem() ? 0 : 1));
        int numEnabledImes = enabledImes.size();
        for (int imiIndex = 0; imiIndex < numEnabledImes; ++imiIndex) {
            InputMethodInfo imi2 = enabledImes.get(imiIndex);
            List<InputMethodSubtype> subtypes = this.getEnabledInputMethodSubtypeList(imi2, true);
            int subtypeCount = subtypes.size();
            for (int subtypeIndex = 0; subtypeIndex < subtypeCount; ++subtypeIndex) {
                InputMethodSubtype subtype = imi2.getSubtypeAt(subtypeIndex);
                if (!SUBTYPE_MODE_VOICE.equals(subtype.getMode())) continue;
                return Collections.singletonMap(imi2, Collections.singletonList(subtype));
            }
        }
        return Collections.emptyMap();
    }

    @UnsupportedAppUsage(trackingBug=204906124L, maxTargetSdk=33, publicAlternatives="Use {@link android.view.WindowInsets} instead")
    public int getInputMethodWindowVisibleHeight() {
        return IInputMethodManagerGlobalInvoker.getInputMethodWindowVisibleHeight(this.mClient);
    }

    public void setRequestCursorUpdateDisplayIdCheck(boolean enabled) {
        this.mRequestCursorUpdateDisplayIdCheck.set(enabled);
    }

    @Deprecated
    public boolean switchToLastInputMethod(IBinder imeToken) {
        return InputMethodPrivilegedOperationsRegistry.get(imeToken).switchToPreviousInputMethod();
    }

    @Deprecated
    public boolean switchToNextInputMethod(IBinder imeToken, boolean onlyCurrentIme) {
        return InputMethodPrivilegedOperationsRegistry.get(imeToken).switchToNextInputMethod(onlyCurrentIme);
    }

    @Deprecated
    public boolean shouldOfferSwitchingToNextInputMethod(IBinder imeToken) {
        return InputMethodPrivilegedOperationsRegistry.get(imeToken).shouldOfferSwitchingToNextInputMethod();
    }

    @Deprecated
    public void setAdditionalInputMethodSubtypes(@NonNull String imiId, @NonNull InputMethodSubtype[] subtypes) {
        IInputMethodManagerGlobalInvoker.setAdditionalInputMethodSubtypes(imiId, subtypes, UserHandle.myUserId());
    }

    public void setExplicitlyEnabledInputMethodSubtypes(@NonNull String imiId, @NonNull int[] subtypeHashCodes) {
        IInputMethodManagerGlobalInvoker.setExplicitlyEnabledInputMethodSubtypes(imiId, subtypeHashCodes, UserHandle.myUserId());
    }

    @Nullable
    public InputMethodSubtype getLastInputMethodSubtype() {
        return IInputMethodManagerGlobalInvoker.getLastInputMethodSubtype(UserHandle.myUserId());
    }

    public int getDisplayId() {
        return this.mDisplayId;
    }

    private void doDump(FileDescriptor fd, PrintWriter fout, String[] args) {
        if (this.processDump(fd, args)) {
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(fout);
        p.println("Input method client state for " + this + ":");
        p.println("  mFallbackInputConnection=" + this.mFallbackInputConnection);
        p.println("  mActive=" + this.mActive + " mRestartOnNextWindowFocus=" + this.mRestartOnNextWindowFocus + " mBindSequence=" + this.getBindSequenceLocked() + " mCurImeId=" + this.getImeIdLocked());
        p.println("  mFullscreenMode=" + this.mFullscreenMode);
        if (this.isImeSessionAvailableLocked()) {
            p.println("  mCurMethod=" + this.mCurBindState.mImeSession);
        } else {
            p.println("  mCurMethod= null");
        }
        for (int i = 0; i < this.mAccessibilityInputMethodSession.size(); ++i) {
            p.println("  mAccessibilityInputMethodSession(" + this.mAccessibilityInputMethodSession.keyAt(i) + ")=" + this.mAccessibilityInputMethodSession.valueAt(i));
        }
        p.println("  mCurRootView=" + this.mCurRootView);
        p.println("  mServedView=" + this.getServedViewLocked());
        p.println("  mNextServedView=" + this.getNextServedViewLocked());
        p.println("  mServedConnecting=" + this.mServedConnecting);
        if (this.mCurrentEditorInfo != null) {
            p.println("  mCurrentEditorInfo:");
            this.mCurrentEditorInfo.dump(p, "    ", false);
        } else {
            p.println("  mCurrentEditorInfo: null");
        }
        p.println("  mServedInputConnection=" + this.mServedInputConnection);
        p.println("  mServedInputConnectionHandler=" + this.mServedInputConnectionHandler);
        p.println("  mLastPendingStartSeqId=" + this.mLastPendingStartSeqId);
        p.println("  mCompletions=" + Arrays.toString(this.mCompletions));
        p.println("  mCursorRect=" + this.mCursorRect);
        p.println("  mCursorSelStart=" + this.mCursorSelStart + " mCursorSelEnd=" + this.mCursorSelEnd + " mCursorCandStart=" + this.mCursorCandStart + " mCursorCandEnd=" + this.mCursorCandEnd);
    }

    @GuardedBy(value={"mH"})
    private boolean isImeSessionAvailableLocked() {
        return this.mCurBindState != null && this.mCurBindState.mImeSession != null;
    }

    @GuardedBy(value={"mH"})
    private String getImeIdLocked() {
        return this.mCurBindState != null ? this.mCurBindState.mImeId : null;
    }

    @GuardedBy(value={"mH"})
    private int getBindSequenceLocked() {
        return this.mCurBindState != null ? this.mCurBindState.mBindSequence : -1;
    }

    private boolean processDump(FileDescriptor fd, String[] args) {
        if (args == null) {
            return false;
        }
        for (String arg : args) {
            if (!arg.equals("--proto-com-android-imetracing")) continue;
            ProtoOutputStream proto = new ProtoOutputStream(fd);
            this.dumpDebug(proto, null);
            proto.flush();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpDebug(ProtoOutputStream proto, @Nullable byte[] icProto) {
        H h = this.mH;
        synchronized (h) {
            if (!this.isImeSessionAvailableLocked()) {
                return;
            }
            proto.write(0x10500000001L, this.mDisplayId);
            long token = proto.start(1146756268034L);
            proto.write(0x10900000001L, this.mCurBindState.mImeId);
            proto.write(1133871366146L, this.mFullscreenMode);
            proto.write(1133871366148L, this.mActive);
            proto.write(1133871366149L, this.mServedConnecting);
            proto.write(1138166333446L, Objects.toString(this.mServedView));
            proto.write(1138166333447L, Objects.toString(this.mNextServedView));
            proto.end(token);
            if (this.mCurRootView != null) {
                this.mCurRootView.dumpDebug(proto, 1146756268035L);
            }
            if (this.mCurrentEditorInfo != null) {
                this.mCurrentEditorInfo.dumpDebug(proto, 1146756268038L);
            }
            if (this.mImeInsetsConsumer != null) {
                this.mImeInsetsConsumer.dumpDebug(proto, 1146756268037L);
            }
            if (this.mServedInputConnection != null) {
                this.mServedInputConnection.dumpDebug(proto, 1146756268040L);
            }
            if (icProto != null) {
                proto.write(1146756268041L, icProto);
            }
        }
    }

    @GuardedBy(value={"mH"})
    private void forAccessibilitySessionsLocked(Consumer<IAccessibilityInputMethodSessionInvoker> consumer) {
        for (int i = 0; i < this.mAccessibilityInputMethodSession.size(); ++i) {
            consumer.accept(this.mAccessibilityInputMethodSession.valueAt(i));
        }
    }

    private static Pair<InputConnection, EditorInfo> createInputConnection(@NonNull View servedView) {
        EditorInfo editorInfo = new EditorInfo();
        editorInfo.packageName = servedView.getContext().getOpPackageName();
        editorInfo.setAutofillId(servedView.getAutofillId());
        editorInfo.fieldId = servedView.getId();
        InputConnection ic = servedView.onCreateInputConnection(editorInfo);
        if (ic == null) {
            editorInfo.setAutofillId(AutofillId.NO_AUTOFILL_ID);
            editorInfo.fieldId = 0;
        }
        return new Pair<InputConnection, EditorInfo>(ic, editorInfo);
    }

    static {
        sInstanceMap = new SparseArray();
        OPTIMIZE_NONEDITABLE_VIEWS = SystemProperties.getBoolean("debug.imm.optimize_noneditable_views", true);
    }

    class H
    extends Handler {
        H(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        InputMethodManager.this.doDump((FileDescriptor)args.arg1, (PrintWriter)args.arg2, (String[])args.arg3);
                    }
                    catch (RuntimeException e) {
                        ((PrintWriter)args.arg2).println("Exception: " + e);
                    }
                    Object e = args.arg4;
                    synchronized (e) {
                        ((CountDownLatch)args.arg4).countDown();
                    }
                    args.recycle();
                    return;
                }
                case 2: {
                    InputBindResult res = (InputBindResult)msg.obj;
                    H e = InputMethodManager.this.mH;
                    synchronized (e) {
                        int curBindSequence = InputMethodManager.this.getBindSequenceLocked();
                        if (curBindSequence < 0 || curBindSequence != res.sequence) {
                            Log.w(InputMethodManager.TAG, "Ignoring onBind: cur seq=" + curBindSequence + ", given seq=" + res.sequence);
                            if (res.channel != null && res.channel != InputMethodManager.this.mCurChannel) {
                                res.channel.dispose();
                            }
                            return;
                        }
                        InputMethodManager.this.mRequestUpdateCursorAnchorInfoMonitorMode = 0;
                        InputMethodManager.this.updateInputChannelLocked(res.channel);
                        InputMethodManager.this.mCurMethod = res.method;
                        InputMethodManager.this.mCurBindState = new BindState(res);
                        InputMethodManager.this.mCurId = res.id;
                    }
                    InputMethodManager.this.startInputInner(6, null, 0, 0, 0);
                    return;
                }
                case 40: {
                    InputBindResult res = (InputBindResult)msg.obj;
                    int startInputSeq = msg.arg1;
                    H curBindSequence = InputMethodManager.this.mH;
                    synchronized (curBindSequence) {
                        if (InputMethodManager.this.mLastPendingStartSeqId == startInputSeq) {
                            InputMethodManager.this.mLastPendingStartSeqId = -1;
                        }
                        if (res == null) {
                            return;
                        }
                        if (res.id != null) {
                            InputMethodManager.this.updateInputChannelLocked(res.channel);
                            InputMethodManager.this.mCurMethod = res.method;
                            InputMethodManager.this.mCurBindState = new BindState(res);
                            InputMethodManager.this.mAccessibilityInputMethodSession.clear();
                            if (res.accessibilitySessions != null) {
                                for (int i = 0; i < res.accessibilitySessions.size(); ++i) {
                                    IAccessibilityInputMethodSessionInvoker wrapper = IAccessibilityInputMethodSessionInvoker.createOrNull(res.accessibilitySessions.valueAt(i));
                                    if (wrapper == null) continue;
                                    InputMethodManager.this.mAccessibilityInputMethodSession.append(res.accessibilitySessions.keyAt(i), wrapper);
                                }
                            }
                            InputMethodManager.this.mCurId = res.id;
                        } else if (res.channel != null && res.channel != InputMethodManager.this.mCurChannel) {
                            res.channel.dispose();
                        }
                        switch (res.result) {
                            case 12: {
                                InputMethodManager.this.mRestartOnNextWindowFocus = true;
                                InputMethodManager.this.mServedView = null;
                            }
                        }
                        if (InputMethodManager.this.mCompletions != null && InputMethodManager.this.isImeSessionAvailableLocked()) {
                            InputMethodManager.this.mCurBindState.mImeSession.displayCompletions(InputMethodManager.this.mCompletions);
                        }
                        if (res != null && res.method != null && InputMethodManager.this.mServedView != null && InputMethodManager.this.mReportInputConnectionOpenedRunner != null && InputMethodManager.this.mReportInputConnectionOpenedRunner.mSequenceNum == startInputSeq) {
                            InputMethodManager.this.mReportInputConnectionOpenedRunner.run();
                        }
                        InputMethodManager.this.mReportInputConnectionOpenedRunner = null;
                    }
                    return;
                }
                case 3: {
                    boolean startInput;
                    int sequence = msg.arg1;
                    int reason = msg.arg2;
                    H i = InputMethodManager.this.mH;
                    synchronized (i) {
                        if (reason == 3) {
                            InputMethodManager.this.mImeDispatcher.clear();
                        }
                        if (InputMethodManager.this.getBindSequenceLocked() != sequence) {
                            return;
                        }
                        InputMethodManager.this.clearAllAccessibilityBindingLocked();
                        InputMethodManager.this.clearBindingLocked();
                        View servedView = InputMethodManager.this.getServedViewLocked();
                        if (servedView != null && servedView.isFocused()) {
                            InputMethodManager.this.mServedConnecting = true;
                        }
                        startInput = InputMethodManager.this.mActive;
                    }
                    if (startInput) {
                        InputMethodManager.this.startInputInner(7, null, 0, 0, 0);
                    }
                    return;
                }
                case 11: {
                    int id2 = msg.arg1;
                    InputBindResult res = (InputBindResult)msg.obj;
                    H startInput = InputMethodManager.this.mH;
                    synchronized (startInput) {
                        IAccessibilityInputMethodSessionInvoker invoker;
                        int curBindSequence = InputMethodManager.this.getBindSequenceLocked();
                        if (curBindSequence < 0 || curBindSequence != res.sequence) {
                            Log.w(InputMethodManager.TAG, "Ignoring onBind: cur seq=" + curBindSequence + ", given seq=" + res.sequence);
                            if (res.channel != null && res.channel != InputMethodManager.this.mCurChannel) {
                                res.channel.dispose();
                            }
                            return;
                        }
                        if (res.accessibilitySessions != null && (invoker = IAccessibilityInputMethodSessionInvoker.createOrNull(res.accessibilitySessions.get(id2))) != null) {
                            InputMethodManager.this.mAccessibilityInputMethodSession.put(id2, invoker);
                            if (InputMethodManager.this.mServedInputConnection != null) {
                                invoker.updateSelection(InputMethodManager.this.mInitialSelStart, InputMethodManager.this.mInitialSelEnd, InputMethodManager.this.mCursorSelStart, InputMethodManager.this.mCursorSelEnd, InputMethodManager.this.mCursorCandStart, InputMethodManager.this.mCursorCandEnd);
                            } else {
                                invoker.updateSelection(-1, -1, -1, -1, -1, -1);
                            }
                        }
                    }
                    InputMethodManager.this.startInputInner(12, null, 0, 0, 0);
                    return;
                }
                case 12: {
                    int sequence = msg.arg1;
                    int id3 = msg.arg2;
                    H startInput = InputMethodManager.this.mH;
                    synchronized (startInput) {
                        if (InputMethodManager.this.getBindSequenceLocked() != sequence) {
                            return;
                        }
                        InputMethodManager.this.clearAccessibilityBindingLocked(id3);
                    }
                    return;
                }
                case 4: {
                    boolean active = msg.arg1 != 0;
                    boolean fullscreen = msg.arg2 != 0;
                    H startInput = InputMethodManager.this.mH;
                    synchronized (startInput) {
                        View servedView;
                        InputMethodManager.this.mActive = active;
                        InputMethodManager.this.mFullscreenMode = fullscreen;
                        if (!active) {
                            InputMethodManager.this.mRestartOnNextWindowFocus = true;
                            InputMethodManager.this.mFallbackInputConnection.finishComposingTextFromImm();
                            if (InputMethodManager.this.clearCurRootViewIfNeeded()) {
                                return;
                            }
                        }
                        if ((servedView = InputMethodManager.this.getServedViewLocked()) == null || !InputMethodManager.canStartInput(servedView)) {
                            return;
                        }
                        if (InputMethodManager.this.mCurRootView == null) {
                            return;
                        }
                        if (!InputMethodManager.this.checkFocusInternalLocked(InputMethodManager.this.mRestartOnNextWindowFocus, InputMethodManager.this.mCurRootView)) {
                            return;
                        }
                        InputMethodManager.this.mCurrentEditorInfo = null;
                        InputMethodManager.this.mCompletions = null;
                        InputMethodManager.this.mServedConnecting = true;
                    }
                    int reason = active ? 8 : 9;
                    InputMethodManager.this.startInputInner(reason, null, 0, 0, 0);
                    return;
                }
                case 13: {
                    boolean interactive = msg.arg1 != 0;
                    boolean fullscreen = msg.arg2 != 0;
                    H reason = InputMethodManager.this.mH;
                    synchronized (reason) {
                        InputMethodManager.this.mActive = interactive;
                        InputMethodManager.this.mFullscreenMode = fullscreen;
                        if (interactive) {
                            View rootView;
                            View view = rootView = InputMethodManager.this.mCurRootView != null ? InputMethodManager.this.mCurRootView.getView() : null;
                            if (rootView == null) {
                                return;
                            }
                            ViewRootImpl currentViewRootImpl = InputMethodManager.this.mCurRootView;
                            rootView.post(() -> {
                                View focusedView;
                                H h = InputMethodManager.this.mH;
                                synchronized (h) {
                                    if (InputMethodManager.this.mCurRootView != currentViewRootImpl) {
                                        return;
                                    }
                                }
                                View curRootView = currentViewRootImpl.getView();
                                if (curRootView == null) {
                                    return;
                                }
                                InputMethodManager.this.onViewFocusChangedInternal(focusedView, (focusedView = curRootView.findFocus()) != null);
                            });
                        } else {
                            InputMethodManager.this.finishInputLocked();
                            if (InputMethodManager.this.isImeSessionAvailableLocked()) {
                                InputMethodManager.this.mCurBindState.mImeSession.finishInput();
                            }
                            InputMethodManager.this.forAccessibilitySessionsLocked(IAccessibilityInputMethodSessionInvoker::finishInput);
                        }
                    }
                    return;
                }
                case 14: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    boolean visible = (Boolean)args.arg1;
                    ImeTracker.Token statsToken = (ImeTracker.Token)args.arg2;
                    H rootView = InputMethodManager.this.mH;
                    synchronized (rootView) {
                        if (InputMethodManager.this.mCurRootView != null) {
                            InsetsController insetsController = InputMethodManager.this.mCurRootView.getInsetsController();
                            if (insetsController != null) {
                                ImeTracker.forLogging().onProgress(statsToken, 58);
                                if (visible) {
                                    insetsController.show(WindowInsets.Type.ime(), false, statsToken);
                                } else {
                                    insetsController.hide(WindowInsets.Type.ime(), false, statsToken);
                                }
                            }
                        } else {
                            ImeTracker.forLogging().onFailed(statsToken, 58);
                        }
                        break;
                    }
                }
                case 5: {
                    InputMethodManager.this.sendInputEventAndReportResultOnMainLooper((PendingEvent)msg.obj);
                    return;
                }
                case 6: {
                    InputMethodManager.this.finishedInputEvent(msg.arg1, false, true);
                    return;
                }
                case 7: {
                    InputMethodManager.this.finishedInputEvent(msg.arg1, false, false);
                    return;
                }
                case 10: {
                    boolean fullscreen = msg.arg1 != 0;
                    RemoteInputConnectionImpl ic = null;
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        if (InputMethodManager.this.mFullscreenMode != fullscreen && InputMethodManager.this.mServedInputConnection != null) {
                            ic = InputMethodManager.this.mServedInputConnection;
                            InputMethodManager.this.mFullscreenMode = fullscreen;
                        }
                    }
                    if (ic != null) {
                        ic.dispatchReportFullscreenMode(fullscreen);
                    }
                    return;
                }
                case 31: {
                    H h = InputMethodManager.this.mH;
                    synchronized (h) {
                        if (InputMethodManager.this.mImeInsetsConsumer != null) {
                            InputMethodManager.this.mImeInsetsConsumer.onShowRequested();
                        }
                    }
                    return;
                }
            }
        }
    }

    private class DelegateImpl
    implements ImeFocusController.InputMethodManagerDelegate {
        private DelegateImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPreWindowGainedFocus(ViewRootImpl viewRootImpl) {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                this.setCurrentRootViewLocked(viewRootImpl);
                InputMethodManager.this.mCurRootViewWindowFocused = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPostWindowGainedFocus(View viewForWindowFocus, @NonNull WindowManager.LayoutParams windowAttribute) {
            boolean checkFocusResult;
            boolean forceFocus = false;
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                boolean nextFocusIsServedView;
                InputMethodManager.this.onViewFocusChangedInternal(viewForWindowFocus, true);
                boolean bl = nextFocusIsServedView = InputMethodManager.this.mServedView == viewForWindowFocus;
                if (nextFocusIsServedView && !InputMethodManager.this.hasActiveInputConnectionInternal(viewForWindowFocus)) {
                    forceFocus = true;
                }
            }
            int softInputMode = windowAttribute.softInputMode;
            int windowFlags = windowAttribute.flags;
            int startInputFlags = InputMethodManager.this.getStartInputFlags(viewForWindowFocus, 0);
            startInputFlags |= 8;
            ImeTracing.getInstance().triggerClientDump("InputMethodManager.DelegateImpl#startInputAsyncOnWindowFocusGain", InputMethodManager.this, null);
            H h2 = InputMethodManager.this.mH;
            synchronized (h2) {
                if (InputMethodManager.this.mCurRootView == null) {
                    return;
                }
                if (InputMethodManager.this.mRestartOnNextWindowFocus) {
                    InputMethodManager.this.mRestartOnNextWindowFocus = false;
                    forceFocus = true;
                }
                checkFocusResult = InputMethodManager.this.checkFocusInternalLocked(forceFocus, InputMethodManager.this.mCurRootView);
            }
            if (checkFocusResult && InputMethodManager.this.startInputOnWindowFocusGainInternal(1, viewForWindowFocus, startInputFlags, softInputMode, windowFlags)) {
                return;
            }
            h2 = InputMethodManager.this.mH;
            synchronized (h2) {
                boolean imeRequestedVisible = InputMethodManager.hasViewImeRequestedVisible(InputMethodManager.this.mCurRootView.getView());
                Trace.traceBegin(32L, "IMM.startInputOrWindowGainedFocus");
                IInputMethodManagerGlobalInvoker.startInputOrWindowGainedFocus(2, InputMethodManager.this.mClient, viewForWindowFocus.getWindowToken(), startInputFlags, softInputMode, windowFlags, null, null, null, InputMethodManager.this.mCurRootView.mContext.getApplicationInfo().targetSdkVersion, UserHandle.myUserId(), InputMethodManager.this.mImeDispatcher, imeRequestedVisible);
                Trace.traceEnd(32L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWindowLostFocus(@NonNull ViewRootImpl viewRootImpl) {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                if (InputMethodManager.this.mCurRootView == viewRootImpl) {
                    InputMethodManager.this.mCurRootViewWindowFocused = false;
                    InputMethodManager.this.clearCurRootViewIfNeeded();
                }
            }
        }

        @Override
        public void onViewFocusChanged(@Nullable View view, boolean hasFocus) {
            InputMethodManager.this.onViewFocusChangedInternal(view, hasFocus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onScheduledCheckFocus(ViewRootImpl viewRootImpl) {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                if (!InputMethodManager.this.checkFocusInternalLocked(false, viewRootImpl)) {
                    return;
                }
            }
            InputMethodManager.this.startInputOnWindowFocusGainInternal(3, null, 0, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onViewDetachedFromWindow(View view, ViewRootImpl viewRootImpl) {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                if (InputMethodManager.this.mCurRootView != view.getViewRootImpl()) {
                    return;
                }
                if (InputMethodManager.this.mNextServedView == view) {
                    InputMethodManager.this.mNextServedView = null;
                }
                if (InputMethodManager.this.mServedView == view) {
                    viewRootImpl.dispatchCheckFocus();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWindowDismissed(ViewRootImpl viewRootImpl) {
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                if (InputMethodManager.this.mCurRootView != viewRootImpl) {
                    return;
                }
                if (InputMethodManager.this.mServedView != null) {
                    InputMethodManager.this.finishInputLocked();
                }
                this.setCurrentRootViewLocked(null);
            }
        }

        @GuardedBy(value={"mH"})
        private void setCurrentRootViewLocked(ViewRootImpl rootView) {
            boolean wasEmpty;
            boolean bl = wasEmpty = InputMethodManager.this.mCurRootView == null;
            if (Flags.refactorInsetsController() && !wasEmpty && InputMethodManager.this.mCurRootView != rootView) {
                InputMethodManager.this.onImeFocusLost(InputMethodManager.this.mCurRootView);
            }
            InputMethodManager.this.mImeDispatcher.switchRootView(InputMethodManager.this.mCurRootView, rootView);
            InputMethodManager.this.mCurRootView = rootView;
            if (wasEmpty && InputMethodManager.this.mCurRootView != null) {
                InputMethodManager.this.mImeDispatcher.updateReceivingDispatcher(InputMethodManager.this.mCurRootView.getOnBackInvokedDispatcher());
            }
        }
    }

    private static class BindState {
        @Nullable
        final IInputMethodSessionInvoker mImeSession;
        final boolean mIsInputMethodSuppressingSpellChecker;
        @Nullable
        final String mImeId;
        final int mBindSequence;

        BindState(@NonNull InputBindResult inputBindResult) {
            this.mImeSession = IInputMethodSessionInvoker.createOrNull(inputBindResult.method);
            this.mIsInputMethodSuppressingSpellChecker = inputBindResult.isInputMethodSuppressingSpellChecker;
            this.mImeId = inputBindResult.id;
            this.mBindSequence = inputBindResult.sequence;
        }
    }

    private class ImeInputEventSender
    extends InputEventSender {
        public ImeInputEventSender(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
        }

        @Override
        public void onInputEventFinished(int seq, boolean handled) {
            InputMethodManager.this.finishedInputEvent(seq, handled, false);
        }
    }

    private static abstract class ReportInputConnectionOpenedRunner
    implements Runnable {
        int mSequenceNum;

        ReportInputConnectionOpenedRunner(int sequenceNum) {
            this.mSequenceNum = sequenceNum;
        }
    }

    private static class ConnectionlessHandwritingCallbackProxy
    extends IConnectionlessHandwritingCallback.Stub {
        private final Object mLock = new Object();
        @Nullable
        @GuardedBy(value={"mLock"})
        private Executor mExecutor;
        @Nullable
        @GuardedBy(value={"mLock"})
        private ConnectionlessHandwritingCallback mCallback;

        ConnectionlessHandwritingCallbackProxy(@NonNull Executor executor, @NonNull ConnectionlessHandwritingCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(CharSequence text) {
            ConnectionlessHandwritingCallback callback;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mCallback == null) {
                    return;
                }
                executor = this.mExecutor;
                callback = this.mCallback;
                this.mExecutor = null;
                this.mCallback = null;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                if (TextUtils.isEmpty(text)) {
                    executor.execute(() -> callback.onError(0));
                } else {
                    executor.execute(() -> callback.onResult(text));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(int errorCode) {
            ConnectionlessHandwritingCallback callback;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mCallback == null) {
                    return;
                }
                executor = this.mExecutor;
                callback = this.mCallback;
                this.mExecutor = null;
                this.mCallback = null;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> callback.onError(errorCode));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    public static interface FinishedInputEventCallback {
        public void onFinishedInputEvent(Object var1, boolean var2);
    }

    private class PendingEvent
    implements Runnable {
        public InputEvent mEvent;
        public Object mToken;
        public String mInputMethodId;
        public FinishedInputEventCallback mCallback;
        public Handler mHandler;
        public boolean mHandled;

        private PendingEvent() {
        }

        public void recycle() {
            this.mEvent = null;
            this.mToken = null;
            this.mInputMethodId = null;
            this.mCallback = null;
            this.mHandler = null;
            this.mHandled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.mCallback.onFinishedInputEvent(this.mToken, this.mHandled);
            H h = InputMethodManager.this.mH;
            synchronized (h) {
                InputMethodManager.this.recyclePendingEventLocked(this);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HideFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HandwritingDelegateFlags {
    }
}

