/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.icu.util.ULocale;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Printer;
import android.util.Slog;
import android.util.Xml;
import android.view.inputmethod.Flags;
import android.view.inputmethod.InputMethodSubtype;
import android.view.inputmethod.InputMethodSubtypeArray;
import com.android.internal.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class InputMethodInfo
implements Parcelable {
    public static final String ACTION_STYLUS_HANDWRITING_SETTINGS = "android.view.inputmethod.action.STYLUS_HANDWRITING_SETTINGS";
    @FlaggedApi(value="android.view.inputmethod.ime_switcher_revamp_api")
    public static final String ACTION_IME_LANGUAGE_SETTINGS = "android.view.inputmethod.action.IME_LANGUAGE_SETTINGS";
    public static final int COMPONENT_NAME_MAX_LENGTH = 1000;
    @SuppressLint(value={"MinMaxConstant"})
    public static final int MAX_IMES_PER_PACKAGE = 20;
    static final String TAG = "InputMethodInfo";
    final ResolveInfo mService;
    final boolean mIsVrOnly;
    final boolean mIsVirtualDeviceOnly;
    final String mId;
    final String mSettingsActivityName;
    @Nullable
    private final String mLanguageSettingsActivityName;
    final int mIsDefaultResId;
    @UnsupportedAppUsage
    private final InputMethodSubtypeArray mSubtypes;
    private final boolean mIsAuxIme;
    private final boolean mForceDefault;
    private final boolean mSupportsSwitchingToNextInputMethod;
    private final boolean mInlineSuggestionsEnabled;
    private final boolean mSupportsInlineSuggestionsWithTouchExploration;
    private final boolean mSuppressesSpellChecker;
    private final boolean mShowInInputMethodPicker;
    private final int mHandledConfigChanges;
    private final boolean mSupportsStylusHandwriting;
    private final boolean mSupportsConnectionlessStylusHandwriting;
    private final String mStylusHandwritingSettingsActivityAttr;
    @NonNull
    public static final Parcelable.Creator<InputMethodInfo> CREATOR = new Parcelable.Creator<InputMethodInfo>(){

        @Override
        public InputMethodInfo createFromParcel(Parcel source) {
            return new InputMethodInfo(source);
        }

        public InputMethodInfo[] newArray(int size) {
            return new InputMethodInfo[size];
        }
    };

    public static String computeId(@NonNull ResolveInfo service) {
        ServiceInfo si = service.serviceInfo;
        return new ComponentName(si.packageName, si.name).flattenToShortString();
    }

    public InputMethodInfo(Context context, ResolveInfo service) throws XmlPullParserException, IOException {
        this(context, service, null);
    }

    public InputMethodInfo(Context context, ResolveInfo service, List<InputMethodSubtype> additionalSubtypes) throws XmlPullParserException, IOException {
        boolean isVirtualDeviceOnly;
        boolean isVrOnly;
        this.mService = service;
        ServiceInfo si = service.serviceInfo;
        this.mId = InputMethodInfo.computeId(service);
        boolean isAuxIme = true;
        boolean supportsSwitchingToNextInputMethod = false;
        boolean inlineSuggestionsEnabled = false;
        boolean supportsInlineSuggestionsWithTouchExploration = false;
        boolean suppressesSpellChecker = false;
        boolean showInInputMethodPicker = true;
        this.mForceDefault = false;
        PackageManager pm = context.getPackageManager();
        String settingsActivityComponent = null;
        String languageSettingsActivityComponent = null;
        String stylusHandwritingSettingsActivity = null;
        int isDefaultResId = 0;
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        try (XmlResourceParser parser = null;){
            int type;
            parser = si.loadXmlMetaData(pm, "android.view.im");
            if (parser == null) {
                throw new XmlPullParserException("No android.view.im meta-data");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"input-method".equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with input-method tag");
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.InputMethod);
            settingsActivityComponent = sa.getString(2);
            if (Flags.imeSwitcherRevampApi()) {
                languageSettingsActivityComponent = sa.getString(13);
            }
            if (si.name != null && si.name.length() > 1000 || settingsActivityComponent != null && settingsActivityComponent.length() > 1000 || languageSettingsActivityComponent != null && languageSettingsActivityComponent.length() > 1000) {
                throw new XmlPullParserException("Activity name exceeds maximum of 1000 characters");
            }
            isVrOnly = sa.getBoolean(4, false);
            isVirtualDeviceOnly = sa.getBoolean(11, false);
            isDefaultResId = sa.getResourceId(1, 0);
            supportsSwitchingToNextInputMethod = sa.getBoolean(3, false);
            inlineSuggestionsEnabled = sa.getBoolean(5, false);
            supportsInlineSuggestionsWithTouchExploration = sa.getBoolean(9, false);
            suppressesSpellChecker = sa.getBoolean(6, false);
            showInInputMethodPicker = sa.getBoolean(7, true);
            this.mHandledConfigChanges = sa.getInt(0, 0);
            this.mSupportsStylusHandwriting = sa.getBoolean(8, false);
            this.mSupportsConnectionlessStylusHandwriting = sa.getBoolean(12, false);
            stylusHandwritingSettingsActivity = sa.getString(10);
            sa.recycle();
            int depth = parser.getDepth();
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                if (type != 2) continue;
                nodeName = parser.getName();
                if (!"subtype".equals(nodeName)) {
                    throw new XmlPullParserException("Meta-data in input-method does not start with subtype tag");
                }
                TypedArray a = res.obtainAttributes(attrs, R.styleable.InputMethod_Subtype);
                String pkLanguageTag = a.getString(10);
                String pkLayoutType = a.getString(11);
                InputMethodSubtype subtype = new InputMethodSubtype.InputMethodSubtypeBuilder().setSubtypeNameResId(a.getResourceId(0, 0)).setSubtypeIconResId(a.getResourceId(1, 0)).setPhysicalKeyboardHint(pkLanguageTag == null ? null : new ULocale(pkLanguageTag), pkLayoutType == null ? "" : pkLayoutType).setLanguageTag(a.getString(9)).setSubtypeLocale(a.getString(2)).setSubtypeMode(a.getString(3)).setSubtypeExtraValue(a.getString(4)).setIsAuxiliary(a.getBoolean(5, false)).setOverridesImplicitlyEnabledSubtype(a.getBoolean(6, false)).setSubtypeId(a.getInt(7, 0)).setIsAsciiCapable(a.getBoolean(8, false)).build();
                a.recycle();
                if (!subtype.isAuxiliary()) {
                    isAuxIme = false;
                }
                subtypes.add(subtype);
            }
        }
        if (subtypes.size() == 0) {
            isAuxIme = false;
        }
        if (additionalSubtypes != null) {
            int N2 = additionalSubtypes.size();
            for (int i = 0; i < N2; ++i) {
                InputMethodSubtype subtype = additionalSubtypes.get(i);
                if (!subtypes.contains(subtype)) {
                    subtypes.add(subtype);
                    continue;
                }
                Slog.w(TAG, "Duplicated subtype definition found: " + subtype.getLocale() + ", " + subtype.getMode());
            }
        }
        this.mSubtypes = new InputMethodSubtypeArray(subtypes);
        this.mSettingsActivityName = settingsActivityComponent;
        this.mLanguageSettingsActivityName = languageSettingsActivityComponent;
        this.mStylusHandwritingSettingsActivityAttr = stylusHandwritingSettingsActivity;
        this.mIsDefaultResId = isDefaultResId;
        this.mIsAuxIme = isAuxIme;
        this.mSupportsSwitchingToNextInputMethod = supportsSwitchingToNextInputMethod;
        this.mInlineSuggestionsEnabled = inlineSuggestionsEnabled;
        this.mSupportsInlineSuggestionsWithTouchExploration = supportsInlineSuggestionsWithTouchExploration;
        this.mSuppressesSpellChecker = suppressesSpellChecker;
        this.mShowInInputMethodPicker = showInInputMethodPicker;
        this.mIsVrOnly = isVrOnly;
        this.mIsVirtualDeviceOnly = isVirtualDeviceOnly;
    }

    public InputMethodInfo(InputMethodInfo source) {
        this(source, Collections.emptyList());
    }

    public InputMethodInfo(@NonNull InputMethodInfo source, @NonNull List<InputMethodSubtype> additionalSubtypes) {
        this.mId = source.mId;
        this.mSettingsActivityName = source.mSettingsActivityName;
        this.mLanguageSettingsActivityName = source.mLanguageSettingsActivityName;
        this.mIsDefaultResId = source.mIsDefaultResId;
        this.mIsAuxIme = source.mIsAuxIme;
        this.mSupportsSwitchingToNextInputMethod = source.mSupportsSwitchingToNextInputMethod;
        this.mInlineSuggestionsEnabled = source.mInlineSuggestionsEnabled;
        this.mSupportsInlineSuggestionsWithTouchExploration = source.mSupportsInlineSuggestionsWithTouchExploration;
        this.mSuppressesSpellChecker = source.mSuppressesSpellChecker;
        this.mShowInInputMethodPicker = source.mShowInInputMethodPicker;
        this.mIsVrOnly = source.mIsVrOnly;
        this.mIsVirtualDeviceOnly = source.mIsVirtualDeviceOnly;
        this.mService = source.mService;
        if (additionalSubtypes.isEmpty()) {
            this.mSubtypes = source.mSubtypes;
        } else {
            ArrayList<InputMethodSubtype> subtypes = source.mSubtypes.toList();
            int additionalSubtypeCount = additionalSubtypes.size();
            for (int i = 0; i < additionalSubtypeCount; ++i) {
                InputMethodSubtype additionalSubtype = additionalSubtypes.get(i);
                if (subtypes.contains(additionalSubtype)) continue;
                subtypes.add(additionalSubtype);
            }
            this.mSubtypes = new InputMethodSubtypeArray(subtypes);
        }
        this.mHandledConfigChanges = source.mHandledConfigChanges;
        this.mSupportsStylusHandwriting = source.mSupportsStylusHandwriting;
        this.mSupportsConnectionlessStylusHandwriting = source.mSupportsConnectionlessStylusHandwriting;
        this.mForceDefault = source.mForceDefault;
        this.mStylusHandwritingSettingsActivityAttr = source.mStylusHandwritingSettingsActivityAttr;
    }

    InputMethodInfo(Parcel source) {
        this.mId = source.readString();
        this.mSettingsActivityName = source.readString();
        this.mLanguageSettingsActivityName = source.readString8();
        this.mIsDefaultResId = source.readInt();
        this.mIsAuxIme = source.readInt() == 1;
        this.mSupportsSwitchingToNextInputMethod = source.readInt() == 1;
        this.mInlineSuggestionsEnabled = source.readInt() == 1;
        this.mSupportsInlineSuggestionsWithTouchExploration = source.readInt() == 1;
        this.mSuppressesSpellChecker = source.readBoolean();
        this.mShowInInputMethodPicker = source.readBoolean();
        this.mIsVrOnly = source.readBoolean();
        this.mIsVirtualDeviceOnly = source.readBoolean();
        this.mService = ResolveInfo.CREATOR.createFromParcel(source);
        this.mSubtypes = new InputMethodSubtypeArray(source);
        this.mHandledConfigChanges = source.readInt();
        this.mSupportsStylusHandwriting = source.readBoolean();
        this.mSupportsConnectionlessStylusHandwriting = source.readBoolean();
        this.mStylusHandwritingSettingsActivityAttr = source.readString8();
        this.mForceDefault = false;
    }

    public InputMethodInfo(String packageName, String className, CharSequence label, String settingsActivity) {
        this(InputMethodInfo.buildFakeResolveInfo(packageName, className, label), false, settingsActivity, null, null, 0, false, true, false, false, false, 0, false, false, null, false);
    }

    public InputMethodInfo(@NonNull String packageName, @NonNull String className, @NonNull CharSequence label, @NonNull String settingsActivity, boolean supportStylusHandwriting, @NonNull String stylusHandwritingSettingsActivityAttr) {
        this(InputMethodInfo.buildFakeResolveInfo(packageName, className, label), false, settingsActivity, null, null, 0, false, true, false, false, false, 0, supportStylusHandwriting, false, stylusHandwritingSettingsActivityAttr, false);
    }

    public InputMethodInfo(@NonNull String packageName, @NonNull String className, @NonNull CharSequence label, @NonNull String settingsActivity, @NonNull String languageSettingsActivity, boolean supportStylusHandwriting, @NonNull String stylusHandwritingSettingsActivityAttr) {
        this(InputMethodInfo.buildFakeResolveInfo(packageName, className, label), false, settingsActivity, languageSettingsActivity, null, 0, false, true, false, false, false, 0, supportStylusHandwriting, false, stylusHandwritingSettingsActivityAttr, false);
    }

    @FlaggedApi(value="android.view.inputmethod.connectionless_handwriting")
    public InputMethodInfo(@NonNull String packageName, @NonNull String className, @NonNull CharSequence label, @NonNull String settingsActivity, @NonNull String languageSettingsActivity, boolean supportStylusHandwriting, boolean supportConnectionlessStylusHandwriting, @NonNull String stylusHandwritingSettingsActivityAttr) {
        this(InputMethodInfo.buildFakeResolveInfo(packageName, className, label), false, settingsActivity, languageSettingsActivity, null, 0, false, true, false, false, false, 0, supportStylusHandwriting, supportConnectionlessStylusHandwriting, stylusHandwritingSettingsActivityAttr, false);
    }

    public InputMethodInfo(@NonNull String packageName, @NonNull String className, @NonNull CharSequence label, @NonNull String settingsActivity, int handledConfigChanges) {
        this(InputMethodInfo.buildFakeResolveInfo(packageName, className, label), false, settingsActivity, null, null, 0, false, true, false, false, false, handledConfigChanges, false, false, null, false);
    }

    public InputMethodInfo(ResolveInfo ri, boolean isAuxIme, String settingsActivity, List<InputMethodSubtype> subtypes, int isDefaultResId, boolean forceDefault) {
        this(ri, isAuxIme, settingsActivity, null, subtypes, isDefaultResId, forceDefault, true, false, false, false, 0, false, false, null, false);
    }

    public InputMethodInfo(ResolveInfo ri, boolean isAuxIme, String settingsActivity, List<InputMethodSubtype> subtypes, int isDefaultResId, boolean forceDefault, boolean supportsSwitchingToNextInputMethod, boolean isVrOnly) {
        this(ri, isAuxIme, settingsActivity, null, subtypes, isDefaultResId, forceDefault, supportsSwitchingToNextInputMethod, false, isVrOnly, false, 0, false, false, null, false);
    }

    public InputMethodInfo(ResolveInfo ri, boolean isAuxIme, String settingsActivity, @Nullable String languageSettingsActivity, List<InputMethodSubtype> subtypes, int isDefaultResId, boolean forceDefault, boolean supportsSwitchingToNextInputMethod, boolean inlineSuggestionsEnabled, boolean isVrOnly, boolean isVirtualDeviceOnly, int handledConfigChanges, boolean supportsStylusHandwriting, boolean supportsConnectionlessStylusHandwriting, String stylusHandwritingSettingsActivityAttr, boolean supportsInlineSuggestionsWithTouchExploration) {
        ServiceInfo si = ri.serviceInfo;
        this.mService = ri;
        this.mId = new ComponentName(si.packageName, si.name).flattenToShortString();
        this.mSettingsActivityName = settingsActivity;
        this.mLanguageSettingsActivityName = languageSettingsActivity;
        this.mIsDefaultResId = isDefaultResId;
        this.mIsAuxIme = isAuxIme;
        this.mSubtypes = new InputMethodSubtypeArray(subtypes);
        this.mForceDefault = forceDefault;
        this.mSupportsSwitchingToNextInputMethod = supportsSwitchingToNextInputMethod;
        this.mInlineSuggestionsEnabled = inlineSuggestionsEnabled;
        this.mSupportsInlineSuggestionsWithTouchExploration = supportsInlineSuggestionsWithTouchExploration;
        this.mSuppressesSpellChecker = false;
        this.mShowInInputMethodPicker = true;
        this.mIsVrOnly = isVrOnly;
        this.mIsVirtualDeviceOnly = isVirtualDeviceOnly;
        this.mHandledConfigChanges = handledConfigChanges;
        this.mSupportsStylusHandwriting = supportsStylusHandwriting;
        this.mSupportsConnectionlessStylusHandwriting = supportsConnectionlessStylusHandwriting;
        this.mStylusHandwritingSettingsActivityAttr = stylusHandwritingSettingsActivityAttr;
    }

    private static ResolveInfo buildFakeResolveInfo(String packageName, String className, CharSequence label) {
        ResolveInfo ri = new ResolveInfo();
        ServiceInfo si = new ServiceInfo();
        ApplicationInfo ai = new ApplicationInfo();
        ai.packageName = packageName;
        ai.enabled = true;
        si.applicationInfo = ai;
        si.enabled = true;
        si.packageName = packageName;
        si.name = className;
        si.exported = true;
        si.nonLocalizedLabel = label;
        ri.serviceInfo = si;
        return ri;
    }

    public String getId() {
        return this.mId;
    }

    public String getPackageName() {
        return this.mService.serviceInfo.packageName;
    }

    public String getServiceName() {
        return this.mService.serviceInfo.name;
    }

    public ServiceInfo getServiceInfo() {
        return this.mService.serviceInfo;
    }

    public ComponentName getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    public CharSequence loadLabel(PackageManager pm) {
        return this.mService.loadLabel(pm);
    }

    public Drawable loadIcon(PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    public String getSettingsActivity() {
        return this.mSettingsActivityName;
    }

    public boolean isVrOnly() {
        return this.mIsVrOnly;
    }

    @SystemApi
    public boolean isVirtualDeviceOnly() {
        return this.mIsVirtualDeviceOnly;
    }

    public int getSubtypeCount() {
        return this.mSubtypes.getCount();
    }

    public InputMethodSubtype getSubtypeAt(int index) {
        return this.mSubtypes.get(index);
    }

    public int getIsDefaultResourceId() {
        return this.mIsDefaultResId;
    }

    @UnsupportedAppUsage
    public boolean isDefault(Context context) {
        if (this.mForceDefault) {
            return true;
        }
        try {
            if (this.getIsDefaultResourceId() == 0) {
                return false;
            }
            Resources res = context.createPackageContext(this.getPackageName(), 0).getResources();
            return res.getBoolean(this.getIsDefaultResourceId());
        }
        catch (PackageManager.NameNotFoundException | Resources.NotFoundException e) {
            return false;
        }
    }

    public int getConfigChanges() {
        return this.mHandledConfigChanges;
    }

    public boolean supportsStylusHandwriting() {
        return this.mSupportsStylusHandwriting;
    }

    @FlaggedApi(value="android.view.inputmethod.connectionless_handwriting")
    public boolean supportsConnectionlessStylusHandwriting() {
        return this.mSupportsConnectionlessStylusHandwriting;
    }

    @Nullable
    public Intent createStylusHandwritingSettingsActivityIntent() {
        if (TextUtils.isEmpty(this.mStylusHandwritingSettingsActivityAttr) || !this.mSupportsStylusHandwriting) {
            return null;
        }
        return new Intent(ACTION_STYLUS_HANDWRITING_SETTINGS).setComponent(new ComponentName(this.getServiceInfo().packageName, this.mStylusHandwritingSettingsActivityAttr));
    }

    @FlaggedApi(value="android.view.inputmethod.ime_switcher_revamp_api")
    @Nullable
    public Intent createImeLanguageSettingsActivityIntent() {
        String activityName;
        String string2 = activityName = !TextUtils.isEmpty(this.mLanguageSettingsActivityName) ? this.mLanguageSettingsActivityName : this.mSettingsActivityName;
        if (TextUtils.isEmpty(activityName)) {
            return null;
        }
        return new Intent(ACTION_IME_LANGUAGE_SETTINGS).setComponent(new ComponentName(this.getServiceInfo().packageName, activityName));
    }

    public void dump(Printer pw, String prefix) {
        pw.println(prefix + "mId=" + this.mId + " mSettingsActivityName=" + this.mSettingsActivityName + " mLanguageSettingsActivityName=" + this.mLanguageSettingsActivityName + " mIsVrOnly=" + this.mIsVrOnly + " mIsVirtualDeviceOnly=" + this.mIsVirtualDeviceOnly + " mSupportsSwitchingToNextInputMethod=" + this.mSupportsSwitchingToNextInputMethod + " mInlineSuggestionsEnabled=" + this.mInlineSuggestionsEnabled + " mSupportsInlineSuggestionsWithTouchExploration=" + this.mSupportsInlineSuggestionsWithTouchExploration + " mSuppressesSpellChecker=" + this.mSuppressesSpellChecker + " mShowInInputMethodPicker=" + this.mShowInInputMethodPicker + " mSupportsStylusHandwriting=" + this.mSupportsStylusHandwriting + " mSupportsConnectionlessStylusHandwriting=" + this.mSupportsConnectionlessStylusHandwriting + " mStylusHandwritingSettingsActivityAttr=" + this.mStylusHandwritingSettingsActivityAttr);
        pw.println(prefix + "mIsDefaultResId=0x" + Integer.toHexString(this.mIsDefaultResId));
        pw.println(prefix + "Service:");
        this.mService.dump(pw, prefix + "  ");
        pw.println(prefix + "InputMethodSubtype array: count=" + this.mSubtypes.getCount());
        this.mSubtypes.dump(pw, prefix + "  ");
    }

    public String toString() {
        return "InputMethodInfo{" + this.mId + ", settings: " + this.mSettingsActivityName + ", languageSettings: " + this.mLanguageSettingsActivityName + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof InputMethodInfo)) {
            return false;
        }
        InputMethodInfo obj = (InputMethodInfo)o;
        return this.mId.equals(obj.mId);
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public boolean isSystem() {
        return (this.mService.serviceInfo.applicationInfo.flags & 1) != 0;
    }

    public boolean isAuxiliaryIme() {
        return this.mIsAuxIme;
    }

    public boolean supportsSwitchingToNextInputMethod() {
        return this.mSupportsSwitchingToNextInputMethod;
    }

    public boolean isInlineSuggestionsEnabled() {
        return this.mInlineSuggestionsEnabled;
    }

    public boolean supportsInlineSuggestionsWithTouchExploration() {
        return this.mSupportsInlineSuggestionsWithTouchExploration;
    }

    public boolean suppressesSpellChecker() {
        return this.mSuppressesSpellChecker;
    }

    public boolean shouldShowInInputMethodPicker() {
        return this.mShowInInputMethodPicker;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeString(this.mSettingsActivityName);
        dest.writeString8(this.mLanguageSettingsActivityName);
        dest.writeInt(this.mIsDefaultResId);
        dest.writeInt(this.mIsAuxIme ? 1 : 0);
        dest.writeInt(this.mSupportsSwitchingToNextInputMethod ? 1 : 0);
        dest.writeInt(this.mInlineSuggestionsEnabled ? 1 : 0);
        dest.writeInt(this.mSupportsInlineSuggestionsWithTouchExploration ? 1 : 0);
        dest.writeBoolean(this.mSuppressesSpellChecker);
        dest.writeBoolean(this.mShowInInputMethodPicker);
        dest.writeBoolean(this.mIsVrOnly);
        dest.writeBoolean(this.mIsVirtualDeviceOnly);
        this.mService.writeToParcel(dest, flags);
        this.mSubtypes.writeToParcel(dest);
        dest.writeInt(this.mHandledConfigChanges);
        dest.writeBoolean(this.mSupportsStylusHandwriting);
        dest.writeBoolean(this.mSupportsConnectionlessStylusHandwriting);
        dest.writeString8(this.mStylusHandwritingSettingsActivityAttr);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

