/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.inputmethod.InlineSuggestion;
import android.widget.inline.InlinePresentationSpec;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public class InlineSuggestionInfo
implements Parcelable {
    public static final String SOURCE_AUTOFILL = "android:autofill";
    public static final String SOURCE_PLATFORM = "android:platform";
    public static final String TYPE_SUGGESTION = "android:autofill:suggestion";
    @SuppressLint(value={"IntentName"})
    public static final String TYPE_ACTION = "android:autofill:action";
    @NonNull
    private final InlinePresentationSpec mInlinePresentationSpec;
    @NonNull
    private final String mSource;
    @Nullable
    private final String[] mAutofillHints;
    @NonNull
    private final String mType;
    private final boolean mPinned;
    @Nullable
    private final InlineSuggestion mTooltip;
    @NonNull
    public static final Parcelable.Creator<InlineSuggestionInfo> CREATOR = new Parcelable.Creator<InlineSuggestionInfo>(){

        public InlineSuggestionInfo[] newArray(int size) {
            return new InlineSuggestionInfo[size];
        }

        @Override
        public InlineSuggestionInfo createFromParcel(@NonNull Parcel in) {
            return new InlineSuggestionInfo(in);
        }
    };

    @NonNull
    public static InlineSuggestionInfo newInlineSuggestionInfo(@NonNull InlinePresentationSpec presentationSpec, @NonNull String source, @SuppressLint(value={"NullableCollection"}) @Nullable String[] autofillHints, @NonNull String type, boolean isPinned) {
        return new InlineSuggestionInfo(presentationSpec, source, autofillHints, type, isPinned, null);
    }

    @NonNull
    public static InlineSuggestionInfo newInlineSuggestionInfo(@NonNull InlinePresentationSpec presentationSpec, @NonNull String source, @Nullable String[] autofillHints, @NonNull String type, boolean isPinned, @Nullable InlineSuggestion tooltip) {
        return new InlineSuggestionInfo(presentationSpec, source, autofillHints, type, isPinned, tooltip);
    }

    public InlineSuggestionInfo(@NonNull InlinePresentationSpec inlinePresentationSpec, @NonNull String source, @Nullable String[] autofillHints, @NonNull String type, boolean pinned, @Nullable InlineSuggestion tooltip) {
        this.mInlinePresentationSpec = inlinePresentationSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mInlinePresentationSpec);
        this.mSource = source;
        if (!Objects.equals(this.mSource, SOURCE_AUTOFILL) && !Objects.equals(this.mSource, SOURCE_PLATFORM)) {
            throw new IllegalArgumentException("source was " + this.mSource + " but must be one of: SOURCE_AUTOFILL(" + SOURCE_AUTOFILL + "), SOURCE_PLATFORM(" + SOURCE_PLATFORM + ")");
        }
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSource);
        this.mAutofillHints = autofillHints;
        this.mType = type;
        if (!Objects.equals(this.mType, TYPE_SUGGESTION) && !Objects.equals(this.mType, TYPE_ACTION)) {
            throw new IllegalArgumentException("type was " + this.mType + " but must be one of: TYPE_SUGGESTION(" + TYPE_SUGGESTION + "), TYPE_ACTION(" + TYPE_ACTION + ")");
        }
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mType);
        this.mPinned = pinned;
        this.mTooltip = tooltip;
    }

    @NonNull
    public InlinePresentationSpec getInlinePresentationSpec() {
        return this.mInlinePresentationSpec;
    }

    @NonNull
    public String getSource() {
        return this.mSource;
    }

    @Nullable
    public String[] getAutofillHints() {
        return this.mAutofillHints;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    public boolean isPinned() {
        return this.mPinned;
    }

    @Nullable
    public InlineSuggestion getTooltip() {
        return this.mTooltip;
    }

    public String toString() {
        return "InlineSuggestionInfo { inlinePresentationSpec = " + this.mInlinePresentationSpec + ", source = " + this.mSource + ", autofillHints = " + Arrays.toString(this.mAutofillHints) + ", type = " + this.mType + ", pinned = " + this.mPinned + ", tooltip = " + this.mTooltip + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InlineSuggestionInfo that = (InlineSuggestionInfo)o;
        return Objects.equals(this.mInlinePresentationSpec, that.mInlinePresentationSpec) && Objects.equals(this.mSource, that.mSource) && Arrays.equals(this.mAutofillHints, that.mAutofillHints) && Objects.equals(this.mType, that.mType) && this.mPinned == that.mPinned && Objects.equals(this.mTooltip, that.mTooltip);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mInlinePresentationSpec);
        _hash = 31 * _hash + Objects.hashCode(this.mSource);
        _hash = 31 * _hash + Arrays.hashCode(this.mAutofillHints);
        _hash = 31 * _hash + Objects.hashCode(this.mType);
        _hash = 31 * _hash + Boolean.hashCode(this.mPinned);
        _hash = 31 * _hash + Objects.hashCode(this.mTooltip);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mPinned) {
            flg = (byte)(flg | 0x10);
        }
        if (this.mAutofillHints != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mTooltip != null) {
            flg = (byte)(flg | 0x20);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mInlinePresentationSpec, flags);
        dest.writeString(this.mSource);
        if (this.mAutofillHints != null) {
            dest.writeStringArray(this.mAutofillHints);
        }
        dest.writeString(this.mType);
        if (this.mTooltip != null) {
            dest.writeTypedObject(this.mTooltip, flags);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    InlineSuggestionInfo(@NonNull Parcel in) {
        byte flg = in.readByte();
        boolean pinned = (flg & 0x10) != 0;
        InlinePresentationSpec inlinePresentationSpec = in.readTypedObject(InlinePresentationSpec.CREATOR);
        String source = in.readString();
        String[] autofillHints = (flg & 4) == 0 ? null : in.createStringArray();
        String type = in.readString();
        InlineSuggestion tooltip = (flg & 0x20) == 0 ? null : in.readTypedObject(InlineSuggestion.CREATOR);
        this.mInlinePresentationSpec = inlinePresentationSpec;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mInlinePresentationSpec);
        this.mSource = source;
        if (!Objects.equals(this.mSource, SOURCE_AUTOFILL) && !Objects.equals(this.mSource, SOURCE_PLATFORM)) {
            throw new IllegalArgumentException("source was " + this.mSource + " but must be one of: SOURCE_AUTOFILL(" + SOURCE_AUTOFILL + "), SOURCE_PLATFORM(" + SOURCE_PLATFORM + ")");
        }
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSource);
        this.mAutofillHints = autofillHints;
        this.mType = type;
        if (!Objects.equals(this.mType, TYPE_SUGGESTION) && !Objects.equals(this.mType, TYPE_ACTION)) {
            throw new IllegalArgumentException("type was " + this.mType + " but must be one of: TYPE_SUGGESTION(" + TYPE_SUGGESTION + "), TYPE_ACTION(" + TYPE_ACTION + ")");
        }
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mType);
        this.mPinned = pinned;
        this.mTooltip = tooltip;
    }

    @Deprecated
    private void __metadata() {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Source {
    }
}

