/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.util.ExceptionUtils;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.Flags;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.window.ImeOnBackInvokedDispatcher;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.inputmethod.IBooleanListener;
import com.android.internal.inputmethod.IConnectionlessHandwritingCallback;
import com.android.internal.inputmethod.IImeTracker;
import com.android.internal.inputmethod.IInputMethodClient;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;
import com.android.internal.inputmethod.IRemoteInputConnection;
import com.android.internal.inputmethod.InputBindResult;
import com.android.internal.inputmethod.InputMethodInfoSafeList;
import com.android.internal.view.IInputMethodManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

class IInputMethodManagerGlobalInvoker {
    private static final long TIMEOUT_MS = 10000L;
    @Nullable
    private static volatile IInputMethodManager sServiceCache = null;
    @Nullable
    private static volatile IImeTracker sTrackerServiceCache = null;
    private static int sCurStartInputSeq = 0;

    IInputMethodManagerGlobalInvoker() {
    }

    static boolean isAvailable() {
        return IInputMethodManagerGlobalInvoker.getService() != null;
    }

    @Nullable
    static IInputMethodManager getService() {
        IInputMethodManager service = sServiceCache;
        if (service == null) {
            if (InputMethodManager.isInEditModeInternal()) {
                return null;
            }
            service = IInputMethodManager.Stub.asInterface(ServiceManager.getService("input_method"));
            if (service == null) {
                return null;
            }
            sServiceCache = service;
        }
        return service;
    }

    private static void handleRemoteExceptionOrRethrow(@NonNull RemoteException e, @Nullable Consumer<RemoteException> exceptionHandler) {
        if (exceptionHandler == null) {
            throw e.rethrowFromSystemServer();
        }
        exceptionHandler.accept(e);
    }

    @RequiresNoPermission
    static void startProtoDump(byte[] protoDump, int source, String where, @Nullable Consumer<RemoteException> exceptionHandler) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.startProtoDump(protoDump, source, where);
        }
        catch (RemoteException e) {
            IInputMethodManagerGlobalInvoker.handleRemoteExceptionOrRethrow(e, exceptionHandler);
        }
    }

    @RequiresPermission(value="android.permission.CONTROL_UI_TRACING")
    static void startImeTrace(@Nullable Consumer<RemoteException> exceptionHandler) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.startImeTrace();
        }
        catch (RemoteException e) {
            IInputMethodManagerGlobalInvoker.handleRemoteExceptionOrRethrow(e, exceptionHandler);
        }
    }

    @RequiresPermission(value="android.permission.CONTROL_UI_TRACING")
    static void stopImeTrace(@Nullable Consumer<RemoteException> exceptionHandler) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.stopImeTrace();
        }
        catch (RemoteException e) {
            IInputMethodManagerGlobalInvoker.handleRemoteExceptionOrRethrow(e, exceptionHandler);
        }
    }

    @RequiresNoPermission
    static boolean isImeTraceEnabled() {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.isImeTraceEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.INTERNAL_SYSTEM_WINDOW", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    static void removeImeSurface(int displayId, @Nullable Consumer<RemoteException> exceptionHandler) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.removeImeSurface(displayId);
        }
        catch (RemoteException e) {
            IInputMethodManagerGlobalInvoker.handleRemoteExceptionOrRethrow(e, exceptionHandler);
        }
    }

    static void addClient(@NonNull IInputMethodClient client, @NonNull IRemoteInputConnection fallbackInputConnection, int untrustedDisplayId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.addClient(client, fallbackInputConnection, untrustedDisplayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static InputMethodInfo getCurrentInputMethodInfoAsUser(int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return null;
        }
        try {
            return service.getCurrentInputMethodInfoAsUser(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static List<InputMethodInfo> getInputMethodList(int userId, int directBootAwareness) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return new ArrayList<InputMethodInfo>();
        }
        try {
            if (Flags.useInputMethodInfoSafeList()) {
                return InputMethodInfoSafeList.extractFrom(service.getInputMethodList(userId, directBootAwareness));
            }
            return service.getInputMethodListLegacy(userId, directBootAwareness);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static List<InputMethodInfo> getEnabledInputMethodList(int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return new ArrayList<InputMethodInfo>();
        }
        try {
            if (Flags.useInputMethodInfoSafeList()) {
                return InputMethodInfoSafeList.extractFrom(service.getEnabledInputMethodList(userId));
            }
            return service.getEnabledInputMethodListLegacy(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static List<InputMethodSubtype> getEnabledInputMethodSubtypeList(@Nullable String imiId, boolean allowsImplicitlyEnabledSubtypes, int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return new ArrayList<InputMethodSubtype>();
        }
        try {
            return service.getEnabledInputMethodSubtypeList(imiId, allowsImplicitlyEnabledSubtypes, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static InputMethodSubtype getLastInputMethodSubtype(int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return null;
        }
        try {
            return service.getLastInputMethodSubtype(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static boolean showSoftInput(@NonNull IInputMethodClient client, @Nullable IBinder windowToken, @NonNull ImeTracker.Token statsToken, int flags, int lastClickToolType, @Nullable ResultReceiver resultReceiver, int reason, boolean async) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.showSoftInput(client, windowToken, statsToken, flags, lastClickToolType, resultReceiver, reason, async);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static boolean hideSoftInput(@NonNull IInputMethodClient client, @Nullable IBinder windowToken, @NonNull ImeTracker.Token statsToken, int flags, @Nullable ResultReceiver resultReceiver, int reason, boolean async) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.hideSoftInput(client, windowToken, statsToken, flags, resultReceiver, reason, async);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static void hideSoftInputFromServerForTest() {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.hideSoftInputFromServerForTest();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static InputBindResult startInputOrWindowGainedFocus(int startInputReason, @NonNull IInputMethodClient client, @Nullable IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, @Nullable EditorInfo editorInfo, @Nullable IRemoteInputConnection remoteInputConnection, @Nullable IRemoteAccessibilityInputConnection remoteAccessibilityInputConnection, int unverifiedTargetSdkVersion, int userId, @NonNull ImeOnBackInvokedDispatcher imeDispatcher, boolean imeRequestedVisible) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return InputBindResult.NULL;
        }
        try {
            return service.startInputOrWindowGainedFocus(startInputReason, client, windowToken, startInputFlags, softInputMode, windowFlags, editorInfo, remoteInputConnection, remoteAccessibilityInputConnection, unverifiedTargetSdkVersion, userId, imeDispatcher, imeRequestedVisible);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static int startInputOrWindowGainedFocusAsync(int startInputReason, @NonNull IInputMethodClient client, @Nullable IBinder windowToken, int startInputFlags, int softInputMode, int windowFlags, @Nullable EditorInfo editorInfo, @Nullable IRemoteInputConnection remoteInputConnection, @Nullable IRemoteAccessibilityInputConnection remoteAccessibilityInputConnection, int unverifiedTargetSdkVersion, int userId, @NonNull ImeOnBackInvokedDispatcher imeDispatcher, boolean imeRequestedVisible, boolean useAsyncShowHideMethod) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return -1;
        }
        try {
            service.startInputOrWindowGainedFocusAsync(startInputReason, client, windowToken, startInputFlags, softInputMode, windowFlags, editorInfo, remoteInputConnection, remoteAccessibilityInputConnection, unverifiedTargetSdkVersion, userId, imeDispatcher, imeRequestedVisible, IInputMethodManagerGlobalInvoker.advanceAngGetStartInputSequenceNumber(), useAsyncShowHideMethod);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return sCurStartInputSeq;
    }

    private static int advanceAngGetStartInputSequenceNumber() {
        return ++sCurStartInputSeq;
    }

    static void showInputMethodPickerFromClient(@NonNull IInputMethodClient client, int auxiliarySubtypeMode) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.showInputMethodPickerFromClient(client, auxiliarySubtypeMode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.WRITE_SECURE_SETTINGS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    static void showInputMethodPickerFromSystem(int auxiliarySubtypeMode, int displayId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.showInputMethodPickerFromSystem(auxiliarySubtypeMode, displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static boolean isInputMethodPickerShownForTest() {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.isInputMethodPickerShownForTest();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.WRITE_SECURE_SETTINGS", "android.permission.INTERACT_ACROSS_USERS_FULL"})
    static void onImeSwitchButtonClickFromSystem(int displayId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.onImeSwitchButtonClickFromSystem(displayId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static boolean shouldShowImeSwitcherButtonForTest() {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.shouldShowImeSwitcherButtonForTest();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Nullable
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static InputMethodSubtype getCurrentInputMethodSubtype(int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return null;
        }
        try {
            return service.getCurrentInputMethodSubtype(userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static void setAdditionalInputMethodSubtypes(@NonNull String imeId, @NonNull InputMethodSubtype[] subtypes, int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.setAdditionalInputMethodSubtypes(imeId, subtypes, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static void setExplicitlyEnabledInputMethodSubtypes(@NonNull String imeId, @NonNull int[] subtypeHashCodes, int userId) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.setExplicitlyEnabledInputMethodSubtypes(imeId, subtypeHashCodes, userId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static int getInputMethodWindowVisibleHeight(@NonNull IInputMethodClient client) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return 0;
        }
        try {
            return service.getInputMethodWindowVisibleHeight(client);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void reportPerceptibleAsync(@NonNull IBinder windowToken, boolean perceptible) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.reportPerceptibleAsync(windowToken, perceptible);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void removeImeSurfaceFromWindowAsync(@NonNull IBinder windowToken) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.removeImeSurfaceFromWindowAsync(windowToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void startStylusHandwriting(@NonNull IInputMethodClient client) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.startStylusHandwriting(client);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static boolean startConnectionlessStylusHandwriting(@NonNull IInputMethodClient client, int userId, @Nullable CursorAnchorInfo cursorAnchorInfo, @Nullable String delegatePackageName, @Nullable String delegatorPackageName, @NonNull IConnectionlessHandwritingCallback callback) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            service.startConnectionlessStylusHandwriting(client, userId, cursorAnchorInfo, delegatePackageName, delegatorPackageName, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return true;
    }

    static void prepareStylusHandwritingDelegation(@NonNull IInputMethodClient client, int userId, @NonNull String delegatePackageName, @NonNull String delegatorPackageName) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.prepareStylusHandwritingDelegation(client, userId, delegatePackageName, delegatorPackageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static boolean acceptStylusHandwritingDelegation(@NonNull IInputMethodClient client, int userId, @NonNull String delegatePackageName, @NonNull String delegatorPackageName, int flags) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.acceptStylusHandwritingDelegation(client, userId, delegatePackageName, delegatorPackageName, flags);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static boolean acceptStylusHandwritingDelegationAsync(@NonNull IInputMethodClient client, int userId, @NonNull String delegatePackageName, @NonNull String delegatorPackageName, int flags, @NonNull IBooleanListener callback) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            service.acceptStylusHandwritingDelegationAsync(client, userId, delegatePackageName, delegatorPackageName, flags, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return true;
    }

    @RequiresPermission(value="android.permission.INTERACT_ACROSS_USERS_FULL", conditional=true)
    static boolean isStylusHandwritingAvailableAsUser(int userId, boolean connectionless) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return false;
        }
        try {
            return service.isStylusHandwritingAvailableAsUser(userId, connectionless);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static void addVirtualStylusIdForTestSession(IInputMethodClient client) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.addVirtualStylusIdForTestSession(client);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static void setStylusWindowIdleTimeoutForTest(IInputMethodClient client, long timeout) {
        IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
        if (service == null) {
            return;
        }
        try {
            service.setStylusWindowIdleTimeoutForTest(client, timeout);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    static ImeTracker.Token onStart(@NonNull String tag, int uid, int type, int origin, int reason, boolean fromUser) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return ImeTracker.Token.empty(tag);
        }
        try {
            return service.onStart(tag, uid, type, origin, reason, fromUser);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onProgress(@NonNull IBinder binder, int phase) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onProgress(binder, phase);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onFailed(@NonNull ImeTracker.Token statsToken, int phase) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onFailed(statsToken, phase);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onCancelled(@NonNull ImeTracker.Token statsToken, int phase) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onCancelled(statsToken, phase);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onShown(@NonNull ImeTracker.Token statsToken) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onShown(statsToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onHidden(@NonNull ImeTracker.Token statsToken) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onHidden(statsToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    static void onDispatched(@NonNull ImeTracker.Token statsToken) {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            service.onDispatched(statsToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static boolean hasPendingImeVisibilityRequests() {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return true;
        }
        try {
            return service.hasPendingImeVisibilityRequests();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.TEST_INPUT_METHOD")
    static void finishTrackingPendingImeVisibilityRequests() {
        IImeTracker service = IInputMethodManagerGlobalInvoker.getImeTrackerService();
        if (service == null) {
            return;
        }
        try {
            AndroidFuture completionSignal = new AndroidFuture();
            service.finishTrackingPendingImeVisibilityRequests(completionSignal);
            completionSignal.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (Exception e) {
            throw ExceptionUtils.propagate(e);
        }
    }

    @Nullable
    private static IImeTracker getImeTrackerService() {
        IImeTracker trackerService = sTrackerServiceCache;
        if (trackerService == null) {
            IInputMethodManager service = IInputMethodManagerGlobalInvoker.getService();
            if (service == null) {
                return null;
            }
            try {
                trackerService = service.getImeTrackerService();
                if (trackerService == null) {
                    return null;
                }
                sTrackerServiceCache = trackerService;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        return trackerService;
    }
}

