/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.content.LocusId;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.Objects;

public class DataShareRequest
implements Parcelable {
    @NonNull
    private final String mPackageName;
    @Nullable
    private final LocusId mLocusId;
    @NonNull
    private final String mMimeType;
    @NonNull
    public static final Parcelable.Creator<DataShareRequest> CREATOR = new Parcelable.Creator<DataShareRequest>(){

        public DataShareRequest[] newArray(int size) {
            return new DataShareRequest[size];
        }

        @Override
        public DataShareRequest createFromParcel(@NonNull Parcel in) {
            return new DataShareRequest(in);
        }
    };

    public DataShareRequest(@Nullable LocusId locusId, @NonNull String mimeType) {
        Objects.requireNonNull(mimeType);
        this.mPackageName = ActivityThread.currentActivityThread().getApplication().getPackageName();
        this.mLocusId = locusId;
        this.mMimeType = mimeType;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @Nullable
    public LocusId getLocusId() {
        return this.mLocusId;
    }

    @NonNull
    public String getMimeType() {
        return this.mMimeType;
    }

    public String toString() {
        return "DataShareRequest { packageName = " + this.mPackageName + ", locusId = " + this.mLocusId + ", mimeType = " + this.mMimeType + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataShareRequest that = (DataShareRequest)o;
        return Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mLocusId, that.mLocusId) && Objects.equals(this.mMimeType, that.mMimeType);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mPackageName);
        _hash = 31 * _hash + Objects.hashCode(this.mLocusId);
        _hash = 31 * _hash + Objects.hashCode(this.mMimeType);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mLocusId != null) {
            flg = (byte)(flg | 2);
        }
        dest.writeByte(flg);
        dest.writeString(this.mPackageName);
        if (this.mLocusId != null) {
            dest.writeTypedObject(this.mLocusId, flags);
        }
        dest.writeString(this.mMimeType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    DataShareRequest(@NonNull Parcel in) {
        byte flg = in.readByte();
        String packageName = in.readString();
        LocusId locusId = (flg & 2) == 0 ? null : in.readTypedObject(LocusId.CREATOR);
        String mimeType = in.readString();
        this.mPackageName = packageName;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPackageName);
        this.mLocusId = locusId;
        this.mMimeType = mimeType;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMimeType);
    }

    @Deprecated
    private void __metadata() {
    }
}

