/*
 * Decompiled with CFR 0.152.
 */
package android.view.contentcapture;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.compat.CompatChanges;
import android.content.ComponentName;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.IBinder;
import android.util.DebugUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewStructure;
import android.view.autofill.AutofillId;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.ContentCaptureSessionId;
import android.view.contentcapture.ViewNode;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class ContentCaptureSession
implements AutoCloseable {
    private static final String TAG = ContentCaptureSession.class.getSimpleName();
    private static final SecureRandom ID_GENERATOR = new SecureRandom();
    public static final String EXTRA_BINDER = "binder";
    public static final String EXTRA_ENABLED_STATE = "enabled";
    public static final int UNKNOWN_STATE = 0;
    public static final int STATE_WAITING_FOR_SERVER = 1;
    public static final int STATE_ACTIVE = 2;
    public static final int STATE_DISABLED = 4;
    public static final int STATE_DUPLICATED_ID = 8;
    public static final int STATE_NO_SERVICE = 16;
    public static final int STATE_FLAG_SECURE = 32;
    public static final int STATE_BY_APP = 64;
    public static final int STATE_NO_RESPONSE = 128;
    public static final int STATE_INTERNAL_ERROR = 256;
    public static final int STATE_NOT_WHITELISTED = 512;
    public static final int STATE_SERVICE_DIED = 1024;
    public static final int STATE_SERVICE_UPDATING = 2048;
    public static final int STATE_SERVICE_RESURRECTED = 4096;
    private static final int INITIAL_CHILDREN_CAPACITY = 5;
    public static final int FLUSH_REASON_FULL = 1;
    public static final int FLUSH_REASON_VIEW_ROOT_ENTERED = 2;
    public static final int FLUSH_REASON_SESSION_STARTED = 3;
    public static final int FLUSH_REASON_SESSION_FINISHED = 4;
    public static final int FLUSH_REASON_IDLE_TIMEOUT = 5;
    public static final int FLUSH_REASON_TEXT_CHANGE_TIMEOUT = 6;
    public static final int FLUSH_REASON_SESSION_CONNECTED = 7;
    public static final int FLUSH_REASON_FORCE_FLUSH = 8;
    public static final int FLUSH_REASON_VIEW_TREE_APPEARING = 9;
    public static final int FLUSH_REASON_VIEW_TREE_APPEARED = 10;
    static final long NOTIFY_NODES_DISAPPEAR_NOW_SENDS_TREE_EVENTS = 258825825L;
    private final Object mLock = new Object();
    @NonNull
    @GuardedBy(value={"mLock"})
    private boolean mDestroyed;
    @Nullable
    protected final int mId;
    private int mState = 0;
    private ContentCaptureSessionId mContentCaptureSessionId;
    @Nullable
    private ContentCaptureContext mClientContext;
    @Nullable
    @GuardedBy(value={"mLock"})
    private ArrayList<ContentCaptureSession> mChildren;

    protected ContentCaptureSession() {
        this(ContentCaptureSession.getRandomSessionId());
    }

    @VisibleForTesting
    public ContentCaptureSession(int id2) {
        Preconditions.checkArgument(id2 != 0);
        this.mId = id2;
    }

    ContentCaptureSession(@NonNull ContentCaptureContext initialContext) {
        this();
        this.mClientContext = Objects.requireNonNull(initialContext);
    }

    @NonNull
    abstract ContentCaptureSession getMainCaptureSession();

    abstract void start(@NonNull IBinder var1, @NonNull IBinder var2, @NonNull ComponentName var3, int var4);

    abstract boolean isDisabled();

    abstract boolean setDisabled(boolean var1);

    @NonNull
    public ContentCaptureSessionId getContentCaptureSessionId() {
        if (this.mContentCaptureSessionId == null) {
            this.mContentCaptureSessionId = new ContentCaptureSessionId(this.mId);
        }
        return this.mContentCaptureSessionId;
    }

    @NonNull
    public int getId() {
        return this.mId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ContentCaptureSession createContentCaptureSession(@NonNull ContentCaptureContext context) {
        ContentCaptureSession child = this.newChild(context);
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "createContentCaptureSession(" + context + ": parent=" + this.mId + ", child=" + child.mId);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mChildren == null) {
                this.mChildren = new ArrayList(5);
            }
            this.mChildren.add(child);
        }
        return child;
    }

    abstract ContentCaptureSession newChild(@NonNull ContentCaptureContext var1);

    abstract void flush(int var1);

    public void setContentCaptureContext(@Nullable ContentCaptureContext context) {
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        this.mClientContext = context;
        this.updateContentCaptureContext(context);
    }

    abstract void updateContentCaptureContext(@Nullable ContentCaptureContext var1);

    @Nullable
    public ContentCaptureContext getContentCaptureContext() {
        return this.mClientContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                if (ContentCaptureHelper.sDebug) {
                    Log.d(TAG, "destroy(" + this.mId + "): already destroyed");
                }
                return;
            }
            this.mDestroyed = true;
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "destroy(): state=" + ContentCaptureSession.getStateAsString(this.mState) + ", mId=" + this.mId);
            }
            if (this.mChildren != null) {
                int numberChildren = this.mChildren.size();
                if (ContentCaptureHelper.sVerbose) {
                    Log.v(TAG, "Destroying " + numberChildren + " children first");
                }
                for (int i = 0; i < numberChildren; ++i) {
                    ContentCaptureSession child = this.mChildren.get(i);
                    try {
                        child.destroy();
                        continue;
                    }
                    catch (Exception e) {
                        Log.w(TAG, "exception destroying child session #" + i + ": " + e);
                    }
                }
            }
        }
        this.onDestroy();
    }

    abstract void onDestroy();

    @Override
    public void close() {
        this.destroy();
    }

    public void notifyViewAppeared(@NonNull ViewStructure node) {
        Objects.requireNonNull(node);
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        if (!(node instanceof ViewNode.ViewStructureImpl)) {
            throw new IllegalArgumentException("Invalid node class: " + node.getClass());
        }
        this.internalNotifyViewAppeared(this.mId, (ViewNode.ViewStructureImpl)node);
    }

    abstract void internalNotifyViewAppeared(int var1, @NonNull ViewNode.ViewStructureImpl var2);

    public void notifyViewDisappeared(@NonNull AutofillId id2) {
        Objects.requireNonNull(id2);
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        this.internalNotifyViewDisappeared(this.mId, id2);
    }

    abstract void internalNotifyViewDisappeared(int var1, @NonNull AutofillId var2);

    public void notifyViewsAppeared(@NonNull List<ViewStructure> appearedNodes) {
        ViewStructure v;
        int i;
        Preconditions.checkCollectionElementsNotNull(appearedNodes, "appearedNodes");
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        for (i = 0; i < appearedNodes.size(); ++i) {
            v = appearedNodes.get(i);
            if (v instanceof ViewNode.ViewStructureImpl) continue;
            throw new IllegalArgumentException("Invalid class: " + v.getClass());
        }
        this.internalNotifyViewTreeEvent(this.mId, true);
        for (i = 0; i < appearedNodes.size(); ++i) {
            v = appearedNodes.get(i);
            this.internalNotifyViewAppeared(this.mId, (ViewNode.ViewStructureImpl)v);
        }
        this.internalNotifyViewTreeEvent(this.mId, false);
    }

    public void notifyViewsDisappeared(@NonNull AutofillId hostId, @NonNull long[] virtualIds) {
        Preconditions.checkArgument(hostId.isNonVirtual(), "hostId cannot be virtual: %s", hostId);
        Preconditions.checkArgument(!ArrayUtils.isEmpty(virtualIds), "virtual ids cannot be empty");
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        if (CompatChanges.isChangeEnabled(258825825L)) {
            this.internalNotifyViewTreeEvent(this.mId, true);
        }
        for (long id2 : virtualIds) {
            this.internalNotifyViewDisappeared(this.mId, new AutofillId(hostId, id2, this.mId));
        }
        if (CompatChanges.isChangeEnabled(258825825L)) {
            this.internalNotifyViewTreeEvent(this.mId, false);
        }
    }

    public void notifyViewTextChanged(@NonNull AutofillId id2, @Nullable CharSequence text) {
        Objects.requireNonNull(id2);
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        this.internalNotifyViewTextChanged(this.mId, id2, text);
    }

    abstract void internalNotifyViewTextChanged(int var1, @NonNull AutofillId var2, @Nullable CharSequence var3);

    public void notifyViewInsetsChanged(@NonNull Insets viewInsets) {
        Objects.requireNonNull(viewInsets);
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        this.internalNotifyViewInsetsChanged(this.mId, viewInsets);
    }

    abstract void internalNotifyViewInsetsChanged(int var1, @NonNull Insets var2);

    @FlaggedApi(value="android.view.contentcapture.flags.ccapi_baklava_enabled")
    public void flush() {
        this.internalNotifySessionFlushEvent(this.mId);
    }

    abstract void internalNotifySessionFlushEvent(int var1);

    public void notifyViewTreeEvent(boolean started) {
        this.internalNotifyViewTreeEvent(this.mId, started);
    }

    abstract void internalNotifyViewTreeEvent(int var1, boolean var2);

    public void notifySessionResumed() {
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        this.internalNotifySessionResumed();
    }

    abstract void internalNotifySessionResumed();

    public void notifySessionPaused() {
        if (!this.isContentCaptureEnabled()) {
            return;
        }
        this.internalNotifySessionPaused();
    }

    abstract void internalNotifySessionPaused();

    abstract void internalNotifyChildSessionStarted(int var1, int var2, @NonNull ContentCaptureContext var3);

    abstract void internalNotifyChildSessionFinished(int var1, int var2);

    abstract void internalNotifyContextUpdated(int var1, @Nullable ContentCaptureContext var2);

    public abstract void notifyWindowBoundsChanged(int var1, @NonNull Rect var2);

    public abstract void notifyContentCaptureEvents(@NonNull SparseArray<ArrayList<Object>> var1);

    @NonNull
    public ViewStructure newViewStructure(@NonNull View view) {
        return new ViewNode.ViewStructureImpl(view);
    }

    @NonNull
    public AutofillId newAutofillId(@NonNull AutofillId hostId, long virtualChildId) {
        Objects.requireNonNull(hostId);
        Preconditions.checkArgument(hostId.isNonVirtual(), "hostId cannot be virtual: %s", hostId);
        return new AutofillId(hostId, virtualChildId, this.mId);
    }

    @NonNull
    public ViewStructure newVirtualViewStructure(@NonNull AutofillId parentId, long virtualId) {
        return new ViewNode.ViewStructureImpl(parentId, virtualId, this.mId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isContentCaptureEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mDestroyed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(@NonNull String prefix, @NonNull PrintWriter pw) {
        pw.print(prefix);
        pw.print("id: ");
        pw.println(this.mId);
        if (this.mClientContext != null) {
            pw.print(prefix);
            this.mClientContext.dump(pw);
            pw.println();
        }
        Object object = this.mLock;
        synchronized (object) {
            pw.print(prefix);
            pw.print("destroyed: ");
            pw.println(this.mDestroyed);
            if (this.mChildren != null && !this.mChildren.isEmpty()) {
                String prefix2 = prefix + "  ";
                int numberChildren = this.mChildren.size();
                pw.print(prefix);
                pw.print("number children: ");
                pw.println(numberChildren);
                for (int i = 0; i < numberChildren; ++i) {
                    ContentCaptureSession child = this.mChildren.get(i);
                    pw.print(prefix);
                    pw.print(i);
                    pw.println(": ");
                    child.dump(prefix2, pw);
                }
            }
        }
    }

    public String toString() {
        return Integer.toString(this.mId);
    }

    @NonNull
    protected static String getStateAsString(int state) {
        return state + " (" + (state == 0 ? "UNKNOWN" : DebugUtils.flagsToString(ContentCaptureSession.class, "STATE_", state)) + ")";
    }

    @NonNull
    public static String getFlushReasonAsString(int reason) {
        switch (reason) {
            case 1: {
                return "FULL";
            }
            case 2: {
                return "VIEW_ROOT";
            }
            case 3: {
                return "STARTED";
            }
            case 4: {
                return "FINISHED";
            }
            case 5: {
                return "IDLE";
            }
            case 6: {
                return "TEXT_CHANGE";
            }
            case 7: {
                return "CONNECTED";
            }
            case 8: {
                return "FORCE_FLUSH";
            }
            case 9: {
                return "VIEW_TREE_APPEARING";
            }
            case 10: {
                return "VIEW_TREE_APPEARED";
            }
        }
        return "UNKNOWN-" + reason;
    }

    private static int getRandomSessionId() {
        int id2;
        while ((id2 = ID_GENERATOR.nextInt()) == 0) {
        }
        return id2;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FlushReason {
    }
}

