/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.content.ComponentName;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.autofill.UserData;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAutoFillManagerClient;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.List;

public interface IAutoFillManager
extends IInterface {
    public void addClient(IAutoFillManagerClient var1, ComponentName var2, int var3, IResultReceiver var4, boolean var5) throws RemoteException;

    public void removeClient(IAutoFillManagerClient var1, int var2) throws RemoteException;

    public void startSession(IBinder var1, IBinder var2, AutofillId var3, Rect var4, AutofillValue var5, int var6, boolean var7, int var8, ComponentName var9, boolean var10, IResultReceiver var11) throws RemoteException;

    public void getFillEventHistory(IResultReceiver var1) throws RemoteException;

    public void restoreSession(int var1, IBinder var2, IBinder var3, IResultReceiver var4) throws RemoteException;

    public void updateSession(int var1, AutofillId var2, Rect var3, AutofillValue var4, int var5, int var6, int var7) throws RemoteException;

    public void setAutofillFailure(int var1, List<AutofillId> var2, boolean var3, int var4) throws RemoteException;

    public void setViewAutofilled(int var1, AutofillId var2, int var3) throws RemoteException;

    public void finishSession(int var1, int var2, int var3) throws RemoteException;

    public void cancelSession(int var1, int var2) throws RemoteException;

    public void setAuthenticationResult(Bundle var1, int var2, int var3, int var4) throws RemoteException;

    public void setHasCallback(int var1, int var2, boolean var3) throws RemoteException;

    public void disableOwnedAutofillServices(int var1) throws RemoteException;

    public void isServiceSupported(int var1, IResultReceiver var2) throws RemoteException;

    public void isServiceEnabled(int var1, String var2, IResultReceiver var3) throws RemoteException;

    public void onPendingSaveUi(int var1, IBinder var2) throws RemoteException;

    public void getUserData(IResultReceiver var1) throws RemoteException;

    public void getUserDataId(IResultReceiver var1) throws RemoteException;

    public void setUserData(UserData var1) throws RemoteException;

    public void isFieldClassificationEnabled(IResultReceiver var1) throws RemoteException;

    public void getAutofillServiceComponentName(IResultReceiver var1) throws RemoteException;

    public void getAvailableFieldClassificationAlgorithms(IResultReceiver var1) throws RemoteException;

    public void getDefaultFieldClassificationAlgorithm(IResultReceiver var1) throws RemoteException;

    public void setAugmentedAutofillWhitelist(List<String> var1, List<ComponentName> var2, IResultReceiver var3) throws RemoteException;

    public void notifyNotExpiringResponseDuringAuth(int var1, int var2) throws RemoteException;

    public void notifyViewEnteredIgnoredDuringAuthCount(int var1, int var2) throws RemoteException;

    public void setAutofillIdsAttemptedForRefill(int var1, List<AutofillId> var2, int var3) throws RemoteException;

    public void notifyImeAnimationStart(int var1, long var2, int var4) throws RemoteException;

    public void notifyImeAnimationEnd(int var1, long var2, int var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAutoFillManager {
        public static final String DESCRIPTOR = "android.view.autofill.IAutoFillManager";
        static final int TRANSACTION_addClient = 1;
        static final int TRANSACTION_removeClient = 2;
        static final int TRANSACTION_startSession = 3;
        static final int TRANSACTION_getFillEventHistory = 4;
        static final int TRANSACTION_restoreSession = 5;
        static final int TRANSACTION_updateSession = 6;
        static final int TRANSACTION_setAutofillFailure = 7;
        static final int TRANSACTION_setViewAutofilled = 8;
        static final int TRANSACTION_finishSession = 9;
        static final int TRANSACTION_cancelSession = 10;
        static final int TRANSACTION_setAuthenticationResult = 11;
        static final int TRANSACTION_setHasCallback = 12;
        static final int TRANSACTION_disableOwnedAutofillServices = 13;
        static final int TRANSACTION_isServiceSupported = 14;
        static final int TRANSACTION_isServiceEnabled = 15;
        static final int TRANSACTION_onPendingSaveUi = 16;
        static final int TRANSACTION_getUserData = 17;
        static final int TRANSACTION_getUserDataId = 18;
        static final int TRANSACTION_setUserData = 19;
        static final int TRANSACTION_isFieldClassificationEnabled = 20;
        static final int TRANSACTION_getAutofillServiceComponentName = 21;
        static final int TRANSACTION_getAvailableFieldClassificationAlgorithms = 22;
        static final int TRANSACTION_getDefaultFieldClassificationAlgorithm = 23;
        static final int TRANSACTION_setAugmentedAutofillWhitelist = 24;
        static final int TRANSACTION_notifyNotExpiringResponseDuringAuth = 25;
        static final int TRANSACTION_notifyViewEnteredIgnoredDuringAuthCount = 26;
        static final int TRANSACTION_setAutofillIdsAttemptedForRefill = 27;
        static final int TRANSACTION_notifyImeAnimationStart = 28;
        static final int TRANSACTION_notifyImeAnimationEnd = 29;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IAutoFillManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IAutoFillManager) {
                return (IAutoFillManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "addClient";
                }
                case 2: {
                    return "removeClient";
                }
                case 3: {
                    return "startSession";
                }
                case 4: {
                    return "getFillEventHistory";
                }
                case 5: {
                    return "restoreSession";
                }
                case 6: {
                    return "updateSession";
                }
                case 7: {
                    return "setAutofillFailure";
                }
                case 8: {
                    return "setViewAutofilled";
                }
                case 9: {
                    return "finishSession";
                }
                case 10: {
                    return "cancelSession";
                }
                case 11: {
                    return "setAuthenticationResult";
                }
                case 12: {
                    return "setHasCallback";
                }
                case 13: {
                    return "disableOwnedAutofillServices";
                }
                case 14: {
                    return "isServiceSupported";
                }
                case 15: {
                    return "isServiceEnabled";
                }
                case 16: {
                    return "onPendingSaveUi";
                }
                case 17: {
                    return "getUserData";
                }
                case 18: {
                    return "getUserDataId";
                }
                case 19: {
                    return "setUserData";
                }
                case 20: {
                    return "isFieldClassificationEnabled";
                }
                case 21: {
                    return "getAutofillServiceComponentName";
                }
                case 22: {
                    return "getAvailableFieldClassificationAlgorithms";
                }
                case 23: {
                    return "getDefaultFieldClassificationAlgorithm";
                }
                case 24: {
                    return "setAugmentedAutofillWhitelist";
                }
                case 25: {
                    return "notifyNotExpiringResponseDuringAuth";
                }
                case 26: {
                    return "notifyViewEnteredIgnoredDuringAuthCount";
                }
                case 27: {
                    return "setAutofillIdsAttemptedForRefill";
                }
                case 28: {
                    return "notifyImeAnimationStart";
                }
                case 29: {
                    return "notifyImeAnimationEnd";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IAutoFillManagerClient _arg0 = IAutoFillManagerClient.Stub.asInterface(data.readStrongBinder());
                    ComponentName _arg1 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg2 = data.readInt();
                    IResultReceiver _arg3 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    boolean _arg4 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.addClient(_arg0, _arg1, _arg2, _arg3, _arg4);
                    break;
                }
                case 2: {
                    IAutoFillManagerClient _arg0 = IAutoFillManagerClient.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeClient(_arg0, _arg1);
                    break;
                }
                case 3: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    AutofillId _arg2 = data.readTypedObject(AutofillId.CREATOR);
                    Rect _arg3 = data.readTypedObject(Rect.CREATOR);
                    AutofillValue _arg4 = data.readTypedObject(AutofillValue.CREATOR);
                    int _arg5 = data.readInt();
                    boolean _arg6 = data.readBoolean();
                    int _arg7 = data.readInt();
                    ComponentName _arg8 = data.readTypedObject(ComponentName.CREATOR);
                    boolean _arg9 = data.readBoolean();
                    IResultReceiver _arg10 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startSession(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9, _arg10);
                    break;
                }
                case 4: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getFillEventHistory(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    IBinder _arg2 = data.readStrongBinder();
                    IResultReceiver _arg3 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.restoreSession(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    Rect _arg2 = data.readTypedObject(Rect.CREATOR);
                    AutofillValue _arg3 = data.readTypedObject(AutofillValue.CREATOR);
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateSession(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    ArrayList<AutofillId> _arg1 = data.createTypedArrayList(AutofillId.CREATOR);
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAutofillFailure(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    AutofillId _arg1 = data.readTypedObject(AutofillId.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setViewAutofilled(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.finishSession(_arg0, _arg1, _arg2);
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.cancelSession(_arg0, _arg1);
                    break;
                }
                case 11: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAuthenticationResult(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setHasCallback(_arg0, _arg1, _arg2);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableOwnedAutofillServices(_arg0);
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    IResultReceiver _arg1 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.isServiceSupported(_arg0, _arg1);
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    IResultReceiver _arg2 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.isServiceEnabled(_arg0, _arg1, _arg2);
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.onPendingSaveUi(_arg0, _arg1);
                    break;
                }
                case 17: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getUserData(_arg0);
                    break;
                }
                case 18: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getUserDataId(_arg0);
                    break;
                }
                case 19: {
                    UserData _arg0 = data.readTypedObject(UserData.CREATOR);
                    data.enforceNoDataAvail();
                    this.setUserData(_arg0);
                    break;
                }
                case 20: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.isFieldClassificationEnabled(_arg0);
                    break;
                }
                case 21: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getAutofillServiceComponentName(_arg0);
                    break;
                }
                case 22: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getAvailableFieldClassificationAlgorithms(_arg0);
                    break;
                }
                case 23: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getDefaultFieldClassificationAlgorithm(_arg0);
                    break;
                }
                case 24: {
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    ArrayList<ComponentName> _arg1 = data.createTypedArrayList(ComponentName.CREATOR);
                    IResultReceiver _arg2 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setAugmentedAutofillWhitelist(_arg0, _arg1, _arg2);
                    break;
                }
                case 25: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyNotExpiringResponseDuringAuth(_arg0, _arg1);
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyViewEnteredIgnoredDuringAuthCount(_arg0, _arg1);
                    break;
                }
                case 27: {
                    int _arg0 = data.readInt();
                    ArrayList<AutofillId> _arg1 = data.createTypedArrayList(AutofillId.CREATOR);
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setAutofillIdsAttemptedForRefill(_arg0, _arg1, _arg2);
                    break;
                }
                case 28: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyImeAnimationStart(_arg0, _arg1, _arg2);
                    break;
                }
                case 29: {
                    int _arg0 = data.readInt();
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.notifyImeAnimationEnd(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 28;
        }

        private static class Proxy
        implements IAutoFillManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addClient(IAutoFillManagerClient client, ComponentName componentName, int userId, IResultReceiver result, boolean credmanRequested) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeTypedObject(componentName, 0);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(result);
                    _data.writeBoolean(credmanRequested);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeClient(IAutoFillManagerClient client, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(client);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSession(IBinder activityToken, IBinder appCallback, AutofillId autoFillId, Rect bounds, AutofillValue value, int userId, boolean hasCallback, int flags, ComponentName componentName, boolean compatMode, IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongBinder(appCallback);
                    _data.writeTypedObject(autoFillId, 0);
                    _data.writeTypedObject(bounds, 0);
                    _data.writeTypedObject(value, 0);
                    _data.writeInt(userId);
                    _data.writeBoolean(hasCallback);
                    _data.writeInt(flags);
                    _data.writeTypedObject(componentName, 0);
                    _data.writeBoolean(compatMode);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getFillEventHistory(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreSession(int sessionId, IBinder activityToken, IBinder appCallback, IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeStrongBinder(activityToken);
                    _data.writeStrongBinder(appCallback);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateSession(int sessionId, AutofillId id2, Rect bounds, AutofillValue value, int action, int flags, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    _data.writeTypedObject(bounds, 0);
                    _data.writeTypedObject(value, 0);
                    _data.writeInt(action);
                    _data.writeInt(flags);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutofillFailure(int sessionId, List<AutofillId> ids, boolean isRefill, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedList(ids, 0);
                    _data.writeBoolean(isRefill);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setViewAutofilled(int sessionId, AutofillId id2, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedObject(id2, 0);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishSession(int sessionId, int userId, int commitReason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(userId);
                    _data.writeInt(commitReason);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelSession(int sessionId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAuthenticationResult(Bundle data, int sessionId, int authenticationId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(data, 0);
                    _data.writeInt(sessionId);
                    _data.writeInt(authenticationId);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHasCallback(int sessionId, int userId, boolean hasIt) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(userId);
                    _data.writeBoolean(hasIt);
                    boolean bl = this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableOwnedAutofillServices(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isServiceSupported(int userId, IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isServiceEnabled(int userId, String packageName, IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPendingSaveUi(int operation, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(operation);
                    _data.writeStrongBinder(token);
                    boolean bl = this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getUserData(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getUserDataId(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setUserData(UserData userData) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(userData, 0);
                    boolean bl = this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isFieldClassificationEnabled(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAutofillServiceComponentName(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAvailableFieldClassificationAlgorithms(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getDefaultFieldClassificationAlgorithm(IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAugmentedAutofillWhitelist(List<String> packages, List<ComponentName> activities, IResultReceiver result) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(packages);
                    _data.writeTypedList(activities, 0);
                    _data.writeStrongInterface(result);
                    boolean bl = this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyNotExpiringResponseDuringAuth(int sessionId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyViewEnteredIgnoredDuringAuthCount(int sessionId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutofillIdsAttemptedForRefill(int sessionId, List<AutofillId> ids, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeTypedList(ids, 0);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyImeAnimationStart(int sessionId, long startTimeMs, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeLong(startTimeMs);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyImeAnimationEnd(int sessionId, long endTimeMs, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    _data.writeLong(endTimeMs);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IAutoFillManager {
        @Override
        public void addClient(IAutoFillManagerClient client, ComponentName componentName, int userId, IResultReceiver result, boolean credmanRequested) throws RemoteException {
        }

        @Override
        public void removeClient(IAutoFillManagerClient client, int userId) throws RemoteException {
        }

        @Override
        public void startSession(IBinder activityToken, IBinder appCallback, AutofillId autoFillId, Rect bounds, AutofillValue value, int userId, boolean hasCallback, int flags, ComponentName componentName, boolean compatMode, IResultReceiver result) throws RemoteException {
        }

        @Override
        public void getFillEventHistory(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void restoreSession(int sessionId, IBinder activityToken, IBinder appCallback, IResultReceiver result) throws RemoteException {
        }

        @Override
        public void updateSession(int sessionId, AutofillId id2, Rect bounds, AutofillValue value, int action, int flags, int userId) throws RemoteException {
        }

        @Override
        public void setAutofillFailure(int sessionId, List<AutofillId> ids, boolean isRefill, int userId) throws RemoteException {
        }

        @Override
        public void setViewAutofilled(int sessionId, AutofillId id2, int userId) throws RemoteException {
        }

        @Override
        public void finishSession(int sessionId, int userId, int commitReason) throws RemoteException {
        }

        @Override
        public void cancelSession(int sessionId, int userId) throws RemoteException {
        }

        @Override
        public void setAuthenticationResult(Bundle data, int sessionId, int authenticationId, int userId) throws RemoteException {
        }

        @Override
        public void setHasCallback(int sessionId, int userId, boolean hasIt) throws RemoteException {
        }

        @Override
        public void disableOwnedAutofillServices(int userId) throws RemoteException {
        }

        @Override
        public void isServiceSupported(int userId, IResultReceiver result) throws RemoteException {
        }

        @Override
        public void isServiceEnabled(int userId, String packageName, IResultReceiver result) throws RemoteException {
        }

        @Override
        public void onPendingSaveUi(int operation, IBinder token) throws RemoteException {
        }

        @Override
        public void getUserData(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void getUserDataId(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void setUserData(UserData userData) throws RemoteException {
        }

        @Override
        public void isFieldClassificationEnabled(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void getAutofillServiceComponentName(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void getAvailableFieldClassificationAlgorithms(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void getDefaultFieldClassificationAlgorithm(IResultReceiver result) throws RemoteException {
        }

        @Override
        public void setAugmentedAutofillWhitelist(List<String> packages, List<ComponentName> activities, IResultReceiver result) throws RemoteException {
        }

        @Override
        public void notifyNotExpiringResponseDuringAuth(int sessionId, int userId) throws RemoteException {
        }

        @Override
        public void notifyViewEnteredIgnoredDuringAuthCount(int sessionId, int userId) throws RemoteException {
        }

        @Override
        public void setAutofillIdsAttemptedForRefill(int sessionId, List<AutofillId> ids, int userId) throws RemoteException {
        }

        @Override
        public void notifyImeAnimationStart(int sessionId, long startTimeMs, int userId) throws RemoteException {
        }

        @Override
        public void notifyImeAnimationEnd(int sessionId, long endTimeMs, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

