/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.annotation.FlaggedApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BaseInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.ClipRectAnimation;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.ExtendAnimation;
import android.view.animation.GridLayoutAnimationController;
import android.view.animation.Interpolator;
import android.view.animation.LayoutAnimationController;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.PathInterpolator;
import android.view.animation.RotateAnimation;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.view.flags.Flags;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AnimationUtils {
    private static final int TOGETHER = 0;
    private static final int SEQUENTIALLY = 1;
    private static boolean sExpectedPresentationTimeFlagValue = Flags.expectedPresentationTimeReadOnly();
    private static ThreadLocal<AnimationState> sAnimationState = new ThreadLocal<AnimationState>(){

        @Override
        protected AnimationState initialValue() {
            return new AnimationState();
        }
    };

    @FlaggedApi(value="android.view.flags.expected_presentation_time_read_only")
    public static void lockAnimationClock(long vsyncMillis, long expectedPresentationTimeNanos) {
        AnimationState state = sAnimationState.get();
        state.animationClockLocked = true;
        state.currentVsyncTimeMillis = vsyncMillis;
        if (!sExpectedPresentationTimeFlagValue) {
            state.mExpectedPresentationTimeNanos = expectedPresentationTimeNanos;
        }
    }

    public static void lockAnimationClock(long vsyncMillis) {
        AnimationState state = sAnimationState.get();
        state.animationClockLocked = true;
        state.currentVsyncTimeMillis = vsyncMillis;
    }

    public static void unlockAnimationClock() {
        AnimationUtils.sAnimationState.get().animationClockLocked = false;
    }

    public static long currentAnimationTimeMillis() {
        AnimationState state = sAnimationState.get();
        if (state.animationClockLocked) {
            return Math.max(state.currentVsyncTimeMillis, state.lastReportedTimeMillis);
        }
        state.lastReportedTimeMillis = SystemClock.uptimeMillis();
        return state.lastReportedTimeMillis;
    }

    @FlaggedApi(value="android.view.flags.expected_presentation_time_read_only")
    public static long getExpectedPresentationTimeNanos() {
        if (!sExpectedPresentationTimeFlagValue) {
            return SystemClock.uptimeMillis() * 1000000L;
        }
        AnimationState state = sAnimationState.get();
        return state.mExpectedPresentationTimeNanos;
    }

    @FlaggedApi(value="android.view.flags.expected_presentation_time_read_only")
    public static long getExpectedPresentationTimeMillis() {
        return AnimationUtils.getExpectedPresentationTimeNanos() / 1000000L;
    }

    public static Animation loadAnimation(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            Animation animation = AnimationUtils.createAnimationFromXml(context, parser);
            return animation;
        }
    }

    private static Animation createAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException {
        return AnimationUtils.createAnimationFromXml(c, parser, null, Xml.asAttributeSet(parser));
    }

    @UnsupportedAppUsage
    private static Animation createAnimationFromXml(Context c, XmlPullParser parser, AnimationSet parent, AttributeSet attrs) throws XmlPullParserException, IOException, InflateException {
        int type;
        Animation anim2 = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("set")) {
                anim2 = new AnimationSet(c, attrs);
                AnimationUtils.createAnimationFromXml(c, parser, anim2, attrs);
            } else if (name.equals("alpha")) {
                anim2 = new AlphaAnimation(c, attrs);
            } else if (name.equals("scale")) {
                anim2 = new ScaleAnimation(c, attrs);
            } else if (name.equals("rotate")) {
                anim2 = new RotateAnimation(c, attrs);
            } else if (name.equals("translate")) {
                anim2 = new TranslateAnimation(c, attrs);
            } else if (name.equals("cliprect")) {
                anim2 = new ClipRectAnimation(c, attrs);
            } else if (name.equals("extend")) {
                anim2 = new ExtendAnimation(c, attrs);
            } else {
                throw new InflateException("Unknown animation name: " + parser.getName());
            }
            if (parent == null) continue;
            parent.addAnimation(anim2);
        }
        return anim2;
    }

    public static LayoutAnimationController loadLayoutAnimation(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            LayoutAnimationController layoutAnimationController = AnimationUtils.createLayoutAnimationFromXml(context, parser);
            return layoutAnimationController;
        }
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context c, XmlPullParser parser) throws XmlPullParserException, IOException, InflateException {
        return AnimationUtils.createLayoutAnimationFromXml(c, parser, Xml.asAttributeSet(parser));
    }

    private static LayoutAnimationController createLayoutAnimationFromXml(Context c, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException, InflateException {
        int type;
        LayoutAnimationController controller = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if ("layoutAnimation".equals(name)) {
                controller = new LayoutAnimationController(c, attrs);
                continue;
            }
            if ("gridLayoutAnimation".equals(name)) {
                controller = new GridLayoutAnimationController(c, attrs);
                continue;
            }
            throw new InflateException("Unknown layout animation name: " + name);
        }
        return controller;
    }

    public static Animation makeInAnimation(Context c, boolean fromLeft) {
        Animation a = fromLeft ? AnimationUtils.loadAnimation(c, 17432578) : AnimationUtils.loadAnimation(c, 17432743);
        a.setInterpolator(new DecelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    public static Animation makeOutAnimation(Context c, boolean toRight) {
        Animation a = toRight ? AnimationUtils.loadAnimation(c, 17432579) : AnimationUtils.loadAnimation(c, 0x10A00AA);
        a.setInterpolator(new AccelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    public static Animation makeInChildBottomAnimation(Context c) {
        Animation a = AnimationUtils.loadAnimation(c, 17432740);
        a.setInterpolator(new AccelerateInterpolator());
        a.setStartTime(AnimationUtils.currentAnimationTimeMillis());
        return a;
    }

    public static Interpolator loadInterpolator(Context context, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = context.getResources().getAnimation(id2);
            Interpolator interpolator2 = AnimationUtils.createInterpolatorFromXml(context.getResources(), context.getTheme(), parser);
            return interpolator2;
        }
    }

    public static Interpolator loadInterpolator(Resources res, Resources.Theme theme, int id2) throws Resources.NotFoundException {
        try (XmlResourceParser parser = null;){
            parser = res.getAnimation(id2);
            Interpolator interpolator2 = AnimationUtils.createInterpolatorFromXml(res, theme, parser);
            return interpolator2;
        }
    }

    private static Interpolator createInterpolatorFromXml(Resources res, Resources.Theme theme, XmlPullParser parser) throws XmlPullParserException, IOException, InflateException {
        int type;
        BaseInterpolator interpolator2 = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            AttributeSet attrs = Xml.asAttributeSet(parser);
            String name = parser.getName();
            if (name.equals("linearInterpolator")) {
                interpolator2 = new LinearInterpolator();
                continue;
            }
            if (name.equals("accelerateInterpolator")) {
                interpolator2 = new AccelerateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("decelerateInterpolator")) {
                interpolator2 = new DecelerateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("accelerateDecelerateInterpolator")) {
                interpolator2 = new AccelerateDecelerateInterpolator();
                continue;
            }
            if (name.equals("cycleInterpolator")) {
                interpolator2 = new CycleInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("anticipateInterpolator")) {
                interpolator2 = new AnticipateInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("overshootInterpolator")) {
                interpolator2 = new OvershootInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("anticipateOvershootInterpolator")) {
                interpolator2 = new AnticipateOvershootInterpolator(res, theme, attrs);
                continue;
            }
            if (name.equals("bounceInterpolator")) {
                interpolator2 = new BounceInterpolator();
                continue;
            }
            if (name.equals("pathInterpolator")) {
                interpolator2 = new PathInterpolator(res, theme, attrs);
                continue;
            }
            throw new InflateException("Unknown interpolator name: " + parser.getName());
        }
        return interpolator2;
    }

    private static class AnimationState {
        boolean animationClockLocked;
        long currentVsyncTimeMillis;
        long lastReportedTimeMillis;
        long mExpectedPresentationTimeNanos;

        private AnimationState() {
        }
    }
}

