/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AccessibilityClickableSpan;
import android.text.style.AccessibilityReplacementSpan;
import android.text.style.AccessibilityURLSpan;
import android.text.style.ClickableSpan;
import android.text.style.ReplacementSpan;
import android.text.style.URLSpan;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.LongArray;
import android.util.Size;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.DirectAccessibilityConnection;
import android.view.accessibility.Flags;
import com.android.internal.R;
import com.android.internal.util.BitUtils;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AccessibilityNodeInfo
implements Parcelable {
    private static final String TAG = "AccessibilityNodeInfo";
    private static final boolean DEBUG = Log.isLoggable("AccessibilityNodeInfo", 3) && _Original_Build.IS_DEBUGGABLE;
    public static final int UNDEFINED_CONNECTION_ID = -1;
    public static final int UNDEFINED_SELECTION_INDEX = -1;
    public static final int UNDEFINED_ITEM_ID = Integer.MAX_VALUE;
    public static final int ROOT_ITEM_ID = 0x7FFFFFFE;
    public static final int LEASHED_ITEM_ID = 0x7FFFFFFD;
    public static final long UNDEFINED_NODE_ID = AccessibilityNodeInfo.makeNodeId(Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final long ROOT_NODE_ID = AccessibilityNodeInfo.makeNodeId(0x7FFFFFFE, -1);
    public static final long LEASHED_NODE_ID = AccessibilityNodeInfo.makeNodeId(0x7FFFFFFD, -1);
    public static final int FLAG_PREFETCH_ANCESTORS = 1;
    public static final int FLAG_PREFETCH_SIBLINGS = 2;
    public static final int FLAG_PREFETCH_DESCENDANTS_HYBRID = 4;
    public static final int FLAG_PREFETCH_DESCENDANTS_DEPTH_FIRST = 8;
    public static final int FLAG_PREFETCH_DESCENDANTS_BREADTH_FIRST = 16;
    public static final int FLAG_PREFETCH_UNINTERRUPTIBLE = 32;
    public static final int FLAG_PREFETCH_MASK = 63;
    public static final int FLAG_PREFETCH_DESCENDANTS_MASK = 28;
    @SuppressLint(value={"MinMaxConstant"})
    public static final int MAX_NUMBER_OF_PREFETCHED_NODES = 50;
    public static final int FLAG_SERVICE_REQUESTS_INCLUDE_NOT_IMPORTANT_VIEWS = 128;
    public static final int FLAG_SERVICE_REQUESTS_REPORT_VIEW_IDS = 256;
    public static final int FLAG_SERVICE_IS_ACCESSIBILITY_TOOL = 512;
    public static final int FLAG_REPORT_MASK = 896;
    public static final int ACTION_FOCUS = 1;
    public static final int ACTION_CLEAR_FOCUS = 2;
    public static final int ACTION_SELECT = 4;
    public static final int ACTION_CLEAR_SELECTION = 8;
    public static final int ACTION_CLICK = 16;
    public static final int ACTION_LONG_CLICK = 32;
    public static final int ACTION_ACCESSIBILITY_FOCUS = 64;
    public static final int ACTION_CLEAR_ACCESSIBILITY_FOCUS = 128;
    public static final int ACTION_NEXT_AT_MOVEMENT_GRANULARITY = 256;
    public static final int ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = 512;
    public static final int ACTION_NEXT_HTML_ELEMENT = 1024;
    public static final int ACTION_PREVIOUS_HTML_ELEMENT = 2048;
    public static final int ACTION_SCROLL_FORWARD = 4096;
    public static final int ACTION_SCROLL_BACKWARD = 8192;
    public static final int ACTION_COPY = 16384;
    public static final int ACTION_PASTE = 32768;
    public static final int ACTION_CUT = 65536;
    public static final int ACTION_SET_SELECTION = 131072;
    public static final int ACTION_EXPAND = 262144;
    public static final int ACTION_COLLAPSE = 524288;
    public static final int ACTION_DISMISS = 0x100000;
    public static final int ACTION_SET_TEXT = 0x200000;
    public static final int LAST_LEGACY_STANDARD_ACTION = 0x200000;
    private static final int INVALID_ACTIONS_MASK = -4194304;
    public static final String ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT = "ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT";
    public static final String ACTION_ARGUMENT_HTML_ELEMENT_STRING = "ACTION_ARGUMENT_HTML_ELEMENT_STRING";
    @FlaggedApi(value="android.view.accessibility.a11y_selection_api")
    public static final String ACTION_ARGUMENT_SELECTION_PARCELABLE = "android.view.accessibility.action.ARGUMENT_SELECTION_PARCELABLE";
    public static final String ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN = "ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN";
    public static final String ACTION_ARGUMENT_SELECTION_START_INT = "ACTION_ARGUMENT_SELECTION_START_INT";
    public static final String ACTION_ARGUMENT_SELECTION_END_INT = "ACTION_ARGUMENT_SELECTION_END_INT";
    public static final String ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE = "ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE";
    public static final String ACTION_ARGUMENT_ROW_INT = "android.view.accessibility.action.ARGUMENT_ROW_INT";
    public static final String ACTION_ARGUMENT_COLUMN_INT = "android.view.accessibility.action.ARGUMENT_COLUMN_INT";
    public static final String ACTION_ARGUMENT_PROGRESS_VALUE = "android.view.accessibility.action.ARGUMENT_PROGRESS_VALUE";
    public static final String ACTION_ARGUMENT_MOVE_WINDOW_X = "ACTION_ARGUMENT_MOVE_WINDOW_X";
    public static final String ACTION_ARGUMENT_MOVE_WINDOW_Y = "ACTION_ARGUMENT_MOVE_WINDOW_Y";
    public static final String ACTION_ARGUMENT_ACCESSIBLE_CLICKABLE_SPAN = "android.view.accessibility.action.ACTION_ARGUMENT_ACCESSIBLE_CLICKABLE_SPAN";
    public static final String ACTION_ARGUMENT_PRESS_AND_HOLD_DURATION_MILLIS_INT = "android.view.accessibility.action.ARGUMENT_PRESS_AND_HOLD_DURATION_MILLIS_INT";
    public static final String ACTION_ARGUMENT_DIRECTION_INT = "android.view.accessibility.action.ARGUMENT_DIRECTION_INT";
    @FlaggedApi(value="android.view.accessibility.granular_scrolling")
    public static final String ACTION_ARGUMENT_SCROLL_AMOUNT_FLOAT = "android.view.accessibility.action.ARGUMENT_SCROLL_AMOUNT_FLOAT";
    @FlaggedApi(value="android.view.accessibility.a11y_expansion_state_api")
    public static final int EXPANDED_STATE_UNDEFINED = 0;
    @FlaggedApi(value="android.view.accessibility.a11y_expansion_state_api")
    public static final int EXPANDED_STATE_COLLAPSED = 1;
    @FlaggedApi(value="android.view.accessibility.a11y_expansion_state_api")
    public static final int EXPANDED_STATE_PARTIAL = 2;
    @FlaggedApi(value="android.view.accessibility.a11y_expansion_state_api")
    public static final int EXPANDED_STATE_FULL = 3;
    public static final int FOCUS_INPUT = 1;
    public static final int FOCUS_ACCESSIBILITY = 2;
    public static final int MOVEMENT_GRANULARITY_CHARACTER = 1;
    public static final int MOVEMENT_GRANULARITY_WORD = 2;
    public static final int MOVEMENT_GRANULARITY_LINE = 4;
    public static final int MOVEMENT_GRANULARITY_PARAGRAPH = 8;
    public static final int MOVEMENT_GRANULARITY_PAGE = 16;
    public static final String EXTRA_DATA_TEXT_CHARACTER_LOCATION_KEY = "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY";
    @FlaggedApi(value="android.view.accessibility.a11y_character_in_window_api")
    public static final String EXTRA_DATA_TEXT_CHARACTER_LOCATION_IN_WINDOW_KEY = "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_IN_WINDOW_KEY";
    public static final String EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_START_INDEX = "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_START_INDEX";
    public static final String EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH = "android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH";
    public static final int EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_MAX_LENGTH = 20000;
    public static final String EXTRA_DATA_RENDERING_INFO_KEY = "android.view.accessibility.extra.DATA_RENDERING_INFO_KEY";
    public static final String EXTRA_DATA_REQUESTED_KEY = "android.view.accessibility.AccessibilityNodeInfo.extra_data_requested";
    @FlaggedApi(value="android.view.accessibility.tri_state_checked")
    public static final int CHECKED_STATE_FALSE = 0;
    @FlaggedApi(value="android.view.accessibility.tri_state_checked")
    public static final int CHECKED_STATE_TRUE = 1;
    @FlaggedApi(value="android.view.accessibility.tri_state_checked")
    public static final int CHECKED_STATE_PARTIAL = 2;
    private static final int BOOLEAN_PROPERTY_CHECKABLE = 1;
    private static final int BOOLEAN_PROPERTY_CHECKED = 2;
    private static final int BOOLEAN_PROPERTY_FOCUSABLE = 4;
    private static final int BOOLEAN_PROPERTY_FOCUSED = 8;
    private static final int BOOLEAN_PROPERTY_SELECTED = 16;
    private static final int BOOLEAN_PROPERTY_CLICKABLE = 32;
    private static final int BOOLEAN_PROPERTY_LONG_CLICKABLE = 64;
    private static final int BOOLEAN_PROPERTY_ENABLED = 128;
    private static final int BOOLEAN_PROPERTY_PASSWORD = 256;
    private static final int BOOLEAN_PROPERTY_SCROLLABLE = 512;
    private static final int BOOLEAN_PROPERTY_ACCESSIBILITY_FOCUSED = 1024;
    private static final int BOOLEAN_PROPERTY_VISIBLE_TO_USER = 2048;
    private static final int BOOLEAN_PROPERTY_EDITABLE = 4096;
    private static final int BOOLEAN_PROPERTY_OPENS_POPUP = 8192;
    private static final int BOOLEAN_PROPERTY_DISMISSABLE = 16384;
    private static final int BOOLEAN_PROPERTY_MULTI_LINE = 32768;
    private static final int BOOLEAN_PROPERTY_CONTENT_INVALID = 65536;
    private static final int BOOLEAN_PROPERTY_CONTEXT_CLICKABLE = 131072;
    private static final int BOOLEAN_PROPERTY_IMPORTANCE = 262144;
    private static final int BOOLEAN_PROPERTY_SCREEN_READER_FOCUSABLE = 524288;
    private static final int BOOLEAN_PROPERTY_IS_SHOWING_HINT = 0x100000;
    private static final int BOOLEAN_PROPERTY_IS_HEADING = 0x200000;
    private static final int BOOLEAN_PROPERTY_IS_TEXT_ENTRY_KEY = 0x400000;
    private static final int BOOLEAN_PROPERTY_IS_TEXT_SELECTABLE = 0x800000;
    private static final int BOOLEAN_PROPERTY_REQUEST_INITIAL_ACCESSIBILITY_FOCUS = 0x1000000;
    private static final int BOOLEAN_PROPERTY_ACCESSIBILITY_DATA_SENSITIVE = 0x2000000;
    private static final int BOOLEAN_PROPERTY_SUPPORTS_GRANULAR_SCROLLING = 0x4000000;
    private static final int BOOLEAN_PROPERTY_FIELD_REQUIRED = 0x8000000;
    private static final long VIRTUAL_DESCENDANT_ID_MASK = -4294967296L;
    private static final int VIRTUAL_DESCENDANT_ID_SHIFT = 32;
    private static final AccessibilityNodeInfo DEFAULT = new AccessibilityNodeInfo();
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private boolean mSealed;
    private int mWindowId = -1;
    @UnsupportedAppUsage
    private long mSourceNodeId = UNDEFINED_NODE_ID;
    private long mParentNodeId = UNDEFINED_NODE_ID;
    private long mLabelForId = UNDEFINED_NODE_ID;
    private long mLabeledById = UNDEFINED_NODE_ID;
    private LongArray mLabeledByIds;
    private long mTraversalBefore = UNDEFINED_NODE_ID;
    private long mTraversalAfter = UNDEFINED_NODE_ID;
    private long mMinDurationBetweenContentChanges = 0L;
    private int mBooleanProperties;
    private final Rect mBoundsInParent = new Rect();
    private final Rect mBoundsInScreen = new Rect();
    private final Rect mBoundsInWindow = new Rect();
    private int mDrawingOrderInParent;
    private CharSequence mPackageName;
    private CharSequence mClassName;
    private CharSequence mOriginalText;
    private CharSequence mText;
    private CharSequence mHintText;
    private CharSequence mError;
    private CharSequence mPaneTitle;
    private CharSequence mStateDescription;
    private CharSequence mContentDescription;
    private CharSequence mSupplementalDescription;
    private CharSequence mTooltipText;
    private String mViewIdResourceName;
    private String mUniqueId;
    private CharSequence mContainerTitle;
    private ArrayList<String> mExtraDataKeys;
    @UnsupportedAppUsage
    private LongArray mChildNodeIds;
    private ArrayList<AccessibilityAction> mActions;
    private int mMaxTextLength = -1;
    private int mMovementGranularities;
    private int mExpandedState;
    private int mTextSelectionStart = -1;
    private int mTextSelectionEnd = -1;
    private int mInputType = 0;
    private int mLiveRegion = 0;
    private Bundle mExtras;
    private int mConnectionId = -1;
    private Selection mSelection;
    private RangeInfo mRangeInfo;
    private CollectionInfo mCollectionInfo;
    private CollectionItemInfo mCollectionItemInfo;
    private TouchDelegateInfo mTouchDelegateInfo;
    private ExtraRenderingInfo mExtraRenderingInfo;
    private IBinder mLeashedChild;
    private IBinder mLeashedParent;
    private long mLeashedParentNodeId = UNDEFINED_NODE_ID;
    private int mChecked;
    @NonNull
    public static final Parcelable.Creator<AccessibilityNodeInfo> CREATOR = new Parcelable.Creator<AccessibilityNodeInfo>(){

        @Override
        public AccessibilityNodeInfo createFromParcel(Parcel parcel) {
            AccessibilityNodeInfo info = new AccessibilityNodeInfo();
            info.initFromParcel(parcel);
            return info;
        }

        public AccessibilityNodeInfo[] newArray(int size) {
            return new AccessibilityNodeInfo[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int getAccessibilityViewId(long accessibilityNodeId) {
        return (int)accessibilityNodeId;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int getVirtualDescendantId(long accessibilityNodeId) {
        return (int)((accessibilityNodeId & 0xFFFFFFFF00000000L) >> 32);
    }

    public static long makeNodeId(int accessibilityViewId, int virtualDescendantId) {
        return (long)virtualDescendantId << 32 | (long)accessibilityViewId;
    }

    public AccessibilityNodeInfo() {
    }

    public AccessibilityNodeInfo(@NonNull View source) {
        this.setSource(source);
    }

    public AccessibilityNodeInfo(@NonNull View root, int virtualDescendantId) {
        this.setSource(root, virtualDescendantId);
    }

    public AccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        this.init(info);
    }

    public void setSource(View source) {
        this.setSource(source, -1);
    }

    public void setSource(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        this.mWindowId = root != null ? root.getAccessibilityWindowId() : Integer.MAX_VALUE;
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mSourceNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public AccessibilityNodeInfo findFocus(int focus) {
        this.enforceSealed();
        this.enforceValidFocusType(focus);
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().findFocus(this.mConnectionId, this.mWindowId, this.mSourceNodeId, focus);
    }

    public AccessibilityNodeInfo focusSearch(int direction) {
        this.enforceSealed();
        this.enforceValidFocusDirection(direction);
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return null;
        }
        return AccessibilityInteractionClient.getInstance().focusSearch(this.mConnectionId, this.mWindowId, this.mSourceNodeId, direction);
    }

    public int getWindowId() {
        return this.mWindowId;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean refresh(Bundle arguments, boolean bypassCache) {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        AccessibilityNodeInfo refreshedInfo = client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, bypassCache, 0, arguments);
        if (refreshedInfo == null) {
            return false;
        }
        this.init(refreshedInfo);
        return true;
    }

    public boolean refresh() {
        return this.refresh(null, true);
    }

    public boolean refreshWithExtraData(String extraDataKey, Bundle args) {
        if (args.getInt(EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH, -1) > 20000) {
            args.putInt(EXTRA_DATA_TEXT_CHARACTER_LOCATION_ARG_LENGTH, 20000);
        }
        args.putString(EXTRA_DATA_REQUESTED_KEY, extraDataKey);
        return this.refresh(args, true);
    }

    public LongArray getChildNodeIds() {
        return this.mChildNodeIds;
    }

    public long getChildId(int index) {
        if (this.mChildNodeIds == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.mChildNodeIds.get(index);
    }

    public int getChildCount() {
        return this.mChildNodeIds == null ? 0 : this.mChildNodeIds.size();
    }

    public AccessibilityNodeInfo getChild(int index) {
        return this.getChild(index, 4);
    }

    @Nullable
    public AccessibilityNodeInfo getChild(int index, int prefetchingStrategy) {
        this.enforceSealed();
        if (this.mChildNodeIds == null) {
            return null;
        }
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return null;
        }
        long childId = this.mChildNodeIds.get(index);
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        if (this.mLeashedChild != null && childId == LEASHED_NODE_ID) {
            return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mLeashedChild, ROOT_NODE_ID, false, prefetchingStrategy, null);
        }
        return client.findAccessibilityNodeInfoByAccessibilityId(this.mConnectionId, this.mWindowId, childId, false, prefetchingStrategy, null);
    }

    public void addChild(View child) {
        this.addChildInternal(child, -1, true);
    }

    public void addChild(@NonNull IBinder token) {
        this.enforceNotSealed();
        if (token == null) {
            return;
        }
        if (this.mChildNodeIds == null) {
            this.mChildNodeIds = new LongArray();
        }
        this.mLeashedChild = token;
        if (this.mChildNodeIds.indexOf(LEASHED_NODE_ID) >= 0) {
            return;
        }
        this.mChildNodeIds.add(LEASHED_NODE_ID);
    }

    public void addChildUnchecked(View child) {
        this.addChildInternal(child, -1, false);
    }

    public boolean removeChild(View child) {
        return this.removeChild(child, -1);
    }

    public boolean removeChild(IBinder token) {
        this.enforceNotSealed();
        if (this.mChildNodeIds == null || this.mLeashedChild == null) {
            return false;
        }
        if (!this.mLeashedChild.equals(token)) {
            return false;
        }
        int index = this.mChildNodeIds.indexOf(LEASHED_NODE_ID);
        this.mLeashedChild = null;
        if (index < 0) {
            return false;
        }
        this.mChildNodeIds.remove(index);
        return true;
    }

    public void addChild(View root, int virtualDescendantId) {
        this.addChildInternal(root, virtualDescendantId, true);
    }

    private void addChildInternal(View root, int virtualDescendantId, boolean checked) {
        int rootAccessibilityViewId;
        long childNodeId;
        this.enforceNotSealed();
        if (this.mChildNodeIds == null) {
            this.mChildNodeIds = new LongArray();
        }
        if ((childNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE, virtualDescendantId)) == this.mSourceNodeId) {
            Log.e(TAG, "Rejecting attempt to make a View its own child");
            return;
        }
        if (checked && this.mChildNodeIds.indexOf(childNodeId) >= 0) {
            return;
        }
        this.mChildNodeIds.add(childNodeId);
    }

    public boolean removeChild(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        LongArray childIds = this.mChildNodeIds;
        if (childIds == null) {
            return false;
        }
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        long childNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
        int index = childIds.indexOf(childNodeId);
        if (index < 0) {
            return false;
        }
        childIds.remove(index);
        return true;
    }

    public List<AccessibilityAction> getActionList() {
        return CollectionUtils.emptyIfNull(this.mActions);
    }

    @Deprecated
    public int getActions() {
        int returnValue = 0;
        if (this.mActions == null) {
            return returnValue;
        }
        int actionSize = this.mActions.size();
        for (int i = 0; i < actionSize; ++i) {
            int actionId = this.mActions.get(i).getId();
            if (actionId > 0x200000) continue;
            returnValue |= actionId;
        }
        return returnValue;
    }

    public void addAction(AccessibilityAction action) {
        this.enforceNotSealed();
        this.addActionUnchecked(action);
    }

    private void addActionUnchecked(AccessibilityAction action) {
        if (action == null) {
            return;
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.remove(action);
        this.mActions.add(action);
    }

    @Deprecated
    public void addAction(int action) {
        this.enforceNotSealed();
        if ((action & 0xFFC00000) != 0) {
            throw new IllegalArgumentException("Action is not a combination of the standard actions: " + action);
        }
        this.addStandardActions(action);
    }

    @Deprecated
    public void removeAction(int action) {
        this.enforceNotSealed();
        this.removeAction(AccessibilityNodeInfo.getActionSingleton(action));
    }

    public boolean removeAction(AccessibilityAction action) {
        this.enforceNotSealed();
        if (this.mActions == null || action == null) {
            return false;
        }
        return this.mActions.remove(action);
    }

    public void removeAllActions() {
        if (this.mActions != null) {
            this.mActions.clear();
        }
    }

    public AccessibilityNodeInfo getTraversalBefore() {
        this.enforceSealed();
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mTraversalBefore);
    }

    public void setTraversalBefore(View view) {
        this.setTraversalBefore(view, -1);
    }

    public void setTraversalBefore(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mTraversalBefore = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public AccessibilityNodeInfo getTraversalAfter() {
        this.enforceSealed();
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mTraversalAfter);
    }

    public void setTraversalAfter(View view) {
        this.setTraversalAfter(view, -1);
    }

    public void setTraversalAfter(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mTraversalAfter = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    public List<String> getAvailableExtraData() {
        if (this.mExtraDataKeys != null) {
            return Collections.unmodifiableList(this.mExtraDataKeys);
        }
        return Collections.EMPTY_LIST;
    }

    public void setAvailableExtraData(List<String> extraDataKeys) {
        this.enforceNotSealed();
        this.mExtraDataKeys = new ArrayList<String>(extraDataKeys);
    }

    public void setMaxTextLength(int max) {
        this.enforceNotSealed();
        this.mMaxTextLength = max;
    }

    public int getMaxTextLength() {
        return this.mMaxTextLength;
    }

    public void setMovementGranularities(int granularities) {
        this.enforceNotSealed();
        this.mMovementGranularities = granularities;
    }

    public int getMovementGranularities() {
        return this.mMovementGranularities;
    }

    @FlaggedApi(value="android.view.accessibility.a11y_expansion_state_api")
    public void setExpandedState(int state) {
        this.enforceValidExpandedState(state);
        this.enforceNotSealed();
        this.mExpandedState = state;
    }

    @FlaggedApi(value="android.view.accessibility.a11y_expansion_state_api")
    public int getExpandedState() {
        return this.mExpandedState;
    }

    public void setMinDurationBetweenContentChanges(@NonNull Duration duration) {
        this.enforceNotSealed();
        this.mMinDurationBetweenContentChanges = duration.toMillis();
    }

    @NonNull
    public Duration getMinDurationBetweenContentChanges() {
        return Duration.ofMillis(this.mMinDurationBetweenContentChanges);
    }

    public boolean performAction(int action) {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        Bundle arguments = null;
        if (this.mExtras != null) {
            arguments = this.mExtras;
        }
        return client.performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, action, arguments);
    }

    public boolean performAction(int action, Bundle arguments) {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return false;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.performAccessibilityAction(this.mConnectionId, this.mWindowId, this.mSourceNodeId, action, arguments);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(String text) {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfosByText(this.mConnectionId, this.mWindowId, this.mSourceNodeId, text);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(@NonNull String viewId) {
        this.enforceSealed();
        if (viewId == null) {
            Log.e(TAG, "returns empty list due to null viewId.");
            return Collections.emptyList();
        }
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return Collections.emptyList();
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfosByViewId(this.mConnectionId, this.mWindowId, this.mSourceNodeId, viewId);
    }

    public AccessibilityWindowInfo getWindow() {
        this.enforceSealed();
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(this.mConnectionId, this.mWindowId, this.mSourceNodeId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.getWindow(this.mConnectionId, this.mWindowId);
    }

    public AccessibilityNodeInfo getParent() {
        this.enforceSealed();
        if (this.mLeashedParent != null && this.mLeashedParentNodeId != UNDEFINED_NODE_ID) {
            return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mLeashedParent, this.mLeashedParentNodeId, 3);
        }
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mParentNodeId);
    }

    @Nullable
    public AccessibilityNodeInfo getParent(int prefetchingStrategy) {
        this.enforceSealed();
        if (this.mLeashedParent != null && this.mLeashedParentNodeId != UNDEFINED_NODE_ID) {
            return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mLeashedParent, this.mLeashedParentNodeId, prefetchingStrategy);
        }
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mParentNodeId, prefetchingStrategy);
    }

    public long getParentNodeId() {
        return this.mParentNodeId;
    }

    public void setParent(View parent) {
        this.setParent(parent, -1);
    }

    public void setParent(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mParentNodeId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    @Deprecated
    public void getBoundsInParent(Rect outBounds) {
        outBounds.set(this.mBoundsInParent.left, this.mBoundsInParent.top, this.mBoundsInParent.right, this.mBoundsInParent.bottom);
    }

    @Deprecated
    public void setBoundsInParent(Rect bounds) {
        this.enforceNotSealed();
        this.mBoundsInParent.set(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void getBoundsInScreen(Rect outBounds) {
        outBounds.set(this.mBoundsInScreen.left, this.mBoundsInScreen.top, this.mBoundsInScreen.right, this.mBoundsInScreen.bottom);
    }

    public Rect getBoundsInScreen() {
        return this.mBoundsInScreen;
    }

    public void setBoundsInScreen(Rect bounds) {
        this.enforceNotSealed();
        this.mBoundsInScreen.set(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    public void getBoundsInWindow(@NonNull Rect outBounds) {
        outBounds.set(this.mBoundsInWindow.left, this.mBoundsInWindow.top, this.mBoundsInWindow.right, this.mBoundsInWindow.bottom);
    }

    @NonNull
    public Rect getBoundsInWindow() {
        return this.mBoundsInWindow;
    }

    public void setBoundsInWindow(@NonNull Rect bounds) {
        this.enforceNotSealed();
        this.mBoundsInWindow.set(bounds);
    }

    public boolean isCheckable() {
        return this.getBooleanProperty(1);
    }

    public void setCheckable(boolean checkable) {
        this.setBooleanProperty(1, checkable);
    }

    @Deprecated
    @FlaggedApi(value="android.view.accessibility.tri_state_checked")
    public boolean isChecked() {
        return this.getBooleanProperty(2);
    }

    @Deprecated
    @FlaggedApi(value="android.view.accessibility.tri_state_checked")
    public void setChecked(boolean checked) {
        this.setBooleanProperty(2, checked);
        if (Flags.triStateChecked()) {
            this.mChecked = checked ? 1 : 0;
        }
    }

    @FlaggedApi(value="android.view.accessibility.tri_state_checked")
    public int getChecked() {
        return this.mChecked;
    }

    @FlaggedApi(value="android.view.accessibility.tri_state_checked")
    public void setChecked(int checked) {
        this.enforceNotSealed();
        switch (checked) {
            case 0: 
            case 1: 
            case 2: {
                this.mChecked = checked;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown checked argument: " + checked);
            }
        }
        this.setBooleanProperty(2, checked == 1);
    }

    @FlaggedApi(value="android.view.accessibility.a11y_is_required_api")
    public boolean isFieldRequired() {
        return this.getBooleanProperty(0x8000000);
    }

    @FlaggedApi(value="android.view.accessibility.a11y_is_required_api")
    public void setFieldRequired(boolean required) {
        this.setBooleanProperty(0x8000000, required);
    }

    public boolean isFocusable() {
        return this.getBooleanProperty(4);
    }

    public void setFocusable(boolean focusable) {
        this.setBooleanProperty(4, focusable);
    }

    public boolean isFocused() {
        return this.getBooleanProperty(8);
    }

    public void setFocused(boolean focused) {
        this.setBooleanProperty(8, focused);
    }

    @FlaggedApi(value="android.view.accessibility.a11y_selection_api")
    public void setSelection(@Nullable Selection selection) {
        this.enforceNotSealed();
        this.mSelection = selection;
    }

    @FlaggedApi(value="android.view.accessibility.a11y_selection_api")
    @Nullable
    public Selection getSelection() {
        if (this.mSelection != null) {
            this.mSelection.getStart().setWindowId(this.mWindowId);
            this.mSelection.getStart().setConnectionId(this.mConnectionId);
            this.mSelection.getEnd().setWindowId(this.mWindowId);
            this.mSelection.getEnd().setConnectionId(this.mConnectionId);
        }
        return this.mSelection;
    }

    public boolean isVisibleToUser() {
        return this.getBooleanProperty(2048);
    }

    public void setVisibleToUser(boolean visibleToUser) {
        this.setBooleanProperty(2048, visibleToUser);
    }

    public boolean isAccessibilityFocused() {
        return this.getBooleanProperty(1024);
    }

    public void setAccessibilityFocused(boolean focused) {
        this.setBooleanProperty(1024, focused);
    }

    public boolean isSelected() {
        return this.getBooleanProperty(16);
    }

    public void setSelected(boolean selected) {
        this.setBooleanProperty(16, selected);
    }

    public boolean isClickable() {
        return this.getBooleanProperty(32);
    }

    public void setClickable(boolean clickable) {
        this.setBooleanProperty(32, clickable);
    }

    public boolean isLongClickable() {
        return this.getBooleanProperty(64);
    }

    public void setLongClickable(boolean longClickable) {
        this.setBooleanProperty(64, longClickable);
    }

    public boolean isEnabled() {
        return this.getBooleanProperty(128);
    }

    public void setEnabled(boolean enabled) {
        this.setBooleanProperty(128, enabled);
    }

    public boolean isPassword() {
        return this.getBooleanProperty(256);
    }

    public void setPassword(boolean password) {
        this.setBooleanProperty(256, password);
    }

    public boolean isScrollable() {
        return this.getBooleanProperty(512);
    }

    public void setScrollable(boolean scrollable) {
        this.setBooleanProperty(512, scrollable);
    }

    @FlaggedApi(value="android.view.accessibility.granular_scrolling")
    public boolean isGranularScrollingSupported() {
        return this.getBooleanProperty(0x4000000);
    }

    @FlaggedApi(value="android.view.accessibility.granular_scrolling")
    public void setGranularScrollingSupported(boolean granularScrollingSupported) {
        this.setBooleanProperty(0x4000000, granularScrollingSupported);
    }

    public boolean isTextSelectable() {
        return this.getBooleanProperty(0x800000);
    }

    public void setTextSelectable(boolean selectableText) {
        this.setBooleanProperty(0x800000, selectableText);
    }

    public boolean hasRequestInitialAccessibilityFocus() {
        return this.getBooleanProperty(0x1000000);
    }

    public void setRequestInitialAccessibilityFocus(boolean requestInitialAccessibilityFocus) {
        this.setBooleanProperty(0x1000000, requestInitialAccessibilityFocus);
    }

    public boolean isEditable() {
        return this.getBooleanProperty(4096);
    }

    public void setEditable(boolean editable) {
        this.setBooleanProperty(4096, editable);
    }

    public boolean isAccessibilityDataSensitive() {
        return this.getBooleanProperty(0x2000000);
    }

    public void setAccessibilityDataSensitive(boolean accessibilityDataSensitive) {
        this.setBooleanProperty(0x2000000, accessibilityDataSensitive);
    }

    public void setPaneTitle(@Nullable CharSequence paneTitle) {
        this.enforceNotSealed();
        this.mPaneTitle = paneTitle == null ? null : paneTitle.subSequence(0, paneTitle.length());
    }

    @Nullable
    public CharSequence getPaneTitle() {
        return this.mPaneTitle;
    }

    public int getDrawingOrder() {
        return this.mDrawingOrderInParent;
    }

    public void setDrawingOrder(int drawingOrderInParent) {
        this.enforceNotSealed();
        this.mDrawingOrderInParent = drawingOrderInParent;
    }

    public CollectionInfo getCollectionInfo() {
        return this.mCollectionInfo;
    }

    public void setCollectionInfo(CollectionInfo collectionInfo) {
        this.enforceNotSealed();
        this.mCollectionInfo = collectionInfo;
    }

    public CollectionItemInfo getCollectionItemInfo() {
        return this.mCollectionItemInfo;
    }

    public void setCollectionItemInfo(CollectionItemInfo collectionItemInfo) {
        this.enforceNotSealed();
        this.mCollectionItemInfo = collectionItemInfo;
    }

    public RangeInfo getRangeInfo() {
        return this.mRangeInfo;
    }

    public void setRangeInfo(RangeInfo rangeInfo) {
        this.enforceNotSealed();
        this.mRangeInfo = rangeInfo;
    }

    @Nullable
    public ExtraRenderingInfo getExtraRenderingInfo() {
        return this.mExtraRenderingInfo;
    }

    public void setExtraRenderingInfo(@NonNull ExtraRenderingInfo extraRenderingInfo) {
        this.enforceNotSealed();
        this.mExtraRenderingInfo = extraRenderingInfo;
    }

    public boolean isContentInvalid() {
        return this.getBooleanProperty(65536);
    }

    public void setContentInvalid(boolean contentInvalid) {
        this.setBooleanProperty(65536, contentInvalid);
    }

    public boolean isContextClickable() {
        return this.getBooleanProperty(131072);
    }

    public void setContextClickable(boolean contextClickable) {
        this.setBooleanProperty(131072, contextClickable);
    }

    public int getLiveRegion() {
        return this.mLiveRegion;
    }

    public void setLiveRegion(int mode) {
        this.enforceNotSealed();
        this.mLiveRegion = mode;
    }

    public boolean isMultiLine() {
        return this.getBooleanProperty(32768);
    }

    public void setMultiLine(boolean multiLine) {
        this.setBooleanProperty(32768, multiLine);
    }

    public boolean canOpenPopup() {
        return this.getBooleanProperty(8192);
    }

    public void setCanOpenPopup(boolean opensPopup) {
        this.enforceNotSealed();
        this.setBooleanProperty(8192, opensPopup);
    }

    public boolean isDismissable() {
        return this.getBooleanProperty(16384);
    }

    public void setDismissable(boolean dismissable) {
        this.setBooleanProperty(16384, dismissable);
    }

    public boolean isImportantForAccessibility() {
        return this.getBooleanProperty(262144);
    }

    public void setImportantForAccessibility(boolean important) {
        this.setBooleanProperty(262144, important);
    }

    public boolean isScreenReaderFocusable() {
        return this.getBooleanProperty(524288);
    }

    public void setScreenReaderFocusable(boolean screenReaderFocusable) {
        this.setBooleanProperty(524288, screenReaderFocusable);
    }

    public boolean isShowingHintText() {
        return this.getBooleanProperty(0x100000);
    }

    public void setShowingHintText(boolean showingHintText) {
        this.setBooleanProperty(0x100000, showingHintText);
    }

    public boolean isHeading() {
        if (this.getBooleanProperty(0x200000)) {
            return true;
        }
        CollectionItemInfo itemInfo = this.getCollectionItemInfo();
        return itemInfo != null && itemInfo.mHeading;
    }

    public void setHeading(boolean isHeading) {
        this.setBooleanProperty(0x200000, isHeading);
    }

    public boolean isTextEntryKey() {
        return this.getBooleanProperty(0x400000);
    }

    public void setTextEntryKey(boolean isTextEntryKey) {
        this.setBooleanProperty(0x400000, isTextEntryKey);
    }

    public CharSequence getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(CharSequence packageName) {
        this.enforceNotSealed();
        this.mPackageName = packageName;
    }

    public CharSequence getClassName() {
        return this.mClassName;
    }

    public void setClassName(CharSequence className) {
        this.enforceNotSealed();
        this.mClassName = className;
    }

    public CharSequence getText() {
        if (this.mText instanceof Spanned) {
            Spanned spanned = (Spanned)this.mText;
            AccessibilityClickableSpan[] clickableSpans = spanned.getSpans(0, this.mText.length(), AccessibilityClickableSpan.class);
            for (int i = 0; i < clickableSpans.length; ++i) {
                clickableSpans[i].copyConnectionDataFrom(this);
            }
            AccessibilityURLSpan[] urlSpans = spanned.getSpans(0, this.mText.length(), AccessibilityURLSpan.class);
            for (int i = 0; i < urlSpans.length; ++i) {
                urlSpans[i].copyConnectionDataFrom(this);
            }
        }
        return this.mText;
    }

    public CharSequence getOriginalText() {
        return this.mOriginalText;
    }

    public void setText(CharSequence text) {
        this.enforceNotSealed();
        this.mOriginalText = text;
        if (text instanceof Spanned) {
            CharSequence tmpText = text;
            tmpText = this.replaceClickableSpan(tmpText);
            this.mText = tmpText = this.replaceReplacementSpan(tmpText);
            return;
        }
        this.mText = text == null ? null : text.subSequence(0, text.length());
    }

    private CharSequence replaceClickableSpan(CharSequence text) {
        ClickableSpan span;
        ClickableSpan[] clickableSpans = ((Spanned)text).getSpans(0, text.length(), ClickableSpan.class);
        SpannableStringBuilder spannable = new SpannableStringBuilder(text);
        if (clickableSpans.length == 0) {
            return text;
        }
        for (int i = 0; i < clickableSpans.length && !((span = clickableSpans[i]) instanceof AccessibilityClickableSpan) && !(span instanceof AccessibilityURLSpan); ++i) {
            int spanToReplaceStart = spannable.getSpanStart(span);
            int spanToReplaceEnd = spannable.getSpanEnd(span);
            int spanToReplaceFlags = spannable.getSpanFlags(span);
            if (spanToReplaceStart < 0) continue;
            spannable.removeSpan(span);
            ClickableSpan replacementSpan = span instanceof URLSpan ? new AccessibilityURLSpan((URLSpan)span) : new AccessibilityClickableSpan(span.getId());
            spannable.setSpan(replacementSpan, spanToReplaceStart, spanToReplaceEnd, spanToReplaceFlags);
        }
        return spannable;
    }

    private CharSequence replaceReplacementSpan(CharSequence text) {
        ReplacementSpan[] replacementSpans = ((Spanned)text).getSpans(0, text.length(), ReplacementSpan.class);
        SpannableStringBuilder spannable = new SpannableStringBuilder(text);
        if (replacementSpans.length == 0) {
            return text;
        }
        for (int i = 0; i < replacementSpans.length; ++i) {
            ReplacementSpan span = replacementSpans[i];
            CharSequence replacementText = span.getContentDescription();
            if (span instanceof AccessibilityReplacementSpan) break;
            if (replacementText == null) continue;
            int spanToReplaceStart = spannable.getSpanStart(span);
            int spanToReplaceEnd = spannable.getSpanEnd(span);
            int spanToReplaceFlags = spannable.getSpanFlags(span);
            if (spanToReplaceStart < 0) continue;
            spannable.removeSpan(span);
            AccessibilityReplacementSpan replacementSpan = new AccessibilityReplacementSpan(replacementText);
            spannable.setSpan(replacementSpan, spanToReplaceStart, spanToReplaceEnd, spanToReplaceFlags);
        }
        return spannable;
    }

    public CharSequence getHintText() {
        return this.mHintText;
    }

    public void setHintText(CharSequence hintText) {
        this.enforceNotSealed();
        this.mHintText = hintText == null ? null : hintText.subSequence(0, hintText.length());
    }

    public void setError(CharSequence error) {
        this.enforceNotSealed();
        this.mError = error == null ? null : error.subSequence(0, error.length());
    }

    public CharSequence getError() {
        return this.mError;
    }

    @Nullable
    public CharSequence getStateDescription() {
        return this.mStateDescription;
    }

    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @FlaggedApi(value="android.view.accessibility.supplemental_description")
    @Nullable
    public CharSequence getSupplementalDescription() {
        return this.mSupplementalDescription;
    }

    public void setStateDescription(@Nullable CharSequence stateDescription) {
        this.enforceNotSealed();
        this.mStateDescription = stateDescription == null ? null : stateDescription.subSequence(0, stateDescription.length());
    }

    public void setContentDescription(CharSequence contentDescription) {
        this.enforceNotSealed();
        this.mContentDescription = contentDescription == null ? null : contentDescription.subSequence(0, contentDescription.length());
    }

    @FlaggedApi(value="android.view.accessibility.supplemental_description")
    public void setSupplementalDescription(@Nullable CharSequence supplementalDescription) {
        this.enforceNotSealed();
        this.mSupplementalDescription = supplementalDescription == null ? null : supplementalDescription.subSequence(0, supplementalDescription.length());
    }

    @Nullable
    public CharSequence getTooltipText() {
        return this.mTooltipText;
    }

    public void setTooltipText(@Nullable CharSequence tooltipText) {
        this.enforceNotSealed();
        this.mTooltipText = tooltipText == null ? null : tooltipText.subSequence(0, tooltipText.length());
    }

    @Deprecated
    @FlaggedApi(value="android.view.accessibility.deprecate_ani_label_for_apis")
    public void setLabelFor(View labeled) {
        this.setLabelFor(labeled, -1);
    }

    @Deprecated
    @FlaggedApi(value="android.view.accessibility.deprecate_ani_label_for_apis")
    public void setLabelFor(View root, int virtualDescendantId) {
        this.enforceNotSealed();
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        this.mLabelForId = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
    }

    @Deprecated
    @FlaggedApi(value="android.view.accessibility.deprecate_ani_label_for_apis")
    public AccessibilityNodeInfo getLabelFor() {
        this.enforceSealed();
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabelForId);
    }

    @FlaggedApi(value="android.view.accessibility.support_multiple_labeledby")
    public void addLabeledBy(@NonNull View label) {
        this.addLabeledBy(label, -1);
    }

    @FlaggedApi(value="android.view.accessibility.support_multiple_labeledby")
    public void addLabeledBy(@NonNull View root, int virtualDescendantId) {
        this.enforceNotSealed();
        Preconditions.checkNotNull(root, "%s must not be null", root);
        if (this.mLabeledByIds == null) {
            this.mLabeledByIds = new LongArray();
        }
        this.mLabeledById = AccessibilityNodeInfo.makeNodeId(root.getAccessibilityViewId(), virtualDescendantId);
        this.mLabeledByIds.add(this.mLabeledById);
    }

    @FlaggedApi(value="android.view.accessibility.support_multiple_labeledby")
    @NonNull
    public List<AccessibilityNodeInfo> getLabeledByList() {
        this.enforceSealed();
        ArrayList<AccessibilityNodeInfo> labels = new ArrayList<AccessibilityNodeInfo>();
        if (this.mLabeledByIds == null) {
            return labels;
        }
        for (int i = 0; i < this.mLabeledByIds.size(); ++i) {
            labels.add(AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabeledByIds.get(i)));
        }
        return labels;
    }

    @FlaggedApi(value="android.view.accessibility.support_multiple_labeledby")
    public boolean removeLabeledBy(@NonNull View label) {
        return this.removeLabeledBy(label, -1);
    }

    @FlaggedApi(value="android.view.accessibility.support_multiple_labeledby")
    public boolean removeLabeledBy(@NonNull View root, int virtualDescendantId) {
        int index;
        this.enforceNotSealed();
        LongArray labeledByIds = this.mLabeledByIds;
        if (labeledByIds == null) {
            return false;
        }
        int rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        long labeledById = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
        if (this.mLabeledById == labeledById) {
            this.mLabeledById = UNDEFINED_NODE_ID;
        }
        if ((index = labeledByIds.indexOf(labeledById)) < 0) {
            return false;
        }
        labeledByIds.remove(index);
        return true;
    }

    @Deprecated
    @FlaggedApi(value="android.view.accessibility.support_multiple_labeledby")
    public void setLabeledBy(View label) {
        this.setLabeledBy(label, -1);
    }

    @Deprecated
    @FlaggedApi(value="android.view.accessibility.support_multiple_labeledby")
    public void setLabeledBy(View root, int virtualDescendantId) {
        int rootAccessibilityViewId;
        this.enforceNotSealed();
        int n = rootAccessibilityViewId = root != null ? root.getAccessibilityViewId() : Integer.MAX_VALUE;
        if (Flags.supportMultipleLabeledby()) {
            if (this.mLabeledByIds == null) {
                this.mLabeledByIds = new LongArray();
            } else {
                this.mLabeledByIds.clear();
            }
        }
        this.mLabeledById = AccessibilityNodeInfo.makeNodeId(rootAccessibilityViewId, virtualDescendantId);
        if (Flags.supportMultipleLabeledby()) {
            this.mLabeledByIds.add(this.mLabeledById);
        }
    }

    @Deprecated
    @FlaggedApi(value="android.view.accessibility.support_multiple_labeledby")
    public AccessibilityNodeInfo getLabeledBy() {
        this.enforceSealed();
        return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mLabeledById);
    }

    public void setViewIdResourceName(String viewIdResName) {
        this.enforceNotSealed();
        this.mViewIdResourceName = viewIdResName;
    }

    public String getViewIdResourceName() {
        return this.mViewIdResourceName;
    }

    public int getTextSelectionStart() {
        if (Flags.a11ySelectionApi()) {
            Selection current = this.getSelection();
            if (current != null && current.getStart().usesNode(this) && current.getEnd().usesNode(this)) {
                return current.getStart().getOffset();
            }
            return -1;
        }
        return this.mTextSelectionStart;
    }

    public int getTextSelectionEnd() {
        if (Flags.a11ySelectionApi()) {
            Selection current = this.getSelection();
            if (current != null && current.getStart().usesNode(this) && current.getEnd().usesNode(this)) {
                return current.getEnd().getOffset();
            }
            return -1;
        }
        return this.mTextSelectionEnd;
    }

    public void setTextSelection(int start, int end) {
        this.enforceNotSealed();
        if (Flags.a11ySelectionApi()) {
            Selection selection = new Selection(new SelectionPosition(this, start), new SelectionPosition(this, end));
            this.setSelection(selection);
            return;
        }
        this.mTextSelectionStart = start;
        this.mTextSelectionEnd = end;
    }

    public int getInputType() {
        return this.mInputType;
    }

    public void setInputType(int inputType) {
        this.enforceNotSealed();
        this.mInputType = inputType;
    }

    public Bundle getExtras() {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        return this.mExtras;
    }

    public boolean hasExtras() {
        return this.mExtras != null;
    }

    @Nullable
    public TouchDelegateInfo getTouchDelegateInfo() {
        if (this.mTouchDelegateInfo != null) {
            this.mTouchDelegateInfo.setConnectionId(this.mConnectionId);
            this.mTouchDelegateInfo.setWindowId(this.mWindowId);
        }
        return this.mTouchDelegateInfo;
    }

    public void setTouchDelegateInfo(@NonNull TouchDelegateInfo delegatedInfo) {
        this.enforceNotSealed();
        this.mTouchDelegateInfo = delegatedInfo;
    }

    private boolean getBooleanProperty(int property) {
        return (this.mBooleanProperties & property) != 0;
    }

    private void setBooleanProperty(int property, boolean value) {
        this.enforceNotSealed();
        this.mBooleanProperties = value ? (this.mBooleanProperties |= property) : (this.mBooleanProperties &= ~property);
    }

    public void setConnectionId(int connectionId) {
        this.enforceNotSealed();
        this.mConnectionId = connectionId;
    }

    public int getConnectionId() {
        return this.mConnectionId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setSourceNodeId(long sourceId, int windowId) {
        this.enforceNotSealed();
        this.mSourceNodeId = sourceId;
        this.mWindowId = windowId;
    }

    @UnsupportedAppUsage
    public long getSourceNodeId() {
        return this.mSourceNodeId;
    }

    public void setUniqueId(@Nullable String uniqueId) {
        this.enforceNotSealed();
        this.mUniqueId = uniqueId;
    }

    @Nullable
    public String getUniqueId() {
        return this.mUniqueId;
    }

    public void setContainerTitle(@Nullable CharSequence containerTitle) {
        this.enforceNotSealed();
        this.mContainerTitle = containerTitle == null ? null : containerTitle.subSequence(0, containerTitle.length());
    }

    @Nullable
    public CharSequence getContainerTitle() {
        return this.mContainerTitle;
    }

    public void setLeashedParent(@Nullable IBinder token, int viewId) {
        this.enforceNotSealed();
        this.mLeashedParent = token;
        this.mLeashedParentNodeId = AccessibilityNodeInfo.makeNodeId(viewId, -1);
    }

    @Nullable
    public IBinder getLeashedParent() {
        return this.mLeashedParent;
    }

    public long getLeashedParentNodeId() {
        return this.mLeashedParentNodeId;
    }

    public void setQueryFromAppProcessEnabled(@NonNull View view, boolean enabled) {
        this.enforceNotSealed();
        if (!enabled) {
            this.setConnectionId(-1);
            return;
        }
        if (this.mConnectionId != -1) {
            return;
        }
        ViewRootImpl viewRootImpl = view.getViewRootImpl();
        if (viewRootImpl == null) {
            throw new IllegalStateException("Cannot link a node to a view that is not attached to a window.");
        }
        this.setConnectionId(viewRootImpl.getDirectAccessibilityConnectionId());
    }

    @UnsupportedAppUsage
    public void setSealed(boolean sealed) {
        this.mSealed = sealed;
    }

    @UnsupportedAppUsage
    public boolean isSealed() {
        return this.mSealed;
    }

    private static boolean usingDirectConnection(int connectionId) {
        return AccessibilityInteractionClient.getConnection(connectionId) instanceof DirectAccessibilityConnection;
    }

    protected void enforceSealed() {
        if (!AccessibilityNodeInfo.usingDirectConnection(this.mConnectionId) && !this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a not sealed instance.");
        }
    }

    private void enforceValidFocusDirection(int direction) {
        switch (direction) {
            case 1: 
            case 2: 
            case 17: 
            case 33: 
            case 66: 
            case 130: {
                return;
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    private void enforceValidFocusType(int focusType) {
        switch (focusType) {
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Unknown focus type: " + focusType);
    }

    private void enforceValidExpandedState(int state) {
        if (Flags.a11yExpansionStateApi()) {
            switch (state) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    return;
                }
            }
            throw new IllegalArgumentException("Unknown expanded state: " + state);
        }
    }

    protected void enforceNotSealed() {
        if (this.isSealed()) {
            throw new IllegalStateException("Cannot perform this action on a sealed instance.");
        }
    }

    @Deprecated
    public static AccessibilityNodeInfo obtain(View source) {
        return new AccessibilityNodeInfo(source);
    }

    @Deprecated
    public static AccessibilityNodeInfo obtain(View root, int virtualDescendantId) {
        return new AccessibilityNodeInfo(root, virtualDescendantId);
    }

    @Deprecated
    public static AccessibilityNodeInfo obtain() {
        return new AccessibilityNodeInfo();
    }

    @Deprecated
    public static AccessibilityNodeInfo obtain(AccessibilityNodeInfo info) {
        return new AccessibilityNodeInfo(info);
    }

    @Deprecated
    public void recycle() {
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        this.writeToParcelNoRecycle(parcel, flags);
    }

    public void writeToParcelNoRecycle(Parcel parcel, int flags) {
        int i;
        long nonDefaultFields = 0L;
        int fieldIndex = 0;
        if (this.isSealed() != DEFAULT.isSealed()) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mSourceNodeId != AccessibilityNodeInfo.DEFAULT.mSourceNodeId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mWindowId != AccessibilityNodeInfo.DEFAULT.mWindowId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mParentNodeId != AccessibilityNodeInfo.DEFAULT.mParentNodeId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLabelForId != AccessibilityNodeInfo.DEFAULT.mLabelForId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLabeledById != AccessibilityNodeInfo.DEFAULT.mLabeledById) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!LongArray.elementsEqual(this.mLabeledByIds, AccessibilityNodeInfo.DEFAULT.mLabeledByIds)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mTraversalBefore != AccessibilityNodeInfo.DEFAULT.mTraversalBefore) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mTraversalAfter != AccessibilityNodeInfo.DEFAULT.mTraversalAfter) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mMinDurationBetweenContentChanges != AccessibilityNodeInfo.DEFAULT.mMinDurationBetweenContentChanges) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mConnectionId != AccessibilityNodeInfo.DEFAULT.mConnectionId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!LongArray.elementsEqual(this.mChildNodeIds, AccessibilityNodeInfo.DEFAULT.mChildNodeIds)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mBoundsInParent, AccessibilityNodeInfo.DEFAULT.mBoundsInParent)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mBoundsInScreen, AccessibilityNodeInfo.DEFAULT.mBoundsInScreen)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mBoundsInWindow, AccessibilityNodeInfo.DEFAULT.mBoundsInWindow)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mActions, AccessibilityNodeInfo.DEFAULT.mActions)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mMaxTextLength != AccessibilityNodeInfo.DEFAULT.mMaxTextLength) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mMovementGranularities != AccessibilityNodeInfo.DEFAULT.mMovementGranularities) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mBooleanProperties != AccessibilityNodeInfo.DEFAULT.mBooleanProperties) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mPackageName, AccessibilityNodeInfo.DEFAULT.mPackageName)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mClassName, AccessibilityNodeInfo.DEFAULT.mClassName)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mText, AccessibilityNodeInfo.DEFAULT.mText)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mHintText, AccessibilityNodeInfo.DEFAULT.mHintText)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mError, AccessibilityNodeInfo.DEFAULT.mError)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mStateDescription, AccessibilityNodeInfo.DEFAULT.mStateDescription)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mContentDescription, AccessibilityNodeInfo.DEFAULT.mContentDescription)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mSupplementalDescription, AccessibilityNodeInfo.DEFAULT.mSupplementalDescription)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mPaneTitle, AccessibilityNodeInfo.DEFAULT.mPaneTitle)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mTooltipText, AccessibilityNodeInfo.DEFAULT.mTooltipText)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mContainerTitle, AccessibilityNodeInfo.DEFAULT.mContainerTitle)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mViewIdResourceName, AccessibilityNodeInfo.DEFAULT.mViewIdResourceName)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mUniqueId, AccessibilityNodeInfo.DEFAULT.mUniqueId)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mTextSelectionStart != AccessibilityNodeInfo.DEFAULT.mTextSelectionStart) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mTextSelectionEnd != AccessibilityNodeInfo.DEFAULT.mTextSelectionEnd) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mInputType != AccessibilityNodeInfo.DEFAULT.mInputType) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLiveRegion != AccessibilityNodeInfo.DEFAULT.mLiveRegion) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mDrawingOrderInParent != AccessibilityNodeInfo.DEFAULT.mDrawingOrderInParent) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mExtraDataKeys, AccessibilityNodeInfo.DEFAULT.mExtraDataKeys)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mExtras, AccessibilityNodeInfo.DEFAULT.mExtras)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mRangeInfo, AccessibilityNodeInfo.DEFAULT.mRangeInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mCollectionInfo, AccessibilityNodeInfo.DEFAULT.mCollectionInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mCollectionItemInfo, AccessibilityNodeInfo.DEFAULT.mCollectionItemInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mTouchDelegateInfo, AccessibilityNodeInfo.DEFAULT.mTouchDelegateInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mExtraRenderingInfo, AccessibilityNodeInfo.DEFAULT.mExtraRenderingInfo)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLeashedChild != AccessibilityNodeInfo.DEFAULT.mLeashedChild) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLeashedParent != AccessibilityNodeInfo.DEFAULT.mLeashedParent) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mLeashedParentNodeId != AccessibilityNodeInfo.DEFAULT.mLeashedParentNodeId) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (!Objects.equals(this.mSelection, AccessibilityNodeInfo.DEFAULT.mSelection)) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mChecked != AccessibilityNodeInfo.DEFAULT.mChecked) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        ++fieldIndex;
        if (this.mExpandedState != AccessibilityNodeInfo.DEFAULT.mExpandedState) {
            nonDefaultFields |= BitUtils.bitAt(fieldIndex);
        }
        int totalFields = fieldIndex;
        parcel.writeLong(nonDefaultFields);
        fieldIndex = 0;
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.isSealed() ? 1 : 0);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mSourceNodeId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mWindowId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mParentNodeId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mLabelForId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mLabeledById);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            LongArray labeledByIds = this.mLabeledByIds;
            if (labeledByIds == null) {
                parcel.writeInt(0);
            } else {
                int labeledByIdsSize = labeledByIds.size();
                parcel.writeInt(labeledByIdsSize);
                for (i = 0; i < labeledByIdsSize; ++i) {
                    parcel.writeLong(labeledByIds.get(i));
                }
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mTraversalBefore);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mTraversalAfter);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mMinDurationBetweenContentChanges);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mConnectionId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            LongArray childIds = this.mChildNodeIds;
            if (childIds == null) {
                parcel.writeInt(0);
            } else {
                int childIdsSize = childIds.size();
                parcel.writeInt(childIdsSize);
                for (i = 0; i < childIdsSize; ++i) {
                    parcel.writeLong(childIds.get(i));
                }
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mBoundsInParent.top);
            parcel.writeInt(this.mBoundsInParent.bottom);
            parcel.writeInt(this.mBoundsInParent.left);
            parcel.writeInt(this.mBoundsInParent.right);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mBoundsInScreen.top);
            parcel.writeInt(this.mBoundsInScreen.bottom);
            parcel.writeInt(this.mBoundsInScreen.left);
            parcel.writeInt(this.mBoundsInScreen.right);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mBoundsInWindow.top);
            parcel.writeInt(this.mBoundsInWindow.bottom);
            parcel.writeInt(this.mBoundsInWindow.left);
            parcel.writeInt(this.mBoundsInWindow.right);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            if (this.mActions != null && !this.mActions.isEmpty()) {
                AccessibilityAction action;
                int i2;
                int actionCount = this.mActions.size();
                int nonStandardActionCount = 0;
                long defaultStandardActions = 0L;
                for (i2 = 0; i2 < actionCount; ++i2) {
                    action = this.mActions.get(i2);
                    if (AccessibilityNodeInfo.isDefaultStandardAction(action)) {
                        defaultStandardActions |= action.mSerializationFlag;
                        continue;
                    }
                    ++nonStandardActionCount;
                }
                parcel.writeLong(defaultStandardActions);
                parcel.writeInt(nonStandardActionCount);
                for (i2 = 0; i2 < actionCount; ++i2) {
                    action = this.mActions.get(i2);
                    if (AccessibilityNodeInfo.isDefaultStandardAction(action)) continue;
                    action.writeToParcel(parcel, flags);
                }
            } else {
                parcel.writeLong(0L);
                parcel.writeInt(0);
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mMaxTextLength);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mMovementGranularities);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mBooleanProperties);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mPackageName);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mClassName);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mText);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mHintText);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mError);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mStateDescription);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mContentDescription);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mSupplementalDescription);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mPaneTitle);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mTooltipText);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeCharSequence(this.mContainerTitle);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeString(this.mViewIdResourceName);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeString(this.mUniqueId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mTextSelectionStart);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mTextSelectionEnd);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mInputType);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mLiveRegion);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mDrawingOrderInParent);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeStringList(this.mExtraDataKeys);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeBundle(this.mExtras);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mRangeInfo.getType());
            parcel.writeFloat(this.mRangeInfo.getMin());
            parcel.writeFloat(this.mRangeInfo.getMax());
            parcel.writeFloat(this.mRangeInfo.getCurrent());
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mCollectionInfo.getRowCount());
            parcel.writeInt(this.mCollectionInfo.getColumnCount());
            parcel.writeInt(this.mCollectionInfo.isHierarchical() ? 1 : 0);
            parcel.writeInt(this.mCollectionInfo.getSelectionMode());
            parcel.writeInt(this.mCollectionInfo.getItemCount());
            parcel.writeInt(this.mCollectionInfo.getImportantForAccessibilityItemCount());
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeString(this.mCollectionItemInfo.getRowTitle());
            parcel.writeInt(this.mCollectionItemInfo.getRowIndex());
            parcel.writeInt(this.mCollectionItemInfo.getRowSpan());
            parcel.writeString(this.mCollectionItemInfo.getColumnTitle());
            parcel.writeInt(this.mCollectionItemInfo.getColumnIndex());
            parcel.writeInt(this.mCollectionItemInfo.getColumnSpan());
            parcel.writeInt(this.mCollectionItemInfo.isHeading() ? 1 : 0);
            parcel.writeInt(this.mCollectionItemInfo.isSelected() ? 1 : 0);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTouchDelegateInfo.writeToParcel(parcel, flags);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeValue(this.mExtraRenderingInfo.getLayoutSize());
            parcel.writeFloat(this.mExtraRenderingInfo.getTextSizeInPx());
            parcel.writeInt(this.mExtraRenderingInfo.getTextSizeUnit());
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeStrongBinder(this.mLeashedChild);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeStrongBinder(this.mLeashedParent);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeLong(this.mLeashedParentNodeId);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mSelection.writeToParcel(parcel, flags);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mChecked);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            parcel.writeInt(this.mExpandedState);
        }
        if (DEBUG && totalFields != --fieldIndex) {
            throw new IllegalStateException("Number of fields mismatch: " + totalFields + " vs " + fieldIndex);
        }
    }

    private void init(AccessibilityNodeInfo other) {
        LongArray otherChildNodeIds;
        ArrayList<AccessibilityAction> otherActions;
        this.mSealed = other.mSealed;
        this.mSourceNodeId = other.mSourceNodeId;
        this.mParentNodeId = other.mParentNodeId;
        this.mLabelForId = other.mLabelForId;
        this.mLabeledById = other.mLabeledById;
        this.mLabeledByIds = other.mLabeledByIds;
        this.mTraversalBefore = other.mTraversalBefore;
        this.mTraversalAfter = other.mTraversalAfter;
        this.mMinDurationBetweenContentChanges = other.mMinDurationBetweenContentChanges;
        this.mWindowId = other.mWindowId;
        this.mConnectionId = other.mConnectionId;
        this.mUniqueId = other.mUniqueId;
        this.mBoundsInParent.set(other.mBoundsInParent);
        this.mBoundsInScreen.set(other.mBoundsInScreen);
        this.mBoundsInWindow.set(other.mBoundsInWindow);
        this.mPackageName = other.mPackageName;
        this.mClassName = other.mClassName;
        this.mText = other.mText;
        this.mOriginalText = other.mOriginalText;
        this.mHintText = other.mHintText;
        this.mError = other.mError;
        this.mStateDescription = other.mStateDescription;
        this.mContentDescription = other.mContentDescription;
        this.mSupplementalDescription = other.mSupplementalDescription;
        this.mPaneTitle = other.mPaneTitle;
        this.mTooltipText = other.mTooltipText;
        this.mContainerTitle = other.mContainerTitle;
        this.mViewIdResourceName = other.mViewIdResourceName;
        if (this.mActions != null) {
            this.mActions.clear();
        }
        if ((otherActions = other.mActions) != null && otherActions.size() > 0) {
            if (this.mActions == null) {
                this.mActions = new ArrayList<AccessibilityAction>(otherActions);
            } else {
                this.mActions.addAll(other.mActions);
            }
        }
        this.mBooleanProperties = other.mBooleanProperties;
        this.mMaxTextLength = other.mMaxTextLength;
        this.mMovementGranularities = other.mMovementGranularities;
        if (this.mChildNodeIds != null) {
            this.mChildNodeIds.clear();
        }
        if ((otherChildNodeIds = other.mChildNodeIds) != null && otherChildNodeIds.size() > 0) {
            if (this.mChildNodeIds == null) {
                this.mChildNodeIds = otherChildNodeIds.clone();
            } else {
                this.mChildNodeIds.addAll(otherChildNodeIds);
            }
        }
        this.mTextSelectionStart = other.mTextSelectionStart;
        this.mTextSelectionEnd = other.mTextSelectionEnd;
        this.mInputType = other.mInputType;
        this.mLiveRegion = other.mLiveRegion;
        this.mDrawingOrderInParent = other.mDrawingOrderInParent;
        this.mExtraDataKeys = other.mExtraDataKeys;
        this.mExtras = other.mExtras != null ? new Bundle(other.mExtras) : null;
        this.initCopyInfos(other);
        TouchDelegateInfo otherInfo = other.mTouchDelegateInfo;
        this.mTouchDelegateInfo = otherInfo != null ? new TouchDelegateInfo(otherInfo.mTargetMap, true) : null;
        this.mLeashedChild = other.mLeashedChild;
        this.mLeashedParent = other.mLeashedParent;
        this.mLeashedParentNodeId = other.mLeashedParentNodeId;
        this.mChecked = other.mChecked;
        this.mExpandedState = other.mExpandedState;
    }

    private void initCopyInfos(AccessibilityNodeInfo other) {
        RangeInfo ri = other.mRangeInfo;
        this.mRangeInfo = ri == null ? null : new RangeInfo(ri.mType, ri.mMin, ri.mMax, ri.mCurrent);
        CollectionInfo ci = other.mCollectionInfo;
        this.mCollectionInfo = ci == null ? null : new CollectionInfo(ci.mRowCount, ci.mColumnCount, ci.mHierarchical, ci.mSelectionMode, ci.mItemCount, ci.mImportantForAccessibilityItemCount);
        CollectionItemInfo cii = other.mCollectionItemInfo;
        CollectionItemInfo.Builder builder = new CollectionItemInfo.Builder();
        this.mCollectionItemInfo = cii == null ? null : builder.setRowTitle(cii.mRowTitle).setRowIndex(cii.mRowIndex).setRowSpan(cii.mRowSpan).setColumnTitle(cii.mColumnTitle).setColumnIndex(cii.mColumnIndex).setColumnSpan(cii.mColumnSpan).setHeading(cii.mHeading).setSelected(cii.mSelected).build();
        ExtraRenderingInfo ti = other.mExtraRenderingInfo;
        ExtraRenderingInfo extraRenderingInfo = this.mExtraRenderingInfo = ti == null ? null : new ExtraRenderingInfo(ti);
        if (Flags.a11ySelectionApi() && other.getSelection() != null) {
            SelectionPosition sps = other.getSelection().getStart();
            SelectionPosition spe = other.getSelection().getEnd();
            this.mSelection = new Selection(new SelectionPosition(sps.mSourceNodeId, sps.getOffset()), new SelectionPosition(spe.mSourceNodeId, spe.getOffset()));
        }
    }

    private void initFromParcel(Parcel parcel) {
        int i;
        boolean sealed;
        long nonDefaultFields = parcel.readLong();
        int fieldIndex = 0;
        boolean bl = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? parcel.readInt() == 1 : (sealed = AccessibilityNodeInfo.DEFAULT.mSealed);
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mSourceNodeId = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mWindowId = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mParentNodeId = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLabelForId = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLabeledById = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            int labeledByIdsSize = parcel.readInt();
            if (labeledByIdsSize <= 0) {
                this.mLabeledByIds = null;
            } else {
                this.mLabeledByIds = new LongArray(labeledByIdsSize);
                for (i = 0; i < labeledByIdsSize; ++i) {
                    long labeledById = parcel.readLong();
                    this.mLabeledByIds.add(labeledById);
                }
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTraversalBefore = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTraversalAfter = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mMinDurationBetweenContentChanges = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mConnectionId = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            int childrenSize = parcel.readInt();
            if (childrenSize <= 0) {
                this.mChildNodeIds = null;
            } else {
                this.mChildNodeIds = new LongArray(childrenSize);
                for (i = 0; i < childrenSize; ++i) {
                    long childId = parcel.readLong();
                    this.mChildNodeIds.add(childId);
                }
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mBoundsInParent.top = parcel.readInt();
            this.mBoundsInParent.bottom = parcel.readInt();
            this.mBoundsInParent.left = parcel.readInt();
            this.mBoundsInParent.right = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mBoundsInScreen.top = parcel.readInt();
            this.mBoundsInScreen.bottom = parcel.readInt();
            this.mBoundsInScreen.left = parcel.readInt();
            this.mBoundsInScreen.right = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mBoundsInWindow.top = parcel.readInt();
            this.mBoundsInWindow.bottom = parcel.readInt();
            this.mBoundsInWindow.left = parcel.readInt();
            this.mBoundsInWindow.right = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            long standardActions = parcel.readLong();
            this.addStandardActions(standardActions);
            int nonStandardActionCount = parcel.readInt();
            for (int i2 = 0; i2 < nonStandardActionCount; ++i2) {
                AccessibilityAction action = AccessibilityAction.CREATOR.createFromParcel(parcel);
                this.addActionUnchecked(action);
            }
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mMaxTextLength = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mMovementGranularities = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mBooleanProperties = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mPackageName = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mClassName = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mText = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mHintText = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mError = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mStateDescription = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mContentDescription = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mSupplementalDescription = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mPaneTitle = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTooltipText = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mContainerTitle = parcel.readCharSequence();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mViewIdResourceName = parcel.readString();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mUniqueId = parcel.readString();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTextSelectionStart = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTextSelectionEnd = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mInputType = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLiveRegion = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mDrawingOrderInParent = parcel.readInt();
        }
        this.mExtraDataKeys = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? parcel.createStringArrayList() : null;
        this.mExtras = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? parcel.readBundle() : null;
        RangeInfo rangeInfo = this.mRangeInfo = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? new RangeInfo(parcel.readInt(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat()) : null;
        CollectionInfo collectionInfo = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? new CollectionInfo(parcel.readInt(), parcel.readInt(), parcel.readInt() == 1, parcel.readInt(), parcel.readInt(), parcel.readInt()) : (this.mCollectionInfo = null);
        CollectionItemInfo collectionItemInfo = BitUtils.isBitSet(nonDefaultFields, fieldIndex++) ? new CollectionItemInfo(parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readString(), parcel.readInt(), parcel.readInt(), parcel.readInt() == 1, parcel.readInt() == 1) : (this.mCollectionItemInfo = null);
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mTouchDelegateInfo = TouchDelegateInfo.CREATOR.createFromParcel(parcel);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mExtraRenderingInfo = new ExtraRenderingInfo(null);
            this.mExtraRenderingInfo.mLayoutSize = (Size)parcel.readValue(null);
            this.mExtraRenderingInfo.mTextSizeInPx = parcel.readFloat();
            this.mExtraRenderingInfo.mTextSizeUnit = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLeashedChild = parcel.readStrongBinder();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLeashedParent = parcel.readStrongBinder();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mLeashedParentNodeId = parcel.readLong();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mSelection = Selection.CREATOR.createFromParcel(parcel);
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mChecked = parcel.readInt();
        }
        if (BitUtils.isBitSet(nonDefaultFields, fieldIndex++)) {
            this.mExpandedState = parcel.readInt();
        }
        this.mSealed = sealed;
    }

    private void clear() {
        this.init(DEFAULT);
    }

    private static boolean isDefaultStandardAction(AccessibilityAction action) {
        return action.mSerializationFlag != -1L && TextUtils.isEmpty(action.getLabel());
    }

    private static AccessibilityAction getActionSingleton(int actionId) {
        int actions = AccessibilityAction.sStandardActions.size();
        for (int i = 0; i < actions; ++i) {
            AccessibilityAction currentAction = AccessibilityAction.sStandardActions.valueAt(i);
            if (actionId != currentAction.getId()) continue;
            return currentAction;
        }
        return null;
    }

    private static AccessibilityAction getActionSingletonBySerializationFlag(long flag) {
        int actions = AccessibilityAction.sStandardActions.size();
        for (int i = 0; i < actions; ++i) {
            AccessibilityAction currentAction = AccessibilityAction.sStandardActions.valueAt(i);
            if (flag != currentAction.mSerializationFlag) continue;
            return currentAction;
        }
        return null;
    }

    private void addStandardActions(long serializationIdMask) {
        long id2;
        for (long remainingIds = serializationIdMask; remainingIds > 0L; remainingIds &= id2 ^ 0xFFFFFFFFFFFFFFFFL) {
            id2 = 1L << Long.numberOfTrailingZeros(remainingIds);
            AccessibilityAction action = AccessibilityNodeInfo.getActionSingletonBySerializationFlag(id2);
            this.addAction(action);
        }
    }

    private static String getActionSymbolicName(int action) {
        switch (action) {
            case 1: {
                return "ACTION_FOCUS";
            }
            case 2: {
                return "ACTION_CLEAR_FOCUS";
            }
            case 4: {
                return "ACTION_SELECT";
            }
            case 8: {
                return "ACTION_CLEAR_SELECTION";
            }
            case 16: {
                return "ACTION_CLICK";
            }
            case 32: {
                return "ACTION_LONG_CLICK";
            }
            case 64: {
                return "ACTION_ACCESSIBILITY_FOCUS";
            }
            case 128: {
                return "ACTION_CLEAR_ACCESSIBILITY_FOCUS";
            }
            case 256: {
                return "ACTION_NEXT_AT_MOVEMENT_GRANULARITY";
            }
            case 512: {
                return "ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY";
            }
            case 1024: {
                return "ACTION_NEXT_HTML_ELEMENT";
            }
            case 2048: {
                return "ACTION_PREVIOUS_HTML_ELEMENT";
            }
            case 4096: {
                return "ACTION_SCROLL_FORWARD";
            }
            case 8192: {
                return "ACTION_SCROLL_BACKWARD";
            }
            case 65536: {
                return "ACTION_CUT";
            }
            case 16384: {
                return "ACTION_COPY";
            }
            case 32768: {
                return "ACTION_PASTE";
            }
            case 131072: {
                return "ACTION_SET_SELECTION";
            }
            case 262144: {
                return "ACTION_EXPAND";
            }
            case 524288: {
                return "ACTION_COLLAPSE";
            }
            case 0x100000: {
                return "ACTION_DISMISS";
            }
            case 0x200000: {
                return "ACTION_SET_TEXT";
            }
            case 16908342: {
                return "ACTION_SHOW_ON_SCREEN";
            }
            case 16908343: {
                return "ACTION_SCROLL_TO_POSITION";
            }
            case 16908344: {
                return "ACTION_SCROLL_UP";
            }
            case 16908345: {
                return "ACTION_SCROLL_LEFT";
            }
            case 16908346: {
                return "ACTION_SCROLL_DOWN";
            }
            case 16908347: {
                return "ACTION_SCROLL_RIGHT";
            }
            case 16908359: {
                return "ACTION_PAGE_DOWN";
            }
            case 16908358: {
                return "ACTION_PAGE_UP";
            }
            case 16908360: {
                return "ACTION_PAGE_LEFT";
            }
            case 16908361: {
                return "ACTION_PAGE_RIGHT";
            }
            case 16908349: {
                return "ACTION_SET_PROGRESS";
            }
            case 16908348: {
                return "ACTION_CONTEXT_CLICK";
            }
            case 16908356: {
                return "ACTION_SHOW_TOOLTIP";
            }
            case 16908357: {
                return "ACTION_HIDE_TOOLTIP";
            }
            case 16908362: {
                return "ACTION_PRESS_AND_HOLD";
            }
            case 16908372: {
                return "ACTION_IME_ENTER";
            }
            case 16908373: {
                return "ACTION_DRAG";
            }
            case 16908375: {
                return "ACTION_CANCEL_DRAG";
            }
            case 16908374: {
                return "ACTION_DROP";
            }
        }
        if (action == 16908376) {
            return "ACTION_SHOW_TEXT_SUGGESTIONS";
        }
        if (action == 16908382) {
            return "ACTION_SCROLL_IN_DIRECTION";
        }
        if (action == R.id.accessibilityActionSetExtendedSelection) {
            return "ACTION_SET_EXTENDED_SELECTION";
        }
        return "ACTION_UNKNOWN";
    }

    private static String getMovementGranularitySymbolicName(int granularity) {
        switch (granularity) {
            case 1: {
                return "MOVEMENT_GRANULARITY_CHARACTER";
            }
            case 2: {
                return "MOVEMENT_GRANULARITY_WORD";
            }
            case 4: {
                return "MOVEMENT_GRANULARITY_LINE";
            }
            case 8: {
                return "MOVEMENT_GRANULARITY_PARAGRAPH";
            }
            case 16: {
                return "MOVEMENT_GRANULARITY_PAGE";
            }
        }
        throw new IllegalArgumentException("Unknown movement granularity: " + granularity);
    }

    private static boolean canPerformRequestOverConnection(int connectionId, int windowId, long accessibilityNodeId) {
        boolean hasWindowId = windowId != -1;
        return (AccessibilityNodeInfo.usingDirectConnection(connectionId) || hasWindowId) && AccessibilityNodeInfo.getAccessibilityViewId(accessibilityNodeId) != Integer.MAX_VALUE && connectionId != -1;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AccessibilityNodeInfo other = (AccessibilityNodeInfo)object;
        if (this.mSourceNodeId != other.mSourceNodeId) {
            return false;
        }
        return this.mWindowId == other.mWindowId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId);
        result = 31 * result + AccessibilityNodeInfo.getVirtualDescendantId(this.mSourceNodeId);
        result = 31 * result + this.mWindowId;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        if (DEBUG) {
            builder.append("; sourceNodeId: 0x").append(Long.toHexString(this.mSourceNodeId));
            builder.append("; windowId: 0x").append(Long.toHexString(this.mWindowId));
            builder.append("; accessibilityViewId: 0x").append(Long.toHexString(AccessibilityNodeInfo.getAccessibilityViewId(this.mSourceNodeId)));
            builder.append("; virtualDescendantId: 0x").append(Long.toHexString(AccessibilityNodeInfo.getVirtualDescendantId(this.mSourceNodeId)));
            builder.append("; mParentNodeId: 0x").append(Long.toHexString(this.mParentNodeId));
            builder.append("; traversalBefore: 0x").append(Long.toHexString(this.mTraversalBefore));
            builder.append("; traversalAfter: 0x").append(Long.toHexString(this.mTraversalAfter));
            builder.append("; minDurationBetweenContentChanges: ").append(this.mMinDurationBetweenContentChanges);
            int granularities = this.mMovementGranularities;
            builder.append("; MovementGranularities: [");
            while (granularities != 0) {
                int granularity = 1 << Integer.numberOfTrailingZeros(granularities);
                builder.append(AccessibilityNodeInfo.getMovementGranularitySymbolicName(granularity));
                if ((granularities &= ~granularity) == 0) continue;
                builder.append(", ");
            }
            builder.append("]");
            builder.append("; childAccessibilityIds: [");
            LongArray childIds = this.mChildNodeIds;
            if (childIds != null) {
                int count = childIds.size();
                for (int i = 0; i < count; ++i) {
                    builder.append("0x").append(Long.toHexString(childIds.get(i)));
                    if (i >= count - 1) continue;
                    builder.append(", ");
                }
            }
            builder.append("]");
        }
        builder.append("; boundsInParent: ").append(this.mBoundsInParent);
        builder.append("; boundsInScreen: ").append(this.mBoundsInScreen);
        builder.append("; boundsInWindow: ").append(this.mBoundsInScreen);
        builder.append("; packageName: ").append(this.mPackageName);
        builder.append("; className: ").append(this.mClassName);
        builder.append("; text: ").append(this.mText);
        builder.append("; error: ").append(this.mError);
        builder.append("; maxTextLength: ").append(this.mMaxTextLength);
        builder.append("; stateDescription: ").append(this.mStateDescription);
        builder.append("; contentDescription: ").append(this.mContentDescription);
        builder.append("; tooltipText: ").append(this.mTooltipText);
        builder.append("; containerTitle: ").append(this.mContainerTitle);
        builder.append("; viewIdResName: ").append(this.mViewIdResourceName);
        builder.append("; uniqueId: ").append(this.mUniqueId);
        builder.append("; checkable: ").append(this.isCheckable());
        builder.append("; checked: ").append(this.isChecked());
        builder.append("; focusable: ").append(this.isFocusable());
        builder.append("; focused: ").append(this.isFocused());
        builder.append("; selected: ").append(this.isSelected());
        builder.append("; clickable: ").append(this.isClickable());
        builder.append("; longClickable: ").append(this.isLongClickable());
        builder.append("; contextClickable: ").append(this.isContextClickable());
        builder.append("; enabled: ").append(this.isEnabled());
        builder.append("; password: ").append(this.isPassword());
        builder.append("; scrollable: ").append(this.isScrollable());
        builder.append("; granularScrollingSupported: ").append(this.isGranularScrollingSupported());
        builder.append("; importantForAccessibility: ").append(this.isImportantForAccessibility());
        builder.append("; visible: ").append(this.isVisibleToUser());
        builder.append("; actions: ").append(this.mActions);
        builder.append("; isTextSelectable: ").append(this.isTextSelectable());
        return builder.toString();
    }

    private static AccessibilityNodeInfo getNodeForAccessibilityId(int connectionId, int windowId, long accessibilityId) {
        return AccessibilityNodeInfo.getNodeForAccessibilityId(connectionId, windowId, accessibilityId, 7);
    }

    private static AccessibilityNodeInfo getNodeForAccessibilityId(int connectionId, int windowId, long accessibilityId, int prefetchingStrategy) {
        if (!AccessibilityNodeInfo.canPerformRequestOverConnection(connectionId, windowId, accessibilityId)) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(connectionId, windowId, accessibilityId, false, prefetchingStrategy, null);
    }

    private static AccessibilityNodeInfo getNodeForAccessibilityId(int connectionId, IBinder leashToken, long accessibilityId) {
        return AccessibilityNodeInfo.getNodeForAccessibilityId(connectionId, leashToken, accessibilityId, 7);
    }

    private static AccessibilityNodeInfo getNodeForAccessibilityId(int connectionId, IBinder leashToken, long accessibilityId, int prefetchingStrategy) {
        if (leashToken == null || AccessibilityNodeInfo.getAccessibilityViewId(accessibilityId) == Integer.MAX_VALUE || connectionId == -1) {
            return null;
        }
        AccessibilityInteractionClient client = AccessibilityInteractionClient.getInstance();
        return client.findAccessibilityNodeInfoByAccessibilityId(connectionId, leashToken, accessibilityId, false, prefetchingStrategy, null);
    }

    public static String idToString(long accessibilityId) {
        int accessibilityViewId = AccessibilityNodeInfo.getAccessibilityViewId(accessibilityId);
        int virtualDescendantId = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityId);
        return virtualDescendantId == -1 ? AccessibilityNodeInfo.idItemToString(accessibilityViewId) : AccessibilityNodeInfo.idItemToString(accessibilityViewId) + ":" + AccessibilityNodeInfo.idItemToString(virtualDescendantId);
    }

    private static String idItemToString(int item) {
        switch (item) {
            case 0x7FFFFFFE: {
                return "ROOT";
            }
            case 0x7FFFFFFF: {
                return "UNDEFINED";
            }
            case -1: {
                return "HOST";
            }
        }
        return "" + item;
    }

    public static class AccessibilityAction
    implements Parcelable {
        public static final ArraySet<AccessibilityAction> sStandardActions = new ArraySet();
        public static final AccessibilityAction ACTION_FOCUS = new AccessibilityAction(1);
        public static final AccessibilityAction ACTION_CLEAR_FOCUS = new AccessibilityAction(2);
        public static final AccessibilityAction ACTION_SELECT = new AccessibilityAction(4);
        public static final AccessibilityAction ACTION_CLEAR_SELECTION = new AccessibilityAction(8);
        public static final AccessibilityAction ACTION_CLICK = new AccessibilityAction(16);
        public static final AccessibilityAction ACTION_LONG_CLICK = new AccessibilityAction(32);
        public static final AccessibilityAction ACTION_ACCESSIBILITY_FOCUS = new AccessibilityAction(64);
        public static final AccessibilityAction ACTION_CLEAR_ACCESSIBILITY_FOCUS = new AccessibilityAction(128);
        public static final AccessibilityAction ACTION_NEXT_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(256);
        public static final AccessibilityAction ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = new AccessibilityAction(512);
        public static final AccessibilityAction ACTION_NEXT_HTML_ELEMENT = new AccessibilityAction(1024);
        public static final AccessibilityAction ACTION_PREVIOUS_HTML_ELEMENT = new AccessibilityAction(2048);
        public static final AccessibilityAction ACTION_SCROLL_FORWARD = new AccessibilityAction(4096);
        public static final AccessibilityAction ACTION_SCROLL_BACKWARD = new AccessibilityAction(8192);
        public static final AccessibilityAction ACTION_COPY = new AccessibilityAction(16384);
        public static final AccessibilityAction ACTION_PASTE = new AccessibilityAction(32768);
        public static final AccessibilityAction ACTION_CUT = new AccessibilityAction(65536);
        public static final AccessibilityAction ACTION_SET_SELECTION = new AccessibilityAction(131072);
        public static final AccessibilityAction ACTION_EXPAND = new AccessibilityAction(262144);
        public static final AccessibilityAction ACTION_COLLAPSE = new AccessibilityAction(524288);
        public static final AccessibilityAction ACTION_DISMISS = new AccessibilityAction(0x100000);
        public static final AccessibilityAction ACTION_SET_TEXT = new AccessibilityAction(0x200000);
        public static final AccessibilityAction ACTION_SHOW_ON_SCREEN = new AccessibilityAction(16908342);
        public static final AccessibilityAction ACTION_SCROLL_TO_POSITION = new AccessibilityAction(16908343);
        @NonNull
        public static final AccessibilityAction ACTION_SCROLL_IN_DIRECTION = new AccessibilityAction(16908382);
        public static final AccessibilityAction ACTION_SCROLL_UP = new AccessibilityAction(16908344);
        public static final AccessibilityAction ACTION_SCROLL_LEFT = new AccessibilityAction(16908345);
        public static final AccessibilityAction ACTION_SCROLL_DOWN = new AccessibilityAction(16908346);
        public static final AccessibilityAction ACTION_SCROLL_RIGHT = new AccessibilityAction(16908347);
        public static final AccessibilityAction ACTION_PAGE_UP = new AccessibilityAction(16908358);
        public static final AccessibilityAction ACTION_PAGE_DOWN = new AccessibilityAction(16908359);
        public static final AccessibilityAction ACTION_PAGE_LEFT = new AccessibilityAction(16908360);
        public static final AccessibilityAction ACTION_PAGE_RIGHT = new AccessibilityAction(16908361);
        public static final AccessibilityAction ACTION_CONTEXT_CLICK = new AccessibilityAction(16908348);
        public static final AccessibilityAction ACTION_SET_PROGRESS = new AccessibilityAction(16908349);
        public static final AccessibilityAction ACTION_MOVE_WINDOW = new AccessibilityAction(16908354);
        public static final AccessibilityAction ACTION_SHOW_TOOLTIP = new AccessibilityAction(16908356);
        public static final AccessibilityAction ACTION_HIDE_TOOLTIP = new AccessibilityAction(16908357);
        @NonNull
        public static final AccessibilityAction ACTION_PRESS_AND_HOLD = new AccessibilityAction(16908362);
        @NonNull
        public static final AccessibilityAction ACTION_IME_ENTER = new AccessibilityAction(16908372);
        @NonNull
        public static final AccessibilityAction ACTION_DRAG_START = new AccessibilityAction(16908373);
        @NonNull
        public static final AccessibilityAction ACTION_DRAG_DROP = new AccessibilityAction(16908374);
        @NonNull
        public static final AccessibilityAction ACTION_DRAG_CANCEL = new AccessibilityAction(16908375);
        @NonNull
        public static final AccessibilityAction ACTION_SHOW_TEXT_SUGGESTIONS = new AccessibilityAction(16908376);
        @FlaggedApi(value="android.view.accessibility.a11y_selection_api")
        @NonNull
        public static final AccessibilityAction ACTION_SET_EXTENDED_SELECTION = new AccessibilityAction(R.id.accessibilityActionSetExtendedSelection);
        private final int mActionId;
        private final CharSequence mLabel;
        public long mSerializationFlag = -1L;
        @NonNull
        public static final Parcelable.Creator<AccessibilityAction> CREATOR = new Parcelable.Creator<AccessibilityAction>(){

            @Override
            public AccessibilityAction createFromParcel(Parcel in) {
                return new AccessibilityAction(in);
            }

            public AccessibilityAction[] newArray(int size) {
                return new AccessibilityAction[size];
            }
        };

        public AccessibilityAction(int actionId, @Nullable CharSequence label) {
            this.mActionId = actionId;
            this.mLabel = label;
        }

        private AccessibilityAction(int standardActionId) {
            this(standardActionId, null);
            this.mSerializationFlag = BitUtils.bitAt(sStandardActions.size());
            sStandardActions.add(this);
        }

        public int getId() {
            return this.mActionId;
        }

        public CharSequence getLabel() {
            return this.mLabel;
        }

        public int hashCode() {
            return this.mActionId;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            return this.mActionId == ((AccessibilityAction)other).mActionId;
        }

        public String toString() {
            return "AccessibilityAction: " + AccessibilityNodeInfo.getActionSymbolicName(this.mActionId) + " - " + this.mLabel;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel out, int flags) {
            out.writeInt(this.mActionId);
            out.writeCharSequence(this.mLabel);
        }

        private AccessibilityAction(Parcel in) {
            this.mActionId = in.readInt();
            this.mLabel = in.readCharSequence();
        }
    }

    @FlaggedApi(value="android.view.accessibility.a11y_selection_api")
    public static class Selection
    implements Parcelable {
        private final SelectionPosition mStart;
        private final SelectionPosition mEnd;
        @NonNull
        public static final Parcelable.Creator<Selection> CREATOR = new Parcelable.Creator<Selection>(){

            @Override
            public Selection createFromParcel(Parcel in) {
                return new Selection(in);
            }

            public Selection[] newArray(int size) {
                return new Selection[size];
            }
        };

        public Selection(@NonNull SelectionPosition start, @NonNull SelectionPosition end) {
            this.mStart = start;
            this.mEnd = end;
        }

        private Selection(Parcel in) {
            this.mStart = SelectionPosition.CREATOR.createFromParcel(in);
            this.mEnd = SelectionPosition.CREATOR.createFromParcel(in);
        }

        @NonNull
        public SelectionPosition getStart() {
            return this.mStart;
        }

        @NonNull
        public SelectionPosition getEnd() {
            return this.mEnd;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Selection rhs = (Selection)obj;
            return this.getStart().equals(rhs.getStart()) && this.getEnd().equals(rhs.getEnd());
        }

        public int hashCode() {
            int prime = 17;
            return 17 * this.getStart().hashCode() * this.getEnd().hashCode();
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            this.mStart.writeToParcel(dest, flags);
            this.mEnd.writeToParcel(dest, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    @FlaggedApi(value="android.view.accessibility.a11y_selection_api")
    public static class SelectionPosition
    implements Parcelable {
        private final int mOffset;
        private final long mSourceNodeId;
        private int mConnectionId;
        private int mWindowId;
        @NonNull
        public static final Parcelable.Creator<SelectionPosition> CREATOR = new Parcelable.Creator<SelectionPosition>(){

            @Override
            public SelectionPosition createFromParcel(Parcel in) {
                return new SelectionPosition(in);
            }

            public SelectionPosition[] newArray(int size) {
                return new SelectionPosition[size];
            }
        };

        public SelectionPosition(@NonNull AccessibilityNodeInfo node, int offset) {
            this(node.mSourceNodeId, offset);
        }

        public SelectionPosition(@NonNull View view, int offset) {
            this(AccessibilityNodeInfo.makeNodeId(view.getAccessibilityViewId(), -1), offset);
        }

        public SelectionPosition(@NonNull View view, int virtualDescendantId, int offset) {
            this(AccessibilityNodeInfo.makeNodeId(view.getAccessibilityViewId(), virtualDescendantId), offset);
        }

        private SelectionPosition(long sourceNodeId, int offset) {
            this.mOffset = offset;
            this.mSourceNodeId = sourceNodeId;
        }

        private SelectionPosition(Parcel in) {
            this.mOffset = in.readInt();
            this.mSourceNodeId = in.readLong();
        }

        private void setWindowId(int windowId) {
            this.mWindowId = windowId;
        }

        private void setConnectionId(int connectionId) {
            this.mConnectionId = connectionId;
        }

        @Nullable
        public AccessibilityNodeInfo getNode() {
            return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, this.mSourceNodeId);
        }

        public int getOffset() {
            return this.mOffset;
        }

        private boolean usesNode(@NonNull AccessibilityNodeInfo node) {
            return this.mSourceNodeId == node.mSourceNodeId && this.mConnectionId == node.mConnectionId && this.mWindowId == node.mWindowId;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            SelectionPosition rhs = (SelectionPosition)other;
            if (this.getOffset() != rhs.getOffset()) {
                return false;
            }
            return this.mSourceNodeId == rhs.mSourceNodeId;
        }

        public int hashCode() {
            long prime = 877L;
            long result = 1L;
            if (this.mOffset != 0) {
                result *= (long)this.mOffset;
            }
            if (this.mSourceNodeId != UNDEFINED_NODE_ID) {
                result *= this.mSourceNodeId;
            }
            return Long.hashCode(result * 877L);
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mOffset);
            dest.writeLong(this.mSourceNodeId);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class CollectionInfo {
        public static final int SELECTION_MODE_NONE = 0;
        public static final int SELECTION_MODE_SINGLE = 1;
        public static final int SELECTION_MODE_MULTIPLE = 2;
        @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
        public static final int UNDEFINED = -1;
        private int mRowCount;
        private int mColumnCount;
        private boolean mHierarchical;
        private int mSelectionMode;
        private int mItemCount;
        private int mImportantForAccessibilityItemCount;

        public static CollectionInfo obtain(CollectionInfo other) {
            return new CollectionInfo(other.mRowCount, other.mColumnCount, other.mHierarchical, other.mSelectionMode, other.mItemCount, other.mImportantForAccessibilityItemCount);
        }

        public static CollectionInfo obtain(int rowCount, int columnCount, boolean hierarchical) {
            return new CollectionInfo(rowCount, columnCount, hierarchical, 0);
        }

        public static CollectionInfo obtain(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            return new CollectionInfo(rowCount, columnCount, hierarchical, selectionMode);
        }

        public CollectionInfo(int rowCount, int columnCount, boolean hierarchical) {
            this(rowCount, columnCount, hierarchical, 0);
        }

        public CollectionInfo(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            this.mRowCount = rowCount;
            this.mColumnCount = columnCount;
            this.mHierarchical = hierarchical;
            this.mSelectionMode = selectionMode;
            this.mItemCount = -1;
            this.mImportantForAccessibilityItemCount = -1;
        }

        public CollectionInfo(int rowCount, int columnCount, boolean hierarchical, int selectionMode, int itemCount, int importantForAccessibilityItemCount) {
            this.mRowCount = rowCount;
            this.mColumnCount = columnCount;
            this.mHierarchical = hierarchical;
            this.mSelectionMode = selectionMode;
            this.mItemCount = itemCount;
            this.mImportantForAccessibilityItemCount = importantForAccessibilityItemCount;
        }

        public int getRowCount() {
            return this.mRowCount;
        }

        public int getColumnCount() {
            return this.mColumnCount;
        }

        public boolean isHierarchical() {
            return this.mHierarchical;
        }

        public int getSelectionMode() {
            return this.mSelectionMode;
        }

        @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
        public int getItemCount() {
            return this.mItemCount;
        }

        @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
        public int getImportantForAccessibilityItemCount() {
            return this.mImportantForAccessibilityItemCount;
        }

        @Deprecated
        void recycle() {
        }

        private void clear() {
            this.mRowCount = 0;
            this.mColumnCount = 0;
            this.mHierarchical = false;
            this.mSelectionMode = 0;
            this.mItemCount = -1;
            this.mImportantForAccessibilityItemCount = -1;
        }

        @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
        public static class Builder {
            private int mRowCount = 0;
            private int mColumnCount = 0;
            private boolean mHierarchical = false;
            private int mSelectionMode;
            private int mItemCount = -1;
            private int mImportantForAccessibilityItemCount = -1;

            @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
            public Builder() {
            }

            @NonNull
            @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
            public Builder setRowCount(int rowCount) {
                this.mRowCount = rowCount;
                return this;
            }

            @NonNull
            @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
            public Builder setColumnCount(int columnCount) {
                this.mColumnCount = columnCount;
                return this;
            }

            @NonNull
            @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
            public Builder setHierarchical(boolean hierarchical) {
                this.mHierarchical = hierarchical;
                return this;
            }

            @NonNull
            @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
            public Builder setSelectionMode(int selectionMode) {
                this.mSelectionMode = selectionMode;
                return this;
            }

            @NonNull
            @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
            public Builder setItemCount(int itemCount) {
                this.mItemCount = itemCount;
                return this;
            }

            @NonNull
            @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
            public Builder setImportantForAccessibilityItemCount(int importantForAccessibilityItemCount) {
                this.mImportantForAccessibilityItemCount = importantForAccessibilityItemCount;
                return this;
            }

            @NonNull
            @FlaggedApi(value="android.view.accessibility.collection_info_item_counts")
            public CollectionInfo build() {
                CollectionInfo collectionInfo = new CollectionInfo(this.mRowCount, this.mColumnCount, this.mHierarchical);
                collectionInfo.mSelectionMode = this.mSelectionMode;
                collectionInfo.mItemCount = this.mItemCount;
                collectionInfo.mImportantForAccessibilityItemCount = this.mImportantForAccessibilityItemCount;
                return collectionInfo;
            }
        }
    }

    public static class CollectionItemInfo {
        private boolean mHeading;
        private int mColumnIndex;
        private int mRowIndex;
        private int mColumnSpan;
        private int mRowSpan;
        private boolean mSelected;
        private String mRowTitle;
        private String mColumnTitle;

        @Deprecated
        public static CollectionItemInfo obtain(CollectionItemInfo other) {
            return new CollectionItemInfo(other.mRowTitle, other.mRowIndex, other.mRowSpan, other.mColumnTitle, other.mColumnIndex, other.mColumnSpan, other.mHeading, other.mSelected);
        }

        @Deprecated
        public static CollectionItemInfo obtain(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading) {
            return new CollectionItemInfo(rowIndex, rowSpan, columnIndex, columnSpan, heading, false);
        }

        @Deprecated
        public static CollectionItemInfo obtain(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            return new CollectionItemInfo(rowIndex, rowSpan, columnIndex, columnSpan, heading, selected);
        }

        @Deprecated
        @NonNull
        public static CollectionItemInfo obtain(@Nullable String rowTitle, int rowIndex, int rowSpan, @Nullable String columnTitle, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            return new CollectionItemInfo(rowTitle, rowIndex, rowSpan, columnTitle, columnIndex, columnSpan, heading, selected);
        }

        private CollectionItemInfo() {
        }

        public CollectionItemInfo(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading) {
            this(rowIndex, rowSpan, columnIndex, columnSpan, heading, false);
        }

        public CollectionItemInfo(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            this(null, rowIndex, rowSpan, null, columnIndex, columnSpan, heading, selected);
        }

        public CollectionItemInfo(@Nullable String rowTitle, int rowIndex, int rowSpan, @Nullable String columnTitle, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            this.mRowIndex = rowIndex;
            this.mRowSpan = rowSpan;
            this.mColumnIndex = columnIndex;
            this.mColumnSpan = columnSpan;
            this.mHeading = heading;
            this.mSelected = selected;
            this.mRowTitle = rowTitle;
            this.mColumnTitle = columnTitle;
        }

        public int getColumnIndex() {
            return this.mColumnIndex;
        }

        public int getRowIndex() {
            return this.mRowIndex;
        }

        public int getColumnSpan() {
            return this.mColumnSpan;
        }

        public int getRowSpan() {
            return this.mRowSpan;
        }

        public boolean isHeading() {
            return this.mHeading;
        }

        public boolean isSelected() {
            return this.mSelected;
        }

        @Nullable
        public String getRowTitle() {
            return this.mRowTitle;
        }

        @Nullable
        public String getColumnTitle() {
            return this.mColumnTitle;
        }

        @Deprecated
        void recycle() {
        }

        private void clear() {
            this.mColumnIndex = 0;
            this.mColumnSpan = 0;
            this.mRowIndex = 0;
            this.mRowSpan = 0;
            this.mHeading = false;
            this.mSelected = false;
            this.mRowTitle = null;
            this.mColumnTitle = null;
        }

        public static class Builder {
            private boolean mHeading;
            private int mColumnIndex;
            private int mRowIndex;
            private int mColumnSpan;
            private int mRowSpan;
            private boolean mSelected;
            private String mRowTitle;
            private String mColumnTitle;

            @NonNull
            public Builder setHeading(boolean heading) {
                this.mHeading = heading;
                return this;
            }

            @NonNull
            public Builder setColumnIndex(int columnIndex) {
                this.mColumnIndex = columnIndex;
                return this;
            }

            @NonNull
            public Builder setRowIndex(int rowIndex) {
                this.mRowIndex = rowIndex;
                return this;
            }

            @NonNull
            public Builder setColumnSpan(int columnSpan) {
                this.mColumnSpan = columnSpan;
                return this;
            }

            @NonNull
            public Builder setRowSpan(int rowSpan) {
                this.mRowSpan = rowSpan;
                return this;
            }

            @NonNull
            public Builder setSelected(boolean selected) {
                this.mSelected = selected;
                return this;
            }

            @NonNull
            public Builder setRowTitle(@Nullable String rowTitle) {
                this.mRowTitle = rowTitle;
                return this;
            }

            @NonNull
            public Builder setColumnTitle(@Nullable String columnTitle) {
                this.mColumnTitle = columnTitle;
                return this;
            }

            @NonNull
            public CollectionItemInfo build() {
                CollectionItemInfo collectionItemInfo = new CollectionItemInfo();
                collectionItemInfo.mHeading = this.mHeading;
                collectionItemInfo.mColumnIndex = this.mColumnIndex;
                collectionItemInfo.mRowIndex = this.mRowIndex;
                collectionItemInfo.mColumnSpan = this.mColumnSpan;
                collectionItemInfo.mRowSpan = this.mRowSpan;
                collectionItemInfo.mSelected = this.mSelected;
                collectionItemInfo.mRowTitle = this.mRowTitle;
                collectionItemInfo.mColumnTitle = this.mColumnTitle;
                return collectionItemInfo;
            }
        }
    }

    public static class RangeInfo {
        public static final int RANGE_TYPE_INT = 0;
        public static final int RANGE_TYPE_FLOAT = 1;
        public static final int RANGE_TYPE_PERCENT = 2;
        @FlaggedApi(value="android.view.accessibility.indeterminate_range_info")
        public static final int RANGE_TYPE_INDETERMINATE = 3;
        @NonNull
        @FlaggedApi(value="android.view.accessibility.indeterminate_range_info")
        public static final RangeInfo INDETERMINATE = new RangeInfo(3, 0.0f, 0.0f, 0.0f);
        private int mType;
        private float mMin;
        private float mMax;
        private float mCurrent;

        @Deprecated
        public static RangeInfo obtain(int type, float min, float max, float current) {
            return new RangeInfo(type, min, max, current);
        }

        public RangeInfo(int type, float min, float max, float current) {
            this.mType = type;
            this.mMin = min;
            this.mMax = max;
            this.mCurrent = current;
        }

        public int getType() {
            return this.mType;
        }

        public float getMin() {
            return this.mMin;
        }

        public float getMax() {
            return this.mMax;
        }

        public float getCurrent() {
            return this.mCurrent;
        }

        @Deprecated
        void recycle() {
        }

        private void clear() {
            this.mType = 0;
            this.mMin = 0.0f;
            this.mMax = 0.0f;
            this.mCurrent = 0.0f;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface RangeType {
        }
    }

    public static class ExtraRenderingInfo {
        private static final int UNDEFINED_VALUE = -1;
        private Size mLayoutSize;
        private float mTextSizeInPx = -1.0f;
        private int mTextSizeUnit = -1;

        @Deprecated
        @NonNull
        public static ExtraRenderingInfo obtain() {
            return new ExtraRenderingInfo(null);
        }

        @Deprecated
        private static ExtraRenderingInfo obtain(ExtraRenderingInfo other) {
            return new ExtraRenderingInfo(other);
        }

        private ExtraRenderingInfo(@Nullable ExtraRenderingInfo other) {
            if (other != null) {
                this.mLayoutSize = other.mLayoutSize;
                this.mTextSizeInPx = other.mTextSizeInPx;
                this.mTextSizeUnit = other.mTextSizeUnit;
            }
        }

        @Nullable
        public Size getLayoutSize() {
            return this.mLayoutSize;
        }

        public void setLayoutSize(int width, int height) {
            this.mLayoutSize = new Size(width, height);
        }

        public float getTextSizeInPx() {
            return this.mTextSizeInPx;
        }

        public void setTextSizeInPx(float textSizeInPx) {
            this.mTextSizeInPx = textSizeInPx;
        }

        public int getTextSizeUnit() {
            return this.mTextSizeUnit;
        }

        public void setTextSizeUnit(int textSizeUnit) {
            this.mTextSizeUnit = textSizeUnit;
        }

        @Deprecated
        void recycle() {
        }

        private void clear() {
            this.mLayoutSize = null;
            this.mTextSizeInPx = -1.0f;
            this.mTextSizeUnit = -1;
        }
    }

    public static class TouchDelegateInfo
    implements Parcelable {
        private ArrayMap<Region, Long> mTargetMap;
        private int mConnectionId;
        private int mWindowId;
        @NonNull
        public static final Parcelable.Creator<TouchDelegateInfo> CREATOR = new Parcelable.Creator<TouchDelegateInfo>(){

            @Override
            public TouchDelegateInfo createFromParcel(Parcel parcel) {
                int size = parcel.readInt();
                if (size == 0) {
                    return null;
                }
                ArrayMap<Region, Long> targetMap = new ArrayMap<Region, Long>(size);
                for (int i = 0; i < size; ++i) {
                    Region region = Region.CREATOR.createFromParcel(parcel);
                    long accessibilityId = parcel.readLong();
                    targetMap.put(region, accessibilityId);
                }
                TouchDelegateInfo touchDelegateInfo = new TouchDelegateInfo(targetMap, false);
                return touchDelegateInfo;
            }

            public TouchDelegateInfo[] newArray(int size) {
                return new TouchDelegateInfo[size];
            }
        };

        public TouchDelegateInfo(@NonNull Map<Region, View> targetMap) {
            Preconditions.checkArgument(!targetMap.isEmpty() && !targetMap.containsKey(null) && !targetMap.containsValue(null));
            this.mTargetMap = new ArrayMap(targetMap.size());
            for (Region region : targetMap.keySet()) {
                View view = targetMap.get(region);
                this.mTargetMap.put(region, Long.valueOf(view.getAccessibilityViewId()));
            }
        }

        TouchDelegateInfo(@NonNull ArrayMap<Region, Long> targetMap, boolean doCopy) {
            Preconditions.checkArgument(!targetMap.isEmpty() && !targetMap.containsKey(null) && !targetMap.containsValue(null));
            if (doCopy) {
                this.mTargetMap = new ArrayMap(targetMap.size());
                this.mTargetMap.putAll(targetMap);
            } else {
                this.mTargetMap = targetMap;
            }
        }

        private void setConnectionId(int connectionId) {
            this.mConnectionId = connectionId;
        }

        private void setWindowId(int windowId) {
            this.mWindowId = windowId;
        }

        public int getRegionCount() {
            return this.mTargetMap.size();
        }

        @NonNull
        public Region getRegionAt(int index) {
            return this.mTargetMap.keyAt(index);
        }

        @Nullable
        public AccessibilityNodeInfo getTargetForRegion(@NonNull Region region) {
            return AccessibilityNodeInfo.getNodeForAccessibilityId(this.mConnectionId, this.mWindowId, (long)this.mTargetMap.get(region));
        }

        public long getAccessibilityIdForRegion(@NonNull Region region) {
            return this.mTargetMap.get(region);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.mTargetMap.size());
            for (int i = 0; i < this.mTargetMap.size(); ++i) {
                Region region = this.mTargetMap.keyAt(i);
                Long accessibilityId = this.mTargetMap.valueAt(i);
                region.writeToParcel(dest, flags);
                dest.writeLong(accessibilityId);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CheckedState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ExpandedState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PrefetchingStrategy {
    }
}

