/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.WindowConfiguration;
import android.graphics.Insets;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.DisplayCutout;
import android.view.Gravity;
import android.view.InsetsSource;
import android.view.InsetsState;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.window.ClientWindowFrames;

public class WindowLayout {
    private static final String TAG = WindowLayout.class.getSimpleName();
    private static final boolean DEBUG = false;
    public static final int UNSPECIFIED_LENGTH = -1;
    static final int MIN_X = -100000;
    static final int MIN_Y = -100000;
    static final int MAX_X = 100000;
    static final int MAX_Y = 100000;
    private final Rect mTempDisplayCutoutSafeExceptMaybeBarsRect = new Rect();
    private final Rect mTempRect = new Rect();

    public void computeFrames(WindowManager.LayoutParams attrs, InsetsState state, Rect displayCutoutSafe, Rect windowBounds, int windowingMode, int requestedWidth, int requestedHeight, int requestedVisibleTypes, float compatScale, ClientWindowFrames frames) {
        float y;
        float x;
        int h;
        int w;
        int type = attrs.type;
        int fl = attrs.flags;
        int pfl = attrs.privateFlags;
        boolean layoutInScreen = (fl & 0x100) == 256;
        Rect attachedWindowFrame = frames.attachedFrame;
        Rect outDisplayFrame = frames.displayFrame;
        Rect outParentFrame = frames.parentFrame;
        Rect outFrame = frames.frame;
        Insets insets = state.calculateInsets(windowBounds, attrs.getFitInsetsTypes(), attrs.isFitInsetsIgnoringVisibility());
        int sides = attrs.getFitInsetsSides();
        int left = (sides & 1) != 0 ? insets.left : 0;
        int top = (sides & 2) != 0 ? insets.top : 0;
        int right = (sides & 4) != 0 ? insets.right : 0;
        int bottom = (sides & 8) != 0 ? insets.bottom : 0;
        outDisplayFrame.set(windowBounds.left + left, windowBounds.top + top, windowBounds.right - right, windowBounds.bottom - bottom);
        if (attachedWindowFrame == null) {
            InsetsSource source;
            outParentFrame.set(outDisplayFrame);
            if ((pfl & 0x40000000) != 0 && (source = state.peekSource(InsetsSource.ID_IME)) != null) {
                outParentFrame.inset(source.calculateInsets(outParentFrame, false));
            }
        } else {
            outParentFrame.set(!layoutInScreen ? attachedWindowFrame : outDisplayFrame);
        }
        int cutoutMode = attrs.layoutInDisplayCutoutMode;
        DisplayCutout cutout = state.getDisplayCutout();
        Rect displayCutoutSafeExceptMaybeBars = this.mTempDisplayCutoutSafeExceptMaybeBarsRect;
        displayCutoutSafeExceptMaybeBars.set(displayCutoutSafe);
        frames.isParentFrameClippedByDisplayCutout = false;
        if (cutoutMode != 3 && !cutout.isEmpty()) {
            boolean floatingInScreenWindow;
            boolean layoutInsetDecor;
            Rect displayFrame = state.getDisplayFrame();
            if (cutoutMode == 1) {
                if (displayFrame.width() < displayFrame.height()) {
                    displayCutoutSafeExceptMaybeBars.top = -100000;
                    displayCutoutSafeExceptMaybeBars.bottom = 100000;
                } else {
                    displayCutoutSafeExceptMaybeBars.left = -100000;
                    displayCutoutSafeExceptMaybeBars.right = 100000;
                }
            }
            boolean bl = layoutInsetDecor = (attrs.flags & 0x10000) != 0;
            if (layoutInScreen && layoutInsetDecor && (cutoutMode == 0 || cutoutMode == 1)) {
                Insets systemBarsInsets = state.calculateInsets(displayFrame, WindowInsets.Type.systemBars(), requestedVisibleTypes);
                if (systemBarsInsets.left >= cutout.getSafeInsetLeft()) {
                    displayCutoutSafeExceptMaybeBars.left = -100000;
                }
                if (systemBarsInsets.top >= cutout.getSafeInsetTop()) {
                    displayCutoutSafeExceptMaybeBars.top = -100000;
                }
                if (systemBarsInsets.right >= cutout.getSafeInsetRight()) {
                    displayCutoutSafeExceptMaybeBars.right = 100000;
                }
                if (systemBarsInsets.bottom >= cutout.getSafeInsetBottom()) {
                    displayCutoutSafeExceptMaybeBars.bottom = 100000;
                }
            }
            if (type == 2011 && displayCutoutSafeExceptMaybeBars.bottom != 100000 && state.calculateInsets((Rect)displayFrame, (int)WindowInsets.Type.navigationBars(), (boolean)true).bottom > 0) {
                displayCutoutSafeExceptMaybeBars.bottom = 100000;
            }
            boolean attachedInParent = attachedWindowFrame != null && !layoutInScreen;
            boolean bl2 = floatingInScreenWindow = !attrs.isFullscreen() && layoutInScreen && type != 1;
            if (!attachedInParent && !floatingInScreenWindow) {
                this.mTempRect.set(outParentFrame);
                WindowLayout.intersectOrClamp(outParentFrame, displayCutoutSafeExceptMaybeBars);
                frames.isParentFrameClippedByDisplayCutout = !this.mTempRect.equals(outParentFrame);
            }
            WindowLayout.intersectOrClamp(outDisplayFrame, displayCutoutSafeExceptMaybeBars);
        }
        boolean noLimits = (attrs.flags & 0x200) != 0;
        boolean inMultiWindowMode = WindowConfiguration.inMultiWindowMode(windowingMode);
        if (noLimits && type != 2010 && !inMultiWindowMode) {
            outDisplayFrame.left = -100000;
            outDisplayFrame.top = -100000;
            outDisplayFrame.right = 100000;
            outDisplayFrame.bottom = 100000;
        }
        boolean hasCompatScale = compatScale != 1.0f;
        int pw = outParentFrame.width();
        int ph = outParentFrame.height();
        boolean extendedByCutout = (attrs.privateFlags & 0x1000) != 0;
        int rw = requestedWidth;
        int rh = requestedHeight;
        if (rw == -1 || extendedByCutout) {
            int n = rw = attrs.width >= 0 ? attrs.width : pw;
        }
        if (rh == -1 || extendedByCutout) {
            int n = rh = attrs.height >= 0 ? attrs.height : ph;
        }
        if ((attrs.flags & 0x4000) != 0) {
            w = attrs.width < 0 ? pw : (hasCompatScale ? (int)((float)attrs.width * compatScale + 0.5f) : attrs.width);
            h = attrs.height < 0 ? ph : (hasCompatScale ? (int)((float)attrs.height * compatScale + 0.5f) : attrs.height);
        } else {
            w = attrs.width == -1 ? pw : (hasCompatScale ? (int)((float)rw * compatScale + 0.5f) : rw);
            h = attrs.height == -1 ? ph : (hasCompatScale ? (int)((float)rh * compatScale + 0.5f) : rh);
        }
        if (hasCompatScale) {
            x = (float)attrs.x * compatScale;
            y = (float)attrs.y * compatScale;
        } else {
            x = attrs.x;
            y = attrs.y;
        }
        if (inMultiWindowMode && (attrs.privateFlags & 0x4000) == 0) {
            w = Math.min(w, pw);
            h = Math.min(h, ph);
        }
        boolean fitToDisplay = !inMultiWindowMode || attrs.type != 1 && !noLimits;
        Gravity.apply(attrs.gravity, w, h, outParentFrame, (int)(x + attrs.horizontalMargin * (float)pw), (int)(y + attrs.verticalMargin * (float)ph), outFrame);
        if (fitToDisplay) {
            Gravity.applyDisplay(attrs.gravity, outDisplayFrame, outFrame);
        }
        if (extendedByCutout) {
            WindowLayout.extendFrameByCutout(displayCutoutSafe, outDisplayFrame, outFrame, this.mTempRect);
        }
    }

    private static void intersectOrClamp(Rect inOutRect, Rect other) {
        inOutRect.left = Math.min(Math.max(inOutRect.left, other.left), inOutRect.right);
        inOutRect.top = Math.min(Math.max(inOutRect.top, other.top), inOutRect.bottom);
        inOutRect.right = Math.max(Math.min(inOutRect.right, other.right), inOutRect.left);
        inOutRect.bottom = Math.max(Math.min(inOutRect.bottom, other.bottom), inOutRect.top);
    }

    public static void extendFrameByCutout(Rect displayCutoutSafe, Rect displayFrame, Rect inOutFrame, Rect tempRect) {
        if (displayCutoutSafe.contains(inOutFrame)) {
            return;
        }
        tempRect.set(inOutFrame);
        Gravity.applyDisplay(0, displayCutoutSafe, tempRect);
        if (tempRect.intersect(displayFrame)) {
            inOutFrame.union(tempRect);
        }
    }

    public static void computeSurfaceSize(WindowManager.LayoutParams attrs, Rect maxBounds, int requestedWidth, int requestedHeight, Rect winFrame, boolean dragResizing, Point outSurfaceSize) {
        int height;
        int width;
        if ((attrs.flags & 0x4000) != 0) {
            width = requestedWidth;
            height = requestedHeight;
        } else if (dragResizing) {
            width = maxBounds.width();
            height = maxBounds.height();
        } else {
            width = winFrame.width();
            height = winFrame.height();
        }
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        Rect surfaceInsets = attrs.surfaceInsets;
        outSurfaceSize.set(width += surfaceInsets.left + surfaceInsets.right, height += surfaceInsets.top + surfaceInsets.bottom);
    }
}

