/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Insets;
import android.graphics.Rect;
import android.util.Size;
import android.view.DisplayCutout;
import android.view.DisplayShape;
import android.view.PrivacyIndicatorBounds;
import android.view.RoundedCorner;
import android.view.RoundedCorners;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class WindowInsets {
    private final Insets[] mTypeInsetsMap;
    private final Insets[] mTypeMaxInsetsMap;
    private final boolean[] mTypeVisibilityMap;
    private final Rect[][] mTypeBoundingRectsMap;
    private final Rect[][] mTypeMaxBoundingRectsMap;
    @Nullable
    private Rect mTempRect;
    private final boolean mIsRound;
    @Nullable
    private final DisplayCutout mDisplayCutout;
    @Nullable
    private final RoundedCorners mRoundedCorners;
    @Nullable
    private final PrivacyIndicatorBounds mPrivacyIndicatorBounds;
    @Nullable
    private final DisplayShape mDisplayShape;
    private final int mFrameWidth;
    private final int mFrameHeight;
    private final int mForceConsumingTypes;
    private final boolean mForceConsumingOpaqueCaptionBar;
    private final int mSuppressScrimTypes;
    private final boolean mSystemWindowInsetsConsumed;
    private final boolean mStableInsetsConsumed;
    private final boolean mDisplayCutoutConsumed;
    private final int mCompatInsetsTypes;
    private final boolean mCompatIgnoreVisibility;
    @NonNull
    public static final WindowInsets CONSUMED = new WindowInsets(WindowInsets.createCompatTypeMap(null), WindowInsets.createCompatTypeMap(null), WindowInsets.createCompatVisibilityMap(WindowInsets.createCompatTypeMap(null)), false, 0, false, 0, null, null, null, null, Type.systemBars(), false, null, null, 0, 0);

    public WindowInsets(@Nullable Insets[] typeInsetsMap, @Nullable Insets[] typeMaxInsetsMap, boolean[] typeVisibilityMap, boolean isRound, int forceConsumingTypes, boolean forceConsumingOpaqueCaptionBar, int suppressScrimTypes, DisplayCutout displayCutout, RoundedCorners roundedCorners, PrivacyIndicatorBounds privacyIndicatorBounds, DisplayShape displayShape, int compatInsetsTypes, boolean compatIgnoreVisibility, Rect[][] typeBoundingRectsMap, Rect[][] typeMaxBoundingRectsMap, int frameWidth, int frameHeight) {
        this.mSystemWindowInsetsConsumed = typeInsetsMap == null;
        this.mTypeInsetsMap = this.mSystemWindowInsetsConsumed ? new Insets[10] : (Insets[])typeInsetsMap.clone();
        this.mStableInsetsConsumed = typeMaxInsetsMap == null;
        this.mTypeMaxInsetsMap = this.mStableInsetsConsumed ? new Insets[10] : (Insets[])typeMaxInsetsMap.clone();
        this.mTypeVisibilityMap = typeVisibilityMap;
        this.mIsRound = isRound;
        this.mForceConsumingTypes = forceConsumingTypes;
        this.mForceConsumingOpaqueCaptionBar = forceConsumingOpaqueCaptionBar;
        this.mSuppressScrimTypes = suppressScrimTypes;
        this.mCompatInsetsTypes = compatInsetsTypes;
        this.mCompatIgnoreVisibility = compatIgnoreVisibility;
        this.mDisplayCutoutConsumed = displayCutout == null;
        this.mDisplayCutout = this.mDisplayCutoutConsumed || displayCutout.isEmpty() ? null : displayCutout;
        this.mRoundedCorners = roundedCorners;
        this.mPrivacyIndicatorBounds = privacyIndicatorBounds;
        this.mDisplayShape = displayShape;
        this.mTypeBoundingRectsMap = this.mSystemWindowInsetsConsumed || typeBoundingRectsMap == null ? new Rect[10][] : (Rect[][])typeBoundingRectsMap.clone();
        this.mTypeMaxBoundingRectsMap = this.mStableInsetsConsumed || typeMaxBoundingRectsMap == null ? new Rect[10][] : (Rect[][])typeMaxBoundingRectsMap.clone();
        this.mFrameWidth = frameWidth;
        this.mFrameHeight = frameHeight;
    }

    public WindowInsets(WindowInsets src) {
        this(src.mSystemWindowInsetsConsumed ? null : src.mTypeInsetsMap, src.mStableInsetsConsumed ? null : src.mTypeMaxInsetsMap, src.mTypeVisibilityMap, src.mIsRound, src.mForceConsumingTypes, src.mForceConsumingOpaqueCaptionBar, src.mSuppressScrimTypes, WindowInsets.displayCutoutCopyConstructorArgument(src), src.mRoundedCorners, src.mPrivacyIndicatorBounds, src.mDisplayShape, src.mCompatInsetsTypes, src.mCompatIgnoreVisibility, src.mSystemWindowInsetsConsumed ? null : src.mTypeBoundingRectsMap, src.mStableInsetsConsumed ? null : src.mTypeMaxBoundingRectsMap, src.mFrameWidth, src.mFrameHeight);
    }

    private static DisplayCutout displayCutoutCopyConstructorArgument(WindowInsets w) {
        if (w.mDisplayCutoutConsumed) {
            return null;
        }
        if (w.mDisplayCutout == null) {
            return DisplayCutout.NO_CUTOUT;
        }
        return w.mDisplayCutout;
    }

    static Insets getInsets(Insets[] typeInsetsMap, int typeMask) {
        Insets result = null;
        for (int i = 1; i <= 512; i <<= 1) {
            Insets insets;
            if ((typeMask & i) == 0 || (insets = typeInsetsMap[Type.indexOf(i)]) == null) continue;
            result = result == null ? insets : Insets.max(result, insets);
        }
        return result == null ? Insets.NONE : result;
    }

    private static void setInsets(Insets[] typeInsetsMap, int typeMask, Insets insets) {
        for (int i = 1; i <= 512; i <<= 1) {
            if ((typeMask & i) == 0) continue;
            typeInsetsMap[Type.indexOf((int)i)] = insets;
        }
    }

    @UnsupportedAppUsage
    public WindowInsets(Rect systemWindowInsets) {
        this(WindowInsets.createCompatTypeMap(systemWindowInsets), null, new boolean[10], false, 0, false, 0, null, null, null, null, Type.systemBars(), false, new Rect[10][], null, 0, 0);
    }

    @VisibleForTesting
    public static Insets[] createCompatTypeMap(@Nullable Rect insets) {
        if (insets == null) {
            return null;
        }
        Insets[] typeInsetsMap = new Insets[10];
        WindowInsets.assignCompatInsets(typeInsetsMap, insets);
        return typeInsetsMap;
    }

    @VisibleForTesting
    public static void assignCompatInsets(Insets[] typeInsetsMap, Rect insets) {
        typeInsetsMap[Type.indexOf((int)1)] = Insets.of(0, insets.top, 0, 0);
        typeInsetsMap[Type.indexOf((int)2)] = Insets.of(insets.left, 0, insets.right, insets.bottom);
    }

    @VisibleForTesting
    private static boolean[] createCompatVisibilityMap(@Nullable Insets[] typeInsetsMap) {
        boolean[] typeVisibilityMap = new boolean[10];
        if (typeInsetsMap == null) {
            return typeVisibilityMap;
        }
        for (int i = 1; i <= 512; i <<= 1) {
            int index = Type.indexOf(i);
            if (Insets.NONE.equals(typeInsetsMap[index])) continue;
            typeVisibilityMap[index] = true;
        }
        return typeVisibilityMap;
    }

    @Deprecated
    @NonNull
    public Rect getSystemWindowInsetsAsRect() {
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        Insets insets = this.getSystemWindowInsets();
        this.mTempRect.set(insets.left, insets.top, insets.right, insets.bottom);
        return this.mTempRect;
    }

    @Deprecated
    @NonNull
    public Insets getSystemWindowInsets() {
        Insets result;
        Insets insets = result = this.mCompatIgnoreVisibility ? this.getInsetsIgnoringVisibility(this.mCompatInsetsTypes & ~Type.ime()) : this.getInsets(this.mCompatInsetsTypes);
        if ((this.mCompatInsetsTypes & Type.ime()) != 0 && this.mCompatIgnoreVisibility) {
            result = Insets.max(result, this.getInsets(Type.ime()));
        }
        return result;
    }

    @NonNull
    public Insets getInsets(int typeMask) {
        return WindowInsets.getInsets(this.mTypeInsetsMap, typeMask);
    }

    @NonNull
    public Insets getInsetsIgnoringVisibility(int typeMask) {
        if ((typeMask & 8) != 0) {
            throw new IllegalArgumentException("Unable to query the maximum insets for IME");
        }
        return WindowInsets.getInsets(this.mTypeMaxInsetsMap, typeMask);
    }

    public boolean isVisible(int typeMask) {
        for (int i = 1; i <= 512; i <<= 1) {
            if ((typeMask & i) == 0 || this.mTypeVisibilityMap[Type.indexOf(i)]) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public int getSystemWindowInsetLeft() {
        return this.getSystemWindowInsets().left;
    }

    @Deprecated
    public int getSystemWindowInsetTop() {
        return this.getSystemWindowInsets().top;
    }

    @Deprecated
    public int getSystemWindowInsetRight() {
        return this.getSystemWindowInsets().right;
    }

    @Deprecated
    public int getSystemWindowInsetBottom() {
        return this.getSystemWindowInsets().bottom;
    }

    @Deprecated
    public boolean hasSystemWindowInsets() {
        return !this.getSystemWindowInsets().equals(Insets.NONE);
    }

    public boolean hasInsets() {
        return !WindowInsets.getInsets(this.mTypeInsetsMap, Type.all()).equals(Insets.NONE) || !WindowInsets.getInsets(this.mTypeMaxInsetsMap, Type.all()).equals(Insets.NONE) || this.mDisplayCutout != null || this.mRoundedCorners != null;
    }

    @FlaggedApi(value="android.view.flags.customizable_window_headers")
    @NonNull
    public List<Rect> getBoundingRects(int typeMask) {
        return this.getBoundingRects(this.mTypeBoundingRectsMap, typeMask);
    }

    @FlaggedApi(value="android.view.flags.customizable_window_headers")
    @NonNull
    public List<Rect> getBoundingRectsIgnoringVisibility(int typeMask) {
        if ((typeMask & 8) != 0) {
            throw new IllegalArgumentException("Unable to query the bounding rects for IME");
        }
        return this.getBoundingRects(this.mTypeMaxBoundingRectsMap, typeMask);
    }

    private List<Rect> getBoundingRects(Rect[][] typeBoundingRectsMap, int typeMask) {
        Rect[] allRects = null;
        for (int i = 1; i <= 512; i <<= 1) {
            Rect[] rects;
            if ((typeMask & i) == 0 || (rects = typeBoundingRectsMap[Type.indexOf(i)]) == null) continue;
            if (allRects == null) {
                allRects = rects;
                continue;
            }
            Rect[] concat = new Rect[allRects.length + rects.length];
            System.arraycopy(allRects, 0, concat, 0, allRects.length);
            System.arraycopy(rects, 0, concat, allRects.length, rects.length);
            allRects = concat;
        }
        if (allRects == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(allRects);
    }

    @Nullable
    public DisplayCutout getDisplayCutout() {
        return this.mDisplayCutout;
    }

    @Nullable
    public RoundedCorner getRoundedCorner(int position) {
        return this.mRoundedCorners == null ? null : this.mRoundedCorners.getRoundedCorner(position);
    }

    @Nullable
    public Rect getPrivacyIndicatorBounds() {
        return this.mPrivacyIndicatorBounds == null ? null : this.mPrivacyIndicatorBounds.getStaticPrivacyIndicatorBounds();
    }

    @Nullable
    public DisplayShape getDisplayShape() {
        return this.mDisplayShape;
    }

    @Deprecated
    @NonNull
    public WindowInsets consumeDisplayCutout() {
        return new WindowInsets(this.mSystemWindowInsetsConsumed ? null : this.mTypeInsetsMap, this.mStableInsetsConsumed ? null : this.mTypeMaxInsetsMap, this.mTypeVisibilityMap, this.mIsRound, this.mForceConsumingTypes, this.mForceConsumingOpaqueCaptionBar, this.mSuppressScrimTypes, null, this.mRoundedCorners, this.mPrivacyIndicatorBounds, this.mDisplayShape, this.mCompatInsetsTypes, this.mCompatIgnoreVisibility, this.mSystemWindowInsetsConsumed ? null : this.mTypeBoundingRectsMap, this.mStableInsetsConsumed ? null : this.mTypeMaxBoundingRectsMap, this.mFrameWidth, this.mFrameHeight);
    }

    public boolean isConsumed() {
        return this.mSystemWindowInsetsConsumed && this.mStableInsetsConsumed && this.mDisplayCutoutConsumed;
    }

    public boolean isRound() {
        return this.mIsRound;
    }

    @Deprecated
    @NonNull
    public WindowInsets consumeSystemWindowInsets() {
        return new WindowInsets(null, null, this.mTypeVisibilityMap, this.mIsRound, this.mForceConsumingTypes, this.mForceConsumingOpaqueCaptionBar, this.mSuppressScrimTypes, (this.mCompatInsetsTypes & Type.displayCutout()) != 0 ? null : WindowInsets.displayCutoutCopyConstructorArgument(this), this.mRoundedCorners, this.mPrivacyIndicatorBounds, this.mDisplayShape, this.mCompatInsetsTypes, this.mCompatIgnoreVisibility, null, null, this.mFrameWidth, this.mFrameHeight);
    }

    @Deprecated
    @NonNull
    public WindowInsets replaceSystemWindowInsets(int left, int top, int right, int bottom) {
        if (this.mSystemWindowInsetsConsumed) {
            return this;
        }
        return new Builder(this).setSystemWindowInsets(Insets.of(left, top, right, bottom)).build();
    }

    @Deprecated
    @NonNull
    public WindowInsets replaceSystemWindowInsets(Rect systemWindowInsets) {
        return this.replaceSystemWindowInsets(systemWindowInsets.left, systemWindowInsets.top, systemWindowInsets.right, systemWindowInsets.bottom);
    }

    @Deprecated
    @NonNull
    public Insets getStableInsets() {
        return WindowInsets.getInsets(this.mTypeMaxInsetsMap, Type.systemBars());
    }

    @Deprecated
    public int getStableInsetTop() {
        return this.getStableInsets().top;
    }

    @Deprecated
    public int getStableInsetLeft() {
        return this.getStableInsets().left;
    }

    @Deprecated
    public int getStableInsetRight() {
        return this.getStableInsets().right;
    }

    @Deprecated
    public int getStableInsetBottom() {
        return this.getStableInsets().bottom;
    }

    @Deprecated
    public boolean hasStableInsets() {
        return !this.getStableInsets().equals(Insets.NONE);
    }

    @Deprecated
    @NonNull
    public Insets getSystemGestureInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, 16);
    }

    @Deprecated
    @NonNull
    public Insets getMandatorySystemGestureInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, 32);
    }

    @Deprecated
    @NonNull
    public Insets getTappableElementInsets() {
        return WindowInsets.getInsets(this.mTypeInsetsMap, 64);
    }

    @Deprecated
    @NonNull
    public WindowInsets consumeStableInsets() {
        return this;
    }

    public int getForceConsumingTypes() {
        return this.mForceConsumingTypes;
    }

    public boolean isForceConsumingOpaqueCaptionBar() {
        return this.mForceConsumingOpaqueCaptionBar;
    }

    public int getSuppressScrimTypes() {
        return this.mSuppressScrimTypes;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("WindowInsets{\n    ");
        for (int i = 0; i < 10; ++i) {
            Insets insets = this.mTypeInsetsMap[i];
            Insets maxInsets = this.mTypeMaxInsetsMap[i];
            boolean visible = this.mTypeVisibilityMap[i];
            if (Insets.NONE.equals(insets) && Insets.NONE.equals(maxInsets) && !visible) continue;
            result.append(Type.toString(1 << i)).append("=").append(insets).append(" max=").append(maxInsets).append(" vis=").append(visible).append(" boundingRects=").append(Arrays.toString(this.mTypeBoundingRectsMap[i])).append(" maxBoundingRects=").append(Arrays.toString(this.mTypeMaxBoundingRectsMap[i])).append("\n    ");
        }
        result.append(this.mDisplayCutout != null ? "cutout=" + this.mDisplayCutout : "");
        result.append("\n    ");
        result.append(this.mRoundedCorners != null ? "roundedCorners=" + this.mRoundedCorners : "");
        result.append("\n    ");
        result.append(this.mPrivacyIndicatorBounds != null ? "privacyIndicatorBounds=" + this.mPrivacyIndicatorBounds : "");
        result.append("\n    ");
        result.append(this.mDisplayShape != null ? "displayShape=" + this.mDisplayShape : "");
        result.append("\n    ");
        result.append("forceConsumingTypes=" + Type.toString(this.mForceConsumingTypes));
        result.append("\n    ");
        result.append("forceConsumingOpaqueCaptionBar=" + this.mForceConsumingOpaqueCaptionBar);
        result.append("\n    ");
        result.append("suppressScrimTypes=" + Type.toString(this.mSuppressScrimTypes));
        result.append("\n    ");
        result.append("compatInsetsTypes=" + Type.toString(this.mCompatInsetsTypes));
        result.append("\n    ");
        result.append("compatIgnoreVisibility=" + this.mCompatIgnoreVisibility);
        result.append("\n    ");
        result.append("systemWindowInsetsConsumed=" + this.mSystemWindowInsetsConsumed);
        result.append("\n    ");
        result.append("stableInsetsConsumed=" + this.mStableInsetsConsumed);
        result.append("\n    ");
        result.append("displayCutoutConsumed=" + this.mDisplayCutoutConsumed);
        result.append("\n    ");
        result.append(this.isRound() ? "round" : "");
        result.append("\n    ");
        result.append("frameWidth=" + this.mFrameWidth);
        result.append("\n    ");
        result.append("frameHeight=" + this.mFrameHeight);
        result.append("}");
        return result.toString();
    }

    @Deprecated
    @NonNull
    public WindowInsets inset(Rect r) {
        return this.inset(r.left, r.top, r.right, r.bottom);
    }

    @NonNull
    public WindowInsets inset(@NonNull Insets insets) {
        Objects.requireNonNull(insets);
        return this.inset(insets.left, insets.top, insets.right, insets.bottom);
    }

    @NonNull
    public WindowInsets inset(int left, int top, int right, int bottom) {
        Preconditions.checkArgumentNonnegative(left);
        Preconditions.checkArgumentNonnegative(top);
        Preconditions.checkArgumentNonnegative(right);
        Preconditions.checkArgumentNonnegative(bottom);
        return this.insetUnchecked(left, top, right, bottom);
    }

    @FlaggedApi(value="android.view.flags.customizable_window_headers")
    @NonNull
    public Size getFrame() {
        return new Size(this.mFrameWidth, this.mFrameHeight);
    }

    @NonNull
    public WindowInsets insetUnchecked(int left, int top, int right, int bottom) {
        return new WindowInsets(this.mSystemWindowInsetsConsumed ? null : WindowInsets.insetInsets(this.mTypeInsetsMap, left, top, right, bottom), this.mStableInsetsConsumed ? null : WindowInsets.insetInsets(this.mTypeMaxInsetsMap, left, top, right, bottom), this.mTypeVisibilityMap, this.mIsRound, this.mForceConsumingTypes, this.mForceConsumingOpaqueCaptionBar, this.mSuppressScrimTypes, this.mDisplayCutoutConsumed ? null : (this.mDisplayCutout == null ? DisplayCutout.NO_CUTOUT : this.mDisplayCutout.inset(left, top, right, bottom)), this.mRoundedCorners == null ? RoundedCorners.NO_ROUNDED_CORNERS : this.mRoundedCorners.inset(left, top, right, bottom), this.mPrivacyIndicatorBounds == null ? null : this.mPrivacyIndicatorBounds.inset(left, top, right, bottom), this.mDisplayShape, this.mCompatInsetsTypes, this.mCompatIgnoreVisibility, this.mSystemWindowInsetsConsumed ? null : WindowInsets.insetBoundingRects(this.mTypeBoundingRectsMap, left, top, right, bottom, this.mFrameWidth, this.mFrameHeight), this.mStableInsetsConsumed ? null : WindowInsets.insetBoundingRects(this.mTypeMaxBoundingRectsMap, left, top, right, bottom, this.mFrameWidth, this.mFrameHeight), Math.max(0, this.mFrameWidth - left - right), Math.max(0, this.mFrameHeight - top - bottom));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof WindowInsets)) {
            return false;
        }
        WindowInsets that = (WindowInsets)o;
        return this.mIsRound == that.mIsRound && this.mForceConsumingTypes == that.mForceConsumingTypes && this.mForceConsumingOpaqueCaptionBar == that.mForceConsumingOpaqueCaptionBar && this.mSuppressScrimTypes == that.mSuppressScrimTypes && this.mSystemWindowInsetsConsumed == that.mSystemWindowInsetsConsumed && this.mStableInsetsConsumed == that.mStableInsetsConsumed && this.mDisplayCutoutConsumed == that.mDisplayCutoutConsumed && Arrays.equals(this.mTypeInsetsMap, that.mTypeInsetsMap) && Arrays.equals(this.mTypeMaxInsetsMap, that.mTypeMaxInsetsMap) && Arrays.equals(this.mTypeVisibilityMap, that.mTypeVisibilityMap) && Objects.equals(this.mDisplayCutout, that.mDisplayCutout) && Objects.equals(this.mRoundedCorners, that.mRoundedCorners) && Objects.equals(this.mPrivacyIndicatorBounds, that.mPrivacyIndicatorBounds) && Objects.equals(this.mDisplayShape, that.mDisplayShape) && Arrays.deepEquals((Object[])this.mTypeBoundingRectsMap, (Object[])that.mTypeBoundingRectsMap) && Arrays.deepEquals((Object[])this.mTypeMaxBoundingRectsMap, (Object[])that.mTypeMaxBoundingRectsMap) && this.mFrameWidth == that.mFrameWidth && this.mFrameHeight == that.mFrameHeight;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.mTypeInsetsMap), Arrays.hashCode(this.mTypeMaxInsetsMap), Arrays.hashCode(this.mTypeVisibilityMap), this.mIsRound, this.mDisplayCutout, this.mRoundedCorners, this.mForceConsumingTypes, this.mForceConsumingOpaqueCaptionBar, this.mSuppressScrimTypes, this.mSystemWindowInsetsConsumed, this.mStableInsetsConsumed, this.mDisplayCutoutConsumed, this.mPrivacyIndicatorBounds, this.mDisplayShape, Arrays.deepHashCode((Object[])this.mTypeBoundingRectsMap), Arrays.deepHashCode((Object[])this.mTypeMaxBoundingRectsMap), this.mFrameWidth, this.mFrameHeight);
    }

    private static Insets[] insetInsets(Insets[] typeInsetsMap, int left, int top, int right, int bottom) {
        boolean cloned = false;
        for (int i = 0; i < 10; ++i) {
            Insets insetInsets;
            Insets insets = typeInsetsMap[i];
            if (insets == null || (insetInsets = WindowInsets.insetInsets(insets, left, top, right, bottom)) == insets) continue;
            if (!cloned) {
                typeInsetsMap = (Insets[])typeInsetsMap.clone();
                cloned = true;
            }
            typeInsetsMap[i] = insetInsets;
        }
        return typeInsetsMap;
    }

    static Insets insetInsets(Insets insets, int left, int top, int right, int bottom) {
        int newLeft = Math.max(0, insets.left - left);
        int newTop = Math.max(0, insets.top - top);
        int newRight = Math.max(0, insets.right - right);
        int newBottom = Math.max(0, insets.bottom - bottom);
        if (newLeft == insets.left && newTop == insets.top && newRight == insets.right && newBottom == insets.bottom) {
            return insets;
        }
        return Insets.of(newLeft, newTop, newRight, newBottom);
    }

    static Rect[][] insetBoundingRects(Rect[][] typeBoundingRectsMap, int insetLeft, int insetTop, int insetRight, int insetBottom, int frameWidth, int frameHeight) {
        if (insetLeft == 0 && insetTop == 0 && insetRight == 0 && insetBottom == 0) {
            return typeBoundingRectsMap;
        }
        boolean cloned = false;
        for (int i = 0; i < 10; ++i) {
            Object[] insetBoundingRects;
            Object[] boundingRects = typeBoundingRectsMap[i];
            if (boundingRects == null || Arrays.equals(insetBoundingRects = WindowInsets.insetBoundingRects((Rect[])boundingRects, insetLeft, insetTop, insetRight, insetBottom, frameWidth, frameHeight), boundingRects)) continue;
            if (!cloned) {
                typeBoundingRectsMap = (Rect[][])typeBoundingRectsMap.clone();
                cloned = true;
            }
            typeBoundingRectsMap[i] = insetBoundingRects;
        }
        return typeBoundingRectsMap;
    }

    static Rect[] insetBoundingRects(Rect[] boundingRects, int left, int top, int right, int bottom, int frameWidth, int frameHeight) {
        ArrayList<Rect> insetBoundingRectsList = new ArrayList<Rect>();
        for (int i = 0; i < boundingRects.length; ++i) {
            Rect insetRect = WindowInsets.insetRect(boundingRects[i], left, top, right, bottom, frameWidth, frameHeight);
            if (insetRect == null) continue;
            insetBoundingRectsList.add(insetRect);
        }
        return insetBoundingRectsList.toArray(new Rect[0]);
    }

    private static Rect insetRect(Rect orig, int insetLeft, int insetTop, int insetRight, int insetBottom, int frameWidth, int frameHeight) {
        if (orig == null) {
            return null;
        }
        Rect insetRect = new Rect();
        Rect insetFrame = new Rect(insetLeft, insetTop, frameWidth - insetRight, frameHeight - insetBottom);
        if (insetRect.setIntersect(insetFrame, orig)) {
            insetRect.offset(-insetLeft, -insetTop);
            return insetRect;
        }
        return null;
    }

    boolean isSystemWindowInsetsConsumed() {
        return this.mSystemWindowInsetsConsumed;
    }

    public static class Type {
        static final int FIRST = 1;
        static final int STATUS_BARS = 1;
        static final int NAVIGATION_BARS = 2;
        static final int CAPTION_BAR = 4;
        static final int IME = 8;
        static final int SYSTEM_GESTURES = 16;
        static final int MANDATORY_SYSTEM_GESTURES = 32;
        static final int TAPPABLE_ELEMENT = 64;
        static final int DISPLAY_CUTOUT = 128;
        static final int WINDOW_DECOR = 256;
        static final int SYSTEM_OVERLAYS = 512;
        static final int LAST = 512;
        static final int SIZE = 10;
        static final int DEFAULT_VISIBLE = -9;

        static int indexOf(int type) {
            switch (type) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return 1;
                }
                case 4: {
                    return 2;
                }
                case 8: {
                    return 3;
                }
                case 16: {
                    return 4;
                }
                case 32: {
                    return 5;
                }
                case 64: {
                    return 6;
                }
                case 128: {
                    return 7;
                }
                case 256: {
                    return 8;
                }
                case 512: {
                    return 9;
                }
            }
            throw new IllegalArgumentException("type needs to be >= FIRST and <= LAST, type=" + type);
        }

        @NonNull
        @SuppressLint(value={"UnflaggedApi"})
        public static String toString(int types) {
            StringBuilder result = new StringBuilder();
            if ((types & 1) != 0) {
                result.append("statusBars ");
            }
            if ((types & 2) != 0) {
                result.append("navigationBars ");
            }
            if ((types & 4) != 0) {
                result.append("captionBar ");
            }
            if ((types & 8) != 0) {
                result.append("ime ");
            }
            if ((types & 0x10) != 0) {
                result.append("systemGestures ");
            }
            if ((types & 0x20) != 0) {
                result.append("mandatorySystemGestures ");
            }
            if ((types & 0x40) != 0) {
                result.append("tappableElement ");
            }
            if ((types & 0x80) != 0) {
                result.append("displayCutout ");
            }
            if ((types & 0x100) != 0) {
                result.append("windowDecor ");
            }
            if ((types & 0x200) != 0) {
                result.append("systemOverlays ");
            }
            if (result.length() > 0) {
                result.delete(result.length() - 1, result.length());
            }
            return result.toString();
        }

        private Type() {
        }

        public static int statusBars() {
            return 1;
        }

        public static int navigationBars() {
            return 2;
        }

        public static int captionBar() {
            return 4;
        }

        public static int ime() {
            return 8;
        }

        public static int systemGestures() {
            return 16;
        }

        public static int mandatorySystemGestures() {
            return 32;
        }

        public static int tappableElement() {
            return 64;
        }

        public static int displayCutout() {
            return 128;
        }

        public static int systemOverlays() {
            return 512;
        }

        public static int systemBars() {
            return 519;
        }

        public static int defaultVisible() {
            return -9;
        }

        public static int all() {
            return -1;
        }

        public static boolean hasCompatSystemBars(int types) {
            return (types & 3) != 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InsetsType {
        }
    }

    public static class Builder {
        private final Insets[] mTypeInsetsMap;
        private final Insets[] mTypeMaxInsetsMap;
        private final boolean[] mTypeVisibilityMap;
        private final Rect[][] mTypeBoundingRectsMap;
        private final Rect[][] mTypeMaxBoundingRectsMap;
        private boolean mSystemInsetsConsumed = true;
        private boolean mStableInsetsConsumed = true;
        private DisplayCutout mDisplayCutout;
        private RoundedCorners mRoundedCorners = RoundedCorners.NO_ROUNDED_CORNERS;
        private DisplayShape mDisplayShape = DisplayShape.NONE;
        private boolean mIsRound;
        private int mForceConsumingTypes;
        private boolean mForceConsumingOpaqueCaptionBar;
        private int mSuppressScrimTypes;
        private PrivacyIndicatorBounds mPrivacyIndicatorBounds = new PrivacyIndicatorBounds();
        private int mFrameWidth;
        private int mFrameHeight;

        public Builder() {
            this.mTypeInsetsMap = new Insets[10];
            this.mTypeMaxInsetsMap = new Insets[10];
            this.mTypeVisibilityMap = new boolean[10];
            this.mTypeBoundingRectsMap = new Rect[10][];
            this.mTypeMaxBoundingRectsMap = new Rect[10][];
        }

        public Builder(@NonNull WindowInsets insets) {
            this.mTypeInsetsMap = (Insets[])insets.mTypeInsetsMap.clone();
            this.mTypeMaxInsetsMap = (Insets[])insets.mTypeMaxInsetsMap.clone();
            this.mTypeVisibilityMap = (boolean[])insets.mTypeVisibilityMap.clone();
            this.mSystemInsetsConsumed = insets.mSystemWindowInsetsConsumed;
            this.mStableInsetsConsumed = insets.mStableInsetsConsumed;
            this.mDisplayCutout = WindowInsets.displayCutoutCopyConstructorArgument(insets);
            this.mRoundedCorners = insets.mRoundedCorners;
            this.mIsRound = insets.mIsRound;
            this.mForceConsumingTypes = insets.mForceConsumingTypes;
            this.mForceConsumingOpaqueCaptionBar = insets.mForceConsumingOpaqueCaptionBar;
            this.mSuppressScrimTypes = insets.mSuppressScrimTypes;
            this.mPrivacyIndicatorBounds = insets.mPrivacyIndicatorBounds;
            this.mDisplayShape = insets.mDisplayShape;
            this.mTypeBoundingRectsMap = (Rect[][])insets.mTypeBoundingRectsMap.clone();
            this.mTypeMaxBoundingRectsMap = (Rect[][])insets.mTypeMaxBoundingRectsMap.clone();
            this.mFrameWidth = insets.mFrameWidth;
            this.mFrameHeight = insets.mFrameHeight;
        }

        @Deprecated
        @NonNull
        public Builder setSystemWindowInsets(@NonNull Insets systemWindowInsets) {
            Preconditions.checkNotNull(systemWindowInsets);
            WindowInsets.assignCompatInsets(this.mTypeInsetsMap, systemWindowInsets.toRect());
            this.mSystemInsetsConsumed = false;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setSystemGestureInsets(@NonNull Insets insets) {
            WindowInsets.setInsets(this.mTypeInsetsMap, 16, insets);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setMandatorySystemGestureInsets(@NonNull Insets insets) {
            WindowInsets.setInsets(this.mTypeInsetsMap, 32, insets);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setTappableElementInsets(@NonNull Insets insets) {
            WindowInsets.setInsets(this.mTypeInsetsMap, 64, insets);
            return this;
        }

        @NonNull
        public Builder setInsets(int typeMask, @NonNull Insets insets) {
            Preconditions.checkNotNull(insets);
            WindowInsets.setInsets(this.mTypeInsetsMap, typeMask, insets);
            this.mSystemInsetsConsumed = false;
            return this;
        }

        @NonNull
        public Builder setInsetsIgnoringVisibility(int typeMask, @NonNull Insets insets) throws IllegalArgumentException {
            if (typeMask == 8) {
                throw new IllegalArgumentException("Maximum inset not available for IME");
            }
            Preconditions.checkNotNull(insets);
            WindowInsets.setInsets(this.mTypeMaxInsetsMap, typeMask, insets);
            this.mStableInsetsConsumed = false;
            return this;
        }

        @NonNull
        public Builder setVisible(int typeMask, boolean visible) {
            for (int i = 1; i <= 512; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.mTypeVisibilityMap[Type.indexOf((int)i)] = visible;
            }
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setStableInsets(@NonNull Insets stableInsets) {
            Preconditions.checkNotNull(stableInsets);
            WindowInsets.assignCompatInsets(this.mTypeMaxInsetsMap, stableInsets.toRect());
            this.mStableInsetsConsumed = false;
            return this;
        }

        @NonNull
        public Builder setDisplayCutout(@Nullable DisplayCutout displayCutout) {
            DisplayCutout displayCutout2 = this.mDisplayCutout = displayCutout != null ? displayCutout : DisplayCutout.NO_CUTOUT;
            if (!this.mDisplayCutout.isEmpty()) {
                Insets safeInsets = Insets.of(this.mDisplayCutout.getSafeInsets());
                int index = Type.indexOf(128);
                this.mTypeInsetsMap[index] = safeInsets;
                this.mTypeMaxInsetsMap[index] = safeInsets;
                this.mTypeVisibilityMap[index] = true;
            }
            return this;
        }

        @NonNull
        public Builder setRoundedCorners(RoundedCorners roundedCorners) {
            this.mRoundedCorners = roundedCorners != null ? roundedCorners : RoundedCorners.NO_ROUNDED_CORNERS;
            return this;
        }

        @NonNull
        public Builder setRoundedCorner(int position, @Nullable RoundedCorner roundedCorner) {
            this.mRoundedCorners.setRoundedCorner(position, roundedCorner);
            return this;
        }

        @NonNull
        public Builder setPrivacyIndicatorBounds(@Nullable PrivacyIndicatorBounds bounds) {
            this.mPrivacyIndicatorBounds = bounds;
            return this;
        }

        @NonNull
        public Builder setPrivacyIndicatorBounds(@Nullable Rect bounds) {
            Rect[] boundsArr = new Rect[]{bounds, bounds, bounds, bounds};
            this.mPrivacyIndicatorBounds = new PrivacyIndicatorBounds(boundsArr, 0);
            return this;
        }

        @NonNull
        public Builder setDisplayShape(@NonNull DisplayShape displayShape) {
            this.mDisplayShape = displayShape;
            return this;
        }

        @NonNull
        public Builder setRound(boolean round) {
            this.mIsRound = round;
            return this;
        }

        @NonNull
        public Builder setAlwaysConsumeSystemBars(boolean alwaysConsumeSystemBars) {
            return this;
        }

        @NonNull
        public Builder setForceConsumingTypes(int forceConsumingTypes) {
            this.mForceConsumingTypes = forceConsumingTypes;
            return this;
        }

        @NonNull
        public Builder setForceConsumingOpaqueCaptionBar(boolean forceConsumingOpaqueCaptionBar) {
            this.mForceConsumingOpaqueCaptionBar = forceConsumingOpaqueCaptionBar;
            return this;
        }

        @NonNull
        public Builder setSuppressScrimTypes(int suppressScrimTypes) {
            this.mSuppressScrimTypes = suppressScrimTypes;
            return this;
        }

        @FlaggedApi(value="android.view.flags.customizable_window_headers")
        @NonNull
        public Builder setBoundingRects(int typeMask, @NonNull List<Rect> rects) {
            for (int i = 1; i <= 512; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.mTypeBoundingRectsMap[Type.indexOf((int)i)] = rects.toArray(new Rect[0]);
            }
            this.mSystemInsetsConsumed = false;
            return this;
        }

        @FlaggedApi(value="android.view.flags.customizable_window_headers")
        @NonNull
        public Builder setBoundingRectsIgnoringVisibility(int typeMask, @NonNull List<Rect> rects) {
            if (typeMask == 8) {
                throw new IllegalArgumentException("Maximum bounding rects not available for IME");
            }
            for (int i = 1; i <= 512; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.mTypeMaxBoundingRectsMap[Type.indexOf((int)i)] = rects.toArray(new Rect[0]);
            }
            this.mStableInsetsConsumed = false;
            return this;
        }

        @FlaggedApi(value="android.view.flags.customizable_window_headers")
        @NonNull
        public Builder setFrame(int width, int height) {
            this.mFrameWidth = width;
            this.mFrameHeight = height;
            return this;
        }

        @NonNull
        public WindowInsets build() {
            return new WindowInsets(this.mSystemInsetsConsumed ? null : this.mTypeInsetsMap, this.mStableInsetsConsumed ? null : this.mTypeMaxInsetsMap, this.mTypeVisibilityMap, this.mIsRound, this.mForceConsumingTypes, this.mForceConsumingOpaqueCaptionBar, this.mSuppressScrimTypes, this.mDisplayCutout, this.mRoundedCorners, this.mPrivacyIndicatorBounds, this.mDisplayShape, Type.systemBars(), false, this.mSystemInsetsConsumed ? null : this.mTypeBoundingRectsMap, this.mStableInsetsConsumed ? null : this.mTypeMaxBoundingRectsMap, this.mFrameWidth, this.mFrameHeight);
        }
    }

    public static class Side {
        public static final int LEFT = 1;
        public static final int TOP = 2;
        public static final int RIGHT = 4;
        public static final int BOTTOM = 8;

        private Side() {
        }

        public static int all() {
            return 15;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface InsetsSide {
        }
    }
}

