/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.hardware.input.InputManagerGlobal;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.DisplayMetrics;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.IWindowManager;
import android.view.InputDevice;
import android.view.WindowManagerGlobal;
import android.view.flags.Flags;
import com.android.internal.annotations.VisibleForTesting;

public class ViewConfiguration {
    private static final int SCROLL_BAR_SIZE = 4;
    private static final int SCROLL_BAR_FADE_DURATION = 250;
    private static final int SCROLL_BAR_DEFAULT_DELAY = 300;
    private static final int FADING_EDGE_LENGTH = 12;
    private static final int PRESSED_STATE_DURATION = 64;
    public static final int DEFAULT_LONG_PRESS_TIMEOUT = 400;
    private static final int DEFAULT_MULTI_PRESS_TIMEOUT = 300;
    private static final int DEFAULT_KEY_REPEAT_TIMEOUT_MS = 400;
    private static final int DEFAULT_KEY_REPEAT_DELAY_MS = 50;
    private static final int GLOBAL_ACTIONS_KEY_TIMEOUT = 500;
    private static final int SCREENSHOT_CHORD_KEY_TIMEOUT = 0;
    private static final int A11Y_SHORTCUT_KEY_TIMEOUT = 3000;
    private static final int A11Y_SHORTCUT_KEY_TIMEOUT_AFTER_CONFIRMATION = 1000;
    private static final int TAP_TIMEOUT = 100;
    private static final int JUMP_TAP_TIMEOUT = 500;
    private static final int DOUBLE_TAP_TIMEOUT = 300;
    private static final int DOUBLE_TAP_MIN_TIME = 40;
    private static final int HOVER_TAP_TIMEOUT = 150;
    private static final int HOVER_TAP_SLOP = 20;
    private static final int ZOOM_CONTROLS_TIMEOUT = 3000;
    private static final int EDGE_SLOP = 12;
    private static final int TOUCH_SLOP = 8;
    private static final int HANDWRITING_SLOP = 2;
    private static final int MIN_SCROLLBAR_TOUCH_TARGET = 48;
    private static final int DOUBLE_TAP_TOUCH_SLOP = 8;
    private static final int PAGING_TOUCH_SLOP = 16;
    private static final int DOUBLE_TAP_SLOP = 100;
    private static final int WINDOW_TOUCH_SLOP = 16;
    private static final int HANDWRITING_GESTURE_LINE_MARGIN = 16;
    private static final int MINIMUM_FLING_VELOCITY = 50;
    private static final int MAXIMUM_FLING_VELOCITY = 8000;
    private static final int NO_FLING_MIN_VELOCITY = Integer.MAX_VALUE;
    private static final int NO_FLING_MAX_VELOCITY = Integer.MIN_VALUE;
    public static final int NO_HAPTIC_SCROLL_TICK_INTERVAL = Integer.MAX_VALUE;
    private static final long SEND_RECURRING_ACCESSIBILITY_EVENTS_INTERVAL_MILLIS = 100L;
    @Deprecated
    private static final int MAXIMUM_DRAWING_CACHE_SIZE = 0x177000;
    @UnsupportedAppUsage
    private static final float SCROLL_FRICTION = 0.015f;
    private static final int OVERSCROLL_DISTANCE = 0;
    private static final int OVERFLING_DISTANCE = 6;
    private static final float HORIZONTAL_SCROLL_FACTOR = 64.0f;
    private static final float VERTICAL_SCROLL_FACTOR = 64.0f;
    private static final long ACTION_MODE_HIDE_DURATION_DEFAULT = 2000L;
    private static final int LONG_PRESS_TOOLTIP_HIDE_TIMEOUT = 1500;
    private static final int HOVER_TOOLTIP_SHOW_TIMEOUT = 500;
    private static final int HOVER_TOOLTIP_HIDE_TIMEOUT = 15000;
    private static final int HOVER_TOOLTIP_HIDE_SHORT_TIMEOUT = 3000;
    private static final int HAS_PERMANENT_MENU_KEY_AUTODETECT = 0;
    private static final int HAS_PERMANENT_MENU_KEY_TRUE = 1;
    private static final int HAS_PERMANENT_MENU_KEY_FALSE = 2;
    private static final float AMBIGUOUS_GESTURE_MULTIPLIER = 2.0f;
    private static final int SMART_SELECTION_INITIALIZED_TIMEOUT_IN_MILLISECOND = 200;
    private static final int SMART_SELECTION_INITIALIZING_TIMEOUT_IN_MILLISECOND = 500;
    private static ResourceCache sResourceCache = new ResourceCache();
    private final boolean mConstructedWithContext;
    private final int mEdgeSlop;
    private final int mFadingEdgeLength;
    private final int mMinimumFlingVelocity;
    private final int mMaximumFlingVelocity;
    private final int mMinimumRotaryEncoderFlingVelocity;
    private final int mMaximumRotaryEncoderFlingVelocity;
    private final int mRotaryEncoderHapticScrollFeedbackTickIntervalPixels;
    private final boolean mRotaryEncoderHapticScrollFeedbackEnabled;
    private final int mScrollbarSize;
    private final int mTouchSlop;
    private final int mHandwritingSlop;
    private final int mMinScalingSpan;
    private final int mHoverSlop;
    private final int mMinScrollbarTouchTarget;
    private final int mDoubleTapTouchSlop;
    private final int mPagingTouchSlop;
    private final int mDoubleTapSlop;
    private final int mWindowTouchSlop;
    private final int mHandwritingGestureLineMargin;
    private final float mAmbiguousGestureMultiplier;
    private final int mMaximumDrawingCacheSize;
    private final int mOverscrollDistance;
    private final int mOverflingDistance;
    private final boolean mViewTouchScreenHapticScrollFeedbackEnabled;
    private final boolean mFadingMarqueeEnabled;
    private final long mGlobalActionsKeyTimeout;
    private final float mVerticalScrollFactor;
    private final float mHorizontalScrollFactor;
    private final boolean mShowMenuShortcutsWhenKeyboardPresent;
    private final long mScreenshotChordKeyTimeout;
    private final int mSmartSelectionInitializedTimeout;
    private final int mSmartSelectionInitializingTimeout;
    private final boolean mPreferKeepClearForFocusEnabled;
    private final boolean mViewBasedRotaryEncoderScrollHapticsEnabledConfig;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123768915L)
    private boolean sHasPermanentMenuKey;
    @UnsupportedAppUsage
    private boolean sHasPermanentMenuKeySet;
    @UnsupportedAppUsage
    static final SparseArray<ViewConfiguration> sConfigurations = new SparseArray(2);

    @Deprecated
    public ViewConfiguration() {
        this.mConstructedWithContext = false;
        this.mEdgeSlop = 12;
        this.mFadingEdgeLength = 12;
        this.mMinimumFlingVelocity = 50;
        this.mMaximumFlingVelocity = 8000;
        this.mMinimumRotaryEncoderFlingVelocity = 50;
        this.mMaximumRotaryEncoderFlingVelocity = 8000;
        this.mRotaryEncoderHapticScrollFeedbackEnabled = false;
        this.mRotaryEncoderHapticScrollFeedbackTickIntervalPixels = Integer.MAX_VALUE;
        this.mViewBasedRotaryEncoderScrollHapticsEnabledConfig = false;
        this.mScrollbarSize = 4;
        this.mTouchSlop = 8;
        this.mHandwritingSlop = 2;
        this.mHoverSlop = 4;
        this.mMinScrollbarTouchTarget = 48;
        this.mDoubleTapTouchSlop = 8;
        this.mPagingTouchSlop = 16;
        this.mDoubleTapSlop = 100;
        this.mWindowTouchSlop = 16;
        this.mHandwritingGestureLineMargin = 16;
        this.mAmbiguousGestureMultiplier = 2.0f;
        this.mMaximumDrawingCacheSize = 0x177000;
        this.mOverscrollDistance = 0;
        this.mOverflingDistance = 6;
        this.mFadingMarqueeEnabled = true;
        this.mGlobalActionsKeyTimeout = 500L;
        this.mHorizontalScrollFactor = 64.0f;
        this.mVerticalScrollFactor = 64.0f;
        this.mShowMenuShortcutsWhenKeyboardPresent = false;
        this.mScreenshotChordKeyTimeout = 0L;
        this.mMinScalingSpan = 0;
        this.mSmartSelectionInitializedTimeout = 200;
        this.mSmartSelectionInitializingTimeout = 500;
        this.mPreferKeepClearForFocusEnabled = false;
        this.mViewTouchScreenHapticScrollFeedbackEnabled = false;
    }

    private ViewConfiguration(@NonNull Context context) {
        this.mConstructedWithContext = true;
        Resources res = context.getResources();
        DisplayMetrics metrics = res.getDisplayMetrics();
        Configuration config = res.getConfiguration();
        float density = metrics.density;
        float sizeAndDensity = config.isLayoutSizeAtLeast(4) ? density * 1.5f : density;
        this.mEdgeSlop = (int)(sizeAndDensity * 12.0f + 0.5f);
        this.mFadingEdgeLength = (int)(sizeAndDensity * 12.0f + 0.5f);
        this.mScrollbarSize = res.getDimensionPixelSize(17105172);
        this.mDoubleTapSlop = (int)(sizeAndDensity * 100.0f + 0.5f);
        this.mWindowTouchSlop = (int)(sizeAndDensity * 16.0f + 0.5f);
        TypedValue multiplierValue = new TypedValue();
        res.getValue(17105112, multiplierValue, true);
        this.mAmbiguousGestureMultiplier = Math.max(1.0f, multiplierValue.getFloat());
        Rect maxBounds = config.windowConfiguration.getMaxBounds();
        this.mMaximumDrawingCacheSize = 4 * maxBounds.width() * maxBounds.height();
        this.mOverscrollDistance = (int)(sizeAndDensity * 0.0f + 0.5f);
        this.mOverflingDistance = (int)(sizeAndDensity * 6.0f + 0.5f);
        if (!this.sHasPermanentMenuKeySet) {
            int configVal = res.getInteger(17694972);
            switch (configVal) {
                default: {
                    IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
                    try {
                        this.sHasPermanentMenuKey = !wm.hasNavigationBar(context.getDisplayId());
                        this.sHasPermanentMenuKeySet = true;
                    }
                    catch (RemoteException ex) {
                        this.sHasPermanentMenuKey = false;
                    }
                    break;
                }
                case 1: {
                    this.sHasPermanentMenuKey = true;
                    this.sHasPermanentMenuKeySet = true;
                    break;
                }
                case 2: {
                    this.sHasPermanentMenuKey = false;
                    this.sHasPermanentMenuKeySet = true;
                }
            }
        }
        this.mFadingMarqueeEnabled = res.getBoolean(17891969);
        this.mTouchSlop = res.getDimensionPixelSize(17105178);
        this.mHandwritingSlop = res.getDimensionPixelSize(17105176);
        this.mHoverSlop = res.getDimensionPixelSize(17105177);
        this.mMinScrollbarTouchTarget = res.getDimensionPixelSize(17105151);
        this.mPagingTouchSlop = this.mTouchSlop * 2;
        this.mDoubleTapTouchSlop = this.mTouchSlop;
        this.mHandwritingGestureLineMargin = res.getDimensionPixelSize(17104906);
        this.mMinimumFlingVelocity = res.getDimensionPixelSize(17105181);
        this.mMaximumFlingVelocity = res.getDimensionPixelSize(17105179);
        int configMinRotaryEncoderFlingVelocity = res.getDimensionPixelSize(17105182);
        int configMaxRotaryEncoderFlingVelocity = res.getDimensionPixelSize(17105180);
        if (configMinRotaryEncoderFlingVelocity < 0 || configMaxRotaryEncoderFlingVelocity < 0) {
            this.mMinimumRotaryEncoderFlingVelocity = Integer.MAX_VALUE;
            this.mMaximumRotaryEncoderFlingVelocity = Integer.MIN_VALUE;
        } else {
            this.mMinimumRotaryEncoderFlingVelocity = configMinRotaryEncoderFlingVelocity;
            this.mMaximumRotaryEncoderFlingVelocity = configMaxRotaryEncoderFlingVelocity;
        }
        int configRotaryEncoderHapticScrollFeedbackTickIntervalPixels = res.getDimensionPixelSize(17105162);
        this.mRotaryEncoderHapticScrollFeedbackTickIntervalPixels = configRotaryEncoderHapticScrollFeedbackTickIntervalPixels > 0 ? configRotaryEncoderHapticScrollFeedbackTickIntervalPixels : Integer.MAX_VALUE;
        this.mRotaryEncoderHapticScrollFeedbackEnabled = res.getBoolean(17891998);
        this.mGlobalActionsKeyTimeout = res.getInteger(17694882);
        this.mHorizontalScrollFactor = res.getDimensionPixelSize(17105132);
        this.mVerticalScrollFactor = res.getDimensionPixelSize(17105175);
        this.mShowMenuShortcutsWhenKeyboardPresent = res.getBoolean(17891899);
        this.mMinScalingSpan = res.getDimensionPixelSize(17105149);
        this.mScreenshotChordKeyTimeout = res.getInteger(17695025);
        this.mSmartSelectionInitializedTimeout = res.getInteger(17695040);
        this.mSmartSelectionInitializingTimeout = res.getInteger(17695041);
        this.mPreferKeepClearForFocusEnabled = res.getBoolean(0x1110212);
        this.mViewBasedRotaryEncoderScrollHapticsEnabledConfig = res.getBoolean(17891997);
        this.mViewTouchScreenHapticScrollFeedbackEnabled = Flags.enableScrollFeedbackForTouch() ? res.getBoolean(17891999) : false;
    }

    public static ViewConfiguration get(@NonNull Context context) {
        StrictMode.assertConfigurationContext(context, "ViewConfiguration");
        int density = ViewConfiguration.getDisplayDensity(context);
        ViewConfiguration configuration = sConfigurations.get(density);
        if (configuration == null) {
            configuration = new ViewConfiguration(context);
            sConfigurations.put(density, configuration);
        }
        return configuration;
    }

    @VisibleForTesting
    public static void resetCacheForTesting() {
        sConfigurations.clear();
        sResourceCache = new ResourceCache();
    }

    @VisibleForTesting
    public static void setInstanceForTesting(Context context, ViewConfiguration instance) {
        sConfigurations.put(ViewConfiguration.getDisplayDensity(context), instance);
    }

    @Deprecated
    public static int getScrollBarSize() {
        return 4;
    }

    public int getScaledScrollBarSize() {
        return this.mScrollbarSize;
    }

    public int getScaledMinScrollbarTouchTarget() {
        return this.mMinScrollbarTouchTarget;
    }

    public static int getScrollBarFadeDuration() {
        return 250;
    }

    public static int getScrollDefaultDelay() {
        return 300;
    }

    @Deprecated
    public static int getFadingEdgeLength() {
        return 12;
    }

    public int getScaledFadingEdgeLength() {
        return this.mFadingEdgeLength;
    }

    public static int getPressedStateDuration() {
        return sResourceCache.getPressedStateDuration();
    }

    public static int getLongPressTimeout() {
        return AppGlobals.getIntCoreSetting("long_press_timeout", 400);
    }

    public static int getMultiPressTimeout() {
        return AppGlobals.getIntCoreSetting("multi_press_timeout", 300);
    }

    public static int getKeyRepeatTimeout() {
        return AppGlobals.getIntCoreSetting("key_repeat_timeout", 400);
    }

    public static int getKeyRepeatDelay() {
        return AppGlobals.getIntCoreSetting("key_repeat_delay", 50);
    }

    public static int getTapTimeout() {
        return sResourceCache.getTapTimeout();
    }

    public static int getJumpTapTimeout() {
        return sResourceCache.getJumpTapTimeout();
    }

    public static int getDoubleTapTimeout() {
        return sResourceCache.getDoubleTapTimeout();
    }

    @UnsupportedAppUsage
    public static int getDoubleTapMinTime() {
        return sResourceCache.getDoubleTapMinTime();
    }

    public static int getHoverTapTimeout() {
        return sResourceCache.getHoverTapTimeout();
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static int getHoverTapSlop() {
        return sResourceCache.getHoverTapSlop();
    }

    @Deprecated
    public static int getEdgeSlop() {
        return 12;
    }

    public int getScaledEdgeSlop() {
        return this.mEdgeSlop;
    }

    @Deprecated
    public static int getTouchSlop() {
        return 8;
    }

    public int getScaledTouchSlop() {
        return this.mTouchSlop;
    }

    public int getScaledHandwritingSlop() {
        return this.mHandwritingSlop;
    }

    public int getScaledHoverSlop() {
        return this.mHoverSlop;
    }

    @UnsupportedAppUsage
    public int getScaledDoubleTapTouchSlop() {
        return this.mDoubleTapTouchSlop;
    }

    public int getScaledPagingTouchSlop() {
        return this.mPagingTouchSlop;
    }

    @Deprecated
    @UnsupportedAppUsage
    public static int getDoubleTapSlop() {
        return 100;
    }

    public int getScaledDoubleTapSlop() {
        return this.mDoubleTapSlop;
    }

    public int getScaledHandwritingGestureLineMargin() {
        return this.mHandwritingGestureLineMargin;
    }

    public static long getSendRecurringAccessibilityEventsInterval() {
        return 100L;
    }

    @Deprecated
    public static int getWindowTouchSlop() {
        return 16;
    }

    public int getScaledWindowTouchSlop() {
        return this.mWindowTouchSlop;
    }

    @Deprecated
    public static int getMinimumFlingVelocity() {
        return 50;
    }

    public int getScaledMinimumFlingVelocity() {
        return this.mMinimumFlingVelocity;
    }

    @Deprecated
    public static int getMaximumFlingVelocity() {
        return 8000;
    }

    public int getScaledMaximumFlingVelocity() {
        return this.mMaximumFlingVelocity;
    }

    public int getScaledScrollFactor() {
        return (int)this.mVerticalScrollFactor;
    }

    public float getScaledHorizontalScrollFactor() {
        return this.mHorizontalScrollFactor;
    }

    public float getScaledVerticalScrollFactor() {
        return this.mVerticalScrollFactor;
    }

    @Deprecated
    public static int getMaximumDrawingCacheSize() {
        return 0x177000;
    }

    public int getScaledMaximumDrawingCacheSize() {
        return this.mMaximumDrawingCacheSize;
    }

    public int getScaledOverscrollDistance() {
        return this.mOverscrollDistance;
    }

    public int getScaledOverflingDistance() {
        return this.mOverflingDistance;
    }

    public static long getZoomControlsTimeout() {
        return sResourceCache.getZoomControlsTimeout();
    }

    @Deprecated
    public static long getGlobalActionKeyTimeout() {
        return 500L;
    }

    public long getDeviceGlobalActionKeyTimeout() {
        return this.mGlobalActionsKeyTimeout;
    }

    public long getScreenshotChordKeyTimeout() {
        return this.mScreenshotChordKeyTimeout;
    }

    public long getAccessibilityShortcutKeyTimeout() {
        return 3000L;
    }

    public long getAccessibilityShortcutKeyTimeoutAfterConfirmation() {
        return 1000L;
    }

    public static float getScrollFriction() {
        return sResourceCache.getScrollFriction();
    }

    public static long getDefaultActionModeHideDuration() {
        return sResourceCache.getDefaultActionModeHideDuration();
    }

    @Deprecated
    public static float getAmbiguousGestureMultiplier() {
        return 2.0f;
    }

    public float getScaledAmbiguousGestureMultiplier() {
        return this.mAmbiguousGestureMultiplier;
    }

    public boolean hasPermanentMenuKey() {
        return this.sHasPermanentMenuKey;
    }

    public int getScaledMinimumFlingVelocity(int inputDeviceId, int axis, int source) {
        if (!ViewConfiguration.isInputDeviceInfoValid(inputDeviceId, axis, source)) {
            return Integer.MAX_VALUE;
        }
        if (source == 0x400000) {
            return this.mMinimumRotaryEncoderFlingVelocity;
        }
        return this.mMinimumFlingVelocity;
    }

    public int getScaledMaximumFlingVelocity(int inputDeviceId, int axis, int source) {
        if (!ViewConfiguration.isInputDeviceInfoValid(inputDeviceId, axis, source)) {
            return Integer.MIN_VALUE;
        }
        if (source == 0x400000) {
            return this.mMaximumRotaryEncoderFlingVelocity;
        }
        return this.mMaximumFlingVelocity;
    }

    public boolean isHapticScrollFeedbackEnabled(int inputDeviceId, int axis, int source) {
        if (!ViewConfiguration.isInputDeviceInfoValid(inputDeviceId, axis, source)) {
            return false;
        }
        if (source == 0x400000 && axis == 26) {
            return this.mRotaryEncoderHapticScrollFeedbackEnabled;
        }
        if ((source & 0x1002) != 0) {
            return this.mViewTouchScreenHapticScrollFeedbackEnabled;
        }
        return false;
    }

    public int getHapticScrollFeedbackTickInterval(int inputDeviceId, int axis, int source) {
        if (!this.mRotaryEncoderHapticScrollFeedbackEnabled) {
            return Integer.MAX_VALUE;
        }
        if (!ViewConfiguration.isInputDeviceInfoValid(inputDeviceId, axis, source)) {
            return Integer.MAX_VALUE;
        }
        if (source == 0x400000 && axis == 26) {
            return this.mRotaryEncoderHapticScrollFeedbackTickIntervalPixels;
        }
        return Integer.MAX_VALUE;
    }

    public boolean isViewBasedRotaryEncoderHapticScrollFeedbackEnabled() {
        return this.mViewBasedRotaryEncoderScrollHapticsEnabledConfig && Flags.useViewBasedRotaryEncoderScrollHaptics();
    }

    private static boolean isInputDeviceInfoValid(int id2, int axis, int source) {
        InputDevice device = InputManagerGlobal.getInstance().getInputDevice(id2);
        return device != null && device.getMotionRange(axis, source) != null;
    }

    public boolean shouldShowMenuShortcutsWhenKeyboardPresent() {
        return this.mShowMenuShortcutsWhenKeyboardPresent;
    }

    public int getScaledMinimumScalingSpan() {
        if (!this.mConstructedWithContext) {
            throw new IllegalStateException("Min scaling span cannot be determined when this method is called on a ViewConfiguration that was instantiated using a constructor with no Context parameter");
        }
        return this.mMinScalingSpan;
    }

    @UnsupportedAppUsage
    public boolean isFadingMarqueeEnabled() {
        return this.mFadingMarqueeEnabled;
    }

    public int getSmartSelectionInitializedTimeout() {
        return this.mSmartSelectionInitializedTimeout;
    }

    public int getSmartSelectionInitializingTimeout() {
        return this.mSmartSelectionInitializingTimeout;
    }

    public boolean isPreferKeepClearForFocusEnabled() {
        return this.mPreferKeepClearForFocusEnabled;
    }

    public static int getLongPressTooltipHideTimeout() {
        return 1500;
    }

    public static int getHoverTooltipShowTimeout() {
        return 500;
    }

    public static int getHoverTooltipHideTimeout() {
        return 15000;
    }

    public static int getHoverTooltipHideShortTimeout() {
        return 3000;
    }

    private static int getDisplayDensity(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return (int)(100.0f * metrics.density);
    }

    private static class ResourceCache {
        private int mPressedStateDuration = -1;
        private int mTapTimeout = -1;
        private int mJumpTapTimeout = -1;
        private int mDoubleTapTimeout = -1;
        private int mDoubleTapMinTime = -1;
        private int mHoverTapTimeout = -1;
        private int mHoverTapSlop = -1;
        private long mZoomControlsTimeout = -1L;
        private float mScrollFriction = -1.0f;
        private long mDefaultActionModeHideDuration = -1L;

        private ResourceCache() {
        }

        public int getPressedStateDuration() {
            if (this.mPressedStateDuration < 0) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mPressedStateDuration = resources != null ? resources.getInteger(17694985) : 64;
            }
            return this.mPressedStateDuration;
        }

        public int getTapTimeout() {
            if (this.mTapTimeout < 0) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mTapTimeout = resources != null ? resources.getInteger(17695047) : 100;
            }
            return this.mTapTimeout;
        }

        public int getJumpTapTimeout() {
            if (this.mJumpTapTimeout < 0) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mJumpTapTimeout = resources != null ? resources.getInteger(17694892) : 500;
            }
            return this.mJumpTapTimeout;
        }

        public int getDoubleTapTimeout() {
            if (this.mDoubleTapTimeout < 0) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mDoubleTapTimeout = resources != null ? resources.getInteger(17694858) : 300;
            }
            return this.mDoubleTapTimeout;
        }

        public int getDoubleTapMinTime() {
            if (this.mDoubleTapMinTime < 0) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mDoubleTapMinTime = resources != null ? resources.getInteger(17694854) : 40;
            }
            return this.mDoubleTapMinTime;
        }

        public int getHoverTapTimeout() {
            if (this.mHoverTapTimeout < 0) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mHoverTapTimeout = resources != null ? resources.getInteger(17694884) : 150;
            }
            return this.mHoverTapTimeout;
        }

        public int getHoverTapSlop() {
            if (this.mHoverTapSlop < 0) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mHoverTapSlop = resources != null ? resources.getDimensionPixelSize(17105133) : 20;
            }
            return this.mHoverTapSlop;
        }

        public long getZoomControlsTimeout() {
            if (this.mZoomControlsTimeout < 0L) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mZoomControlsTimeout = resources != null ? (long)resources.getInteger(17695077) : 3000L;
            }
            return this.mZoomControlsTimeout;
        }

        public float getScrollFriction() {
            if (this.mScrollFriction < 0.0f) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mScrollFriction = resources != null ? resources.getFloat(17105171) : 0.015f;
            }
            return this.mScrollFriction;
        }

        public long getDefaultActionModeHideDuration() {
            if (this.mDefaultActionModeHideDuration < 0L) {
                Resources resources = ResourceCache.getCurrentResources();
                this.mDefaultActionModeHideDuration = resources != null ? (long)resources.getInteger(17694801) : 2000L;
            }
            return this.mDefaultActionModeHideDuration;
        }

        private static Resources getCurrentResources() {
            if (!com.android.internal.hidden_from_bootclasspath.android.companion.virtualdevice.flags.Flags.migrateViewconfigurationConstantsToResources()) {
                return null;
            }
            Application application = ActivityThread.currentApplication();
            Context context = application != null ? application.getApplicationContext() : null;
            return context != null ? context.getResources() : null;
        }
    }
}

