/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.gui.BorderSettings;
import android.gui.DropInputMode;
import android.gui.StalledTransactionInfo;
import android.gui.TrustedOverlay;
import android.hardware.DisplayLuts;
import android.hardware.HardwareBuffer;
import android.hardware.OverlayProperties;
import android.hardware.SyncFence;
import android.hardware.display.DeviceProductInfo;
import android.hardware.display.DisplayedContentSample;
import android.hardware.display.DisplayedContentSamplingAttributes;
import android.hardware.graphics.common.DisplayDecorationSupport;
import android.media.quality.PictureProfileHandle;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os._Original_Build;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import android.view.Choreographer;
import android.view.Display;
import android.view.FrameRateCategoryRate;
import android.view.InputWindowHandle;
import android.view.Surface;
import android.view.SurfaceControlRegistry;
import android.view.SurfaceControl_Delegate;
import android.view.SurfaceSession;
import android.view.View;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import com.android.graphics.surfaceflinger.flags.Flags;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import libcore.util.NativeAllocationRegistry;

public class SurfaceControl
implements Parcelable {
    private static final String TAG = "SurfaceControl";
    public static final int BUFFER_TRANSFORM_IDENTITY = 0;
    public static final int BUFFER_TRANSFORM_MIRROR_HORIZONTAL = 1;
    public static final int BUFFER_TRANSFORM_MIRROR_VERTICAL = 2;
    public static final int BUFFER_TRANSFORM_ROTATE_90 = 4;
    public static final int BUFFER_TRANSFORM_ROTATE_180 = 3;
    public static final int BUFFER_TRANSFORM_ROTATE_270 = 7;
    @Nullable
    @GuardedBy(value={"mLock"})
    private ArrayList<OnReparentListener> mReparentListeners;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private String mName;
    private String mCallsite;
    public long mNativeObject;
    private long mNativeHandle;
    private final Object mChoreographerLock = new Object();
    @GuardedBy(value={"mChoreographerLock"})
    private Choreographer mChoreographer;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private int mWidth;
    @GuardedBy(value={"mLock"})
    private int mHeight;
    private TrustedPresentationCallback mTrustedPresentationCallback;
    private WeakReference<View> mLocalOwnerView;
    private Throwable mReleaseStack = null;
    private static volatile boolean sDebugUsageAfterRelease = false;
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(SurfaceControl.class.getClassLoader(), SurfaceControl.nativeGetNativeSurfaceControlFinalizer());
    private Runnable mFreeNativeResources;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public static final int HIDDEN = 4;
    public static final int SKIP_SCREENSHOT = 64;
    public static final int SECURE = 128;
    public static final int ENABLE_BACKPRESSURE = 256;
    public static final int DISPLAY_DECORATION = 512;
    public static final int IGNORE_DESTINATION_FRAME = 1024;
    public static final int LAYER_IS_REFRESH_RATE_INDICATOR = 2048;
    public static final int CAN_OCCLUDE_PRESENTATION = 4096;
    public static final int RECOVERABLE_FROM_BUFFER_STUFFING = 8192;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int PROTECTED_APP = 2048;
    public static final int CURSOR_WINDOW = 8192;
    public static final int NO_COLOR_FILL = 16384;
    public static final int FX_SURFACE_NORMAL = 0;
    public static final int FX_SURFACE_EFFECT = 131072;
    public static final int FX_SURFACE_CONTAINER = 524288;
    public static final int FX_SURFACE_BLAST = 262144;
    public static final int FX_SURFACE_MASK = 983040;
    private static final int SURFACE_HIDDEN = 1;
    private static final int SURFACE_OPAQUE = 2;
    public static final int DISPLAY_RECEIVES_INPUT = 1;
    public static final int POWER_MODE_OFF = 0;
    public static final int POWER_MODE_DOZE = 1;
    public static final int POWER_MODE_NORMAL = 2;
    public static final int POWER_MODE_DOZE_SUSPEND = 3;
    public static final int POWER_MODE_ON_SUSPEND = 4;
    public static final int CACHING_DISABLED = 0;
    public static final int CACHING_ENABLED = 1;
    public static final int METADATA_OWNER_UID = 1;
    public static final int METADATA_WINDOW_TYPE = 2;
    public static final int METADATA_TASK_ID = 3;
    public static final int METADATA_MOUSE_CURSOR = 4;
    public static final int METADATA_ACCESSIBILITY_ID = 5;
    public static final int METADATA_OWNER_PID = 6;
    public static final int METADATA_GAME_MODE = 8;
    public static final int FRAME_RATE_SELECTION_STRATEGY_PROPAGATE = 0;
    public static final int FRAME_RATE_SELECTION_STRATEGY_OVERRIDE_CHILDREN = 1;
    public static final int FRAME_RATE_SELECTION_STRATEGY_SELF = 2;
    @NonNull
    public static final Parcelable.Creator<SurfaceControl> CREATOR = new Parcelable.Creator<SurfaceControl>(){

        @Override
        public SurfaceControl createFromParcel(Parcel in) {
            return new SurfaceControl(in);
        }

        public SurfaceControl[] newArray(int size) {
            return new SurfaceControl[size];
        }
    };

    private static long nativeCreate(SurfaceSession surfaceSession, String string2, int n, int n2, int n3, int n4, long l, Parcel parcel) throws Surface.OutOfResourcesException {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCreate(Landroid/view/SurfaceSession;Ljava/lang/String;IIIIJLandroid/os/Parcel;)J", true, null);
    }

    private static long nativeReadFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeReadFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static long nativeCopyFromSurfaceControl(long l) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCopyFromSurfaceControl(J)J", true, null);
    }

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeWriteToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static long nativeGetNativeSurfaceControlFinalizer() {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeGetNativeSurfaceControlFinalizer()J", true, null);
    }

    private static void nativeDisconnect(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDisconnect(J)V", true, null);
    }

    private static void nativeUpdateDefaultBufferSize(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeUpdateDefaultBufferSize(JII)V", true, null);
    }

    private static long nativeMirrorSurface(long l) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeMirrorSurface(J)J", true, null);
    }

    @LayoutlibDelegate
    private static long nativeCreateTransaction() {
        return SurfaceControl_Delegate.nativeCreateTransaction();
    }

    @LayoutlibDelegate
    private static long nativeGetNativeTransactionFinalizer() {
        return SurfaceControl_Delegate.nativeGetNativeTransactionFinalizer();
    }

    private static void nativeApplyTransaction(long l, boolean bl, boolean bl2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeApplyTransaction(JZZ)V", true, null);
    }

    private static void nativeMergeTransaction(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeMergeTransaction(JJ)V", true, null);
    }

    private static void nativeClearTransaction(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeClearTransaction(J)V", true, null);
    }

    private static void nativeSetAnimationTransaction(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAnimationTransaction(J)V", true, null);
    }

    private static void nativeSetEarlyWakeupStart(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetEarlyWakeupStart(J)V", true, null);
    }

    private static void nativeSetEarlyWakeupEnd(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetEarlyWakeupEnd(J)V", true, null);
    }

    private static long nativeGetTransactionId(long l) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeGetTransactionId(J)J", true, null);
    }

    private static void nativeSetLayer(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayer(JJI)V", true, null);
    }

    private static void nativeSetRelativeLayer(long l, long l2, long l3, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetRelativeLayer(JJJI)V", true, null);
    }

    private static void nativeSetPosition(long l, long l2, float f, float f2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetPosition(JJFF)V", true, null);
    }

    private static void nativeSetScale(long l, long l2, float f, float f2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetScale(JJFF)V", true, null);
    }

    private static void nativeSetTransparentRegionHint(long l, long l2, Region region) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetTransparentRegionHint(JJLandroid/graphics/Region;)V", true, null);
    }

    private static void nativeSetAlpha(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAlpha(JJF)V", true, null);
    }

    private static void nativeSetMatrix(long l, long l2, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetMatrix(JJFFFF)V", true, null);
    }

    private static void nativeSetColorTransform(long l, long l2, float[] fArray, float[] fArray2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColorTransform(JJ[F[F)V", true, null);
    }

    private static void nativeSetColorSpaceAgnostic(long l, long l2, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColorSpaceAgnostic(JJZ)V", true, null);
    }

    private static void nativeSetGeometry(long l, long l2, Rect rect, Rect rect2, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGeometry(JJLandroid/graphics/Rect;Landroid/graphics/Rect;J)V", true, null);
    }

    private static void nativeSetColor(long l, long l2, float[] fArray) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetColor(JJ[F)V", true, null);
    }

    private static void nativeSetFlags(long l, long l2, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFlags(JJII)V", true, null);
    }

    private static void nativeSetFrameRateSelectionPriority(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFrameRateSelectionPriority(JJI)V", true, null);
    }

    private static void nativeSetWindowCrop(long l, long l2, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetWindowCrop(JJIIII)V", true, null);
    }

    private static void nativeSetCrop(long l, long l2, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetCrop(JJFFFF)V", true, null);
    }

    private static void nativeSetCornerRadius(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetCornerRadius(JJF)V", true, null);
    }

    private static void nativeSetClientDrawnCornerRadius(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetClientDrawnCornerRadius(JJF)V", true, null);
    }

    private static void nativeSetBackgroundBlurRadius(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetBackgroundBlurRadius(JJI)V", true, null);
    }

    private static void nativeSetLayerStack(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayerStack(JJI)V", true, null);
    }

    private static void nativeSetBlurRegions(long l, long l2, float[][] fArray, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetBlurRegions(JJ[[FI)V", true, null);
    }

    private static void nativeSetStretchEffect(long l, long l2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetStretchEffect(JJFFFFFFFFFF)V", true, null);
    }

    private static void nativeSetEdgeExtensionEffect(long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetEdgeExtensionEffect(JJZZZZ)V", true, null);
    }

    private static void nativeSetTrustedOverlay(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetTrustedOverlay(JJI)V", true, null);
    }

    private static void nativeSetDropInputMode(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDropInputMode(JJI)V", true, null);
    }

    private static void nativeSetCanOccludePresentation(long l, long l2, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetCanOccludePresentation(JJZ)V", true, null);
    }

    private static void nativeSurfaceFlushJankData(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSurfaceFlushJankData(J)V", true, null);
    }

    private static boolean nativeClearContentFrameStats(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearContentFrameStats(J)Z", true, null) != 0;
    }

    private static boolean nativeGetContentFrameStats(long l, WindowContentFrameStats windowContentFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetContentFrameStats(JLandroid/view/WindowContentFrameStats;)Z", true, null) != 0;
    }

    private static boolean nativeClearAnimationFrameStats() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearAnimationFrameStats()Z", true, null) != 0;
    }

    private static boolean nativeGetAnimationFrameStats(WindowAnimationFrameStats windowAnimationFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetAnimationFrameStats(Landroid/view/WindowAnimationFrameStats;)Z", true, null) != 0;
    }

    private static void nativeSetDisplaySurface(long l, IBinder iBinder, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySurface(JLandroid/os/IBinder;J)V", true, null);
    }

    private static void nativeSetDisplayLayerStack(long l, IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayLayerStack(JLandroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetDisplayFlags(long l, IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayFlags(JLandroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetDisplayProjection(long l, IBinder iBinder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayProjection(JLandroid/os/IBinder;IIIIIIIII)V", true, null);
    }

    private static void nativeSetDisplaySize(long l, IBinder iBinder, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySize(JLandroid/os/IBinder;II)V", true, null);
    }

    private static StaticDisplayInfo nativeGetStaticDisplayInfo(long l) {
        return (StaticDisplayInfo)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetStaticDisplayInfo(J)Landroid/view/SurfaceControl$StaticDisplayInfo;", true, null);
    }

    private static DynamicDisplayInfo nativeGetDynamicDisplayInfo(long l) {
        return (DynamicDisplayInfo)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDynamicDisplayInfo(J)Landroid/view/SurfaceControl$DynamicDisplayInfo;", true, null);
    }

    private static DisplayedContentSamplingAttributes nativeGetDisplayedContentSamplingAttributes(IBinder iBinder) {
        return (DisplayedContentSamplingAttributes)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayedContentSamplingAttributes(Landroid/os/IBinder;)Landroid/hardware/display/DisplayedContentSamplingAttributes;", true, null);
    }

    private static boolean nativeSetDisplayedContentSamplingEnabled(IBinder iBinder, boolean bl, int n, int n2) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetDisplayedContentSamplingEnabled(Landroid/os/IBinder;ZII)Z", true, null) != 0;
    }

    private static DisplayedContentSample nativeGetDisplayedContentSample(IBinder iBinder, long l, long l2) {
        return (DisplayedContentSample)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayedContentSample(Landroid/os/IBinder;JJ)Landroid/hardware/display/DisplayedContentSample;", true, null);
    }

    private static boolean nativeSetDesiredDisplayModeSpecs(IBinder iBinder, DesiredDisplayModeSpecs desiredDisplayModeSpecs) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetDesiredDisplayModeSpecs(Landroid/os/IBinder;Landroid/view/SurfaceControl$DesiredDisplayModeSpecs;)Z", true, null) != 0;
    }

    private static DesiredDisplayModeSpecs nativeGetDesiredDisplayModeSpecs(IBinder iBinder) {
        return (DesiredDisplayModeSpecs)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDesiredDisplayModeSpecs(Landroid/os/IBinder;)Landroid/view/SurfaceControl$DesiredDisplayModeSpecs;", true, null);
    }

    private static DisplayPrimaries nativeGetDisplayNativePrimaries(IBinder iBinder) {
        return (DisplayPrimaries)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayNativePrimaries(Landroid/os/IBinder;)Landroid/view/SurfaceControl$DisplayPrimaries;", true, null);
    }

    private static int[] nativeGetCompositionDataspaces() {
        return (int[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetCompositionDataspaces()[I", true, null);
    }

    private static OverlayProperties nativeGetOverlaySupport() {
        return (OverlayProperties)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetOverlaySupport()Landroid/hardware/OverlayProperties;", true, null);
    }

    private static boolean nativeSetActiveColorMode(IBinder iBinder, int n) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetActiveColorMode(Landroid/os/IBinder;I)Z", true, null) != 0;
    }

    private static boolean nativeGetBootDisplayModeSupport() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetBootDisplayModeSupport()Z", true, null) != 0;
    }

    private static void nativeSetBootDisplayMode(IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetBootDisplayMode(Landroid/os/IBinder;I)V", true, null);
    }

    private static void nativeClearBootDisplayMode(IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeClearBootDisplayMode(Landroid/os/IBinder;)V", true, null);
    }

    private static void nativeSetAutoLowLatencyMode(IBinder iBinder, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAutoLowLatencyMode(Landroid/os/IBinder;Z)V", true, null);
    }

    private static void nativeSetGameContentType(IBinder iBinder, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGameContentType(Landroid/os/IBinder;Z)V", true, null);
    }

    private static void nativeSetDisplayPowerMode(IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayPowerMode(Landroid/os/IBinder;I)V", true, null);
    }

    private static void nativeReparent(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReparent(JJJ)V", true, null);
    }

    private static void nativeSetBuffer(long l, long l2, HardwareBuffer hardwareBuffer, long l3, Consumer<SyncFence> consumer) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetBuffer(JJLandroid/hardware/HardwareBuffer;JLjava/util/function/Consumer;)V", true, null);
    }

    private static void nativeUnsetBuffer(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeUnsetBuffer(JJ)V", true, null);
    }

    private static void nativeSetBufferTransform(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetBufferTransform(JJI)V", true, null);
    }

    private static void nativeSetDataSpace(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDataSpace(JJI)V", true, null);
    }

    private static void nativeSetExtendedRangeBrightness(long l, long l2, float f, float f2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetExtendedRangeBrightness(JJFF)V", true, null);
    }

    private static void nativeSetDesiredHdrHeadroom(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDesiredHdrHeadroom(JJF)V", true, null);
    }

    private static void nativeSetCachingHint(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetCachingHint(JJI)V", true, null);
    }

    private static void nativeSetDamageRegion(long l, long l2, Region region) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDamageRegion(JJLandroid/graphics/Region;)V", true, null);
    }

    private static void nativeSetDimmingEnabled(long l, long l2, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDimmingEnabled(JJZ)V", true, null);
    }

    private static void nativeSetInputWindowInfo(long l, long l2, InputWindowHandle inputWindowHandle) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetInputWindowInfo(JJLandroid/view/InputWindowHandle;)V", true, null);
    }

    private static boolean nativeGetProtectedContentSupport() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetProtectedContentSupport()Z", true, null) != 0;
    }

    private static void nativeSetMetadata(long l, long l2, int n, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetMetadata(JJILandroid/os/Parcel;)V", true, null);
    }

    private static void nativeAddWindowInfosReportedListener(long l, Runnable runnable) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeAddWindowInfosReportedListener(JLjava/lang/Runnable;)V", true, null);
    }

    private static boolean nativeGetDisplayBrightnessSupport(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetDisplayBrightnessSupport(Landroid/os/IBinder;)Z", true, null) != 0;
    }

    private static boolean nativeSetDisplayBrightness(IBinder iBinder, float f, float f2, float f3, float f4) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetDisplayBrightness(Landroid/os/IBinder;FFFF)Z", true, null) != 0;
    }

    private static long nativeReadTransactionFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeReadTransactionFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    private static void nativeWriteTransactionToParcel(long l, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeWriteTransactionToParcel(JLandroid/os/Parcel;)V", true, null);
    }

    private static void nativeSetShadowRadius(long l, long l2, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetShadowRadius(JJF)V", true, null);
    }

    private static void nativeSetBorderSettings(long l, long l2, Parcel parcel) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetBorderSettings(JJLandroid/os/Parcel;)V", true, null);
    }

    private static void nativeSetGlobalShadowSettings(float[] fArray, float[] fArray2, float f, float f2, float f3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGlobalShadowSettings([F[FFFF)V", true, null);
    }

    private static DisplayDecorationSupport nativeGetDisplayDecorationSupport(IBinder iBinder) {
        return (DisplayDecorationSupport)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayDecorationSupport(Landroid/os/IBinder;)Landroid/hardware/graphics/common/DisplayDecorationSupport;", true, null);
    }

    private static void nativeSetFrameRate(long l, long l2, float f, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFrameRate(JJFII)V", true, null);
    }

    private static void nativeSetDefaultFrameRateCompatibility(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDefaultFrameRateCompatibility(JJI)V", true, null);
    }

    private static void nativeSetFrameRateCategory(long l, long l2, int n, boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFrameRateCategory(JJIZ)V", true, null);
    }

    private static void nativeSetFrameRateSelectionStrategy(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFrameRateSelectionStrategy(JJI)V", true, null);
    }

    private static long nativeGetHandle(long l) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeGetHandle(J)J", true, null);
    }

    private static void nativeSetFixedTransformHint(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFixedTransformHint(JJI)V", true, null);
    }

    private static void nativeRemoveCurrentInputFocus(long l, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeRemoveCurrentInputFocus(JI)V", true, null);
    }

    private static void nativeSetFocusedWindow(long l, IBinder iBinder, String string2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFocusedWindow(JLandroid/os/IBinder;Ljava/lang/String;I)V", true, null);
    }

    private static void nativeSetFrameTimelineVsync(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFrameTimelineVsync(JJ)V", true, null);
    }

    private static long nativeCreateJankDataListenerWrapper(long l, OnJankDataListener onJankDataListener) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCreateJankDataListenerWrapper(JLandroid/view/SurfaceControl$OnJankDataListener;)J", true, null);
    }

    private static long nativeGetJankDataListenerWrapperFinalizer() {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeGetJankDataListenerWrapperFinalizer()J", true, null);
    }

    private static void nativeAddJankDataListener(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeAddJankDataListener(J)V", true, null);
    }

    private static void nativeFlushJankData(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeFlushJankData(J)V", true, null);
    }

    private static void nativeRemoveJankDataListener(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeRemoveJankDataListener(JJ)V", true, null);
    }

    private static int nativeGetGPUContextPriority() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetGPUContextPriority()I", true, null);
    }

    private static void nativeSetTransformHint(long l, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetTransformHint(JI)V", true, null);
    }

    private static int nativeGetTransformHint(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetTransformHint(J)I", true, null);
    }

    private static int nativeGetLayerId(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetLayerId(J)I", true, null);
    }

    private static void nativeAddTransactionCommittedListener(long l, TransactionCommittedListener transactionCommittedListener) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeAddTransactionCommittedListener(JLandroid/view/SurfaceControl$TransactionCommittedListener;)V", true, null);
    }

    private static void nativeAddTransactionCompletedListener(long l, Consumer<TransactionStats> consumer) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeAddTransactionCompletedListener(JLjava/util/function/Consumer;)V", true, null);
    }

    private static void nativeSanitize(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSanitize(JII)V", true, null);
    }

    private static void nativeSetDestinationFrame(long l, long l2, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDestinationFrame(JJIIII)V", true, null);
    }

    private static void nativeSetDefaultApplyToken(IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDefaultApplyToken(Landroid/os/IBinder;)V", true, null);
    }

    private static IBinder nativeGetDefaultApplyToken() {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDefaultApplyToken()Landroid/os/IBinder;", true, null);
    }

    private static boolean nativeBootFinished() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeBootFinished()Z", true, null) != 0;
    }

    private static long nativeCreateTpc(TrustedPresentationCallback trustedPresentationCallback) {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCreateTpc(Landroid/view/SurfaceControl$TrustedPresentationCallback;)J", true, null);
    }

    private static long getNativeTrustedPresentationCallbackFinalizer() {
        return OverrideMethod.invokeL("android.view.SurfaceControl#getNativeTrustedPresentationCallbackFinalizer()J", true, null);
    }

    private static void nativeSetTrustedPresentationCallback(long l, long l2, long l3, TrustedPresentationThresholds trustedPresentationThresholds) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetTrustedPresentationCallback(JJJLandroid/view/SurfaceControl$TrustedPresentationThresholds;)V", true, null);
    }

    private static void nativeClearTrustedPresentationCallback(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeClearTrustedPresentationCallback(JJ)V", true, null);
    }

    private static StalledTransactionInfo nativeGetStalledTransactionInfo(int n) {
        return (StalledTransactionInfo)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetStalledTransactionInfo(I)Landroid/gui/StalledTransactionInfo;", true, null);
    }

    private static void nativeSetDesiredPresentTimeNanos(long l, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDesiredPresentTimeNanos(JJ)V", true, null);
    }

    private static void nativeNotifyShutdown() {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeNotifyShutdown()V", true, null);
    }

    private static void nativeSetLuts(long l, long l2, float[] fArray, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLuts(JJ[F[I[I[I[I)V", true, null);
    }

    private static void nativeEnableDebugLogCallPoints(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeEnableDebugLogCallPoints(J)V", true, null);
    }

    private static int nativeGetMaxPictureProfiles() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetMaxPictureProfiles()I", true, null);
    }

    private static void nativeSetPictureProfileId(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetPictureProfileId(JJJ)V", true, null);
    }

    private static void nativeSetContentPriority(long l, long l2, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetContentPriority(JJI)V", true, null);
    }

    public static int rotationToBufferTransform(int rotation) {
        switch (rotation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
        }
        Log.e(TAG, "Trying to convert unknown rotation=" + rotation);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOnReparentListener(@NonNull OnReparentListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mReparentListeners == null) {
                this.mReparentListeners = new ArrayList(1);
            }
            return this.mReparentListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOnReparentListener(@NonNull OnReparentListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            boolean removed = this.mReparentListeners.remove(listener);
            if (this.mReparentListeners.isEmpty()) {
                this.mReparentListeners = null;
            }
            return removed;
        }
    }

    private void assignNativeObject(long nativeObject, String callsite) {
        if (this.mNativeObject != 0L) {
            this.release();
        }
        if (nativeObject != 0L) {
            this.mFreeNativeResources = sRegistry.registerNativeAllocation(this, nativeObject);
        }
        this.mNativeObject = nativeObject;
        this.mNativeHandle = this.mNativeObject != 0L ? SurfaceControl.nativeGetHandle(nativeObject) : 0L;
        this.mReleaseStack = sDebugUsageAfterRelease && this.mNativeObject == 0L ? new Throwable("Assigned invalid nativeObject") : null;
        this.setUnreleasedWarningCallSite(callsite);
        if (nativeObject != 0L) {
            SurfaceControlRegistry.getProcessInstance().add(this);
        }
    }

    public void copyFrom(@NonNull SurfaceControl other, String callsite) {
        this.mName = other.mName;
        this.mWidth = other.mWidth;
        this.mHeight = other.mHeight;
        this.mLocalOwnerView = other.mLocalOwnerView;
        this.assignNativeObject(SurfaceControl.nativeCopyFromSurfaceControl(other.mNativeObject), callsite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags, SurfaceControl parent, SparseIntArray metadata, WeakReference<View> localOwnerView, String callsite) throws Surface.OutOfResourcesException, IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        this.mName = name;
        this.mWidth = w;
        this.mHeight = h;
        this.mLocalOwnerView = localOwnerView;
        Parcel metaParcel = Parcel.obtain();
        long nativeObject = 0L;
        try {
            if (metadata != null && metadata.size() > 0) {
                metaParcel.writeInt(metadata.size());
                for (int i = 0; i < metadata.size(); ++i) {
                    metaParcel.writeInt(metadata.keyAt(i));
                    metaParcel.writeByteArray(ByteBuffer.allocate(4).order(ByteOrder.nativeOrder()).putInt(metadata.valueAt(i)).array());
                }
                metaParcel.setDataPosition(0);
            }
            nativeObject = SurfaceControl.nativeCreate(session, name, w, h, format, flags, parent != null ? parent.mNativeObject : 0L, metaParcel);
        }
        finally {
            metaParcel.recycle();
        }
        if (nativeObject == 0L) {
            throw new Surface.OutOfResourcesException("Couldn't allocate SurfaceControl native object");
        }
        this.assignNativeObject(nativeObject, callsite);
    }

    public SurfaceControl(@NonNull SurfaceControl other, @NonNull String callsite) {
        this.copyFrom(other, callsite);
    }

    private SurfaceControl(Parcel in) {
        this.readFromParcel(in);
    }

    public SurfaceControl() {
    }

    public void readFromParcel(Parcel in) {
        if (in == null) {
            throw new IllegalArgumentException("source must not be null");
        }
        this.mName = in.readString8();
        this.mWidth = in.readInt();
        this.mHeight = in.readInt();
        long object = 0L;
        if (in.readInt() != 0) {
            object = SurfaceControl.nativeReadFromParcel(in);
        }
        this.assignNativeObject(object, "readFromParcel");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (sDebugUsageAfterRelease) {
            this.checkNotReleased();
        }
        dest.writeString8(this.mName);
        dest.writeInt(this.mWidth);
        dest.writeInt(this.mHeight);
        if (this.mNativeObject == 0L) {
            dest.writeInt(0);
        } else {
            dest.writeInt(1);
        }
        SurfaceControl.nativeWriteToParcel(this.mNativeObject, dest);
        if ((flags & 1) != 0) {
            this.release();
        }
    }

    public static void setDebugUsageAfterRelease(boolean debug) {
        if (!_Original_Build.isDebuggable()) {
            return;
        }
        sDebugUsageAfterRelease = debug;
    }

    public void setUnreleasedWarningCallSite(@NonNull String callsite) {
        if (!this.isValid()) {
            return;
        }
        this.mCloseGuard.openWithCallSite("release", callsite);
        this.mCallsite = callsite;
    }

    @Nullable
    String getCallsite() {
        return this.mCallsite;
    }

    @NonNull
    String getName() {
        return this.mName;
    }

    public boolean isSameSurface(@NonNull SurfaceControl other) {
        return other.mNativeHandle == this.mNativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Choreographer getChoreographer() {
        this.checkNotReleased();
        Object object = this.mChoreographerLock;
        synchronized (object) {
            if (this.mChoreographer == null) {
                return this.getChoreographer(Looper.myLooper());
            }
            return this.mChoreographer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public Choreographer getChoreographer(@NonNull Looper looper) {
        this.checkNotReleased();
        Object object = this.mChoreographerLock;
        synchronized (object) {
            if (this.mChoreographer == null) {
                this.mChoreographer = Choreographer.getInstanceForSurfaceControl(this.mNativeHandle, looper);
            } else if (!this.mChoreographer.isTheLooperSame(looper)) {
                throw new IllegalStateException("Choreographer already exists with a different looper");
            }
            return this.mChoreographer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public boolean hasChoreographer() {
        Object object = this.mChoreographerLock;
        synchronized (object) {
            return this.mChoreographer != null;
        }
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10500000001L, System.identityHashCode(this));
        proto.write(1138166333442L, this.mName);
        proto.write(1120986464259L, this.getLayerId());
        proto.end(token);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            SurfaceControlRegistry.getProcessInstance().remove(this);
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.mNativeObject != 0L) {
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("release", null, this, null);
            }
            this.mFreeNativeResources.run();
            this.mNativeObject = 0L;
            this.mNativeHandle = 0L;
            if (sDebugUsageAfterRelease) {
                this.mReleaseStack = new Throwable("Released");
            }
            this.mCloseGuard.close();
            Object object = this.mChoreographerLock;
            synchronized (object) {
                if (this.mChoreographer != null) {
                    this.mChoreographer.invalidate();
                    this.mChoreographer = null;
                }
            }
            SurfaceControlRegistry.getProcessInstance().remove(this);
        }
    }

    public void disconnect() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDisconnect(this.mNativeObject);
        }
    }

    private void checkNotReleased() {
        if (this.mNativeObject == 0L) {
            if (this.mReleaseStack != null) {
                throw new IllegalStateException("Invalid usage after release of " + this, this.mReleaseStack);
            }
            throw new NullPointerException("mNativeObject of " + this + " is null. Have you called release() already?");
        }
    }

    public boolean isValid() {
        return this.mNativeObject != 0L;
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=35, publicAlternatives="Use {@code SurfaceControl.Transaction} instead", trackingBug=247078497L)
    public static void openTransaction() {
    }

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=35, publicAlternatives="Use {@code SurfaceControl.Transaction} instead", trackingBug=247078497L)
    public static void closeTransaction() {
    }

    public boolean clearContentFrameStats() {
        this.checkNotReleased();
        return SurfaceControl.nativeClearContentFrameStats(this.mNativeObject);
    }

    public boolean getContentFrameStats(WindowContentFrameStats outStats) {
        this.checkNotReleased();
        return SurfaceControl.nativeGetContentFrameStats(this.mNativeObject, outStats);
    }

    public static boolean clearAnimationFrameStats() {
        return SurfaceControl.nativeClearAnimationFrameStats();
    }

    public static boolean getAnimationFrameStats(WindowAnimationFrameStats outStats) {
        return SurfaceControl.nativeGetAnimationFrameStats(outStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mHeight;
        }
    }

    @Nullable
    public View getLocalOwnerView() {
        return this.mLocalOwnerView != null ? (View)this.mLocalOwnerView.get() : null;
    }

    public String toString() {
        return "Surface(name=" + this.mName + ")/@0x" + Integer.toHexString(System.identityHashCode(this));
    }

    public static void setDisplayPowerMode(IBinder displayToken, int mode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayPowerMode(displayToken, mode);
    }

    public static StaticDisplayInfo getStaticDisplayInfo(long displayId) {
        return SurfaceControl.nativeGetStaticDisplayInfo(displayId);
    }

    public static DynamicDisplayInfo getDynamicDisplayInfo(long displayId) {
        return SurfaceControl.nativeGetDynamicDisplayInfo(displayId);
    }

    public static DisplayedContentSamplingAttributes getDisplayedContentSamplingAttributes(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayedContentSamplingAttributes(displayToken);
    }

    public static boolean setDisplayedContentSamplingEnabled(IBinder displayToken, boolean enable, int componentMask, int maxFrames) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        int maxColorComponents = 4;
        if (componentMask >> 4 != 0) {
            throw new IllegalArgumentException("invalid componentMask when enabling sampling");
        }
        return SurfaceControl.nativeSetDisplayedContentSamplingEnabled(displayToken, enable, componentMask, maxFrames);
    }

    public static DisplayedContentSample getDisplayedContentSample(IBinder displayToken, long maxFrames, long timestamp) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayedContentSample(displayToken, maxFrames, timestamp);
    }

    public static boolean setDesiredDisplayModeSpecs(IBinder displayToken, DesiredDisplayModeSpecs desiredDisplayModeSpecs) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (desiredDisplayModeSpecs == null) {
            throw new IllegalArgumentException("desiredDisplayModeSpecs must not be null");
        }
        if (desiredDisplayModeSpecs.defaultMode < 0) {
            throw new IllegalArgumentException("defaultMode must be non-negative");
        }
        return SurfaceControl.nativeSetDesiredDisplayModeSpecs(displayToken, desiredDisplayModeSpecs);
    }

    public static DesiredDisplayModeSpecs getDesiredDisplayModeSpecs(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDesiredDisplayModeSpecs(displayToken);
    }

    public static DisplayPrimaries getDisplayNativePrimaries(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayNativePrimaries(displayToken);
    }

    public static boolean setActiveColorMode(IBinder displayToken, int colorMode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveColorMode(displayToken, colorMode);
    }

    public static ColorSpace[] getCompositionColorSpaces() {
        int[] dataspaces = SurfaceControl.nativeGetCompositionDataspaces();
        ColorSpace srgb = ColorSpace.get(ColorSpace.Named.SRGB);
        ColorSpace[] colorSpaces = new ColorSpace[]{srgb, srgb};
        if (dataspaces != null && dataspaces.length == 2) {
            for (int i = 0; i < 2; ++i) {
                ColorSpace cs = ColorSpace.getFromDataSpace(dataspaces[i]);
                if (cs == null) continue;
                colorSpaces[i] = cs;
            }
        }
        return colorSpaces;
    }

    public static OverlayProperties getOverlaySupport() {
        return SurfaceControl.nativeGetOverlaySupport();
    }

    public static boolean getBootDisplayModeSupport() {
        return SurfaceControl.nativeGetBootDisplayModeSupport();
    }

    public static void setBootDisplayMode(IBinder displayToken, int displayModeId) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetBootDisplayMode(displayToken, displayModeId);
    }

    public static void clearBootDisplayMode(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeClearBootDisplayMode(displayToken);
    }

    public static void setAutoLowLatencyMode(IBinder displayToken, boolean on) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetAutoLowLatencyMode(displayToken, on);
    }

    public static void setGameContentType(IBinder displayToken, boolean on) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetGameContentType(displayToken, on);
    }

    public static boolean getProtectedContentSupport() {
        return SurfaceControl.nativeGetProtectedContentSupport();
    }

    public static boolean getDisplayBrightnessSupport(IBinder displayToken) {
        return SurfaceControl.nativeGetDisplayBrightnessSupport(displayToken);
    }

    public static boolean setDisplayBrightness(IBinder displayToken, float brightness) {
        return SurfaceControl.setDisplayBrightness(displayToken, brightness, -1.0f, brightness, -1.0f);
    }

    public static boolean setDisplayBrightness(IBinder displayToken, float sdrBrightness, float sdrBrightnessNits, float displayBrightness, float displayBrightnessNits) {
        Objects.requireNonNull(displayToken);
        if (Float.isNaN(displayBrightness) || displayBrightness > 1.0f || displayBrightness < 0.0f && displayBrightness != -1.0f) {
            throw new IllegalArgumentException("displayBrightness must be a number between 0.0f  and 1.0f, or -1 to turn the backlight off: " + displayBrightness);
        }
        if (Float.isNaN(sdrBrightness) || sdrBrightness > 1.0f || sdrBrightness < 0.0f && sdrBrightness != -1.0f) {
            throw new IllegalArgumentException("sdrBrightness must be a number between 0.0f and 1.0f, or -1 to turn the backlight off: " + sdrBrightness);
        }
        return SurfaceControl.nativeSetDisplayBrightness(displayToken, sdrBrightness, sdrBrightnessNits, displayBrightness, displayBrightnessNits);
    }

    public static SurfaceControl mirrorSurface(SurfaceControl mirrorOf) {
        long nativeObj = SurfaceControl.nativeMirrorSurface(mirrorOf.mNativeObject);
        SurfaceControl sc = new SurfaceControl();
        sc.mName = mirrorOf.mName + " (mirror)";
        sc.assignNativeObject(nativeObj, "mirrorSurface");
        return sc;
    }

    private static void validateColorArg(float[] color2) {
        String msg = "Color must be specified as a float array with four values to represent r, g, b, a in range [0..1]";
        if (color2.length != 4) {
            throw new IllegalArgumentException("Color must be specified as a float array with four values to represent r, g, b, a in range [0..1]");
        }
        for (float c : color2) {
            if (!(c < 0.0f) && !(c > 1.0f)) continue;
            throw new IllegalArgumentException("Color must be specified as a float array with four values to represent r, g, b, a in range [0..1]");
        }
    }

    public static void setGlobalShadowSettings(float[] ambientColor, float[] spotColor, float lightPosY, float lightPosZ, float lightRadius) {
        SurfaceControl.validateColorArg(ambientColor);
        SurfaceControl.validateColorArg(spotColor);
        SurfaceControl.nativeSetGlobalShadowSettings(ambientColor, spotColor, lightPosY, lightPosZ, lightRadius);
    }

    public static DisplayDecorationSupport getDisplayDecorationSupport(IBinder displayToken) {
        return SurfaceControl.nativeGetDisplayDecorationSupport(displayToken);
    }

    @NonNull
    public OnJankDataListenerRegistration addOnJankDataListener(@NonNull OnJankDataListener listener) {
        return new OnJankDataListenerRegistration(this, listener);
    }

    public static int getGPUContextPriority() {
        return SurfaceControl.nativeGetGPUContextPriority();
    }

    public static boolean bootFinished() {
        return SurfaceControl.nativeBootFinished();
    }

    public static int getMaxPictureProfiles() {
        return SurfaceControl.nativeGetMaxPictureProfiles();
    }

    public void resize(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
        SurfaceControl.nativeUpdateDefaultBufferSize(this.mNativeObject, w, h);
    }

    public int getTransformHint() {
        this.checkNotReleased();
        return SurfaceControl.nativeGetTransformHint(this.mNativeObject);
    }

    public void setTransformHint(int transformHint) {
        SurfaceControl.nativeSetTransformHint(this.mNativeObject, transformHint);
    }

    public int getLayerId() {
        if (this.mNativeObject != 0L) {
            return SurfaceControl.nativeGetLayerId(this.mNativeObject);
        }
        return -1;
    }

    private static void invokeReleaseCallback(Consumer<SyncFence> callback, long nativeFencePtr) {
        SyncFence fence = new SyncFence(nativeFencePtr);
        callback.accept(fence);
    }

    public static StalledTransactionInfo getStalledTransactionInfo(int pid) {
        return SurfaceControl.nativeGetStalledTransactionInfo(pid);
    }

    public static void notifyShutdown() {
        SurfaceControl.nativeNotifyShutdown();
    }

    public static class Transaction
    implements Closeable,
    Parcelable {
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(Transaction.class.getClassLoader(), SurfaceControl.nativeGetNativeTransactionFinalizer(), 512L);
        public long mNativeObject;
        private final ArrayMap<SurfaceControl, Point> mResizedSurfaces = new ArrayMap();
        private final ArrayMap<SurfaceControl, SurfaceControl> mReparentedSurfaces = new ArrayMap();
        @Nullable
        ArrayList<String> mCalls;
        Runnable mFreeNativeResources;
        private static final float[] INVALID_COLOR = new float[]{-1.0f, -1.0f, -1.0f};
        @NonNull
        public static final Parcelable.Creator<Transaction> CREATOR = new Parcelable.Creator<Transaction>(){

            @Override
            public Transaction createFromParcel(Parcel in) {
                return new Transaction(in);
            }

            public Transaction[] newArray(int size) {
                return new Transaction[size];
            }
        };

        protected void checkPreconditions(SurfaceControl sc) {
            sc.checkNotReleased();
        }

        public Transaction() {
            this(SurfaceControl.nativeCreateTransaction());
        }

        private Transaction(long nativeObject) {
            this.mNativeObject = nativeObject;
            this.mFreeNativeResources = sRegistry.registerNativeAllocation(this, this.mNativeObject);
            this.setUpForSurfaceControlRegistry();
        }

        private Transaction(Parcel in) {
            this.readFromParcel(in);
            this.setUpForSurfaceControlRegistry();
        }

        private void setUpForSurfaceControlRegistry() {
            if (!SurfaceControlRegistry.sCallStackDebuggingInitialized) {
                SurfaceControlRegistry.initializeCallStackDebugging();
            }
            ArrayList arrayList = this.mCalls = SurfaceControlRegistry.sLogAllTxCallsOnApply ? new ArrayList() : null;
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("ctor", this, null, null);
            }
        }

        public static void setDefaultApplyToken(IBinder token) {
            SurfaceControl.nativeSetDefaultApplyToken(token);
        }

        public static IBinder getDefaultApplyToken() {
            return SurfaceControl.nativeGetDefaultApplyToken();
        }

        public void apply() {
            this.apply(false);
        }

        public void applyAsyncUnsafe() {
            this.apply(false, true);
        }

        public void clear() {
            this.mResizedSurfaces.clear();
            this.mReparentedSurfaces.clear();
            if (this.mNativeObject != 0L) {
                SurfaceControl.nativeClearTransaction(this.mNativeObject);
            }
            if (this.mCalls != null) {
                this.mCalls.clear();
            }
        }

        @Override
        public void close() {
            this.mResizedSurfaces.clear();
            this.mReparentedSurfaces.clear();
            this.mFreeNativeResources.run();
            this.mNativeObject = 0L;
            if (this.mCalls != null) {
                this.mCalls.clear();
            }
        }

        public void apply(boolean sync) {
            this.apply(sync, false);
        }

        private void apply(boolean sync, boolean oneWay) {
            this.applyResizedSurfaces();
            this.notifyReparentedSurfaces();
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("apply", this, null, null);
            }
            if (this.mCalls != null) {
                this.mCalls.clear();
            }
            SurfaceControl.nativeApplyTransaction(this.mNativeObject, sync, oneWay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void applyResizedSurfaces() {
            for (int i = this.mResizedSurfaces.size() - 1; i >= 0; --i) {
                Point size = this.mResizedSurfaces.valueAt(i);
                SurfaceControl surfaceControl = this.mResizedSurfaces.keyAt(i);
                Object object = surfaceControl.mLock;
                synchronized (object) {
                    surfaceControl.resize(size.x, size.y);
                    continue;
                }
            }
            this.mResizedSurfaces.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void notifyReparentedSurfaces() {
            int reparentCount = this.mReparentedSurfaces.size();
            for (int i = reparentCount - 1; i >= 0; --i) {
                SurfaceControl child = this.mReparentedSurfaces.keyAt(i);
                Object object = child.mLock;
                synchronized (object) {
                    int listenerCount = child.mReparentListeners != null ? child.mReparentListeners.size() : 0;
                    for (int j = 0; j < listenerCount; ++j) {
                        OnReparentListener listener = child.mReparentListeners.get(j);
                        listener.onReparent(this, this.mReparentedSurfaces.valueAt(i));
                    }
                    this.mReparentedSurfaces.removeAt(i);
                    continue;
                }
            }
        }

        @NonNull
        public Transaction setVisibility(@NonNull SurfaceControl sc, boolean visible) {
            this.checkPreconditions(sc);
            if (visible) {
                return this.show(sc);
            }
            return this.hide(sc);
        }

        @NonNull
        public Transaction setFrameRateSelectionPriority(@NonNull SurfaceControl sc, int priority) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFrameRateSelectionPriority(this.mNativeObject, sc.mNativeObject, priority);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction show(SurfaceControl sc) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("show", this, sc, null);
            }
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 1);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction hide(SurfaceControl sc) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("hide", this, sc, null);
            }
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 1, 1);
            return this;
        }

        @NonNull
        public Transaction setPosition(@NonNull SurfaceControl sc, float x, float y) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setPosition", this, sc, "x=" + x + " y=" + y);
            }
            SurfaceControl.nativeSetPosition(this.mNativeObject, sc.mNativeObject, x, y);
            return this;
        }

        @NonNull
        public Transaction setScale(@NonNull SurfaceControl sc, float scaleX, float scaleY) {
            this.checkPreconditions(sc);
            Preconditions.checkArgument(scaleX >= 0.0f, "Negative value passed in for scaleX");
            Preconditions.checkArgument(scaleY >= 0.0f, "Negative value passed in for scaleY");
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setScale", this, sc, "sx=" + scaleX + " sy=" + scaleY);
            }
            SurfaceControl.nativeSetScale(this.mNativeObject, sc.mNativeObject, scaleX, scaleY);
            return this;
        }

        @NonNull
        public Transaction setBufferSize(@NonNull SurfaceControl sc, int w, int h) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setBufferSize", this, sc, "w=" + w + " h=" + h);
            }
            this.mResizedSurfaces.put(sc, new Point(w, h));
            return this;
        }

        @NonNull
        public Transaction setFixedTransformHint(@NonNull SurfaceControl sc, int transformHint) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setFixedTransformHint", this, sc, "hint=" + transformHint);
            }
            SurfaceControl.nativeSetFixedTransformHint(this.mNativeObject, sc.mNativeObject, transformHint);
            return this;
        }

        @NonNull
        public Transaction unsetFixedTransformHint(@NonNull SurfaceControl sc) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("unsetFixedTransformHint", this, sc, null);
            }
            SurfaceControl.nativeSetFixedTransformHint(this.mNativeObject, sc.mNativeObject, -1);
            return this;
        }

        @NonNull
        public Transaction setLayer(@NonNull SurfaceControl sc, int z) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setLayer", this, sc, "z=" + z);
            }
            SurfaceControl.nativeSetLayer(this.mNativeObject, sc.mNativeObject, z);
            return this;
        }

        public Transaction setRelativeLayer(SurfaceControl sc, SurfaceControl relativeTo, int z) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setRelativeLayer", this, sc, "relTo=" + relativeTo + " z=" + z);
            }
            SurfaceControl.nativeSetRelativeLayer(this.mNativeObject, sc.mNativeObject, relativeTo.mNativeObject, z);
            return this;
        }

        public Transaction setTransparentRegionHint(SurfaceControl sc, Region transparentRegion) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("unsetFixedTransformHint", this, sc, "region=" + transparentRegion);
            }
            SurfaceControl.nativeSetTransparentRegionHint(this.mNativeObject, sc.mNativeObject, transparentRegion);
            return this;
        }

        @NonNull
        public Transaction setAlpha(@NonNull SurfaceControl sc, float alpha) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setAlpha", this, sc, "alpha=" + alpha);
            }
            SurfaceControl.nativeSetAlpha(this.mNativeObject, sc.mNativeObject, alpha);
            return this;
        }

        public Transaction setInputWindowInfo(SurfaceControl sc, InputWindowHandle handle) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetInputWindowInfo(this.mNativeObject, sc.mNativeObject, handle);
            return this;
        }

        public Transaction addWindowInfosReportedListener(@NonNull Runnable listener) {
            SurfaceControl.nativeAddWindowInfosReportedListener(this.mNativeObject, listener);
            return this;
        }

        @NonNull
        public Transaction setGeometry(@NonNull SurfaceControl sc, @Nullable Rect sourceCrop, @Nullable Rect destFrame, int orientation) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetGeometry(this.mNativeObject, sc.mNativeObject, sourceCrop, destFrame, orientation);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setMatrix(SurfaceControl sc, float dsdx, float dtdx, float dtdy, float dsdy) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setMatrix", this, sc, "dsdx=" + dsdx + " dtdx=" + dtdx + " dtdy=" + dtdy + " dsdy=" + dsdy);
            }
            SurfaceControl.nativeSetMatrix(this.mNativeObject, sc.mNativeObject, dsdx, dtdx, dtdy, dsdy);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setMatrix(SurfaceControl sc, Matrix matrix, float[] float9) {
            matrix.getValues(float9);
            this.setMatrix(sc, float9[0], float9[3], float9[1], float9[4]);
            this.setPosition(sc, float9[2], float9[5]);
            return this;
        }

        public Transaction setColorTransform(SurfaceControl sc, float[] matrix, float[] translation) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColorTransform(this.mNativeObject, sc.mNativeObject, matrix, translation);
            return this;
        }

        public Transaction setColorSpaceAgnostic(SurfaceControl sc, boolean agnostic) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetColorSpaceAgnostic(this.mNativeObject, sc.mNativeObject, agnostic);
            return this;
        }

        @Deprecated
        @UnsupportedAppUsage
        public Transaction setWindowCrop(SurfaceControl sc, Rect crop) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setWindowCrop", this, sc, "crop=" + crop);
            }
            if (crop != null) {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
            } else {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, 0, 0);
            }
            return this;
        }

        @NonNull
        public Transaction setCrop(@NonNull SurfaceControl sc, @Nullable Rect crop) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setCrop", this, sc, "crop=" + crop);
            }
            if (crop != null) {
                Preconditions.checkArgument(crop.isValid(), "Crop " + crop + " isn't valid");
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
            } else {
                SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, 0, 0);
            }
            return this;
        }

        public Transaction setWindowCrop(SurfaceControl sc, int width, int height) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setWindowCrop", this, sc, "w=" + width + " h=" + height);
            }
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, sc.mNativeObject, 0, 0, width, height);
            return this;
        }

        @NonNull
        public Transaction setCrop(@NonNull SurfaceControl sc, float left, float top, float right, float bottom) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setCrop", this, sc, "crop={" + top + ", " + left + ", " + bottom + ", " + right + "}");
            }
            SurfaceControl.nativeSetCrop(this.mNativeObject, sc.mNativeObject, left, top, right, bottom);
            return this;
        }

        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public Transaction setCornerRadius(SurfaceControl sc, float cornerRadius) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setCornerRadius", this, sc, "cornerRadius=" + cornerRadius);
            }
            SurfaceControl.nativeSetCornerRadius(this.mNativeObject, sc.mNativeObject, cornerRadius);
            return this;
        }

        @NonNull
        public Transaction setClientDrawnCornerRadius(@NonNull SurfaceControl sc, float clientDrawnCornerRadius) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setClientDrawnCornerRadius", this, sc, "clientDrawnCornerRadius=" + clientDrawnCornerRadius);
            }
            if (com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.ignoreCornerRadiusAndShadows()) {
                SurfaceControl.nativeSetClientDrawnCornerRadius(this.mNativeObject, sc.mNativeObject, clientDrawnCornerRadius);
            } else {
                Log.w(SurfaceControl.TAG, "setClientDrawnCornerRadius was called butignore_corner_radius_and_shadows flag is disabled");
            }
            return this;
        }

        public Transaction setBackgroundBlurRadius(SurfaceControl sc, int radius) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setBackgroundBlurRadius", this, sc, "radius=" + radius);
            }
            SurfaceControl.nativeSetBackgroundBlurRadius(this.mNativeObject, sc.mNativeObject, radius);
            return this;
        }

        public Transaction setBlurRegions(SurfaceControl sc, float[][] regions) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetBlurRegions(this.mNativeObject, sc.mNativeObject, regions, regions.length);
            return this;
        }

        public Transaction setStretchEffect(SurfaceControl sc, float width, float height, float vecX, float vecY, float maxStretchAmountX, float maxStretchAmountY, float childRelativeLeft, float childRelativeTop, float childRelativeRight, float childRelativeBottom) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetStretchEffect(this.mNativeObject, sc.mNativeObject, width, height, vecX, vecY, maxStretchAmountX, maxStretchAmountY, childRelativeLeft, childRelativeTop, childRelativeRight, childRelativeBottom);
            return this;
        }

        public Transaction setEdgeExtensionEffect(SurfaceControl sc, int edge) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetEdgeExtensionEffect(this.mNativeObject, sc.mNativeObject, (edge & 1) != 0, (edge & 4) != 0, (edge & 2) != 0, (edge & 8) != 0);
            return this;
        }

        @UnsupportedAppUsage(maxTargetSdk=26)
        public Transaction setLayerStack(SurfaceControl sc, int layerStack) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetLayerStack(this.mNativeObject, sc.mNativeObject, layerStack);
            return this;
        }

        @NonNull
        public Transaction reparent(@NonNull SurfaceControl sc, @Nullable SurfaceControl newParent) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("reparent", this, sc, "newParent=" + newParent);
            }
            long otherObject = 0L;
            if (newParent != null) {
                newParent.checkNotReleased();
                otherObject = newParent.mNativeObject;
            }
            SurfaceControl.nativeReparent(this.mNativeObject, sc.mNativeObject, otherObject);
            this.mReparentedSurfaces.put(sc, newParent);
            return this;
        }

        @UnsupportedAppUsage
        public Transaction setColor(SurfaceControl sc, float[] color2) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setColor", this, sc, "r=" + color2[0] + " g=" + color2[1] + " b=" + color2[2]);
            }
            SurfaceControl.nativeSetColor(this.mNativeObject, sc.mNativeObject, color2);
            return this;
        }

        public Transaction unsetColor(SurfaceControl sc) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("unsetColor", this, sc, null);
            }
            SurfaceControl.nativeSetColor(this.mNativeObject, sc.mNativeObject, INVALID_COLOR);
            return this;
        }

        public Transaction setSecure(SurfaceControl sc, boolean isSecure) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setSecure", this, sc, "secure=" + isSecure);
            }
            if (isSecure) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 128, 128);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 128);
            }
            return this;
        }

        public Transaction setDisplayDecoration(SurfaceControl sc, boolean displayDecoration) {
            this.checkPreconditions(sc);
            if (displayDecoration) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 512, 512);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 512);
            }
            return this;
        }

        @NonNull
        public Transaction setOpaque(@NonNull SurfaceControl sc, boolean isOpaque) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setOpaque", this, sc, "opaque=" + isOpaque);
            }
            if (isOpaque) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 2, 2);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 2);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transaction setDisplaySurface(IBinder displayToken, Surface surface) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (surface != null) {
                Object object = surface.mLock;
                synchronized (object) {
                    SurfaceControl.nativeSetDisplaySurface(this.mNativeObject, displayToken, surface.mNativeObject);
                }
            } else {
                SurfaceControl.nativeSetDisplaySurface(this.mNativeObject, displayToken, 0L);
            }
            return this;
        }

        public Transaction setDisplayLayerStack(IBinder displayToken, int layerStack) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            SurfaceControl.nativeSetDisplayLayerStack(this.mNativeObject, displayToken, layerStack);
            return this;
        }

        public Transaction setDisplayFlags(IBinder displayToken, int flags) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            SurfaceControl.nativeSetDisplayFlags(this.mNativeObject, displayToken, flags);
            return this;
        }

        public Transaction setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (layerStackRect == null) {
                throw new IllegalArgumentException("layerStackRect must not be null");
            }
            if (displayRect == null) {
                throw new IllegalArgumentException("displayRect must not be null");
            }
            SurfaceControl.nativeSetDisplayProjection(this.mNativeObject, displayToken, orientation, layerStackRect.left, layerStackRect.top, layerStackRect.right, layerStackRect.bottom, displayRect.left, displayRect.top, displayRect.right, displayRect.bottom);
            return this;
        }

        public Transaction setDisplaySize(IBinder displayToken, int width, int height) {
            if (displayToken == null) {
                throw new IllegalArgumentException("displayToken must not be null");
            }
            if (width <= 0 || height <= 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            SurfaceControl.nativeSetDisplaySize(this.mNativeObject, displayToken, width, height);
            return this;
        }

        public Transaction setAnimationTransaction() {
            SurfaceControl.nativeSetAnimationTransaction(this.mNativeObject);
            return this;
        }

        @RequiresPermission(value="android.permission.WAKEUP_SURFACE_FLINGER")
        public Transaction setEarlyWakeupStart() {
            SurfaceControl.nativeSetEarlyWakeupStart(this.mNativeObject);
            return this;
        }

        @RequiresPermission(value="android.permission.WAKEUP_SURFACE_FLINGER")
        public Transaction setEarlyWakeupEnd() {
            SurfaceControl.nativeSetEarlyWakeupEnd(this.mNativeObject);
            return this;
        }

        public long getId() {
            return SurfaceControl.nativeGetTransactionId(this.mNativeObject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transaction setMetadata(SurfaceControl sc, int key, int data) {
            Parcel parcel = Parcel.obtain();
            parcel.writeInt(data);
            try {
                this.setMetadata(sc, key, parcel);
            }
            finally {
                parcel.recycle();
            }
            return this;
        }

        public Transaction setMetadata(SurfaceControl sc, int key, Parcel data) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetMetadata(this.mNativeObject, sc.mNativeObject, key, data);
            return this;
        }

        public Transaction setShadowRadius(SurfaceControl sc, float shadowRadius) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setShadowRadius", this, sc, "radius=" + shadowRadius);
            }
            SurfaceControl.nativeSetShadowRadius(this.mNativeObject, sc.mNativeObject, shadowRadius);
            return this;
        }

        public Transaction setBorderSettings(SurfaceControl sc, @NonNull BorderSettings settings) {
            this.checkPreconditions(sc);
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setBorderSettings", this, sc, "settings=" + settings);
            }
            if (!com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.enableBorderSettings()) {
                Log.w(SurfaceControl.TAG, "setBorderSettings was called butenable_border_settings flag is disabled");
                return this;
            }
            Parcel settingsParcel = Parcel.obtain();
            settings.writeToParcel(settingsParcel, 0);
            settingsParcel.setDataPosition(0);
            SurfaceControl.nativeSetBorderSettings(this.mNativeObject, sc.mNativeObject, settingsParcel);
            return this;
        }

        @NonNull
        public Transaction setFrameRate(@NonNull SurfaceControl sc, float frameRate, int compatibility) {
            return this.setFrameRate(sc, frameRate, compatibility, 0);
        }

        @NonNull
        public Transaction setFrameRate(@NonNull SurfaceControl sc, float frameRate, int compatibility, int changeFrameRateStrategy) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFrameRate(this.mNativeObject, sc.mNativeObject, frameRate, compatibility, changeFrameRateStrategy);
            return this;
        }

        @NonNull
        @FlaggedApi(value="com.android.graphics.surfaceflinger.flags.arr_surfacecontrol_setframerate_api")
        public Transaction setFrameRate(@NonNull SurfaceControl sc, @NonNull Surface.FrameRateParams frameRateParams) {
            this.checkPreconditions(sc);
            if (Flags.arrSetframerateApi()) {
                int compatibility = frameRateParams.getFixedSourceRate() == 0.0f ? 0 : 1;
                float frameRate = compatibility == 0 ? frameRateParams.getDesiredMinRate() : frameRateParams.getFixedSourceRate();
                SurfaceControl.nativeSetFrameRate(this.mNativeObject, sc.mNativeObject, frameRate, compatibility, frameRateParams.getChangeFrameRateStrategy());
            } else {
                Log.w(SurfaceControl.TAG, "setFrameRate was called but flag arr_setframerate_api is disabled");
            }
            return this;
        }

        @NonNull
        public Transaction clearFrameRate(@NonNull SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFrameRate(this.mNativeObject, sc.mNativeObject, 0.0f, 0, 1);
            return this;
        }

        @NonNull
        public Transaction setDefaultFrameRateCompatibility(@NonNull SurfaceControl sc, int compatibility) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetDefaultFrameRateCompatibility(this.mNativeObject, sc.mNativeObject, compatibility);
            return this;
        }

        @NonNull
        public Transaction setFrameRateCategory(@NonNull SurfaceControl sc, int category, boolean smoothSwitchOnly) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFrameRateCategory(this.mNativeObject, sc.mNativeObject, category, smoothSwitchOnly);
            return this;
        }

        @NonNull
        public Transaction setFrameRateSelectionStrategy(@NonNull SurfaceControl sc, int strategy) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFrameRateSelectionStrategy(this.mNativeObject, sc.mNativeObject, strategy);
            return this;
        }

        public Transaction setFocusedWindow(@NonNull IBinder token, String windowName, int displayId) {
            SurfaceControl.nativeSetFocusedWindow(this.mNativeObject, token, windowName, displayId);
            return this;
        }

        public Transaction removeCurrentInputFocus(int displayId) {
            SurfaceControl.nativeRemoveCurrentInputFocus(this.mNativeObject, displayId);
            return this;
        }

        public Transaction setSkipScreenshot(SurfaceControl sc, boolean skipScrenshot) {
            this.checkPreconditions(sc);
            if (skipScrenshot) {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 64, 64);
            } else {
                SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 0, 64);
            }
            return this;
        }

        @Deprecated
        public Transaction setBuffer(SurfaceControl sc, GraphicBuffer buffer) {
            return this.setBuffer(sc, HardwareBuffer.createFromGraphicBuffer(buffer));
        }

        @NonNull
        public Transaction setBuffer(@NonNull SurfaceControl sc, @Nullable HardwareBuffer buffer) {
            return this.setBuffer(sc, buffer, null);
        }

        public Transaction unsetBuffer(SurfaceControl sc) {
            SurfaceControl.nativeUnsetBuffer(this.mNativeObject, sc.mNativeObject);
            return this;
        }

        @NonNull
        public Transaction setBuffer(@NonNull SurfaceControl sc, @Nullable HardwareBuffer buffer, @Nullable SyncFence fence) {
            return this.setBuffer(sc, buffer, fence, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        public Transaction setBuffer(@NonNull SurfaceControl sc, @Nullable HardwareBuffer buffer, @Nullable SyncFence fence, @Nullable Consumer<SyncFence> releaseCallback) {
            this.checkPreconditions(sc);
            if (fence != null) {
                Object object = fence.getLock();
                synchronized (object) {
                    SurfaceControl.nativeSetBuffer(this.mNativeObject, sc.mNativeObject, buffer, fence.getNativeFence(), releaseCallback);
                }
            } else {
                SurfaceControl.nativeSetBuffer(this.mNativeObject, sc.mNativeObject, buffer, 0L, releaseCallback);
            }
            return this;
        }

        @NonNull
        public Transaction setBufferTransform(@NonNull SurfaceControl sc, int transform) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetBufferTransform(this.mNativeObject, sc.mNativeObject, transform);
            return this;
        }

        @NonNull
        public Transaction setDamageRegion(@NonNull SurfaceControl sc, @Nullable Region region) {
            SurfaceControl.nativeSetDamageRegion(this.mNativeObject, sc.mNativeObject, region);
            return this;
        }

        @NonNull
        public Transaction setDimmingEnabled(@NonNull SurfaceControl sc, boolean dimmingEnabled) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetDimmingEnabled(this.mNativeObject, sc.mNativeObject, dimmingEnabled);
            return this;
        }

        @Deprecated
        public Transaction setColorSpace(SurfaceControl sc, ColorSpace colorSpace) {
            this.checkPreconditions(sc);
            if (colorSpace.getId() == ColorSpace.Named.DISPLAY_P3.ordinal()) {
                this.setDataSpace(sc, 0x88A0000);
            } else {
                this.setDataSpace(sc, 0x8810000);
            }
            return this;
        }

        @NonNull
        public Transaction setDataSpace(@NonNull SurfaceControl sc, int dataspace) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetDataSpace(this.mNativeObject, sc.mNativeObject, dataspace);
            return this;
        }

        @NonNull
        public Transaction setExtendedRangeBrightness(@NonNull SurfaceControl sc, float currentBufferRatio, float desiredRatio) {
            this.checkPreconditions(sc);
            if (!Float.isFinite(currentBufferRatio) || currentBufferRatio < 1.0f) {
                throw new IllegalArgumentException("currentBufferRatio must be finite && >= 1.0f; got " + currentBufferRatio);
            }
            if (!Float.isFinite(desiredRatio) || desiredRatio < 1.0f) {
                throw new IllegalArgumentException("desiredRatio must be finite && >= 1.0f; got " + desiredRatio);
            }
            SurfaceControl.nativeSetExtendedRangeBrightness(this.mNativeObject, sc.mNativeObject, currentBufferRatio, desiredRatio);
            return this;
        }

        @FlaggedApi(value="com.android.graphics.hwui.flags.limited_hdr")
        @NonNull
        public Transaction setDesiredHdrHeadroom(@NonNull SurfaceControl sc, float desiredRatio) {
            this.checkPreconditions(sc);
            if (!Float.isFinite(desiredRatio) || desiredRatio != 0.0f && desiredRatio < 1.0f) {
                throw new IllegalArgumentException("desiredRatio must be finite && >= 1.0f or 0; got " + desiredRatio);
            }
            SurfaceControl.nativeSetDesiredHdrHeadroom(this.mNativeObject, sc.mNativeObject, desiredRatio);
            return this;
        }

        @FlaggedApi(value="android.hardware.flags.luts_api")
        @NonNull
        public Transaction setLuts(@NonNull SurfaceControl sc, @Nullable DisplayLuts displayLuts) {
            this.checkPreconditions(sc);
            if (displayLuts != null && displayLuts.valid()) {
                SurfaceControl.nativeSetLuts(this.mNativeObject, sc.mNativeObject, displayLuts.getLutBuffers(), displayLuts.getOffsets(), displayLuts.getLutDimensions(), displayLuts.getLutSizes(), displayLuts.getLutSamplingKeys());
            } else {
                SurfaceControl.nativeSetLuts(this.mNativeObject, sc.mNativeObject, null, null, null, null, null);
            }
            return this;
        }

        @SystemApi
        @FlaggedApi(value="android.media.tv.flags.apply_picture_profiles")
        @NonNull
        public Transaction setPictureProfileHandle(@NonNull SurfaceControl sc, @NonNull PictureProfileHandle handle) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetPictureProfileId(this.mNativeObject, sc.mNativeObject, handle.getId());
            return this;
        }

        @FlaggedApi(value="android.media.tv.flags.apply_picture_profiles")
        @NonNull
        public Transaction setContentPriority(@NonNull SurfaceControl sc, int priority) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetContentPriority(this.mNativeObject, sc.mNativeObject, priority);
            return this;
        }

        @NonNull
        public Transaction setCachingHint(@NonNull SurfaceControl sc, int cachingHint) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetCachingHint(this.mNativeObject, sc.mNativeObject, cachingHint);
            return this;
        }

        public Transaction setTrustedOverlay(SurfaceControl sc, boolean isTrustedOverlay) {
            return this.setTrustedOverlay(sc, isTrustedOverlay ? 2 : 0);
        }

        public Transaction setTrustedOverlay(SurfaceControl sc, @TrustedOverlay int trustedOverlay) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetTrustedOverlay(this.mNativeObject, sc.mNativeObject, trustedOverlay);
            return this;
        }

        public Transaction setDropInputMode(SurfaceControl sc, @DropInputMode int mode) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetDropInputMode(this.mNativeObject, sc.mNativeObject, mode);
            return this;
        }

        public Transaction setCanOccludePresentation(SurfaceControl sc, boolean canOccludePresentation) {
            this.checkPreconditions(sc);
            int value = canOccludePresentation ? 4096 : 0;
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, value, 4096);
            return this;
        }

        public static void sendSurfaceFlushJankData(SurfaceControl sc) {
            sc.checkNotReleased();
            SurfaceControl.nativeSurfaceFlushJankData(sc.mNativeObject);
        }

        public void sanitize(int pid, int uid) {
            SurfaceControl.nativeSanitize(this.mNativeObject, pid, uid);
        }

        public Transaction setDestinationFrame(SurfaceControl sc, @NonNull Rect destinationFrame) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetDestinationFrame(this.mNativeObject, sc.mNativeObject, destinationFrame.left, destinationFrame.top, destinationFrame.right, destinationFrame.bottom);
            return this;
        }

        public Transaction setDestinationFrame(SurfaceControl sc, int width, int height) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetDestinationFrame(this.mNativeObject, sc.mNativeObject, 0, 0, width, height);
            return this;
        }

        @NonNull
        public Transaction merge(@NonNull Transaction other) {
            if (this == other) {
                return this;
            }
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("merge", this, null, "otherTx=" + other.getId());
                if (this.mCalls != null && other.mCalls != null) {
                    this.mCalls.addAll(other.mCalls);
                    other.mCalls.clear();
                }
            }
            this.mResizedSurfaces.putAll(other.mResizedSurfaces);
            other.mResizedSurfaces.clear();
            this.mReparentedSurfaces.putAll(other.mReparentedSurfaces);
            other.mReparentedSurfaces.clear();
            SurfaceControl.nativeMergeTransaction(this.mNativeObject, other.mNativeObject);
            return this;
        }

        void onMergeWithNextTransaction(CharSequence windowName) {
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("merge", this, null, "window=" + windowName);
                if (this.mCalls != null) {
                    this.mCalls.clear();
                }
                SurfaceControl.nativeEnableDebugLogCallPoints(this.mNativeObject);
            }
        }

        @NonNull
        public Transaction remove(@NonNull SurfaceControl sc) {
            this.reparent(sc, null);
            sc.release();
            return this;
        }

        @FlaggedApi(value="com.android.window.flags.sdk_desired_present_time")
        @NonNull
        public Transaction setFrameTimeline(long vsyncId) {
            if (!com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.sdkDesiredPresentTime()) {
                Log.w(SurfaceControl.TAG, "addTransactionCompletedListener was called but flag is disabled");
                return this;
            }
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setFrameTimeline", this, null, "vsyncId=" + vsyncId);
            }
            SurfaceControl.nativeSetFrameTimelineVsync(this.mNativeObject, vsyncId);
            return this;
        }

        @NonNull
        public Transaction setFrameTimelineVsync(long frameTimelineVsyncId) {
            if (SurfaceControlRegistry.sCallStackDebuggingEnabled) {
                SurfaceControlRegistry.getProcessInstance().checkCallStackDebugging("setFrameTimelineVsync", this, null, "frameTimelineVsyncId=" + frameTimelineVsyncId);
            }
            SurfaceControl.nativeSetFrameTimelineVsync(this.mNativeObject, frameTimelineVsyncId);
            return this;
        }

        @NonNull
        public Transaction addTransactionCommittedListener(@NonNull Executor executor, @NonNull TransactionCommittedListener listener) {
            TransactionCommittedListener listenerInner = () -> executor.execute(listener::onTransactionCommitted);
            SurfaceControl.nativeAddTransactionCommittedListener(this.mNativeObject, listenerInner);
            return this;
        }

        @FlaggedApi(value="com.android.window.flags.sdk_desired_present_time")
        @NonNull
        public Transaction addTransactionCompletedListener(@NonNull Executor executor, @NonNull Consumer<TransactionStats> listener) {
            if (!com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.sdkDesiredPresentTime()) {
                Log.w(SurfaceControl.TAG, "addTransactionCompletedListener was called but flag is disabled");
                return this;
            }
            Consumer<TransactionStats> listenerInner = stats -> executor.execute(() -> listener.andThen(TransactionStats::close).accept((TransactionStats)stats));
            SurfaceControl.nativeAddTransactionCompletedListener(this.mNativeObject, listenerInner);
            return this;
        }

        @Deprecated
        @NonNull
        public Transaction setTrustedPresentationCallback(@NonNull SurfaceControl sc, @NonNull TrustedPresentationThresholds thresholds, final @NonNull Executor executor, final @NonNull Consumer<Boolean> listener) {
            this.checkPreconditions(sc);
            TrustedPresentationCallback tpc = new TrustedPresentationCallback(this){

                @Override
                public void onTrustedPresentationChanged(boolean inTrustedPresentationState) {
                    executor.execute(() -> listener.accept(inTrustedPresentationState));
                }
            };
            if (sc.mTrustedPresentationCallback != null) {
                sc.mTrustedPresentationCallback.mFreeNativeResources.run();
            }
            SurfaceControl.nativeSetTrustedPresentationCallback(this.mNativeObject, sc.mNativeObject, tpc.mNativeObject, thresholds);
            sc.mTrustedPresentationCallback = tpc;
            return this;
        }

        @Deprecated
        @NonNull
        public Transaction clearTrustedPresentationCallback(@NonNull SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeClearTrustedPresentationCallback(this.mNativeObject, sc.mNativeObject);
            if (sc.mTrustedPresentationCallback != null) {
                sc.mTrustedPresentationCallback.mFreeNativeResources.run();
                sc.mTrustedPresentationCallback = null;
            }
            return this;
        }

        @FlaggedApi(value="com.android.window.flags.sdk_desired_present_time")
        @NonNull
        public Transaction setDesiredPresentTimeNanos(long desiredPresentTimeNanos) {
            if (!com.android.internal.hidden_from_bootclasspath.com.android.window.flags.Flags.sdkDesiredPresentTime()) {
                Log.w(SurfaceControl.TAG, "addTransactionCompletedListener was called but flag is disabled");
                return this;
            }
            SurfaceControl.nativeSetDesiredPresentTimeNanos(this.mNativeObject, desiredPresentTimeNanos);
            return this;
        }

        @NonNull
        public Transaction setRecoverableFromBufferStuffing(@NonNull SurfaceControl sc) {
            this.checkPreconditions(sc);
            SurfaceControl.nativeSetFlags(this.mNativeObject, sc.mNativeObject, 8192, 8192);
            return this;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            if (this.mNativeObject == 0L) {
                dest.writeInt(0);
                return;
            }
            dest.writeInt(1);
            SurfaceControl.nativeWriteTransactionToParcel(this.mNativeObject, dest);
            if ((flags & 1) != 0) {
                SurfaceControl.nativeClearTransaction(this.mNativeObject);
            }
        }

        private void readFromParcel(Parcel in) {
            this.mNativeObject = 0L;
            if (in.readInt() != 0) {
                this.mNativeObject = SurfaceControl.nativeReadTransactionFromParcel(in);
                this.mFreeNativeResources = sRegistry.registerNativeAllocation(this, this.mNativeObject);
            }
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class StaticDisplayInfo {
        public boolean isInternal;
        public float density;
        public boolean secure;
        public DeviceProductInfo deviceProductInfo;
        public int installOrientation;

        public String toString() {
            return "StaticDisplayInfo{isInternal=" + this.isInternal + ", density=" + this.density + ", secure=" + this.secure + ", deviceProductInfo=" + this.deviceProductInfo + ", installOrientation=" + this.installOrientation + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StaticDisplayInfo that = (StaticDisplayInfo)o;
            return this.isInternal == that.isInternal && this.density == that.density && this.secure == that.secure && Objects.equals(this.deviceProductInfo, that.deviceProductInfo) && this.installOrientation == that.installOrientation;
        }

        public int hashCode() {
            return Objects.hash(this.isInternal, Float.valueOf(this.density), this.secure, this.deviceProductInfo, this.installOrientation);
        }
    }

    public static class DynamicDisplayInfo {
        public DisplayMode[] supportedDisplayModes;
        public int activeDisplayModeId;
        public float renderFrameRate;
        public boolean hasArrSupport;
        public FrameRateCategoryRate frameRateCategoryRate;
        public float[] supportedRefreshRates;
        public int[] supportedColorModes;
        public int activeColorMode;
        public Display.HdrCapabilities hdrCapabilities;
        public boolean autoLowLatencyModeSupported;
        public boolean gameContentTypeSupported;
        public int preferredBootDisplayMode;

        public String toString() {
            return "DynamicDisplayInfo{supportedDisplayModes=" + Arrays.toString(this.supportedDisplayModes) + ", activeDisplayModeId=" + this.activeDisplayModeId + ", renderFrameRate=" + this.renderFrameRate + ", hasArrSupport=" + this.hasArrSupport + ", frameRateCategoryRate=" + this.frameRateCategoryRate + ", supportedRefreshRates=" + Arrays.toString(this.supportedRefreshRates) + ", supportedColorModes=" + Arrays.toString(this.supportedColorModes) + ", activeColorMode=" + this.activeColorMode + ", hdrCapabilities=" + this.hdrCapabilities + ", autoLowLatencyModeSupported=" + this.autoLowLatencyModeSupported + ", gameContentTypeSupported" + this.gameContentTypeSupported + ", preferredBootDisplayMode" + this.preferredBootDisplayMode + "}";
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicDisplayInfo that = (DynamicDisplayInfo)o;
            return Arrays.equals(this.supportedDisplayModes, that.supportedDisplayModes) && this.activeDisplayModeId == that.activeDisplayModeId && this.renderFrameRate == that.renderFrameRate && Arrays.equals(this.supportedColorModes, that.supportedColorModes) && this.activeColorMode == that.activeColorMode && Objects.equals(this.hdrCapabilities, that.hdrCapabilities) && this.preferredBootDisplayMode == that.preferredBootDisplayMode && this.hasArrSupport == that.hasArrSupport && Objects.equals(this.frameRateCategoryRate, that.frameRateCategoryRate) && Arrays.equals(this.supportedRefreshRates, that.supportedRefreshRates);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.supportedDisplayModes), this.activeDisplayModeId, Float.valueOf(this.renderFrameRate), this.activeColorMode, this.hdrCapabilities, this.hasArrSupport, this.frameRateCategoryRate, Arrays.hashCode(this.supportedRefreshRates));
        }
    }

    public static class DesiredDisplayModeSpecs {
        public int defaultMode;
        public boolean allowGroupSwitching;
        public final RefreshRateRanges primaryRanges;
        public final RefreshRateRanges appRequestRanges;
        @Nullable
        public IdleScreenRefreshRateConfig idleScreenRefreshRateConfig;

        public DesiredDisplayModeSpecs() {
            this.primaryRanges = new RefreshRateRanges();
            this.appRequestRanges = new RefreshRateRanges();
        }

        public DesiredDisplayModeSpecs(DesiredDisplayModeSpecs other) {
            this.primaryRanges = new RefreshRateRanges();
            this.appRequestRanges = new RefreshRateRanges();
            this.copyFrom(other);
        }

        public DesiredDisplayModeSpecs(int defaultMode, boolean allowGroupSwitching, RefreshRateRanges primaryRanges, RefreshRateRanges appRequestRanges, @Nullable IdleScreenRefreshRateConfig idleScreenRefreshRateConfig) {
            this.defaultMode = defaultMode;
            this.allowGroupSwitching = allowGroupSwitching;
            this.primaryRanges = new RefreshRateRanges(primaryRanges.physical, primaryRanges.render);
            this.appRequestRanges = new RefreshRateRanges(appRequestRanges.physical, appRequestRanges.render);
            this.idleScreenRefreshRateConfig = idleScreenRefreshRateConfig == null ? null : new IdleScreenRefreshRateConfig(idleScreenRefreshRateConfig.timeoutMillis);
        }

        public boolean equals(@Nullable Object o) {
            return o instanceof DesiredDisplayModeSpecs && this.equals((DesiredDisplayModeSpecs)o);
        }

        public boolean equals(DesiredDisplayModeSpecs other) {
            return other != null && this.defaultMode == other.defaultMode && this.allowGroupSwitching == other.allowGroupSwitching && this.primaryRanges.equals(other.primaryRanges) && this.appRequestRanges.equals(other.appRequestRanges) && Objects.equals(this.idleScreenRefreshRateConfig, other.idleScreenRefreshRateConfig);
        }

        public int hashCode() {
            return 0;
        }

        public void copyFrom(DesiredDisplayModeSpecs other) {
            this.defaultMode = other.defaultMode;
            this.allowGroupSwitching = other.allowGroupSwitching;
            this.primaryRanges.copyFrom(other.primaryRanges);
            this.appRequestRanges.copyFrom(other.appRequestRanges);
            this.copyIdleScreenRefreshRateConfig(other.idleScreenRefreshRateConfig);
        }

        public String toString() {
            return "defaultMode=" + this.defaultMode + " allowGroupSwitching=" + this.allowGroupSwitching + " primaryRanges=" + this.primaryRanges + " appRequestRanges=" + this.appRequestRanges + " idleScreenRefreshRate=" + String.valueOf(this.idleScreenRefreshRateConfig);
        }

        private void copyIdleScreenRefreshRateConfig(IdleScreenRefreshRateConfig other) {
            if (this.idleScreenRefreshRateConfig == null) {
                if (other != null) {
                    this.idleScreenRefreshRateConfig = new IdleScreenRefreshRateConfig(other.timeoutMillis);
                }
            } else if (other == null) {
                this.idleScreenRefreshRateConfig = null;
            } else {
                this.idleScreenRefreshRateConfig.copyFrom(other);
            }
        }
    }

    public static class DisplayPrimaries {
        public CieXyz red;
        public CieXyz green;
        public CieXyz blue;
        public CieXyz white;
    }

    @FlaggedApi(value="com.android.window.flags.jank_api")
    public static class OnJankDataListenerRegistration {
        public static final OnJankDataListenerRegistration NONE = new OnJankDataListenerRegistration(){

            @Override
            public void flush() {
            }

            @Override
            public void removeAfter(long afterVsync) {
            }

            @Override
            public void release() {
            }
        };
        private final long mNativeObject;
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(OnJankDataListenerRegistration.class.getClassLoader(), SurfaceControl.nativeGetJankDataListenerWrapperFinalizer());
        private final Runnable mFreeNativeResources;
        private boolean mRemoved = false;
        private OnJankDataListener mListener;

        private OnJankDataListenerRegistration() {
            this.mNativeObject = 0L;
            this.mFreeNativeResources = () -> {};
        }

        OnJankDataListenerRegistration(SurfaceControl surface, OnJankDataListener listener) {
            this.mNativeObject = SurfaceControl.nativeCreateJankDataListenerWrapper(surface.mNativeObject, listener);
            this.mFreeNativeResources = this.mNativeObject == 0L ? () -> {} : sRegistry.registerNativeAllocation(this, this.mNativeObject);
            this.mListener = listener;
        }

        public void flush() {
            SurfaceControl.nativeFlushJankData(this.mNativeObject);
        }

        public void removeAfter(long afterVsync) {
            this.mRemoved = true;
            SurfaceControl.nativeRemoveJankDataListener(this.mNativeObject, afterVsync);
        }

        public void release() {
            if (!this.mRemoved) {
                this.removeAfter(0L);
            }
            this.mListener = null;
            this.mFreeNativeResources.run();
        }
    }

    @FlaggedApi(value="com.android.window.flags.jank_api")
    public static interface OnJankDataListener {
        public void onJankDataAvailable(@NonNull List<JankData> var1);
    }

    public static class LockDebuggingTransaction
    extends Transaction {
        Object mMonitor;

        public LockDebuggingTransaction(Object o) {
            this.mMonitor = o;
        }

        @Override
        protected void checkPreconditions(SurfaceControl sc) {
            super.checkPreconditions(sc);
            if (!Thread.holdsLock(this.mMonitor)) {
                throw new RuntimeException("Unlocked access to synchronized SurfaceControl.Transaction");
            }
        }
    }

    public static abstract class TrustedPresentationCallback {
        private final long mNativeObject = SurfaceControl.nativeCreateTpc(this);
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(TrustedPresentationCallback.class.getClassLoader(), SurfaceControl.getNativeTrustedPresentationCallbackFinalizer());
        private final Runnable mFreeNativeResources = sRegistry.registerNativeAllocation(this, this.mNativeObject);

        private TrustedPresentationCallback() {
        }

        public abstract void onTrustedPresentationChanged(boolean var1);
    }

    @Deprecated
    public static class TrustedPresentationThresholds {
        private final float mMinAlpha;
        private final float mMinFractionRendered;
        private final int mStabilityRequirementMs;

        public TrustedPresentationThresholds(float minAlpha, float minFractionRendered, int stabilityRequirementMs) {
            this.mMinAlpha = minAlpha;
            this.mMinFractionRendered = minFractionRendered;
            this.mStabilityRequirementMs = stabilityRequirementMs;
            this.checkValid();
        }

        private void checkValid() {
            if (this.mMinAlpha <= 0.0f || this.mMinFractionRendered <= 0.0f || this.mStabilityRequirementMs < 1) {
                throw new IllegalArgumentException("TrustedPresentationThresholds values are invalid");
            }
        }
    }

    @FlaggedApi(value="com.android.window.flags.sdk_desired_present_time")
    public static class TransactionStats {
        private long mLatchTimeNanos;
        private SyncFence mSyncFence;

        private TransactionStats(long latchTimeNanos, long presentFencePtr) {
            this.mLatchTimeNanos = latchTimeNanos;
            this.mSyncFence = new SyncFence(presentFencePtr);
        }

        public void close() {
            this.mSyncFence.close();
        }

        @FlaggedApi(value="com.android.window.flags.sdk_desired_present_time")
        public long getLatchTimeNanos() {
            return this.mLatchTimeNanos;
        }

        @FlaggedApi(value="com.android.window.flags.sdk_desired_present_time")
        @NonNull
        public SyncFence getPresentFence() {
            return new SyncFence(this.mSyncFence);
        }
    }

    public static interface TransactionCommittedListener {
        public void onTransactionCommitted();
    }

    public static class CieXyz {
        public float X;
        public float Y;
        public float Z;
    }

    public static class IdleScreenRefreshRateConfig {
        public int timeoutMillis;

        public IdleScreenRefreshRateConfig() {
            this.timeoutMillis = -1;
        }

        public IdleScreenRefreshRateConfig(int timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof IdleScreenRefreshRateConfig) || other == null) {
                return false;
            }
            IdleScreenRefreshRateConfig idleScreenRefreshRateConfig = (IdleScreenRefreshRateConfig)other;
            return this.timeoutMillis == idleScreenRefreshRateConfig.timeoutMillis;
        }

        public int hashCode() {
            return Objects.hash(this.timeoutMillis);
        }

        public String toString() {
            return "timeoutMillis: " + this.timeoutMillis;
        }

        public void copyFrom(IdleScreenRefreshRateConfig other) {
            if (other != null) {
                this.timeoutMillis = other.timeoutMillis;
            }
        }
    }

    public static class RefreshRateRanges {
        public static final String TAG = "RefreshRateRanges";
        public final RefreshRateRange physical;
        public final RefreshRateRange render;

        public RefreshRateRanges() {
            this.physical = new RefreshRateRange();
            this.render = new RefreshRateRange();
        }

        public RefreshRateRanges(RefreshRateRange physical, RefreshRateRange render) {
            this.physical = new RefreshRateRange(physical.min, physical.max);
            this.render = new RefreshRateRange(render.min, render.max);
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof RefreshRateRanges)) {
                return false;
            }
            RefreshRateRanges rates = (RefreshRateRanges)other;
            return this.physical.equals(rates.physical) && this.render.equals(rates.render);
        }

        public int hashCode() {
            return Objects.hash(this.physical, this.render);
        }

        public String toString() {
            return "physical: " + this.physical + " render:  " + this.render;
        }

        public void copyFrom(RefreshRateRanges other) {
            this.physical.copyFrom(other.physical);
            this.render.copyFrom(other.render);
        }
    }

    public static class RefreshRateRange
    implements Parcelable {
        public static final String TAG = "RefreshRateRange";
        public static final float FLOAT_TOLERANCE = 0.01f;
        public float min;
        public float max;
        @NonNull
        public static final Parcelable.Creator<RefreshRateRange> CREATOR = new Parcelable.Creator<RefreshRateRange>(){

            @Override
            public RefreshRateRange createFromParcel(Parcel in) {
                return new RefreshRateRange(in.readFloat(), in.readFloat());
            }

            public RefreshRateRange[] newArray(int size) {
                return new RefreshRateRange[size];
            }
        };

        public RefreshRateRange() {
        }

        public RefreshRateRange(float min, float max) {
            if (min < 0.0f || max < 0.0f || min > max + 0.01f) {
                Slog.e(TAG, "Wrong values for min and max when initializing RefreshRateRange : " + min + " " + max);
                this.max = 0.0f;
                this.min = 0.0f;
                return;
            }
            if (min > max) {
                float t = min;
                min = max;
                max = t;
            }
            this.min = min;
            this.max = max;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof RefreshRateRange)) {
                return false;
            }
            RefreshRateRange refreshRateRange = (RefreshRateRange)other;
            return this.min == refreshRateRange.min && this.max == refreshRateRange.max;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.min), Float.valueOf(this.max));
        }

        public String toString() {
            return "(" + this.min + " " + this.max + ")";
        }

        public void copyFrom(RefreshRateRange other) {
            this.min = other.min;
            this.max = other.max;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeFloat(this.min);
            dest.writeFloat(this.max);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class DisplayMode {
        public int id;
        public int width;
        public int height;
        public float xDpi;
        public float yDpi;
        public float peakRefreshRate;
        public float vsyncRate;
        public long appVsyncOffsetNanos;
        public long presentationDeadlineNanos;
        public int[] supportedHdrTypes;
        public int group;

        public String toString() {
            return "DisplayMode{id=" + this.id + ", width=" + this.width + ", height=" + this.height + ", xDpi=" + this.xDpi + ", yDpi=" + this.yDpi + ", peakRefreshRate=" + this.peakRefreshRate + ", vsyncRate=" + this.vsyncRate + ", appVsyncOffsetNanos=" + this.appVsyncOffsetNanos + ", presentationDeadlineNanos=" + this.presentationDeadlineNanos + ", supportedHdrTypes=" + Arrays.toString(this.supportedHdrTypes) + ", group=" + this.group + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisplayMode that = (DisplayMode)o;
            return this.id == that.id && this.width == that.width && this.height == that.height && Float.compare(that.xDpi, this.xDpi) == 0 && Float.compare(that.yDpi, this.yDpi) == 0 && Float.compare(that.peakRefreshRate, this.peakRefreshRate) == 0 && Float.compare(that.vsyncRate, this.vsyncRate) == 0 && this.appVsyncOffsetNanos == that.appVsyncOffsetNanos && this.presentationDeadlineNanos == that.presentationDeadlineNanos && Arrays.equals(this.supportedHdrTypes, that.supportedHdrTypes) && this.group == that.group;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.width, this.height, Float.valueOf(this.xDpi), Float.valueOf(this.yDpi), Float.valueOf(this.peakRefreshRate), Float.valueOf(this.vsyncRate), this.appVsyncOffsetNanos, this.presentationDeadlineNanos, this.group, Arrays.hashCode(this.supportedHdrTypes));
        }
    }

    public static class Builder {
        private SurfaceSession mSession;
        private int mFlags = 4;
        private int mWidth;
        private int mHeight;
        private int mFormat = -1;
        private String mName;
        private WeakReference<View> mLocalOwnerView;
        private SurfaceControl mParent;
        private SparseIntArray mMetadata;
        private String mCallsite = "SurfaceControl.Builder";

        public Builder(SurfaceSession session) {
            this.mSession = session;
        }

        public Builder() {
        }

        @NonNull
        public SurfaceControl build() {
            if (this.mWidth < 0 || this.mHeight < 0) {
                throw new IllegalStateException("width and height must be positive or unset");
            }
            if ((this.mWidth > 0 || this.mHeight > 0) && (this.isEffectLayer() || this.isContainerLayer())) {
                throw new IllegalStateException("Only buffer layers can set a valid buffer size.");
            }
            if (this.mName == null) {
                Log.w(SurfaceControl.TAG, "Missing name for SurfaceControl", new Throwable());
            }
            if ((this.mFlags & 0xF0000) == 0) {
                this.setBLASTLayer();
            }
            return new SurfaceControl(this.mSession, this.mName, this.mWidth, this.mHeight, this.mFormat, this.mFlags, this.mParent, this.mMetadata, this.mLocalOwnerView, this.mCallsite);
        }

        @NonNull
        public Builder setName(@NonNull String name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setLocalOwnerView(@NonNull View view) {
            this.mLocalOwnerView = new WeakReference<View>(view);
            return this;
        }

        @NonNull
        public Builder setBufferSize(int width, int height) {
            if (width < 0 || height < 0) {
                throw new IllegalArgumentException("width and height must be positive");
            }
            this.mWidth = width;
            this.mHeight = height;
            return this.setFlags(0, 983040);
        }

        private void unsetBufferSize() {
            this.mWidth = 0;
            this.mHeight = 0;
        }

        @NonNull
        public Builder setFormat(int format) {
            this.mFormat = format;
            return this;
        }

        @NonNull
        public Builder setProtected(boolean protectedContent) {
            this.mFlags = protectedContent ? (this.mFlags |= 0x800) : (this.mFlags &= 0xFFFFF7FF);
            return this;
        }

        @NonNull
        public Builder setSecure(boolean secure) {
            this.mFlags = secure ? (this.mFlags |= 0x80) : (this.mFlags &= 0xFFFFFF7F);
            return this;
        }

        @NonNull
        public Builder setOpaque(boolean opaque) {
            this.mFlags = opaque ? (this.mFlags |= 0x400) : (this.mFlags &= 0xFFFFFBFF);
            return this;
        }

        @NonNull
        public Builder setHidden(boolean hidden) {
            this.mFlags = hidden ? (this.mFlags |= 4) : (this.mFlags &= 0xFFFFFFFB);
            return this;
        }

        @NonNull
        public Builder setParent(@Nullable SurfaceControl parent) {
            this.mParent = parent;
            return this;
        }

        public Builder setMetadata(int key, int data) {
            if (this.mMetadata == null) {
                this.mMetadata = new SparseIntArray();
            }
            this.mMetadata.put(key, data);
            return this;
        }

        public Builder setEffectLayer() {
            this.mFlags |= 0x4000;
            this.unsetBufferSize();
            return this.setFlags(131072, 983040);
        }

        public Builder setColorLayer() {
            this.unsetBufferSize();
            return this.setFlags(131072, 983040);
        }

        private boolean isEffectLayer() {
            return (this.mFlags & 0x20000) == 131072;
        }

        public Builder setBLASTLayer() {
            return this.setFlags(262144, 983040);
        }

        public Builder setContainerLayer() {
            this.unsetBufferSize();
            return this.setFlags(524288, 983040);
        }

        private boolean isContainerLayer() {
            return (this.mFlags & 0x80000) == 524288;
        }

        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        public Builder setCallsite(String callsite) {
            this.mCallsite = callsite;
            return this;
        }

        private Builder setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~mask | flags;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FrameRateSelectionStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CachingHint {
    }

    @FlaggedApi(value="com.android.window.flags.jank_api")
    public static class JankData {
        public static final int JANK_NONE = 0;
        public static final int JANK_COMPOSER = 1;
        public static final int JANK_APPLICATION = 2;
        public static final int JANK_OTHER = 4;
        private final long mFrameVsyncId;
        private final int mJankType;
        private final long mFrameIntervalNs;
        private final long mScheduledAppFrameTimeNs;
        private final long mActualAppFrameTimeNs;

        public JankData(long frameVsyncId, int jankType, long frameIntervalNs, long scheduledAppFrameTimeNs, long actualAppFrameTimeNs) {
            this.mFrameVsyncId = frameVsyncId;
            this.mJankType = jankType;
            this.mFrameIntervalNs = frameIntervalNs;
            this.mScheduledAppFrameTimeNs = scheduledAppFrameTimeNs;
            this.mActualAppFrameTimeNs = actualAppFrameTimeNs;
        }

        public long getVsyncId() {
            return this.mFrameVsyncId;
        }

        public int getJankType() {
            return this.mJankType;
        }

        public long getFrameIntervalNanos() {
            return this.mFrameIntervalNs;
        }

        public long getScheduledAppFrameTimeNanos() {
            return this.mScheduledAppFrameTimeNs;
        }

        public long getActualAppFrameTimeNanos() {
            return this.mActualAppFrameTimeNs;
        }

        public String toString() {
            return "JankData{vsync=" + this.mFrameVsyncId + ", jankType=0x" + Integer.toHexString(this.mJankType) + ", frameInterval=" + this.mFrameIntervalNs + "ns, scheduledAppTime=" + this.mScheduledAppFrameTimeNs + "ns, actualAppTime=" + this.mActualAppFrameTimeNs + "ns}";
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface JankType {
        }
    }

    public static interface OnReparentListener {
        public void onReparent(@NonNull Transaction var1, @Nullable SurfaceControl var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BufferTransform {
    }
}

