/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.Flags;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.MathUtils;
import android.view.MotionEvent;
import android.view.NotificationTopLineView;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.CachingIconView;
import com.android.internal.widget.NotificationExpandButton;
import java.util.ArrayList;

@RemoteViews.RemoteView
public class NotificationHeaderView
extends RelativeLayout {
    private final int mTouchableHeight;
    private View.OnClickListener mExpandClickListener;
    private HeaderTouchListener mTouchListener = new HeaderTouchListener();
    private NotificationTopLineView mTopLineView;
    private NotificationExpandButton mExpandButton;
    private View mAltExpandTarget;
    private CachingIconView mIcon;
    private Drawable mBackground;
    private boolean mEntireHeaderClickable;
    private boolean mExpandOnlyOnButton;
    private boolean mAcceptAllTouches;
    private float mTopLineTranslation;
    private float mExpandButtonTranslation;
    ViewOutlineProvider mProvider = new ViewOutlineProvider(){

        @Override
        public void getOutline(View view, Outline outline) {
            if (NotificationHeaderView.this.mBackground != null) {
                outline.setRect(0, 0, NotificationHeaderView.this.getWidth(), NotificationHeaderView.this.getHeight());
                outline.setAlpha(1.0f);
            }
        }
    };

    public NotificationHeaderView(Context context) {
        this(context, null);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public NotificationHeaderView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NotificationHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationHeaderView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Resources res = this.getResources();
        this.mTouchableHeight = res.getDimensionPixelSize(17105601);
        this.mEntireHeaderClickable = res.getBoolean(0x1110201);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mIcon = (CachingIconView)this.findViewById(16908294);
        this.mTopLineView = (NotificationTopLineView)this.findViewById(16909370);
        this.mExpandButton = (NotificationExpandButton)this.findViewById(16909039);
        this.mAltExpandTarget = this.findViewById(16908811);
        this.setClipToPadding(false);
    }

    public void setHeaderBackgroundDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            this.setWillNotDraw(false);
            this.mBackground = drawable2;
            this.mBackground.setCallback(this);
            this.setOutlineProvider(this.mProvider);
        } else {
            this.setWillNotDraw(true);
            this.mBackground = null;
            this.setOutlineProvider(null);
        }
        this.invalidate();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        if (this.mBackground != null) {
            this.mBackground.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.mBackground.draw(canvas);
        }
    }

    @Override
    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || who == this.mBackground;
    }

    @Override
    protected void drawableStateChanged() {
        if (this.mBackground != null && this.mBackground.isStateful()) {
            this.mBackground.setState(this.getDrawableState());
        }
    }

    private void updateTouchListener() {
        if (this.mExpandClickListener == null) {
            this.setOnTouchListener(null);
            return;
        }
        this.setOnTouchListener(this.mTouchListener);
        this.mTouchListener.bindTouchRects();
    }

    @Override
    public void setOnClickListener(@Nullable View.OnClickListener l) {
        this.mExpandClickListener = l;
        this.mExpandButton.setOnClickListener(this.mExpandClickListener);
        this.mAltExpandTarget.setOnClickListener(this.mExpandClickListener);
        this.updateTouchListener();
    }

    public void setTopLineExtraMarginEnd(int extraMarginEnd) {
        this.mTopLineView.setHeaderTextMarginEnd(extraMarginEnd);
    }

    @RemotableViewMethod
    public void setTopLineExtraMarginEndDp(float extraMarginEndDp) {
        this.setTopLineExtraMarginEnd((int)(extraMarginEndDp * this.getResources().getDisplayMetrics().density));
    }

    @RemotableViewMethod
    public void centerTopLine(boolean center) {
        if (Flags.notificationsRedesignTemplates()) {
            ViewGroup.LayoutParams lp = this.mTopLineView.getLayoutParams();
            lp.height = center ? -1 : -2;
            this.mTopLineView.setLayoutParams(lp);
            this.centerExpandButton(center);
        }
    }

    private void centerExpandButton(boolean center) {
        ViewGroup.LayoutParams lp = this.mExpandButton.getLayoutParams();
        int n = lp.height = center ? -1 : -2;
        if (lp instanceof FrameLayout.LayoutParams) {
            FrameLayout.LayoutParams flp = (FrameLayout.LayoutParams)lp;
            flp.gravity = center ? 17 : 8388661;
        }
        this.mExpandButton.setLayoutParams(lp);
    }

    public NotificationTopLineView getTopLineView() {
        return this.mTopLineView;
    }

    public NotificationExpandButton getExpandButton() {
        return this.mExpandButton;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (Flags.notificationsRedesignTemplates()) {
            if (this.mTopLineView != null) {
                this.mTopLineTranslation = this.measureCenterTranslation(this.mTopLineView);
            }
            if (this.mExpandButton != null) {
                this.mExpandButtonTranslation = this.measureCenterTranslation(this.mExpandButton);
            }
        }
    }

    private float measureCenterTranslation(View view) {
        int parentHeight = this.getMeasuredHeight();
        float wrapContentHeight = view.getMeasuredHeight();
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        return MathUtils.abs(((float)parentHeight - wrapContentHeight) / 2.0f - (float)lp.topMargin);
    }

    public float getTopLineTranslation() {
        return this.mTopLineTranslation;
    }

    public float getExpandButtonTranslation() {
        return this.mExpandButtonTranslation;
    }

    @RemotableViewMethod
    public void styleTextAsTitle(boolean styleTextAsTitle) {
        Object appNameText;
        int styleResId = styleTextAsTitle ? 16974749 : 16974746;
        Object headerText = this.findViewById(16909138);
        if (headerText instanceof TextView) {
            ((TextView)headerText).setTextAppearance(styleResId);
        }
        if ((appNameText = this.findViewById(16908825)) instanceof TextView) {
            ((TextView)appNameText).setTextAppearance(styleResId);
        }
    }

    private View getFirstChildNotGone() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            return child;
        }
        return this;
    }

    @Override
    public boolean hasOverlappingRendering() {
        return false;
    }

    public boolean isInTouchRect(float x, float y) {
        if (this.mExpandClickListener == null) {
            return false;
        }
        return this.mTouchListener.isInside(x, y);
    }

    @RemotableViewMethod
    public void setAcceptAllTouches(boolean acceptAllTouches) {
        this.mAcceptAllTouches = this.mEntireHeaderClickable || acceptAllTouches;
    }

    @RemotableViewMethod
    public void setExpandOnlyOnButton(boolean expandOnlyOnButton) {
        this.mExpandOnlyOnButton = expandOnlyOnButton;
    }

    public class HeaderTouchListener
    implements View.OnTouchListener {
        private final ArrayList<Rect> mTouchRects = new ArrayList();
        private Rect mExpandButtonRect;
        private Rect mAltExpandTargetRect;
        private int mTouchSlop;
        private boolean mTrackGesture;
        private float mDownX;
        private float mDownY;

        public void bindTouchRects() {
            this.mTouchRects.clear();
            this.addRectAroundView(NotificationHeaderView.this.mIcon);
            this.mExpandButtonRect = this.addRectAroundView(NotificationHeaderView.this.mExpandButton);
            this.mAltExpandTargetRect = this.addRectAroundView(NotificationHeaderView.this.mAltExpandTarget);
            this.addWidthRect();
            this.mTouchSlop = ViewConfiguration.get(NotificationHeaderView.this.getContext()).getScaledTouchSlop();
        }

        private void addWidthRect() {
            Rect r = new Rect();
            r.top = 0;
            r.bottom = NotificationHeaderView.this.mTouchableHeight;
            r.left = 0;
            r.right = NotificationHeaderView.this.getWidth();
            this.mTouchRects.add(r);
        }

        private Rect addRectAroundView(View view) {
            Rect r = this.getRectAroundView(view);
            this.mTouchRects.add(r);
            return r;
        }

        private Rect getRectAroundView(View view) {
            float size = 48.0f * NotificationHeaderView.this.getResources().getDisplayMetrics().density;
            float width = Math.max(size, (float)view.getWidth());
            float height = Math.max(size, (float)view.getHeight());
            Rect r = new Rect();
            if (view.getVisibility() == 8) {
                view = NotificationHeaderView.this.getFirstChildNotGone();
                r.left = (int)((float)view.getLeft() - width / 2.0f);
            } else {
                r.left = (int)((float)(view.getLeft() + view.getRight()) / 2.0f - width / 2.0f);
            }
            r.top = (int)((float)(view.getTop() + view.getBottom()) / 2.0f - height / 2.0f);
            r.bottom = (int)((float)r.top + height);
            r.right = (int)((float)r.left + width);
            return r;
        }

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            float x = event.getX();
            float y = event.getY();
            switch (event.getActionMasked() & 0xFF) {
                case 0: {
                    this.mTrackGesture = false;
                    if (!this.isInside(x, y)) break;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mTrackGesture = true;
                    return true;
                }
                case 2: {
                    if (!this.mTrackGesture || !(Math.abs(this.mDownX - x) > (float)this.mTouchSlop) && !(Math.abs(this.mDownY - y) > (float)this.mTouchSlop)) break;
                    this.mTrackGesture = false;
                    break;
                }
                case 1: {
                    float topLineY;
                    float topLineX;
                    if (!this.mTrackGesture || NotificationHeaderView.this.mTopLineView.onTouchUp(x - (topLineX = NotificationHeaderView.this.mTopLineView.getX()), y - (topLineY = NotificationHeaderView.this.mTopLineView.getY()), this.mDownX - topLineX, this.mDownY - topLineY)) break;
                    NotificationHeaderView.this.mExpandButton.performClick();
                }
            }
            return this.mTrackGesture;
        }

        private boolean isInside(float x, float y) {
            if (NotificationHeaderView.this.mAcceptAllTouches) {
                return true;
            }
            if (NotificationHeaderView.this.mExpandOnlyOnButton) {
                return this.mExpandButtonRect.contains((int)x, (int)y) || this.mAltExpandTargetRect.contains((int)x, (int)y);
            }
            for (int i = 0; i < this.mTouchRects.size(); ++i) {
                Rect r = this.mTouchRects.get(i);
                if (!r.contains((int)x, (int)y)) continue;
                return true;
            }
            float topLineX = x - NotificationHeaderView.this.mTopLineView.getX();
            float topLineY = y - NotificationHeaderView.this.mTopLineView.getY();
            return NotificationHeaderView.this.mTopLineView.isInTouchRect(topLineX, topLineY);
        }
    }
}

